/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.ParentFieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchHitField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;

public final class ParentFieldSubFetchPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (context.storedFieldsContext() != null && !context.storedFieldsContext().fetchFields()) {
            return;
        }
        ParentFieldMapper parentFieldMapper = context.mapperService().documentMapper(hitContext.hit().type()).parentFieldMapper();
        if (!parentFieldMapper.active()) {
            return;
        }
        String parentId = ParentFieldSubFetchPhase.getParentId(parentFieldMapper, hitContext.reader(), hitContext.docId());
        if (parentId == null) {
            return;
        }
        Map<String, SearchHitField> fields = hitContext.hit().fieldsOrNull();
        if (fields == null) {
            fields = new HashMap<String, SearchHitField>();
            hitContext.hit().fields(fields);
        }
        fields.put("_parent", new SearchHitField("_parent", Collections.singletonList(parentId)));
    }

    public static String getParentId(ParentFieldMapper fieldMapper, LeafReader reader, int docId) {
        try {
            SortedDocValues docValues = reader.getSortedDocValues(fieldMapper.name());
            if (docValues == null) {
                return null;
            }
            BytesRef parentId = docValues.get(docId);
            return parentId.length > 0 ? parentId.utf8ToString() : null;
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }
}

