/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchScrollRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchTask;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.Scroll;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequest;

public class InternalScrollSearchRequest
extends TransportRequest {
    private long id;
    private Scroll scroll;

    public InternalScrollSearchRequest() {
    }

    public InternalScrollSearchRequest(SearchScrollRequest request, long id) {
        this.id = id;
        this.scroll = request.scroll();
    }

    public long id() {
        return this.id;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public InternalScrollSearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        this.scroll = in.readOptionalWriteable(Scroll::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        out.writeOptionalWriteable(this.scroll);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId) {
        return new SearchTask(id, type, action, this.getDescription(), parentTaskId);
    }

    @Override
    public String getDescription() {
        return "id[" + this.id + "], scroll[" + this.scroll + "]";
    }
}

