/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.MultiSearch;
import io.searchbox.core.MultiSearchResult;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog2.indexer.ElasticsearchException;

public class MultiSearch {
    private final JestClient jestClient;

    @Inject
    public MultiSearch(JestClient jestClient) {
        this.jestClient = jestClient;
    }

    public SearchResult wrap(Search search, Supplier<String> errorMessage) {
        io.searchbox.core.MultiSearch multiSearch = new MultiSearch.Builder(search).build();
        MultiSearchResult multiSearchResult = JestUtils.execute(this.jestClient, multiSearch, errorMessage);
        List<MultiSearchResult.MultiSearchResponse> responses = multiSearchResult.getResponses();
        if (responses.size() != 1) {
            throw new ElasticsearchException("Expected exactly 1 search result, but got " + responses.size());
        }
        MultiSearchResult.MultiSearchResponse response = responses.get(0);
        if (response.isError) {
            throw JestUtils.specificException(errorMessage, response.error);
        }
        Optional<ElasticsearchException> elasticsearchException = JestUtils.checkForFailedShards(response.searchResult);
        elasticsearchException.ifPresent(e -> {
            throw e;
        });
        return response.searchResult;
    }

    public long tookMsFromSearchResult(JestResult searchResult) {
        JsonNode tookMs = searchResult.getJsonObject().path("took");
        if (tookMs.isNumber()) {
            return tookMs.asLong();
        }
        throw new ElasticsearchException("Unexpected response structure: " + searchResult.getJsonString());
    }
}

