/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import io.searchbox.client.JestClient;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.graylog.storage.elasticsearch6.ScrollResultES6;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.results.ScrollResult;

public class Scroll {
    private final JestClient jestClient;
    private final ScrollResultES6.Factory scrollResultFactory;

    @Inject
    public Scroll(ScrollResultES6.Factory scrollResultFactory, JestClient jestClient) {
        this.scrollResultFactory = scrollResultFactory;
        this.jestClient = jestClient;
    }

    public ScrollResult scroll(Search search, Supplier<String> errorMessage, String query, String scrollTime, List<String> fields) {
        return this.scroll(search, errorMessage, query, scrollTime, fields, -1);
    }

    public ScrollResult scroll(Search search, Supplier<String> errorMessage, String query, String scrollTime, List<String> fields, int limit) {
        SearchResult result = JestUtils.execute(this.jestClient, search, errorMessage);
        Optional<ElasticsearchException> elasticsearchException = JestUtils.checkForFailedShards(result);
        elasticsearchException.ifPresent(e -> {
            throw e;
        });
        return this.scrollResultFactory.create(result, query, scrollTime, fields, limit);
    }
}

