/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.views.export;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.sort.Sort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch6.views.export.JestWrapper;
import org.graylog.storage.elasticsearch6.views.export.RequestStrategy;
import org.graylog2.plugin.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAfter
implements RequestStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SearchAfter.class);
    static final String DEFAULT_TIEBREAKER_FIELD = "gl2_message_id";
    static final String EVENTS_TIEBREAKER_FIELD = "_id";
    private final JestWrapper jestWrapper;
    private Object[] searchAfterValues = null;

    @Inject
    public SearchAfter(JestWrapper jestWrapper) {
        this.jestWrapper = jestWrapper;
    }

    @Override
    public List<SearchResult.Hit<Map, Void>> nextChunk(Search.Builder search, ExportMessagesCommand command) {
        SearchResult result = this.search(search, command);
        List<SearchResult.Hit<Map, Void>> hits = result.getHits(Map.class, false);
        this.searchAfterValues = this.lastHitSortFrom(hits);
        return hits;
    }

    private SearchResult search(Search.Builder search, ExportMessagesCommand command) {
        Search.Builder modified = search.addSort(this.configureSort(command));
        return this.jestWrapper.execute(modified.build(), () -> "Failed to execute Search After request");
    }

    private ArrayList<Sort> configureSort(ExportMessagesCommand command) {
        return Lists.newArrayList((Object[])new Sort[]{new Sort("timestamp", Sort.Sorting.DESC), new Sort(this.tieBreakerFrom(command.streams()), Sort.Sorting.DESC)});
    }

    private String tieBreakerFrom(Set<String> streams) {
        boolean hasOnlyEventStreams = Sets.difference(streams, (Set)Stream.DEFAULT_EVENT_STREAM_IDS).size() == 0;
        return hasOnlyEventStreams ? EVENTS_TIEBREAKER_FIELD : DEFAULT_TIEBREAKER_FIELD;
    }

    private Object[] lastHitSortFrom(List<SearchResult.Hit<Map, Void>> hits) {
        if (hits.isEmpty()) {
            return null;
        }
        SearchResult.Hit<Map, Void> lastHit = hits.get(hits.size() - 1);
        return lastHit.sort.toArray(new Object[0]);
    }

    @Override
    public SearchSourceBuilder configure(SearchSourceBuilder ssb) {
        return this.searchAfterValues == null ? ssb : ssb.searchAfter(this.searchAfterValues);
    }

    @Override
    public Set<String> removeUnsupportedStreams(Set<String> streams) {
        boolean hasOthers;
        boolean hasEventStreams = Sets.intersection(streams, (Set)Stream.DEFAULT_EVENT_STREAM_IDS).size() > 0;
        Sets.SetView others = Sets.difference(streams, (Set)Stream.DEFAULT_EVENT_STREAM_IDS);
        boolean bl = hasOthers = others.size() > 0;
        if (hasEventStreams && hasOthers) {
            LOG.warn("Search After requests for a mix of event streams and others are not supported. Removing event streams.");
            return ImmutableSet.copyOf((Collection)others);
        }
        return streams;
    }
}

