/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.functions.abusech;

import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.threatintel.functions.GenericLookupResult;
import org.graylog.plugins.threatintel.functions.misc.LookupTableFunction;
import org.graylog.plugins.threatintel.tools.Domain;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbuseChRansomDomainLookupFunction
extends LookupTableFunction<GenericLookupResult> {
    private static final Logger LOG = LoggerFactory.getLogger(AbuseChRansomDomainLookupFunction.class);
    public static final String NAME = "abusech_ransom_lookup_domain";
    private static final String VALUE = "domain_name";
    private static final String LOOKUP_TABLE_NAME = "abuse-ch-ransomware-domains";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string((String)"domain_name").description("The domain to look up. Example: foo.example.org (A trailing dot ('.') will be ignored.)").build();
    private final LookupTableService.Function lookupFunction;

    @Inject
    public AbuseChRansomDomainLookupFunction(LookupTableService lookupTableService) {
        this.lookupFunction = lookupTableService.newBuilder().lookupTable(LOOKUP_TABLE_NAME).build();
    }

    public GenericLookupResult evaluate(FunctionArgs args, EvaluationContext context) {
        String domain = (String)this.valueParam.required(args, context);
        if (domain == null) {
            LOG.error("NULL parameter passed to abuse.ch Ransomware domain lookup.");
            return null;
        }
        domain = Domain.prepareDomain(domain);
        LOG.debug("Running abuse.ch Ransomware lookup for domain [{}].", (Object)domain);
        LookupResult lookupResult = this.lookupFunction.lookup((Object)domain.trim());
        if (lookupResult != null && !lookupResult.isEmpty() && lookupResult.singleValue() != null) {
            if (lookupResult.singleValue() instanceof Boolean) {
                return (Boolean)lookupResult.singleValue() != false ? GenericLookupResult.TRUE : GenericLookupResult.FALSE;
            }
            if (lookupResult.singleValue() instanceof String) {
                return Boolean.valueOf((String)lookupResult.singleValue()) != false ? GenericLookupResult.TRUE : GenericLookupResult.FALSE;
            }
        }
        return GenericLookupResult.FALSE;
    }

    public FunctionDescriptor<GenericLookupResult> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Match a domain name against the abuse.ch Ransomware Domain Blocklist. (RW_DOMBL)").params(new ParameterDescriptor[]{this.valueParam}).returnType(GenericLookupResult.class).build();
    }
}

