/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateTransitGatewayRouteTableRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateTransitGatewayRouteTableRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateTransitGatewayRouteTableRequest> {
    private String transitGatewayId;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setTransitGatewayId(String transitGatewayId) {
        this.transitGatewayId = transitGatewayId;
    }

    public String getTransitGatewayId() {
        return this.transitGatewayId;
    }

    public CreateTransitGatewayRouteTableRequest withTransitGatewayId(String transitGatewayId) {
        this.setTransitGatewayId(transitGatewayId);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public CreateTransitGatewayRouteTableRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public CreateTransitGatewayRouteTableRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateTransitGatewayRouteTableRequest> getDryRunRequest() {
        Request<CreateTransitGatewayRouteTableRequest> request = new CreateTransitGatewayRouteTableRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTransitGatewayId() != null) {
            sb.append("TransitGatewayId: ").append(this.getTransitGatewayId()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayRouteTableRequest)) {
            return false;
        }
        CreateTransitGatewayRouteTableRequest other = (CreateTransitGatewayRouteTableRequest)obj;
        if (other.getTransitGatewayId() == null ^ this.getTransitGatewayId() == null) {
            return false;
        }
        if (other.getTransitGatewayId() != null && !other.getTransitGatewayId().equals(this.getTransitGatewayId())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTransitGatewayId() == null ? 0 : this.getTransitGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    @Override
    public CreateTransitGatewayRouteTableRequest clone() {
        return (CreateTransitGatewayRouteTableRequest)super.clone();
    }
}

