/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CurrencyCodeValues;
import com.amazonaws.services.ec2.model.PaymentOption;
import com.amazonaws.services.ec2.model.ReservationState;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class HostReservation
implements Serializable,
Cloneable {
    private Integer count;
    private String currencyCode;
    private Integer duration;
    private Date end;
    private SdkInternalList<String> hostIdSet;
    private String hostReservationId;
    private String hourlyPrice;
    private String instanceFamily;
    private String offeringId;
    private String paymentOption;
    private Date start;
    private String state;
    private String upfrontPrice;
    private SdkInternalList<Tag> tags;

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getCount() {
        return this.count;
    }

    public HostReservation withCount(Integer count) {
        this.setCount(count);
        return this;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public HostReservation withCurrencyCode(String currencyCode) {
        this.setCurrencyCode(currencyCode);
        return this;
    }

    public void setCurrencyCode(CurrencyCodeValues currencyCode) {
        this.withCurrencyCode(currencyCode);
    }

    public HostReservation withCurrencyCode(CurrencyCodeValues currencyCode) {
        this.currencyCode = currencyCode.toString();
        return this;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public HostReservation withDuration(Integer duration) {
        this.setDuration(duration);
        return this;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Date getEnd() {
        return this.end;
    }

    public HostReservation withEnd(Date end) {
        this.setEnd(end);
        return this;
    }

    public List<String> getHostIdSet() {
        if (this.hostIdSet == null) {
            this.hostIdSet = new SdkInternalList();
        }
        return this.hostIdSet;
    }

    public void setHostIdSet(Collection<String> hostIdSet) {
        if (hostIdSet == null) {
            this.hostIdSet = null;
            return;
        }
        this.hostIdSet = new SdkInternalList<String>(hostIdSet);
    }

    public HostReservation withHostIdSet(String ... hostIdSet) {
        if (this.hostIdSet == null) {
            this.setHostIdSet(new SdkInternalList<String>(hostIdSet.length));
        }
        for (String ele : hostIdSet) {
            this.hostIdSet.add(ele);
        }
        return this;
    }

    public HostReservation withHostIdSet(Collection<String> hostIdSet) {
        this.setHostIdSet(hostIdSet);
        return this;
    }

    public void setHostReservationId(String hostReservationId) {
        this.hostReservationId = hostReservationId;
    }

    public String getHostReservationId() {
        return this.hostReservationId;
    }

    public HostReservation withHostReservationId(String hostReservationId) {
        this.setHostReservationId(hostReservationId);
        return this;
    }

    public void setHourlyPrice(String hourlyPrice) {
        this.hourlyPrice = hourlyPrice;
    }

    public String getHourlyPrice() {
        return this.hourlyPrice;
    }

    public HostReservation withHourlyPrice(String hourlyPrice) {
        this.setHourlyPrice(hourlyPrice);
        return this;
    }

    public void setInstanceFamily(String instanceFamily) {
        this.instanceFamily = instanceFamily;
    }

    public String getInstanceFamily() {
        return this.instanceFamily;
    }

    public HostReservation withInstanceFamily(String instanceFamily) {
        this.setInstanceFamily(instanceFamily);
        return this;
    }

    public void setOfferingId(String offeringId) {
        this.offeringId = offeringId;
    }

    public String getOfferingId() {
        return this.offeringId;
    }

    public HostReservation withOfferingId(String offeringId) {
        this.setOfferingId(offeringId);
        return this;
    }

    public void setPaymentOption(String paymentOption) {
        this.paymentOption = paymentOption;
    }

    public String getPaymentOption() {
        return this.paymentOption;
    }

    public HostReservation withPaymentOption(String paymentOption) {
        this.setPaymentOption(paymentOption);
        return this;
    }

    public void setPaymentOption(PaymentOption paymentOption) {
        this.withPaymentOption(paymentOption);
    }

    public HostReservation withPaymentOption(PaymentOption paymentOption) {
        this.paymentOption = paymentOption.toString();
        return this;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getStart() {
        return this.start;
    }

    public HostReservation withStart(Date start) {
        this.setStart(start);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public HostReservation withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(ReservationState state) {
        this.withState(state);
    }

    public HostReservation withState(ReservationState state) {
        this.state = state.toString();
        return this;
    }

    public void setUpfrontPrice(String upfrontPrice) {
        this.upfrontPrice = upfrontPrice;
    }

    public String getUpfrontPrice() {
        return this.upfrontPrice;
    }

    public HostReservation withUpfrontPrice(String upfrontPrice) {
        this.setUpfrontPrice(upfrontPrice);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public HostReservation withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public HostReservation withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount()).append(",");
        }
        if (this.getCurrencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.getCurrencyCode()).append(",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: ").append(this.getDuration()).append(",");
        }
        if (this.getEnd() != null) {
            sb.append("End: ").append(this.getEnd()).append(",");
        }
        if (this.getHostIdSet() != null) {
            sb.append("HostIdSet: ").append(this.getHostIdSet()).append(",");
        }
        if (this.getHostReservationId() != null) {
            sb.append("HostReservationId: ").append(this.getHostReservationId()).append(",");
        }
        if (this.getHourlyPrice() != null) {
            sb.append("HourlyPrice: ").append(this.getHourlyPrice()).append(",");
        }
        if (this.getInstanceFamily() != null) {
            sb.append("InstanceFamily: ").append(this.getInstanceFamily()).append(",");
        }
        if (this.getOfferingId() != null) {
            sb.append("OfferingId: ").append(this.getOfferingId()).append(",");
        }
        if (this.getPaymentOption() != null) {
            sb.append("PaymentOption: ").append(this.getPaymentOption()).append(",");
        }
        if (this.getStart() != null) {
            sb.append("Start: ").append(this.getStart()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getUpfrontPrice() != null) {
            sb.append("UpfrontPrice: ").append(this.getUpfrontPrice()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostReservation)) {
            return false;
        }
        HostReservation other = (HostReservation)obj;
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getCurrencyCode() == null ^ this.getCurrencyCode() == null) {
            return false;
        }
        if (other.getCurrencyCode() != null && !other.getCurrencyCode().equals(this.getCurrencyCode())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getEnd() == null ^ this.getEnd() == null) {
            return false;
        }
        if (other.getEnd() != null && !other.getEnd().equals(this.getEnd())) {
            return false;
        }
        if (other.getHostIdSet() == null ^ this.getHostIdSet() == null) {
            return false;
        }
        if (other.getHostIdSet() != null && !other.getHostIdSet().equals(this.getHostIdSet())) {
            return false;
        }
        if (other.getHostReservationId() == null ^ this.getHostReservationId() == null) {
            return false;
        }
        if (other.getHostReservationId() != null && !other.getHostReservationId().equals(this.getHostReservationId())) {
            return false;
        }
        if (other.getHourlyPrice() == null ^ this.getHourlyPrice() == null) {
            return false;
        }
        if (other.getHourlyPrice() != null && !other.getHourlyPrice().equals(this.getHourlyPrice())) {
            return false;
        }
        if (other.getInstanceFamily() == null ^ this.getInstanceFamily() == null) {
            return false;
        }
        if (other.getInstanceFamily() != null && !other.getInstanceFamily().equals(this.getInstanceFamily())) {
            return false;
        }
        if (other.getOfferingId() == null ^ this.getOfferingId() == null) {
            return false;
        }
        if (other.getOfferingId() != null && !other.getOfferingId().equals(this.getOfferingId())) {
            return false;
        }
        if (other.getPaymentOption() == null ^ this.getPaymentOption() == null) {
            return false;
        }
        if (other.getPaymentOption() != null && !other.getPaymentOption().equals(this.getPaymentOption())) {
            return false;
        }
        if (other.getStart() == null ^ this.getStart() == null) {
            return false;
        }
        if (other.getStart() != null && !other.getStart().equals(this.getStart())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getUpfrontPrice() == null ^ this.getUpfrontPrice() == null) {
            return false;
        }
        if (other.getUpfrontPrice() != null && !other.getUpfrontPrice().equals(this.getUpfrontPrice())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getCurrencyCode() == null ? 0 : this.getCurrencyCode().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getEnd() == null ? 0 : this.getEnd().hashCode());
        hashCode = 31 * hashCode + (this.getHostIdSet() == null ? 0 : this.getHostIdSet().hashCode());
        hashCode = 31 * hashCode + (this.getHostReservationId() == null ? 0 : this.getHostReservationId().hashCode());
        hashCode = 31 * hashCode + (this.getHourlyPrice() == null ? 0 : this.getHourlyPrice().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceFamily() == null ? 0 : this.getInstanceFamily().hashCode());
        hashCode = 31 * hashCode + (this.getOfferingId() == null ? 0 : this.getOfferingId().hashCode());
        hashCode = 31 * hashCode + (this.getPaymentOption() == null ? 0 : this.getPaymentOption().hashCode());
        hashCode = 31 * hashCode + (this.getStart() == null ? 0 : this.getStart().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getUpfrontPrice() == null ? 0 : this.getUpfrontPrice().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public HostReservation clone() {
        try {
            return (HostReservation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

