/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PoolCidrBlock;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Ipv6Pool
implements Serializable,
Cloneable {
    private String poolId;
    private String description;
    private SdkInternalList<PoolCidrBlock> poolCidrBlocks;
    private SdkInternalList<Tag> tags;

    public void setPoolId(String poolId) {
        this.poolId = poolId;
    }

    public String getPoolId() {
        return this.poolId;
    }

    public Ipv6Pool withPoolId(String poolId) {
        this.setPoolId(poolId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Ipv6Pool withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<PoolCidrBlock> getPoolCidrBlocks() {
        if (this.poolCidrBlocks == null) {
            this.poolCidrBlocks = new SdkInternalList();
        }
        return this.poolCidrBlocks;
    }

    public void setPoolCidrBlocks(Collection<PoolCidrBlock> poolCidrBlocks) {
        if (poolCidrBlocks == null) {
            this.poolCidrBlocks = null;
            return;
        }
        this.poolCidrBlocks = new SdkInternalList<PoolCidrBlock>(poolCidrBlocks);
    }

    public Ipv6Pool withPoolCidrBlocks(PoolCidrBlock ... poolCidrBlocks) {
        if (this.poolCidrBlocks == null) {
            this.setPoolCidrBlocks(new SdkInternalList<PoolCidrBlock>(poolCidrBlocks.length));
        }
        for (PoolCidrBlock ele : poolCidrBlocks) {
            this.poolCidrBlocks.add(ele);
        }
        return this;
    }

    public Ipv6Pool withPoolCidrBlocks(Collection<PoolCidrBlock> poolCidrBlocks) {
        this.setPoolCidrBlocks(poolCidrBlocks);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public Ipv6Pool withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Ipv6Pool withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPoolId() != null) {
            sb.append("PoolId: ").append(this.getPoolId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPoolCidrBlocks() != null) {
            sb.append("PoolCidrBlocks: ").append(this.getPoolCidrBlocks()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ipv6Pool)) {
            return false;
        }
        Ipv6Pool other = (Ipv6Pool)obj;
        if (other.getPoolId() == null ^ this.getPoolId() == null) {
            return false;
        }
        if (other.getPoolId() != null && !other.getPoolId().equals(this.getPoolId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPoolCidrBlocks() == null ^ this.getPoolCidrBlocks() == null) {
            return false;
        }
        if (other.getPoolCidrBlocks() != null && !other.getPoolCidrBlocks().equals(this.getPoolCidrBlocks())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPoolId() == null ? 0 : this.getPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPoolCidrBlocks() == null ? 0 : this.getPoolCidrBlocks().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Ipv6Pool clone() {
        try {
            return (Ipv6Pool)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

