/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ArchitectureType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ProcessorInfo
implements Serializable,
Cloneable {
    private SdkInternalList<String> supportedArchitectures;
    private Double sustainedClockSpeedInGhz;

    public List<String> getSupportedArchitectures() {
        if (this.supportedArchitectures == null) {
            this.supportedArchitectures = new SdkInternalList();
        }
        return this.supportedArchitectures;
    }

    public void setSupportedArchitectures(Collection<String> supportedArchitectures) {
        if (supportedArchitectures == null) {
            this.supportedArchitectures = null;
            return;
        }
        this.supportedArchitectures = new SdkInternalList<String>(supportedArchitectures);
    }

    public ProcessorInfo withSupportedArchitectures(String ... supportedArchitectures) {
        if (this.supportedArchitectures == null) {
            this.setSupportedArchitectures(new SdkInternalList<String>(supportedArchitectures.length));
        }
        for (String ele : supportedArchitectures) {
            this.supportedArchitectures.add(ele);
        }
        return this;
    }

    public ProcessorInfo withSupportedArchitectures(Collection<String> supportedArchitectures) {
        this.setSupportedArchitectures(supportedArchitectures);
        return this;
    }

    public ProcessorInfo withSupportedArchitectures(ArchitectureType ... supportedArchitectures) {
        SdkInternalList<String> supportedArchitecturesCopy = new SdkInternalList<String>(supportedArchitectures.length);
        for (ArchitectureType value : supportedArchitectures) {
            supportedArchitecturesCopy.add(value.toString());
        }
        if (this.getSupportedArchitectures() == null) {
            this.setSupportedArchitectures(supportedArchitecturesCopy);
        } else {
            this.getSupportedArchitectures().addAll(supportedArchitecturesCopy);
        }
        return this;
    }

    public void setSustainedClockSpeedInGhz(Double sustainedClockSpeedInGhz) {
        this.sustainedClockSpeedInGhz = sustainedClockSpeedInGhz;
    }

    public Double getSustainedClockSpeedInGhz() {
        return this.sustainedClockSpeedInGhz;
    }

    public ProcessorInfo withSustainedClockSpeedInGhz(Double sustainedClockSpeedInGhz) {
        this.setSustainedClockSpeedInGhz(sustainedClockSpeedInGhz);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSupportedArchitectures() != null) {
            sb.append("SupportedArchitectures: ").append(this.getSupportedArchitectures()).append(",");
        }
        if (this.getSustainedClockSpeedInGhz() != null) {
            sb.append("SustainedClockSpeedInGhz: ").append(this.getSustainedClockSpeedInGhz());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorInfo)) {
            return false;
        }
        ProcessorInfo other = (ProcessorInfo)obj;
        if (other.getSupportedArchitectures() == null ^ this.getSupportedArchitectures() == null) {
            return false;
        }
        if (other.getSupportedArchitectures() != null && !other.getSupportedArchitectures().equals(this.getSupportedArchitectures())) {
            return false;
        }
        if (other.getSustainedClockSpeedInGhz() == null ^ this.getSustainedClockSpeedInGhz() == null) {
            return false;
        }
        return other.getSustainedClockSpeedInGhz() == null || other.getSustainedClockSpeedInGhz().equals(this.getSustainedClockSpeedInGhz());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSupportedArchitectures() == null ? 0 : this.getSupportedArchitectures().hashCode());
        hashCode = 31 * hashCode + (this.getSustainedClockSpeedInGhz() == null ? 0 : this.getSustainedClockSpeedInGhz().hashCode());
        return hashCode;
    }

    public ProcessorInfo clone() {
        try {
            return (ProcessorInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

