/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.Instance;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Reservation
implements Serializable,
Cloneable {
    private SdkInternalList<GroupIdentifier> groups;
    private SdkInternalList<Instance> instances;
    private String ownerId;
    private String requesterId;
    private String reservationId;
    private SdkInternalList<String> groupNames;

    public List<GroupIdentifier> getGroups() {
        if (this.groups == null) {
            this.groups = new SdkInternalList();
        }
        return this.groups;
    }

    public void setGroups(Collection<GroupIdentifier> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new SdkInternalList<GroupIdentifier>(groups);
    }

    public Reservation withGroups(GroupIdentifier ... groups) {
        if (this.groups == null) {
            this.setGroups(new SdkInternalList<GroupIdentifier>(groups.length));
        }
        for (GroupIdentifier ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public Reservation withGroups(Collection<GroupIdentifier> groups) {
        this.setGroups(groups);
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new SdkInternalList();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new SdkInternalList<Instance>(instances);
    }

    public Reservation withInstances(Instance ... instances) {
        if (this.instances == null) {
            this.setInstances(new SdkInternalList<Instance>(instances.length));
        }
        for (Instance ele : instances) {
            this.instances.add(ele);
        }
        return this;
    }

    public Reservation withInstances(Collection<Instance> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public Reservation withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public void setRequesterId(String requesterId) {
        this.requesterId = requesterId;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public Reservation withRequesterId(String requesterId) {
        this.setRequesterId(requesterId);
        return this;
    }

    public void setReservationId(String reservationId) {
        this.reservationId = reservationId;
    }

    public String getReservationId() {
        return this.reservationId;
    }

    public Reservation withReservationId(String reservationId) {
        this.setReservationId(reservationId);
        return this;
    }

    public List<String> getGroupNames() {
        if (this.groupNames == null) {
            this.groupNames = new SdkInternalList();
        }
        return this.groupNames;
    }

    public void setGroupNames(Collection<String> groupNames) {
        if (groupNames == null) {
            this.groupNames = null;
            return;
        }
        this.groupNames = new SdkInternalList<String>(groupNames);
    }

    public Reservation withGroupNames(String ... groupNames) {
        if (this.groupNames == null) {
            this.setGroupNames(new SdkInternalList<String>(groupNames.length));
        }
        for (String ele : groupNames) {
            this.groupNames.add(ele);
        }
        return this;
    }

    public Reservation withGroupNames(Collection<String> groupNames) {
        this.setGroupNames(groupNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: ").append(this.getOwnerId()).append(",");
        }
        if (this.getRequesterId() != null) {
            sb.append("RequesterId: ").append(this.getRequesterId()).append(",");
        }
        if (this.getReservationId() != null) {
            sb.append("ReservationId: ").append(this.getReservationId()).append(",");
        }
        if (this.getGroupNames() != null) {
            sb.append("GroupNames: ").append(this.getGroupNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation)obj;
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getRequesterId() == null ^ this.getRequesterId() == null) {
            return false;
        }
        if (other.getRequesterId() != null && !other.getRequesterId().equals(this.getRequesterId())) {
            return false;
        }
        if (other.getReservationId() == null ^ this.getReservationId() == null) {
            return false;
        }
        if (other.getReservationId() != null && !other.getReservationId().equals(this.getReservationId())) {
            return false;
        }
        if (other.getGroupNames() == null ^ this.getGroupNames() == null) {
            return false;
        }
        return other.getGroupNames() == null || other.getGroupNames().equals(this.getGroupNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getRequesterId() == null ? 0 : this.getRequesterId().hashCode());
        hashCode = 31 * hashCode + (this.getReservationId() == null ? 0 : this.getReservationId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupNames() == null ? 0 : this.getGroupNames().hashCode());
        return hashCode;
    }

    public Reservation clone() {
        try {
            return (Reservation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

