/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PropagatingVgw;
import com.amazonaws.services.ec2.model.Route;
import com.amazonaws.services.ec2.model.RouteTableAssociation;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RouteTable
implements Serializable,
Cloneable {
    private SdkInternalList<RouteTableAssociation> associations;
    private SdkInternalList<PropagatingVgw> propagatingVgws;
    private String routeTableId;
    private SdkInternalList<Route> routes;
    private SdkInternalList<Tag> tags;
    private String vpcId;
    private String ownerId;

    public List<RouteTableAssociation> getAssociations() {
        if (this.associations == null) {
            this.associations = new SdkInternalList();
        }
        return this.associations;
    }

    public void setAssociations(Collection<RouteTableAssociation> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }
        this.associations = new SdkInternalList<RouteTableAssociation>(associations);
    }

    public RouteTable withAssociations(RouteTableAssociation ... associations) {
        if (this.associations == null) {
            this.setAssociations(new SdkInternalList<RouteTableAssociation>(associations.length));
        }
        for (RouteTableAssociation ele : associations) {
            this.associations.add(ele);
        }
        return this;
    }

    public RouteTable withAssociations(Collection<RouteTableAssociation> associations) {
        this.setAssociations(associations);
        return this;
    }

    public List<PropagatingVgw> getPropagatingVgws() {
        if (this.propagatingVgws == null) {
            this.propagatingVgws = new SdkInternalList();
        }
        return this.propagatingVgws;
    }

    public void setPropagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
        if (propagatingVgws == null) {
            this.propagatingVgws = null;
            return;
        }
        this.propagatingVgws = new SdkInternalList<PropagatingVgw>(propagatingVgws);
    }

    public RouteTable withPropagatingVgws(PropagatingVgw ... propagatingVgws) {
        if (this.propagatingVgws == null) {
            this.setPropagatingVgws(new SdkInternalList<PropagatingVgw>(propagatingVgws.length));
        }
        for (PropagatingVgw ele : propagatingVgws) {
            this.propagatingVgws.add(ele);
        }
        return this;
    }

    public RouteTable withPropagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
        this.setPropagatingVgws(propagatingVgws);
        return this;
    }

    public void setRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
    }

    public String getRouteTableId() {
        return this.routeTableId;
    }

    public RouteTable withRouteTableId(String routeTableId) {
        this.setRouteTableId(routeTableId);
        return this;
    }

    public List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new SdkInternalList();
        }
        return this.routes;
    }

    public void setRoutes(Collection<Route> routes) {
        if (routes == null) {
            this.routes = null;
            return;
        }
        this.routes = new SdkInternalList<Route>(routes);
    }

    public RouteTable withRoutes(Route ... routes) {
        if (this.routes == null) {
            this.setRoutes(new SdkInternalList<Route>(routes.length));
        }
        for (Route ele : routes) {
            this.routes.add(ele);
        }
        return this;
    }

    public RouteTable withRoutes(Collection<Route> routes) {
        this.setRoutes(routes);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public RouteTable withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public RouteTable withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public RouteTable withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public RouteTable withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociations() != null) {
            sb.append("Associations: ").append(this.getAssociations()).append(",");
        }
        if (this.getPropagatingVgws() != null) {
            sb.append("PropagatingVgws: ").append(this.getPropagatingVgws()).append(",");
        }
        if (this.getRouteTableId() != null) {
            sb.append("RouteTableId: ").append(this.getRouteTableId()).append(",");
        }
        if (this.getRoutes() != null) {
            sb.append("Routes: ").append(this.getRoutes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: ").append(this.getOwnerId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable)obj;
        if (other.getAssociations() == null ^ this.getAssociations() == null) {
            return false;
        }
        if (other.getAssociations() != null && !other.getAssociations().equals(this.getAssociations())) {
            return false;
        }
        if (other.getPropagatingVgws() == null ^ this.getPropagatingVgws() == null) {
            return false;
        }
        if (other.getPropagatingVgws() != null && !other.getPropagatingVgws().equals(this.getPropagatingVgws())) {
            return false;
        }
        if (other.getRouteTableId() == null ^ this.getRouteTableId() == null) {
            return false;
        }
        if (other.getRouteTableId() != null && !other.getRouteTableId().equals(this.getRouteTableId())) {
            return false;
        }
        if (other.getRoutes() == null ^ this.getRoutes() == null) {
            return false;
        }
        if (other.getRoutes() != null && !other.getRoutes().equals(this.getRoutes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        return other.getOwnerId() == null || other.getOwnerId().equals(this.getOwnerId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociations() == null ? 0 : this.getAssociations().hashCode());
        hashCode = 31 * hashCode + (this.getPropagatingVgws() == null ? 0 : this.getPropagatingVgws().hashCode());
        hashCode = 31 * hashCode + (this.getRouteTableId() == null ? 0 : this.getRouteTableId().hashCode());
        hashCode = 31 * hashCode + (this.getRoutes() == null ? 0 : this.getRoutes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        return hashCode;
    }

    public RouteTable clone() {
        try {
            return (RouteTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

