/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ActivityStatus;
import com.amazonaws.services.ec2.model.BatchState;
import com.amazonaws.services.ec2.model.SpotFleetRequestConfigData;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SpotFleetRequestConfig
implements Serializable,
Cloneable {
    private String activityStatus;
    private Date createTime;
    private SpotFleetRequestConfigData spotFleetRequestConfig;
    private String spotFleetRequestId;
    private String spotFleetRequestState;
    private SdkInternalList<Tag> tags;

    public void setActivityStatus(String activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getActivityStatus() {
        return this.activityStatus;
    }

    public SpotFleetRequestConfig withActivityStatus(String activityStatus) {
        this.setActivityStatus(activityStatus);
        return this;
    }

    public void setActivityStatus(ActivityStatus activityStatus) {
        this.withActivityStatus(activityStatus);
    }

    public SpotFleetRequestConfig withActivityStatus(ActivityStatus activityStatus) {
        this.activityStatus = activityStatus.toString();
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public SpotFleetRequestConfig withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setSpotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
        this.spotFleetRequestConfig = spotFleetRequestConfig;
    }

    public SpotFleetRequestConfigData getSpotFleetRequestConfig() {
        return this.spotFleetRequestConfig;
    }

    public SpotFleetRequestConfig withSpotFleetRequestConfig(SpotFleetRequestConfigData spotFleetRequestConfig) {
        this.setSpotFleetRequestConfig(spotFleetRequestConfig);
        return this;
    }

    public void setSpotFleetRequestId(String spotFleetRequestId) {
        this.spotFleetRequestId = spotFleetRequestId;
    }

    public String getSpotFleetRequestId() {
        return this.spotFleetRequestId;
    }

    public SpotFleetRequestConfig withSpotFleetRequestId(String spotFleetRequestId) {
        this.setSpotFleetRequestId(spotFleetRequestId);
        return this;
    }

    public void setSpotFleetRequestState(String spotFleetRequestState) {
        this.spotFleetRequestState = spotFleetRequestState;
    }

    public String getSpotFleetRequestState() {
        return this.spotFleetRequestState;
    }

    public SpotFleetRequestConfig withSpotFleetRequestState(String spotFleetRequestState) {
        this.setSpotFleetRequestState(spotFleetRequestState);
        return this;
    }

    public void setSpotFleetRequestState(BatchState spotFleetRequestState) {
        this.withSpotFleetRequestState(spotFleetRequestState);
    }

    public SpotFleetRequestConfig withSpotFleetRequestState(BatchState spotFleetRequestState) {
        this.spotFleetRequestState = spotFleetRequestState.toString();
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public SpotFleetRequestConfig withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public SpotFleetRequestConfig withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActivityStatus() != null) {
            sb.append("ActivityStatus: ").append(this.getActivityStatus()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getSpotFleetRequestConfig() != null) {
            sb.append("SpotFleetRequestConfig: ").append(this.getSpotFleetRequestConfig()).append(",");
        }
        if (this.getSpotFleetRequestId() != null) {
            sb.append("SpotFleetRequestId: ").append(this.getSpotFleetRequestId()).append(",");
        }
        if (this.getSpotFleetRequestState() != null) {
            sb.append("SpotFleetRequestState: ").append(this.getSpotFleetRequestState()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetRequestConfig)) {
            return false;
        }
        SpotFleetRequestConfig other = (SpotFleetRequestConfig)obj;
        if (other.getActivityStatus() == null ^ this.getActivityStatus() == null) {
            return false;
        }
        if (other.getActivityStatus() != null && !other.getActivityStatus().equals(this.getActivityStatus())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getSpotFleetRequestConfig() == null ^ this.getSpotFleetRequestConfig() == null) {
            return false;
        }
        if (other.getSpotFleetRequestConfig() != null && !other.getSpotFleetRequestConfig().equals(this.getSpotFleetRequestConfig())) {
            return false;
        }
        if (other.getSpotFleetRequestId() == null ^ this.getSpotFleetRequestId() == null) {
            return false;
        }
        if (other.getSpotFleetRequestId() != null && !other.getSpotFleetRequestId().equals(this.getSpotFleetRequestId())) {
            return false;
        }
        if (other.getSpotFleetRequestState() == null ^ this.getSpotFleetRequestState() == null) {
            return false;
        }
        if (other.getSpotFleetRequestState() != null && !other.getSpotFleetRequestState().equals(this.getSpotFleetRequestState())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActivityStatus() == null ? 0 : this.getActivityStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getSpotFleetRequestConfig() == null ? 0 : this.getSpotFleetRequestConfig().hashCode());
        hashCode = 31 * hashCode + (this.getSpotFleetRequestId() == null ? 0 : this.getSpotFleetRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getSpotFleetRequestState() == null ? 0 : this.getSpotFleetRequestState().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public SpotFleetRequestConfig clone() {
        try {
            return (SpotFleetRequestConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

