/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TrafficMirrorFilterRule;
import com.amazonaws.services.ec2.model.TrafficMirrorNetworkService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class TrafficMirrorFilter
implements Serializable,
Cloneable {
    private String trafficMirrorFilterId;
    private SdkInternalList<TrafficMirrorFilterRule> ingressFilterRules;
    private SdkInternalList<TrafficMirrorFilterRule> egressFilterRules;
    private SdkInternalList<String> networkServices;
    private String description;
    private SdkInternalList<Tag> tags;

    public void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
        this.trafficMirrorFilterId = trafficMirrorFilterId;
    }

    public String getTrafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    public TrafficMirrorFilter withTrafficMirrorFilterId(String trafficMirrorFilterId) {
        this.setTrafficMirrorFilterId(trafficMirrorFilterId);
        return this;
    }

    public List<TrafficMirrorFilterRule> getIngressFilterRules() {
        if (this.ingressFilterRules == null) {
            this.ingressFilterRules = new SdkInternalList();
        }
        return this.ingressFilterRules;
    }

    public void setIngressFilterRules(Collection<TrafficMirrorFilterRule> ingressFilterRules) {
        if (ingressFilterRules == null) {
            this.ingressFilterRules = null;
            return;
        }
        this.ingressFilterRules = new SdkInternalList<TrafficMirrorFilterRule>(ingressFilterRules);
    }

    public TrafficMirrorFilter withIngressFilterRules(TrafficMirrorFilterRule ... ingressFilterRules) {
        if (this.ingressFilterRules == null) {
            this.setIngressFilterRules(new SdkInternalList<TrafficMirrorFilterRule>(ingressFilterRules.length));
        }
        for (TrafficMirrorFilterRule ele : ingressFilterRules) {
            this.ingressFilterRules.add(ele);
        }
        return this;
    }

    public TrafficMirrorFilter withIngressFilterRules(Collection<TrafficMirrorFilterRule> ingressFilterRules) {
        this.setIngressFilterRules(ingressFilterRules);
        return this;
    }

    public List<TrafficMirrorFilterRule> getEgressFilterRules() {
        if (this.egressFilterRules == null) {
            this.egressFilterRules = new SdkInternalList();
        }
        return this.egressFilterRules;
    }

    public void setEgressFilterRules(Collection<TrafficMirrorFilterRule> egressFilterRules) {
        if (egressFilterRules == null) {
            this.egressFilterRules = null;
            return;
        }
        this.egressFilterRules = new SdkInternalList<TrafficMirrorFilterRule>(egressFilterRules);
    }

    public TrafficMirrorFilter withEgressFilterRules(TrafficMirrorFilterRule ... egressFilterRules) {
        if (this.egressFilterRules == null) {
            this.setEgressFilterRules(new SdkInternalList<TrafficMirrorFilterRule>(egressFilterRules.length));
        }
        for (TrafficMirrorFilterRule ele : egressFilterRules) {
            this.egressFilterRules.add(ele);
        }
        return this;
    }

    public TrafficMirrorFilter withEgressFilterRules(Collection<TrafficMirrorFilterRule> egressFilterRules) {
        this.setEgressFilterRules(egressFilterRules);
        return this;
    }

    public List<String> getNetworkServices() {
        if (this.networkServices == null) {
            this.networkServices = new SdkInternalList();
        }
        return this.networkServices;
    }

    public void setNetworkServices(Collection<String> networkServices) {
        if (networkServices == null) {
            this.networkServices = null;
            return;
        }
        this.networkServices = new SdkInternalList<String>(networkServices);
    }

    public TrafficMirrorFilter withNetworkServices(String ... networkServices) {
        if (this.networkServices == null) {
            this.setNetworkServices(new SdkInternalList<String>(networkServices.length));
        }
        for (String ele : networkServices) {
            this.networkServices.add(ele);
        }
        return this;
    }

    public TrafficMirrorFilter withNetworkServices(Collection<String> networkServices) {
        this.setNetworkServices(networkServices);
        return this;
    }

    public TrafficMirrorFilter withNetworkServices(TrafficMirrorNetworkService ... networkServices) {
        SdkInternalList<String> networkServicesCopy = new SdkInternalList<String>(networkServices.length);
        for (TrafficMirrorNetworkService value : networkServices) {
            networkServicesCopy.add(value.toString());
        }
        if (this.getNetworkServices() == null) {
            this.setNetworkServices(networkServicesCopy);
        } else {
            this.getNetworkServices().addAll(networkServicesCopy);
        }
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public TrafficMirrorFilter withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public TrafficMirrorFilter withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public TrafficMirrorFilter withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrafficMirrorFilterId() != null) {
            sb.append("TrafficMirrorFilterId: ").append(this.getTrafficMirrorFilterId()).append(",");
        }
        if (this.getIngressFilterRules() != null) {
            sb.append("IngressFilterRules: ").append(this.getIngressFilterRules()).append(",");
        }
        if (this.getEgressFilterRules() != null) {
            sb.append("EgressFilterRules: ").append(this.getEgressFilterRules()).append(",");
        }
        if (this.getNetworkServices() != null) {
            sb.append("NetworkServices: ").append(this.getNetworkServices()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorFilter)) {
            return false;
        }
        TrafficMirrorFilter other = (TrafficMirrorFilter)obj;
        if (other.getTrafficMirrorFilterId() == null ^ this.getTrafficMirrorFilterId() == null) {
            return false;
        }
        if (other.getTrafficMirrorFilterId() != null && !other.getTrafficMirrorFilterId().equals(this.getTrafficMirrorFilterId())) {
            return false;
        }
        if (other.getIngressFilterRules() == null ^ this.getIngressFilterRules() == null) {
            return false;
        }
        if (other.getIngressFilterRules() != null && !other.getIngressFilterRules().equals(this.getIngressFilterRules())) {
            return false;
        }
        if (other.getEgressFilterRules() == null ^ this.getEgressFilterRules() == null) {
            return false;
        }
        if (other.getEgressFilterRules() != null && !other.getEgressFilterRules().equals(this.getEgressFilterRules())) {
            return false;
        }
        if (other.getNetworkServices() == null ^ this.getNetworkServices() == null) {
            return false;
        }
        if (other.getNetworkServices() != null && !other.getNetworkServices().equals(this.getNetworkServices())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrafficMirrorFilterId() == null ? 0 : this.getTrafficMirrorFilterId().hashCode());
        hashCode = 31 * hashCode + (this.getIngressFilterRules() == null ? 0 : this.getIngressFilterRules().hashCode());
        hashCode = 31 * hashCode + (this.getEgressFilterRules() == null ? 0 : this.getEgressFilterRules().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkServices() == null ? 0 : this.getNetworkServices().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TrafficMirrorFilter clone() {
        try {
            return (TrafficMirrorFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

