/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AssignIpv6AddressesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AssignIpv6AddressesRequestMarshaller
implements Marshaller<Request<AssignIpv6AddressesRequest>, AssignIpv6AddressesRequest> {
    @Override
    public Request<AssignIpv6AddressesRequest> marshall(AssignIpv6AddressesRequest assignIpv6AddressesRequest) {
        SdkInternalList assignIpv6AddressesRequestIpv6AddressesList;
        if (assignIpv6AddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AssignIpv6AddressesRequest> request = new DefaultRequest<AssignIpv6AddressesRequest>(assignIpv6AddressesRequest, "AmazonEC2");
        request.addParameter("Action", "AssignIpv6Addresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assignIpv6AddressesRequest.getIpv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger(assignIpv6AddressesRequest.getIpv6AddressCount()));
        }
        if (!(assignIpv6AddressesRequestIpv6AddressesList = (SdkInternalList)assignIpv6AddressesRequest.getIpv6Addresses()).isEmpty() || !assignIpv6AddressesRequestIpv6AddressesList.isAutoConstruct()) {
            int ipv6AddressesListIndex = 1;
            for (String assignIpv6AddressesRequestIpv6AddressesListValue : assignIpv6AddressesRequestIpv6AddressesList) {
                if (assignIpv6AddressesRequestIpv6AddressesListValue != null) {
                    request.addParameter("Ipv6Addresses." + ipv6AddressesListIndex, StringUtils.fromString(assignIpv6AddressesRequestIpv6AddressesListValue));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (assignIpv6AddressesRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(assignIpv6AddressesRequest.getNetworkInterfaceId()));
        }
        return request;
    }
}

