/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AttachVolumeRequestMarshaller
implements Marshaller<Request<AttachVolumeRequest>, AttachVolumeRequest> {
    @Override
    public Request<AttachVolumeRequest> marshall(AttachVolumeRequest attachVolumeRequest) {
        if (attachVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AttachVolumeRequest> request = new DefaultRequest<AttachVolumeRequest>(attachVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "AttachVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachVolumeRequest.getDevice() != null) {
            request.addParameter("Device", StringUtils.fromString(attachVolumeRequest.getDevice()));
        }
        if (attachVolumeRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(attachVolumeRequest.getInstanceId()));
        }
        if (attachVolumeRequest.getVolumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString(attachVolumeRequest.getVolumeId()));
        }
        return request;
    }
}

