/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.DescribeFleetHistoryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeFleetHistoryRequestMarshaller
implements Marshaller<Request<DescribeFleetHistoryRequest>, DescribeFleetHistoryRequest> {
    @Override
    public Request<DescribeFleetHistoryRequest> marshall(DescribeFleetHistoryRequest describeFleetHistoryRequest) {
        if (describeFleetHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetHistoryRequest> request = new DefaultRequest<DescribeFleetHistoryRequest>(describeFleetHistoryRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeFleetHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeFleetHistoryRequest.getEventType() != null) {
            request.addParameter("EventType", StringUtils.fromString(describeFleetHistoryRequest.getEventType()));
        }
        if (describeFleetHistoryRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeFleetHistoryRequest.getMaxResults()));
        }
        if (describeFleetHistoryRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeFleetHistoryRequest.getNextToken()));
        }
        if (describeFleetHistoryRequest.getFleetId() != null) {
            request.addParameter("FleetId", StringUtils.fromString(describeFleetHistoryRequest.getFleetId()));
        }
        if (describeFleetHistoryRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(describeFleetHistoryRequest.getStartTime()));
        }
        return request;
    }
}

