/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeTransitGatewayMulticastDomainsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeTransitGatewayMulticastDomainsRequestMarshaller
implements Marshaller<Request<DescribeTransitGatewayMulticastDomainsRequest>, DescribeTransitGatewayMulticastDomainsRequest> {
    @Override
    public Request<DescribeTransitGatewayMulticastDomainsRequest> marshall(DescribeTransitGatewayMulticastDomainsRequest describeTransitGatewayMulticastDomainsRequest) {
        SdkInternalList describeTransitGatewayMulticastDomainsRequestFiltersList;
        if (describeTransitGatewayMulticastDomainsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTransitGatewayMulticastDomainsRequest> request = new DefaultRequest<DescribeTransitGatewayMulticastDomainsRequest>(describeTransitGatewayMulticastDomainsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeTransitGatewayMulticastDomains");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeTransitGatewayMulticastDomainsRequestTransitGatewayMulticastDomainIdsList = (SdkInternalList)describeTransitGatewayMulticastDomainsRequest.getTransitGatewayMulticastDomainIds();
        if (!describeTransitGatewayMulticastDomainsRequestTransitGatewayMulticastDomainIdsList.isEmpty() || !describeTransitGatewayMulticastDomainsRequestTransitGatewayMulticastDomainIdsList.isAutoConstruct()) {
            int transitGatewayMulticastDomainIdsListIndex = 1;
            for (String describeTransitGatewayMulticastDomainsRequestTransitGatewayMulticastDomainIdsListValue : describeTransitGatewayMulticastDomainsRequestTransitGatewayMulticastDomainIdsList) {
                if (describeTransitGatewayMulticastDomainsRequestTransitGatewayMulticastDomainIdsListValue != null) {
                    request.addParameter("TransitGatewayMulticastDomainIds." + transitGatewayMulticastDomainIdsListIndex, StringUtils.fromString(describeTransitGatewayMulticastDomainsRequestTransitGatewayMulticastDomainIdsListValue));
                }
                ++transitGatewayMulticastDomainIdsListIndex;
            }
        }
        if (!(describeTransitGatewayMulticastDomainsRequestFiltersList = (SdkInternalList)describeTransitGatewayMulticastDomainsRequest.getFilters()).isEmpty() || !describeTransitGatewayMulticastDomainsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeTransitGatewayMulticastDomainsRequestFiltersListValue : describeTransitGatewayMulticastDomainsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeTransitGatewayMulticastDomainsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeTransitGatewayMulticastDomainsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeTransitGatewayMulticastDomainsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeTransitGatewayMulticastDomainsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeTransitGatewayMulticastDomainsRequest.getMaxResults()));
        }
        if (describeTransitGatewayMulticastDomainsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeTransitGatewayMulticastDomainsRequest.getNextToken()));
        }
        return request;
    }
}

