/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.DiskImage;
import com.amazonaws.services.ec2.model.transform.DiskImageDetailStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.VolumeDetailStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DiskImageStaxUnmarshaller
implements Unmarshaller<DiskImage, StaxUnmarshallerContext> {
    private static DiskImageStaxUnmarshaller instance;

    @Override
    public DiskImage unmarshall(StaxUnmarshallerContext context) throws Exception {
        DiskImage diskImage = new DiskImage();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return diskImage;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Description", targetDepth)) {
                    diskImage.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Image", targetDepth)) {
                    diskImage.setImage(DiskImageDetailStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Volume", targetDepth)) continue;
                diskImage.setVolume(VolumeDetailStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return diskImage;
    }

    public static DiskImageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DiskImageStaxUnmarshaller();
        }
        return instance;
    }
}

