/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ClientConnectOptions;
import com.amazonaws.services.ec2.model.ConnectionLogOptions;
import com.amazonaws.services.ec2.model.DnsServersOptionsModifyStructure;
import com.amazonaws.services.ec2.model.ModifyClientVpnEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyClientVpnEndpointRequestMarshaller
implements Marshaller<Request<ModifyClientVpnEndpointRequest>, ModifyClientVpnEndpointRequest> {
    @Override
    public Request<ModifyClientVpnEndpointRequest> marshall(ModifyClientVpnEndpointRequest modifyClientVpnEndpointRequest) {
        ClientConnectOptions clientConnectOptions;
        SdkInternalList modifyClientVpnEndpointRequestSecurityGroupIdsList;
        DnsServersOptionsModifyStructure dnsServers;
        ConnectionLogOptions connectionLogOptions;
        if (modifyClientVpnEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyClientVpnEndpointRequest> request = new DefaultRequest<ModifyClientVpnEndpointRequest>(modifyClientVpnEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyClientVpnEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyClientVpnEndpointRequest.getClientVpnEndpointId() != null) {
            request.addParameter("ClientVpnEndpointId", StringUtils.fromString(modifyClientVpnEndpointRequest.getClientVpnEndpointId()));
        }
        if (modifyClientVpnEndpointRequest.getServerCertificateArn() != null) {
            request.addParameter("ServerCertificateArn", StringUtils.fromString(modifyClientVpnEndpointRequest.getServerCertificateArn()));
        }
        if ((connectionLogOptions = modifyClientVpnEndpointRequest.getConnectionLogOptions()) != null) {
            if (connectionLogOptions.getEnabled() != null) {
                request.addParameter("ConnectionLogOptions.Enabled", StringUtils.fromBoolean(connectionLogOptions.getEnabled()));
            }
            if (connectionLogOptions.getCloudwatchLogGroup() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogGroup", StringUtils.fromString(connectionLogOptions.getCloudwatchLogGroup()));
            }
            if (connectionLogOptions.getCloudwatchLogStream() != null) {
                request.addParameter("ConnectionLogOptions.CloudwatchLogStream", StringUtils.fromString(connectionLogOptions.getCloudwatchLogStream()));
            }
        }
        if ((dnsServers = modifyClientVpnEndpointRequest.getDnsServers()) != null) {
            SdkInternalList dnsServersOptionsModifyStructureCustomDnsServersList = (SdkInternalList)dnsServers.getCustomDnsServers();
            if (!dnsServersOptionsModifyStructureCustomDnsServersList.isEmpty() || !dnsServersOptionsModifyStructureCustomDnsServersList.isAutoConstruct()) {
                int customDnsServersListIndex = 1;
                for (String dnsServersOptionsModifyStructureCustomDnsServersListValue : dnsServersOptionsModifyStructureCustomDnsServersList) {
                    if (dnsServersOptionsModifyStructureCustomDnsServersListValue != null) {
                        request.addParameter("DnsServers.CustomDnsServers." + customDnsServersListIndex, StringUtils.fromString(dnsServersOptionsModifyStructureCustomDnsServersListValue));
                    }
                    ++customDnsServersListIndex;
                }
            }
            if (dnsServers.getEnabled() != null) {
                request.addParameter("DnsServers.Enabled", StringUtils.fromBoolean(dnsServers.getEnabled()));
            }
        }
        if (modifyClientVpnEndpointRequest.getVpnPort() != null) {
            request.addParameter("VpnPort", StringUtils.fromInteger(modifyClientVpnEndpointRequest.getVpnPort()));
        }
        if (modifyClientVpnEndpointRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(modifyClientVpnEndpointRequest.getDescription()));
        }
        if (modifyClientVpnEndpointRequest.getSplitTunnel() != null) {
            request.addParameter("SplitTunnel", StringUtils.fromBoolean(modifyClientVpnEndpointRequest.getSplitTunnel()));
        }
        if (!(modifyClientVpnEndpointRequestSecurityGroupIdsList = (SdkInternalList)modifyClientVpnEndpointRequest.getSecurityGroupIds()).isEmpty() || !modifyClientVpnEndpointRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String modifyClientVpnEndpointRequestSecurityGroupIdsListValue : modifyClientVpnEndpointRequestSecurityGroupIdsList) {
                if (modifyClientVpnEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString(modifyClientVpnEndpointRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (modifyClientVpnEndpointRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(modifyClientVpnEndpointRequest.getVpcId()));
        }
        if (modifyClientVpnEndpointRequest.getSelfServicePortal() != null) {
            request.addParameter("SelfServicePortal", StringUtils.fromString(modifyClientVpnEndpointRequest.getSelfServicePortal()));
        }
        if ((clientConnectOptions = modifyClientVpnEndpointRequest.getClientConnectOptions()) != null) {
            if (clientConnectOptions.getEnabled() != null) {
                request.addParameter("ClientConnectOptions.Enabled", StringUtils.fromBoolean(clientConnectOptions.getEnabled()));
            }
            if (clientConnectOptions.getLambdaFunctionArn() != null) {
                request.addParameter("ClientConnectOptions.LambdaFunctionArn", StringUtils.fromString(clientConnectOptions.getLambdaFunctionArn()));
            }
        }
        return request;
    }
}

