/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.SpotMarketOptions;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class SpotMarketOptionsStaxUnmarshaller
implements Unmarshaller<SpotMarketOptions, StaxUnmarshallerContext> {
    private static SpotMarketOptionsStaxUnmarshaller instance;

    @Override
    public SpotMarketOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        SpotMarketOptions spotMarketOptions = new SpotMarketOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return spotMarketOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MaxPrice", targetDepth)) {
                    spotMarketOptions.setMaxPrice(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SpotInstanceType", targetDepth)) {
                    spotMarketOptions.setSpotInstanceType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BlockDurationMinutes", targetDepth)) {
                    spotMarketOptions.setBlockDurationMinutes(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ValidUntil", targetDepth)) {
                    spotMarketOptions.setValidUntil(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("InstanceInterruptionBehavior", targetDepth)) continue;
                spotMarketOptions.setInstanceInterruptionBehavior(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return spotMarketOptions;
    }

    public static SpotMarketOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SpotMarketOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

