/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisfirehose.model.DestinationDescription;

@SdkInternalApi
public class DestinationDescriptionMarshaller {
    private static final MarshallingInfo<String> DESTINATIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationId").build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DestinationDescription").build();
    private static final MarshallingInfo<StructuredPojo> EXTENDEDS3DESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtendedS3DestinationDescription").build();
    private static final MarshallingInfo<StructuredPojo> REDSHIFTDESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedshiftDestinationDescription").build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHDESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchDestinationDescription").build();
    private static final MarshallingInfo<StructuredPojo> SPLUNKDESTINATIONDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SplunkDestinationDescription").build();
    private static final DestinationDescriptionMarshaller instance = new DestinationDescriptionMarshaller();

    public static DestinationDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DestinationDescription destinationDescription, ProtocolMarshaller protocolMarshaller) {
        if (destinationDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(destinationDescription.getDestinationId(), DESTINATIONID_BINDING);
            protocolMarshaller.marshall(destinationDescription.getS3DestinationDescription(), S3DESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall(destinationDescription.getExtendedS3DestinationDescription(), EXTENDEDS3DESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall(destinationDescription.getRedshiftDestinationDescription(), REDSHIFTDESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall(destinationDescription.getElasticsearchDestinationDescription(), ELASTICSEARCHDESTINATIONDESCRIPTION_BINDING);
            protocolMarshaller.marshall(destinationDescription.getSplunkDestinationDescription(), SPLUNKDESTINATIONDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

