/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.logs.model.FilteredLogEvent;

@SdkInternalApi
public class FilteredLogEventMarshaller {
    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").build();
    private static final MarshallingInfo<Long> TIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timestamp").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").build();
    private static final MarshallingInfo<Long> INGESTIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ingestionTime").build();
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventId").build();
    private static final FilteredLogEventMarshaller instance = new FilteredLogEventMarshaller();

    public static FilteredLogEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(FilteredLogEvent filteredLogEvent, ProtocolMarshaller protocolMarshaller) {
        if (filteredLogEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(filteredLogEvent.getLogStreamName(), LOGSTREAMNAME_BINDING);
            protocolMarshaller.marshall(filteredLogEvent.getTimestamp(), TIMESTAMP_BINDING);
            protocolMarshaller.marshall(filteredLogEvent.getMessage(), MESSAGE_BINDING);
            protocolMarshaller.marshall(filteredLogEvent.getIngestionTime(), INGESTIONTIME_BINDING);
            protocolMarshaller.marshall(filteredLogEvent.getEventId(), EVENTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

