/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.graylog.aws.config.AWSPluginConfiguration;

final class AutoValue_AWSPluginConfiguration
extends AWSPluginConfiguration {
    private final boolean lookupsEnabled;
    private final String lookupRegions;
    private final String accessKey;
    private final String encryptedSecretKey;
    private final String secretKeySalt;
    private final boolean proxyEnabled;

    private AutoValue_AWSPluginConfiguration(boolean lookupsEnabled, String lookupRegions, String accessKey, @Nullable String encryptedSecretKey, @Nullable String secretKeySalt, boolean proxyEnabled) {
        this.lookupsEnabled = lookupsEnabled;
        this.lookupRegions = lookupRegions;
        this.accessKey = accessKey;
        this.encryptedSecretKey = encryptedSecretKey;
        this.secretKeySalt = secretKeySalt;
        this.proxyEnabled = proxyEnabled;
    }

    @Override
    @JsonProperty(value="lookups_enabled")
    public boolean lookupsEnabled() {
        return this.lookupsEnabled;
    }

    @Override
    @JsonProperty(value="lookup_regions")
    public String lookupRegions() {
        return this.lookupRegions;
    }

    @Override
    @JsonProperty(value="access_key")
    public String accessKey() {
        return this.accessKey;
    }

    @Override
    @JsonProperty(value="secret_key")
    @Nullable
    public String encryptedSecretKey() {
        return this.encryptedSecretKey;
    }

    @Override
    @JsonProperty(value="secret_key_salt")
    @Nullable
    public String secretKeySalt() {
        return this.secretKeySalt;
    }

    @Override
    @JsonProperty(value="proxy_enabled")
    public boolean proxyEnabled() {
        return this.proxyEnabled;
    }

    public String toString() {
        return "AWSPluginConfiguration{lookupsEnabled=" + this.lookupsEnabled + ", lookupRegions=" + this.lookupRegions + ", accessKey=" + this.accessKey + ", encryptedSecretKey=" + this.encryptedSecretKey + ", secretKeySalt=" + this.secretKeySalt + ", proxyEnabled=" + this.proxyEnabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AWSPluginConfiguration) {
            AWSPluginConfiguration that = (AWSPluginConfiguration)o;
            return this.lookupsEnabled == that.lookupsEnabled() && this.lookupRegions.equals(that.lookupRegions()) && this.accessKey.equals(that.accessKey()) && (this.encryptedSecretKey == null ? that.encryptedSecretKey() == null : this.encryptedSecretKey.equals(that.encryptedSecretKey())) && (this.secretKeySalt == null ? that.secretKeySalt() == null : this.secretKeySalt.equals(that.secretKeySalt())) && this.proxyEnabled == that.proxyEnabled();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.lookupsEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.lookupRegions.hashCode();
        h$ *= 1000003;
        h$ ^= this.accessKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.encryptedSecretKey == null ? 0 : this.encryptedSecretKey.hashCode();
        h$ *= 1000003;
        h$ ^= this.secretKeySalt == null ? 0 : this.secretKeySalt.hashCode();
        h$ *= 1000003;
        return h$ ^= this.proxyEnabled ? 1231 : 1237;
    }

    @Override
    public AWSPluginConfiguration.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AWSPluginConfiguration.Builder {
        private Boolean lookupsEnabled;
        private String lookupRegions;
        private String accessKey;
        private String encryptedSecretKey;
        private String secretKeySalt;
        private Boolean proxyEnabled;

        Builder() {
        }

        private Builder(AWSPluginConfiguration source) {
            this.lookupsEnabled = source.lookupsEnabled();
            this.lookupRegions = source.lookupRegions();
            this.accessKey = source.accessKey();
            this.encryptedSecretKey = source.encryptedSecretKey();
            this.secretKeySalt = source.secretKeySalt();
            this.proxyEnabled = source.proxyEnabled();
        }

        @Override
        public AWSPluginConfiguration.Builder lookupsEnabled(boolean lookupsEnabled) {
            this.lookupsEnabled = lookupsEnabled;
            return this;
        }

        @Override
        public AWSPluginConfiguration.Builder lookupRegions(String lookupRegions) {
            if (lookupRegions == null) {
                throw new NullPointerException("Null lookupRegions");
            }
            this.lookupRegions = lookupRegions;
            return this;
        }

        @Override
        public AWSPluginConfiguration.Builder accessKey(String accessKey) {
            if (accessKey == null) {
                throw new NullPointerException("Null accessKey");
            }
            this.accessKey = accessKey;
            return this;
        }

        @Override
        AWSPluginConfiguration.Builder encryptedSecretKey(String encryptedSecretKey) {
            this.encryptedSecretKey = encryptedSecretKey;
            return this;
        }

        @Override
        AWSPluginConfiguration.Builder secretKeySalt(String secretKeySalt) {
            this.secretKeySalt = secretKeySalt;
            return this;
        }

        @Override
        public AWSPluginConfiguration.Builder proxyEnabled(boolean proxyEnabled) {
            this.proxyEnabled = proxyEnabled;
            return this;
        }

        @Override
        public AWSPluginConfiguration build() {
            String missing = "";
            if (this.lookupsEnabled == null) {
                missing = missing + " lookupsEnabled";
            }
            if (this.lookupRegions == null) {
                missing = missing + " lookupRegions";
            }
            if (this.accessKey == null) {
                missing = missing + " accessKey";
            }
            if (this.proxyEnabled == null) {
                missing = missing + " proxyEnabled";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AWSPluginConfiguration(this.lookupsEnabled, this.lookupRegions, this.accessKey, this.encryptedSecretKey, this.secretKeySalt, this.proxyEnabled);
        }
    }
}

