/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.inputs.cloudtrail;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.codahale.metrics.MetricSet;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.assistedinject.Assisted;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import okhttp3.HttpUrl;
import org.graylog.aws.AWS;
import org.graylog.aws.AWSObjectMapper;
import org.graylog.aws.auth.AWSAuthProvider;
import org.graylog.aws.config.AWSPluginConfiguration;
import org.graylog.aws.inputs.cloudtrail.CloudTrailSubscriber;
import org.graylog2.Configuration;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.DropdownField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.MisfireException;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.transports.ThrottleableTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.lifecycles.Lifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudTrailTransport
extends ThrottleableTransport {
    private static final Logger LOG = LoggerFactory.getLogger(CloudTrailTransport.class);
    public static final String NAME = "cloudtrail";
    private static final String CK_LEGACY_AWS_REGION = "aws_region";
    private static final String CK_AWS_SQS_REGION = "aws_sqs_region";
    private static final String CK_AWS_S3_REGION = "aws_s3_region";
    private static final String CK_SQS_NAME = "aws_sqs_queue_name";
    private static final String CK_ACCESS_KEY = "aws_access_key";
    private static final String CK_SECRET_KEY = "aws_secret_key";
    private static final String CK_ASSUME_ROLE_ARN = "aws_assume_role_arn";
    private static final Regions DEFAULT_REGION = Regions.US_EAST_1;
    private final ServerStatus serverStatus;
    private final URI httpProxyUri;
    private final LocalMetricRegistry localRegistry;
    private final Configuration systemConfiguration;
    private final ClusterConfigService clusterConfigService;
    private final ObjectMapper objectMapper;
    private CloudTrailSubscriber subscriber;

    @Inject
    public CloudTrailTransport(@Assisted org.graylog2.plugin.configuration.Configuration configuration, Configuration systemConfiguration, ClusterConfigService clusterConfigService, EventBus serverEventBus, ServerStatus serverStatus, @AWSObjectMapper ObjectMapper objectMapper, @Named(value="http_proxy_uri") @Nullable URI httpProxyUri, LocalMetricRegistry localRegistry) {
        super(serverEventBus, configuration);
        this.systemConfiguration = systemConfiguration;
        this.clusterConfigService = clusterConfigService;
        this.serverStatus = serverStatus;
        this.objectMapper = objectMapper;
        this.httpProxyUri = httpProxyUri;
        this.localRegistry = localRegistry;
    }

    public void setMessageAggregator(CodecAggregator aggregator) {
    }

    @Subscribe
    public void lifecycleStateChange(Lifecycle lifecycle) {
        LOG.debug("Lifecycle changed to {}", (Object)lifecycle);
        switch (lifecycle) {
            case PAUSED: 
            case FAILED: 
            case HALTING: {
                if (this.subscriber == null) break;
                this.subscriber.pause();
                break;
            }
            default: {
                if (this.subscriber == null) break;
                this.subscriber.unpause();
            }
        }
    }

    public void doLaunch(MessageInput input) throws MisfireException {
        this.serverStatus.awaitRunning(() -> this.lifecycleStateChange(Lifecycle.RUNNING));
        AWSPluginConfiguration config = (AWSPluginConfiguration)this.clusterConfigService.getOrDefault(AWSPluginConfiguration.class, (Object)AWSPluginConfiguration.createDefault());
        LOG.info("Starting cloud trail subscriber");
        String legacyRegionName = input.getConfiguration().getString(CK_LEGACY_AWS_REGION, DEFAULT_REGION.getName());
        String sqsRegionName = input.getConfiguration().getString(CK_AWS_SQS_REGION, legacyRegionName);
        String s3RegionName = input.getConfiguration().getString(CK_AWS_S3_REGION, legacyRegionName);
        HttpUrl proxyUrl = config.proxyEnabled() && this.httpProxyUri != null ? HttpUrl.get((URI)this.httpProxyUri) : null;
        AWSAuthProvider authProvider = new AWSAuthProvider(this.systemConfiguration, config, input.getConfiguration().getString(CK_ACCESS_KEY), input.getConfiguration().getString(CK_SECRET_KEY), input.getConfiguration().getString(CK_AWS_SQS_REGION), input.getConfiguration().getString(CK_ASSUME_ROLE_ARN));
        this.subscriber = new CloudTrailSubscriber(Region.getRegion(Regions.fromName(sqsRegionName)), Region.getRegion(Regions.fromName(s3RegionName)), input.getConfiguration().getString(CK_SQS_NAME), input, authProvider, proxyUrl, this.objectMapper);
        this.subscriber.start();
    }

    public void doStop() {
        LOG.info("Stopping cloud trail subscriber");
        if (this.subscriber != null) {
            this.subscriber.terminate();
        }
    }

    public MetricSet getMetricSet() {
        return this.localRegistry;
    }

    @ConfigClass
    public static class Config
    extends ThrottleableTransport.Config {
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            Map<String, String> regionChoices = AWS.buildRegionChoices();
            r.addField((ConfigurationField)new DropdownField(CloudTrailTransport.CK_AWS_SQS_REGION, "AWS SQS Region", DEFAULT_REGION.getName(), regionChoices, "The AWS region the SQS queue is in.", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField((ConfigurationField)new DropdownField(CloudTrailTransport.CK_AWS_S3_REGION, "AWS S3 Region", DEFAULT_REGION.getName(), regionChoices, "The AWS region the S3 bucket containing CloudTrail logs is in.", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField((ConfigurationField)new TextField(CloudTrailTransport.CK_SQS_NAME, "SQS queue name", "cloudtrail-notifications", "The SQS queue that SNS is writing CloudTrail notifications to.", ConfigurationField.Optional.NOT_OPTIONAL));
            r.addField((ConfigurationField)new TextField(CloudTrailTransport.CK_ACCESS_KEY, "AWS access key", "", "Access key of an AWS user with sufficient permissions. (See documentation)", ConfigurationField.Optional.OPTIONAL));
            r.addField((ConfigurationField)new TextField(CloudTrailTransport.CK_SECRET_KEY, "AWS secret key", "", "Secret key of an AWS user with sufficient permissions. (See documentation)", ConfigurationField.Optional.OPTIONAL, new TextField.Attribute[]{TextField.Attribute.IS_PASSWORD}));
            r.addField((ConfigurationField)new TextField(CloudTrailTransport.CK_ASSUME_ROLE_ARN, "AWS assume role ARN", "", "The role ARN with required permissions (cross account access)", ConfigurationField.Optional.OPTIONAL));
            return r;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<CloudTrailTransport> {
        public CloudTrailTransport create(org.graylog2.plugin.configuration.Configuration var1);

        public Config getConfig();
    }
}

