ace.define("ace/keyboard/vim",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/dom","ace/lib/oop","ace/lib/keys","ace/lib/event","ace/search","ace/lib/useragent","ace/search_highlight","ace/commands/multi_select_commands","ace/mode/text","ace/multi_select"],(function(require,exports,e){"use strict";var t=require("../range").Range,n=require("../lib/event_emitter").EventEmitter,r=require("../lib/dom"),o=require("../lib/oop"),i=require("../lib/keys"),a=require("../lib/event"),s=require("../search").Search,c=require("../lib/useragent"),l=require("../search_highlight").SearchHighlight,u=require("../commands/multi_select_commands"),h=require("../mode/text").Mode.prototype.tokenRe;require("../multi_select");var p=function(e){this.ace=e,this.state={},this.marks={},this.$uid=0,this.onChange=this.onChange.bind(this),this.onSelectionChange=this.onSelectionChange.bind(this),this.onBeforeEndOperation=this.onBeforeEndOperation.bind(this),this.ace.on("change",this.onChange),this.ace.on("changeSelection",this.onSelectionChange),this.ace.on("beforeEndOperation",this.onBeforeEndOperation)};function f(e){return{row:e.line,column:e.ch}}function d(e){return new y(e.row,e.column)}p.Pos=function(e,t){if(!(this instanceof y))return new y(e,t);this.line=e,this.ch=t},p.defineOption=function(e,t,n){},p.commands={redo:function(e){e.ace.redo()},undo:function(e){e.ace.undo()},newlineAndIndent:function(e){e.ace.insert("\n")}},p.keyMap={},p.addClass=p.rmClass=function(){},p.e_stop=p.e_preventDefault=a.stopEvent,p.keyName=function(e){var t=i[e.keyCode]||e.key||"";return 1==t.length&&(t=t.toUpperCase()),t=a.getModifierString(e).replace(/(^|-)\w/g,(function(e){return e.toUpperCase()}))+t},p.keyMap.default=function(e){return function(t){var n=t.ace.commands.commandKeyBinding[e.toLowerCase()];return n&&!1!==t.ace.execCommand(n)}},p.lookupKey=function e(t,n,r){n||(n="default"),"string"==typeof n&&(n=p.keyMap[n]);var o="function"==typeof n?n(t):n[t];if(!1===o)return"nothing";if("..."===o)return"multi";if(null!=o&&r(o))return"handled";if(n.fallthrough){if(!Array.isArray(n.fallthrough))return e(t,n.fallthrough,r);for(var i=0;i<n.fallthrough.length;i++){var a=e(t,n.fallthrough[i],r);if(a)return a}}},p.signal=function(e,t,n){return e._signal(t,n)},p.on=a.addListener,p.off=a.removeListener,p.isWordChar=function(e){return e<""?/^\w$/.test(e):(h.lastIndex=0,h.test(e))},function(){o.implement(p.prototype,n),this.destroy=function(){this.ace.off("change",this.onChange),this.ace.off("changeSelection",this.onSelectionChange),this.ace.off("beforeEndOperation",this.onBeforeEndOperation),this.removeOverlay()},this.virtualSelectionMode=function(){return this.ace.inVirtualSelectionMode&&this.ace.selection.index},this.onChange=function(e){var t={text:"i"==e.action[0]?e.lines:[]},n=this.curOp=this.curOp||{};n.changeHandlers||(n.changeHandlers=this._eventRegistry.change&&this._eventRegistry.change.slice()),n.lastChange?n.lastChange.next=n.lastChange=t:n.lastChange=n.change=t,this.$updateMarkers(e)},this.onSelectionChange=function(){var e=this.curOp=this.curOp||{};e.cursorActivityHandlers||(e.cursorActivityHandlers=this._eventRegistry.cursorActivity&&this._eventRegistry.cursorActivity.slice()),this.curOp.cursorActivity=!0,this.ace.inMultiSelectMode&&this.ace.keyBinding.removeKeyboardHandler(u.keyboardHandler)},this.operation=function(e,t){if(!t&&this.curOp||t&&this.curOp&&this.curOp.force)return e();if(!t&&this.ace.curOp||this.curOp&&this.onBeforeEndOperation(),!this.ace.curOp){var n=this.ace.prevOp;this.ace.startOperation({command:{name:"vim",scrollIntoView:"cursor"}})}var r=this.curOp=this.curOp||{};this.curOp.force=t;var o=e();return this.ace.curOp&&"vim"==this.ace.curOp.command.name&&(this.state.dialog&&(this.ace.curOp.command.scrollIntoView=!1),this.ace.endOperation(),r.cursorActivity||r.lastChange||!n||(this.ace.prevOp=n)),!t&&this.ace.curOp||this.curOp&&this.onBeforeEndOperation(),o},this.onBeforeEndOperation=function(){var e=this.curOp;e&&(e.change&&this.signal("change",e.change,e),e&&e.cursorActivity&&this.signal("cursorActivity",null,e),this.curOp=null)},this.signal=function(e,t,n){var r=n?n[e+"Handlers"]:(this._eventRegistry||{})[e];if(r){r=r.slice();for(var o=0;o<r.length;o++)r[o](this,t)}},this.firstLine=function(){return 0},this.lastLine=function(){return this.ace.session.getLength()-1},this.lineCount=function(){return this.ace.session.getLength()},this.setCursor=function(e,t){"object"==typeof e&&(t=e.ch,e=e.line),this.ace.inVirtualSelectionMode||this.ace.exitMultiSelectMode(),this.ace.session.unfold({row:e,column:t}),this.ace.selection.moveTo(e,t)},this.getCursor=function(e){var t=this.ace.selection;return d("anchor"==e?t.isEmpty()?t.lead:t.anchor:"head"!=e&&e?t.getRange()[e]:t.lead)},this.listSelections=function(e){var t=this.ace.multiSelect.rangeList.ranges;return!t.length||this.ace.inVirtualSelectionMode?[{anchor:this.getCursor("anchor"),head:this.getCursor("head")}]:t.map((function(e){return{anchor:this.clipPos(d(e.cursor==e.end?e.start:e.end)),head:this.clipPos(d(e.cursor))}}),this)},this.setSelections=function(e,n){var r=this.ace.multiSelect,o=e.map((function(e){var n=f(e.anchor),r=f(e.head),o=t.comparePoints(n,r)<0?new t.fromPoints(n,r):new t.fromPoints(r,n);return o.cursor=t.comparePoints(o.start,r)?o.end:o.start,o}));if(this.ace.inVirtualSelectionMode)this.ace.selection.fromOrientedRange(o[0]);else{n?o[n]&&o.push(o.splice(n,1)[0]):o=o.reverse(),r.toSingleRange(o[0].clone());for(var i=this.ace.session,a=0;a<o.length;a++){var s=i.$clipRangeToDocument(o[a]);r.addRange(s)}}},this.setSelection=function(e,t,n){var r=this.ace.selection;r.moveTo(e.line,e.ch),r.selectTo(t.line,t.ch),n&&"*mouse"==n.origin&&this.onBeforeEndOperation()},this.somethingSelected=function(e){return!this.ace.selection.isEmpty()},this.clipPos=function(e){return d(this.ace.session.$clipPositionToDocument(e.line,e.ch))},this.markText=function(e){return{clear:function(){},find:function(){}}},this.$updateMarkers=function(e){var n="insert"==e.action,r=e.start,o=e.end,i=(o.row-r.row)*(n?1:-1),a=(o.column-r.column)*(n?1:-1);for(var s in n&&(o=r),this.marks){var c=this.marks[s],l=t.comparePoints(c,r);if(!(l<0)){if(0===l&&n){if(1!=c.bias){c.bias=-1;continue}l=1}var u=n?l:t.comparePoints(c,o);u>0?(c.row+=i,c.column+=c.row==o.row?a:0):!n&&u<=0&&(c.row=r.row,c.column=r.column,0===u&&(c.bias=1))}}};var e=function(e,t,n,r){this.cm=e,this.id=t,this.row=n,this.column=r,e.marks[this.id]=this};e.prototype.clear=function(){delete this.cm.marks[this.id]},e.prototype.find=function(){return d(this)},this.setBookmark=function(t,n){var r=new e(this,this.$uid++,t.line,t.ch);return n&&n.insertLeft||(r.$insertRight=!0),this.marks[r.id]=r,r},this.moveH=function(e,t){if("char"==t){var n=this.ace.selection;n.clearSelection(),n.moveCursorBy(0,e)}},this.findPosV=function(e,t,n,r){if("page"==n){var o=this.ace.renderer.layerConfig;t*=Math.floor(o.height/o.lineHeight),n="line"}if("line"==n){var i=this.ace.session.documentToScreenPosition(e.line,e.ch);return null!=r&&(i.column=r),i.row+=t,i.row=Math.min(Math.max(0,i.row),this.ace.session.getScreenLength()-1),d(this.ace.session.screenToDocumentPosition(i.row,i.column))}},this.charCoords=function(e,t){if("div"==t||!t)return{left:(r=this.ace.session.documentToScreenPosition(e.line,e.ch)).column,top:r.row};if("local"==t){var n=this.ace.renderer,r=this.ace.session.documentToScreenPosition(e.line,e.ch),o=n.layerConfig.lineHeight,i=n.layerConfig.characterWidth,a=o*r.row;return{left:r.column*i,top:a,bottom:a+o}}},this.coordsChar=function(e,t){var n=this.ace.renderer;if("local"==t){var r=Math.max(0,Math.floor(e.top/n.lineHeight)),o=Math.max(0,Math.floor(e.left/n.characterWidth));return d(n.session.screenToDocumentPosition(r,o))}if("div"==t)throw"not implemented"},this.getSearchCursor=function(e,t,n){var r=!1,o=!1;e instanceof RegExp&&!e.global&&(r=!e.ignoreCase,e=e.source,o=!0);var i=new s;null==t.ch&&(t.ch=Number.MAX_VALUE);var a={row:t.line,column:t.ch},c=this,l=null;return{findNext:function(){return this.find(!1)},findPrevious:function(){return this.find(!0)},find:function(t){i.setOptions({needle:e,caseSensitive:r,wrap:!1,backwards:t,regExp:o,start:l||a});var n=i.find(c.ace.session);return n&&n.isEmpty()&&c.getLine(n.start.row).length==n.start.column&&(i.$options.start=n,n=i.find(c.ace.session)),l=n},from:function(){return l&&d(l.start)},to:function(){return l&&d(l.end)},replace:function(e){l&&(l.end=c.ace.session.doc.replace(l,e))}}},this.scrollTo=function(e,t){var n=this.ace.renderer,r=n.layerConfig,o=r.maxHeight;o-=(n.$size.scrollerHeight-n.lineHeight)*n.$scrollPastEnd,null!=t&&this.ace.session.setScrollTop(Math.max(0,Math.min(t,o))),null!=e&&this.ace.session.setScrollLeft(Math.max(0,Math.min(e,r.width)))},this.scrollInfo=function(){return 0},this.scrollIntoView=function(e,t){if(e){var n=this.ace.renderer,r={top:0,bottom:t};n.scrollCursorIntoView(f(e),2*n.lineHeight/n.$size.scrollerHeight,r)}},this.getLine=function(e){return this.ace.session.getLine(e)},this.getRange=function(e,n){return this.ace.session.getTextRange(new t(e.line,e.ch,n.line,n.ch))},this.replaceRange=function(e,n,r){return r||(r=n),this.ace.session.replace(new t(n.line,n.ch,r.line,r.ch),e)},this.replaceSelection=this.replaceSelections=function(e){var t=this.ace.selection;if(this.ace.inVirtualSelectionMode)this.ace.session.replace(t.getRange(),e[0]||"");else{t.inVirtualSelectionMode=!0;var n=t.rangeList.ranges;n.length||(n=[this.ace.multiSelect.getRange()]);for(var r=n.length;r--;)this.ace.session.replace(n[r],e[r]||"");t.inVirtualSelectionMode=!1}},this.getSelection=function(){return this.ace.getSelectedText()},this.getSelections=function(){return this.listSelections().map((function(e){return this.getRange(e.anchor,e.head)}),this)},this.getInputField=function(){return this.ace.textInput.getElement()},this.getWrapperElement=function(){return this.ace.container};var r={indentWithTabs:"useSoftTabs",indentUnit:"tabSize",tabSize:"tabSize",firstLineNumber:"firstLineNumber",readOnly:"readOnly"};this.setOption=function(e,t){switch(this.state[e]=t,e){case"indentWithTabs":e=r[e],t=!t;break;case"keyMap":return void(this.state.$keyMap=t);default:e=r[e]}e&&this.ace.setOption(e,t)},this.getOption=function(e,t){var n=r[e];switch(n&&(t=this.ace.getOption(n)),e){case"indentWithTabs":return e=r[e],!t;case"keyMap":return this.state.$keyMap}return n?t:this.state[e]},this.toggleOverwrite=function(e){return this.state.overwrite=e,this.ace.setOverwrite(e)},this.addOverlay=function(e){if(!this.$searchHighlight||!this.$searchHighlight.session){var t=new l(null,"ace_highlight-marker","text"),n=this.ace.session.addDynamicMarker(t);t.id=n.id,t.session=this.ace.session,t.destroy=function(e){t.session.off("change",t.updateOnChange),t.session.off("changeEditor",t.destroy),t.session.removeMarker(t.id),t.session=null},t.updateOnChange=function(e){var n=e.start.row;n==e.end.row?t.cache[n]=void 0:t.cache.splice(n,t.cache.length)},t.session.on("changeEditor",t.destroy),t.session.on("change",t.updateOnChange)}var r=new RegExp(e.query.source,"gmi");this.$searchHighlight=e.highlight=t,this.$searchHighlight.setRegexp(r),this.ace.renderer.updateBackMarkers()},this.removeOverlay=function(e){this.$searchHighlight&&this.$searchHighlight.session&&this.$searchHighlight.destroy()},this.getScrollInfo=function(){var e=this.ace.renderer,t=e.layerConfig;return{left:e.scrollLeft,top:e.scrollTop,height:t.maxHeight,width:t.width,clientHeight:t.height,clientWidth:t.width}},this.getValue=function(){return this.ace.getValue()},this.setValue=function(e){return this.ace.setValue(e,-1)},this.getTokenTypeAt=function(e){var t=this.ace.session.getTokenAt(e.line,e.ch);return t&&/comment|string/.test(t.type)?"string":""},this.findMatchingBracket=function(e){var t=this.ace.session.findMatchingBracket(f(e));return{to:t&&d(t)}},this.indentLine=function(e,n){!0===n?this.ace.session.indentRows(e,e,"\t"):!1===n&&this.ace.session.outdentRows(new t(e,0,e,0))},this.indexFromPos=function(e){return this.ace.session.doc.positionToIndex(f(e))},this.posFromIndex=function(e){return d(this.ace.session.doc.indexToPosition(e))},this.focus=function(e){return this.ace.textInput.focus()},this.blur=function(e){return this.ace.blur()},this.defaultTextHeight=function(e){return this.ace.renderer.layerConfig.lineHeight},this.scanForBracket=function(e,t,n,r){var o=r.bracketRegex.source,i=/paren|text|operator|tag/;if(1==t)var a=this.ace.session.$findClosingBracket(o.slice(1,2),f(e),i);else a=this.ace.session.$findOpeningBracket(o.slice(-2,-1),{row:e.line,column:e.ch+1},i);return a&&{pos:d(a)}},this.refresh=function(){return this.ace.resize(!0)},this.getMode=function(){return{name:this.getOption("mode")}},this.execCommand=function(e){"indentAuto"==e?this.ace.execCommand("autoindent"):console.log(e+" is not implemented")}}.call(p.prototype),(p.StringStream=function(e,t){this.pos=this.start=0,this.string=e,this.tabSize=t||8,this.lastColumnPos=this.lastColumnValue=0,this.lineStart=0}).prototype={eol:function(){return this.pos>=this.string.length},sol:function(){return this.pos==this.lineStart},peek:function(){return this.string.charAt(this.pos)||void 0},next:function(){if(this.pos<this.string.length)return this.string.charAt(this.pos++)},eat:function(e){var t=this.string.charAt(this.pos);if("string"==typeof e)var n=t==e;else n=t&&(e.test?e.test(t):e(t));if(n)return++this.pos,t},eatWhile:function(e){for(var t=this.pos;this.eat(e););return this.pos>t},eatSpace:function(){for(var e=this.pos;/[\s\u00a0]/.test(this.string.charAt(this.pos));)++this.pos;return this.pos>e},skipToEnd:function(){this.pos=this.string.length},skipTo:function(e){var t=this.string.indexOf(e,this.pos);if(t>-1)return this.pos=t,!0},backUp:function(e){this.pos-=e},column:function(){throw"not implemented"},indentation:function(){throw"not implemented"},match:function(e,t,n){if("string"!=typeof e){var r=this.string.slice(this.pos).match(e);return r&&r.index>0?null:(r&&!1!==t&&(this.pos+=r[0].length),r)}var o=function(e){return n?e.toLowerCase():e};if(o(this.string.substr(this.pos,e.length))==o(e))return!1!==t&&(this.pos+=e.length),!0},current:function(){return this.string.slice(this.start,this.pos)},hideFirstChars:function(e,t){this.lineStart+=e;try{return t()}finally{this.lineStart-=e}}},p.defineExtension=function(e,t){p.prototype[e]=t},r.importCssString(".normal-mode .ace_cursor{    border: none;    background-color: rgba(255,0,0,0.5);}.normal-mode .ace_hidden-cursors .ace_cursor{  background-color: transparent;  border: 1px solid red;  opacity: 0.7}.ace_dialog {  position: absolute;  left: 0; right: 0;  background: inherit;  z-index: 15;  padding: .1em .8em;  overflow: hidden;  color: inherit;}.ace_dialog-top {  border-bottom: 1px solid #444;  top: 0;}.ace_dialog-bottom {  border-top: 1px solid #444;  bottom: 0;}.ace_dialog input {  border: none;  outline: none;  background: transparent;  width: 20em;  color: inherit;  font-family: monospace;}","vimMode"),function(){function e(e,t,n){var r;return(r=e.ace.container.appendChild(document.createElement("div"))).className=n?"ace_dialog ace_dialog-bottom":"ace_dialog ace_dialog-top","string"==typeof t?r.innerHTML=t:r.appendChild(t),r}function t(e,t){e.state.currentNotificationClose&&e.state.currentNotificationClose(),e.state.currentNotificationClose=t}p.defineExtension("openDialog",(function(n,r,o){if(!this.virtualSelectionMode()){o||(o={}),t(this,null);var i=e(this,n,o.bottom),a=!1,s=this;this.state.dialog=i;var c,l=i.getElementsByTagName("input")[0];return l?(o.value&&(l.value=o.value,!1!==o.selectValueOnOpen&&l.select()),o.onInput&&p.on(l,"input",(function(e){o.onInput(e,l.value,u)})),o.onKeyUp&&p.on(l,"keyup",(function(e){o.onKeyUp(e,l.value,u)})),p.on(l,"keydown",(function(e){o&&o.onKeyDown&&o.onKeyDown(e,l.value,u)||(13==e.keyCode&&r(l.value),(27==e.keyCode||!1!==o.closeOnEnter&&13==e.keyCode)&&(l.blur(),p.e_stop(e),u()))})),!1!==o.closeOnBlur&&p.on(l,"blur",u),l.focus()):(c=i.getElementsByTagName("button")[0])&&(p.on(c,"click",(function(){u(),s.focus()})),!1!==o.closeOnBlur&&p.on(c,"blur",u),c.focus()),u}function u(e){if("string"==typeof e)l.value=e;else{if(a)return;if(e&&"blur"==e.type&&document.activeElement===l)return;s.state.dialog=null,a=!0,i.parentNode.removeChild(i),s.focus(),o.onClose&&o.onClose(i)}}})),p.defineExtension("openNotification",(function(n,r){if(!this.virtualSelectionMode()){t(this,c);var o,i=e(this,n,r&&r.bottom),a=!1,s=r&&void 0!==r.duration?r.duration:5e3;return p.on(i,"click",(function(e){p.e_preventDefault(e),c()})),s&&(o=setTimeout(c,s)),c}function c(){a||(a=!0,clearTimeout(o),i.parentNode.removeChild(i))}}))}();var m=[{keys:"<Left>",type:"keyToKey",toKeys:"h"},{keys:"<Right>",type:"keyToKey",toKeys:"l"},{keys:"<Up>",type:"keyToKey",toKeys:"k"},{keys:"<Down>",type:"keyToKey",toKeys:"j"},{keys:"<Space>",type:"keyToKey",toKeys:"l"},{keys:"<BS>",type:"keyToKey",toKeys:"h",context:"normal"},{keys:"<Del>",type:"keyToKey",toKeys:"x",context:"normal"},{keys:"<C-Space>",type:"keyToKey",toKeys:"W"},{keys:"<C-BS>",type:"keyToKey",toKeys:"B",context:"normal"},{keys:"<S-Space>",type:"keyToKey",toKeys:"w"},{keys:"<S-BS>",type:"keyToKey",toKeys:"b",context:"normal"},{keys:"<C-n>",type:"keyToKey",toKeys:"j"},{keys:"<C-p>",type:"keyToKey",toKeys:"k"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-[>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"<C-c>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"<C-Esc>",type:"keyToKey",toKeys:"<Esc>"},{keys:"<C-Esc>",type:"keyToKey",toKeys:"<Esc>",context:"insert"},{keys:"s",type:"keyToKey",toKeys:"cl",context:"normal"},{keys:"s",type:"keyToKey",toKeys:"c",context:"visual"},{keys:"S",type:"keyToKey",toKeys:"cc",context:"normal"},{keys:"S",type:"keyToKey",toKeys:"VdO",context:"visual"},{keys:"<Home>",type:"keyToKey",toKeys:"0"},{keys:"<End>",type:"keyToKey",toKeys:"$"},{keys:"<PageUp>",type:"keyToKey",toKeys:"<C-b>"},{keys:"<PageDown>",type:"keyToKey",toKeys:"<C-f>"},{keys:"<CR>",type:"keyToKey",toKeys:"j^",context:"normal"},{keys:"<Ins>",type:"action",action:"toggleOverwrite",context:"insert"},{keys:"H",type:"motion",motion:"moveToTopLine",motionArgs:{linewise:!0,toJumplist:!0}},{keys:"M",type:"motion",motion:"moveToMiddleLine",motionArgs:{linewise:!0,toJumplist:!0}},{keys:"L",type:"motion",motion:"moveToBottomLine",motionArgs:{linewise:!0,toJumplist:!0}},{keys:"h",type:"motion",motion:"moveByCharacters",motionArgs:{forward:!1}},{keys:"l",type:"motion",motion:"moveByCharacters",motionArgs:{forward:!0}},{keys:"j",type:"motion",motion:"moveByLines",motionArgs:{forward:!0,linewise:!0}},{keys:"k",type:"motion",motion:"moveByLines",motionArgs:{forward:!1,linewise:!0}},{keys:"gj",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:!0}},{keys:"gk",type:"motion",motion:"moveByDisplayLines",motionArgs:{forward:!1}},{keys:"w",type:"motion",motion:"moveByWords",motionArgs:{forward:!0,wordEnd:!1}},{keys:"W",type:"motion",motion:"moveByWords",motionArgs:{forward:!0,wordEnd:!1,bigWord:!0}},{keys:"e",type:"motion",motion:"moveByWords",motionArgs:{forward:!0,wordEnd:!0,inclusive:!0}},{keys:"E",type:"motion",motion:"moveByWords",motionArgs:{forward:!0,wordEnd:!0,bigWord:!0,inclusive:!0}},{keys:"b",type:"motion",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!1}},{keys:"B",type:"motion",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!1,bigWord:!0}},{keys:"ge",type:"motion",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!0,inclusive:!0}},{keys:"gE",type:"motion",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!0,bigWord:!0,inclusive:!0}},{keys:"{",type:"motion",motion:"moveByParagraph",motionArgs:{forward:!1,toJumplist:!0}},{keys:"}",type:"motion",motion:"moveByParagraph",motionArgs:{forward:!0,toJumplist:!0}},{keys:"(",type:"motion",motion:"moveBySentence",motionArgs:{forward:!1}},{keys:")",type:"motion",motion:"moveBySentence",motionArgs:{forward:!0}},{keys:"<C-f>",type:"motion",motion:"moveByPage",motionArgs:{forward:!0}},{keys:"<C-b>",type:"motion",motion:"moveByPage",motionArgs:{forward:!1}},{keys:"<C-d>",type:"motion",motion:"moveByScroll",motionArgs:{forward:!0,explicitRepeat:!0}},{keys:"<C-u>",type:"motion",motion:"moveByScroll",motionArgs:{forward:!1,explicitRepeat:!0}},{keys:"gg",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:!1,explicitRepeat:!0,linewise:!0,toJumplist:!0}},{keys:"G",type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:!0,explicitRepeat:!0,linewise:!0,toJumplist:!0}},{keys:"0",type:"motion",motion:"moveToStartOfLine"},{keys:"^",type:"motion",motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"+",type:"motion",motion:"moveByLines",motionArgs:{forward:!0,toFirstChar:!0}},{keys:"-",type:"motion",motion:"moveByLines",motionArgs:{forward:!1,toFirstChar:!0}},{keys:"_",type:"motion",motion:"moveByLines",motionArgs:{forward:!0,toFirstChar:!0,repeatOffset:-1}},{keys:"$",type:"motion",motion:"moveToEol",motionArgs:{inclusive:!0}},{keys:"%",type:"motion",motion:"moveToMatchedSymbol",motionArgs:{inclusive:!0,toJumplist:!0}},{keys:"f<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:!0,inclusive:!0}},{keys:"F<character>",type:"motion",motion:"moveToCharacter",motionArgs:{forward:!1}},{keys:"t<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:!0,inclusive:!0}},{keys:"T<character>",type:"motion",motion:"moveTillCharacter",motionArgs:{forward:!1}},{keys:";",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:!0}},{keys:",",type:"motion",motion:"repeatLastCharacterSearch",motionArgs:{forward:!1}},{keys:"'<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:!0,linewise:!0}},{keys:"`<character>",type:"motion",motion:"goToMark",motionArgs:{toJumplist:!0}},{keys:"]`",type:"motion",motion:"jumpToMark",motionArgs:{forward:!0}},{keys:"[`",type:"motion",motion:"jumpToMark",motionArgs:{forward:!1}},{keys:"]'",type:"motion",motion:"jumpToMark",motionArgs:{forward:!0,linewise:!0}},{keys:"['",type:"motion",motion:"jumpToMark",motionArgs:{forward:!1,linewise:!0}},{keys:"]p",type:"action",action:"paste",isEdit:!0,actionArgs:{after:!0,isEdit:!0,matchIndent:!0}},{keys:"[p",type:"action",action:"paste",isEdit:!0,actionArgs:{after:!1,isEdit:!0,matchIndent:!0}},{keys:"]<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:!0,toJumplist:!0}},{keys:"[<character>",type:"motion",motion:"moveToSymbol",motionArgs:{forward:!1,toJumplist:!0}},{keys:"|",type:"motion",motion:"moveToColumn"},{keys:"o",type:"motion",motion:"moveToOtherHighlightedEnd",context:"visual"},{keys:"O",type:"motion",motion:"moveToOtherHighlightedEnd",motionArgs:{sameLine:!0},context:"visual"},{keys:"d",type:"operator",operator:"delete"},{keys:"y",type:"operator",operator:"yank"},{keys:"c",type:"operator",operator:"change"},{keys:"=",type:"operator",operator:"indentAuto"},{keys:">",type:"operator",operator:"indent",operatorArgs:{indentRight:!0}},{keys:"<",type:"operator",operator:"indent",operatorArgs:{indentRight:!1}},{keys:"g~",type:"operator",operator:"changeCase"},{keys:"gu",type:"operator",operator:"changeCase",operatorArgs:{toLower:!0},isEdit:!0},{keys:"gU",type:"operator",operator:"changeCase",operatorArgs:{toLower:!1},isEdit:!0},{keys:"n",type:"motion",motion:"findNext",motionArgs:{forward:!0,toJumplist:!0}},{keys:"N",type:"motion",motion:"findNext",motionArgs:{forward:!1,toJumplist:!0}},{keys:"x",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:!0},operatorMotionArgs:{visualLine:!1}},{keys:"X",type:"operatorMotion",operator:"delete",motion:"moveByCharacters",motionArgs:{forward:!1},operatorMotionArgs:{visualLine:!0}},{keys:"D",type:"operatorMotion",operator:"delete",motion:"moveToEol",motionArgs:{inclusive:!0},context:"normal"},{keys:"D",type:"operator",operator:"delete",operatorArgs:{linewise:!0},context:"visual"},{keys:"Y",type:"operatorMotion",operator:"yank",motion:"expandToLine",motionArgs:{linewise:!0},context:"normal"},{keys:"Y",type:"operator",operator:"yank",operatorArgs:{linewise:!0},context:"visual"},{keys:"C",type:"operatorMotion",operator:"change",motion:"moveToEol",motionArgs:{inclusive:!0},context:"normal"},{keys:"C",type:"operator",operator:"change",operatorArgs:{linewise:!0},context:"visual"},{keys:"~",type:"operatorMotion",operator:"changeCase",motion:"moveByCharacters",motionArgs:{forward:!0},operatorArgs:{shouldMoveCursor:!0},context:"normal"},{keys:"~",type:"operator",operator:"changeCase",context:"visual"},{keys:"<C-w>",type:"operatorMotion",operator:"delete",motion:"moveByWords",motionArgs:{forward:!1,wordEnd:!1},context:"insert"},{keys:"<C-w>",type:"idle",context:"normal"},{keys:"<C-i>",type:"action",action:"jumpListWalk",actionArgs:{forward:!0}},{keys:"<C-o>",type:"action",action:"jumpListWalk",actionArgs:{forward:!1}},{keys:"<C-e>",type:"action",action:"scroll",actionArgs:{forward:!0,linewise:!0}},{keys:"<C-y>",type:"action",action:"scroll",actionArgs:{forward:!1,linewise:!0}},{keys:"a",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"charAfter"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"eol"},context:"normal"},{keys:"A",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"endOfSelectedArea"},context:"visual"},{keys:"i",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"inplace"},context:"normal"},{keys:"gi",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"lastEdit"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"firstNonBlank"},context:"normal"},{keys:"gI",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"bol"},context:"normal"},{keys:"I",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{insertAt:"startOfSelectedArea"},context:"visual"},{keys:"o",type:"action",action:"newLineAndEnterInsertMode",isEdit:!0,interlaceInsertRepeat:!0,actionArgs:{after:!0},context:"normal"},{keys:"O",type:"action",action:"newLineAndEnterInsertMode",isEdit:!0,interlaceInsertRepeat:!0,actionArgs:{after:!1},context:"normal"},{keys:"v",type:"action",action:"toggleVisualMode"},{keys:"V",type:"action",action:"toggleVisualMode",actionArgs:{linewise:!0}},{keys:"<C-v>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:!0}},{keys:"<C-q>",type:"action",action:"toggleVisualMode",actionArgs:{blockwise:!0}},{keys:"gv",type:"action",action:"reselectLastSelection"},{keys:"J",type:"action",action:"joinLines",isEdit:!0},{keys:"gJ",type:"action",action:"joinLines",actionArgs:{keepSpaces:!0},isEdit:!0},{keys:"p",type:"action",action:"paste",isEdit:!0,actionArgs:{after:!0,isEdit:!0}},{keys:"P",type:"action",action:"paste",isEdit:!0,actionArgs:{after:!1,isEdit:!0}},{keys:"r<character>",type:"action",action:"replace",isEdit:!0},{keys:"@<character>",type:"action",action:"replayMacro"},{keys:"q<character>",type:"action",action:"enterMacroRecordMode"},{keys:"R",type:"action",action:"enterInsertMode",isEdit:!0,actionArgs:{replace:!0},context:"normal"},{keys:"R",type:"operator",operator:"change",operatorArgs:{linewise:!0,fullLine:!0},context:"visual",exitVisualBlock:!0},{keys:"u",type:"action",action:"undo",context:"normal"},{keys:"u",type:"operator",operator:"changeCase",operatorArgs:{toLower:!0},context:"visual",isEdit:!0},{keys:"U",type:"operator",operator:"changeCase",operatorArgs:{toLower:!1},context:"visual",isEdit:!0},{keys:"<C-r>",type:"action",action:"redo"},{keys:"m<character>",type:"action",action:"setMark"},{keys:'"<character>',type:"action",action:"setRegister"},{keys:"zz",type:"action",action:"scrollToCursor",actionArgs:{position:"center"}},{keys:"z.",type:"action",action:"scrollToCursor",actionArgs:{position:"center"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"zt",type:"action",action:"scrollToCursor",actionArgs:{position:"top"}},{keys:"z<CR>",type:"action",action:"scrollToCursor",actionArgs:{position:"top"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:"z-",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"}},{keys:"zb",type:"action",action:"scrollToCursor",actionArgs:{position:"bottom"},motion:"moveToFirstNonWhiteSpaceCharacter"},{keys:".",type:"action",action:"repeatLastEdit"},{keys:"<C-a>",type:"action",action:"incrementNumberToken",isEdit:!0,actionArgs:{increase:!0,backtrack:!1}},{keys:"<C-x>",type:"action",action:"incrementNumberToken",isEdit:!0,actionArgs:{increase:!1,backtrack:!1}},{keys:"<C-t>",type:"action",action:"indent",actionArgs:{indentRight:!0},context:"insert"},{keys:"<C-d>",type:"action",action:"indent",actionArgs:{indentRight:!1},context:"insert"},{keys:"a<character>",type:"motion",motion:"textObjectManipulation"},{keys:"i<character>",type:"motion",motion:"textObjectManipulation",motionArgs:{textObjectInner:!0}},{keys:"/",type:"search",searchArgs:{forward:!0,querySrc:"prompt",toJumplist:!0}},{keys:"?",type:"search",searchArgs:{forward:!1,querySrc:"prompt",toJumplist:!0}},{keys:"*",type:"search",searchArgs:{forward:!0,querySrc:"wordUnderCursor",wholeWordOnly:!0,toJumplist:!0}},{keys:"#",type:"search",searchArgs:{forward:!1,querySrc:"wordUnderCursor",wholeWordOnly:!0,toJumplist:!0}},{keys:"g*",type:"search",searchArgs:{forward:!0,querySrc:"wordUnderCursor",toJumplist:!0}},{keys:"g#",type:"search",searchArgs:{forward:!1,querySrc:"wordUnderCursor",toJumplist:!0}},{keys:":",type:"ex"}],g=m.length,v=[{name:"colorscheme",shortName:"colo"},{name:"map"},{name:"imap",shortName:"im"},{name:"nmap",shortName:"nm"},{name:"vmap",shortName:"vm"},{name:"unmap"},{name:"write",shortName:"w"},{name:"undo",shortName:"u"},{name:"redo",shortName:"red"},{name:"set",shortName:"se"},{name:"set",shortName:"se"},{name:"setlocal",shortName:"setl"},{name:"setglobal",shortName:"setg"},{name:"sort",shortName:"sor"},{name:"substitute",shortName:"s",possiblyAsync:!0},{name:"nohlsearch",shortName:"noh"},{name:"yank",shortName:"y"},{name:"delmarks",shortName:"delm"},{name:"registers",shortName:"reg",excludeFromCommandHistory:!0},{name:"global",shortName:"g"}],y=p.Pos,C=function(){return Y};function k(e,t){this==p.keyMap.vim&&p.rmClass(e.getWrapperElement(),"cm-fat-cursor"),t&&t.attach==w||function(e){e.setOption("disableInput",!1),e.off("cursorActivity",ft),p.off(e.getInputField(),"paste",A(e)),e.state.vim=null}(e)}function w(e,t){this==p.keyMap.vim&&p.addClass(e.getWrapperElement(),"cm-fat-cursor"),t&&t.attach==w||function(e){e.setOption("disableInput",!0),e.setOption("showCursorWhenSelecting",!1),p.signal(e,"vim-mode-change",{mode:"normal"}),e.on("cursorActivity",ft),X(e),p.on(e.getInputField(),"paste",A(e))}(e)}function x(e,t){if(t){if(this[e])return this[e];var n=function(e){if("'"==e.charAt(0))return e.charAt(1);var t=e.split(/-(?!$)/),n=t[t.length-1];if(1==t.length&&1==t[0].length)return!1;if(2==t.length&&"Shift"==t[0]&&1==n.length)return!1;for(var r=!1,o=0;o<t.length;o++){var i=t[o];i in M?t[o]=M[i]:r=!0,i in S&&(t[o]=S[i])}if(!r)return!1;_(n)&&(t[t.length-1]=n.toLowerCase());return"<"+t.join("-")+">"}(e);if(!n)return!1;var r=p.Vim.findKey(t,n);return"function"==typeof r&&p.signal(t,"vim-keypress",n),r}}p.defineOption("vimMode",!1,(function(e,t,n){t&&"vim"!=e.getOption("keyMap")?e.setOption("keyMap","vim"):!t&&n!=p.Init&&/^vim/.test(e.getOption("keyMap"))&&e.setOption("keyMap","default")}));var M={Shift:"S",Ctrl:"C",Alt:"A",Cmd:"D",Mod:"A"},S={Enter:"CR",Backspace:"BS",Delete:"Del",Insert:"Ins"};function A(e){var t=e.state.vim;return t.onPasteFn||(t.onPasteFn=function(){t.insertMode||(e.setCursor(pe(e.getCursor(),0,1)),le.enterInsertMode(e,{},t))}),t.onPasteFn}var b=/[\d]/,L=[p.isWordChar,function(e){return e&&!p.isWordChar(e)&&!/\s/.test(e)}],O=[function(e){return/\S/.test(e)}];function T(e,t){for(var n=[],r=e;r<e+t;r++)n.push(String.fromCharCode(r));return n}var E=T(65,26),R=T(97,26),B=T(48,10),I=[].concat(E,R,B,["<",">"]),K=[].concat(E,R,B,["-",'"',".",":","/"]);function P(e,t){return t>=e.firstLine()&&t<=e.lastLine()}function N(e){return/^[a-z]$/.test(e)}function _(e){return/^[A-Z]$/.test(e)}function H(e){return/^\s*$/.test(e)}function V(e){return-1!=".?!".indexOf(e)}function j(e,t){for(var n=0;n<t.length;n++)if(t[n]==e)return!0;return!1}var D={};function W(e,t,n,r,o){if(void 0===t&&!o)throw Error("defaultValue is required unless callback is provided");if(n||(n="string"),D[e]={type:n,defaultValue:t,callback:o},r)for(var i=0;i<r.length;i++)D[r[i]]=D[e];t&&F(e,t)}function F(e,t,n,r){var o=D[e],i=(r=r||{}).scope;if(!o)return new Error("Unknown option: "+e);if("boolean"==o.type){if(t&&!0!==t)return new Error("Invalid argument: "+e+"="+t);!1!==t&&(t=!0)}o.callback?("local"!==i&&o.callback(t,void 0),"global"!==i&&n&&o.callback(t,n)):("local"!==i&&(o.value="boolean"==o.type?!!t:t),"global"!==i&&n&&(n.state.vim.options[e]={value:t}))}function U(e,t,n){var r=D[e],o=(n=n||{}).scope;if(!r)return new Error("Unknown option: "+e);if(r.callback){var i=t&&r.callback(void 0,t);return"global"!==o&&void 0!==i?i:"local"!==o?r.callback():void 0}return((i="global"!==o&&t&&t.state.vim.options[e])||"local"!==o&&r||{}).value}W("filetype",void 0,"string",["ft"],(function(e,t){if(void 0!==t){if(void 0===e)return"null"==(n=t.getOption("mode"))?"":n;var n=""==e?"null":e;t.setOption("mode",n)}}));var z,J,q=function(){var e=100,t=-1,n=0,r=0,o=new Array(e);function i(i,a){(t+=a)>n?t=n:t<r&&(t=r);var s=o[(e+t)%e];if(s&&!s.find()){var c,l=a>0?1:-1,u=i.getCursor();do{if((s=o[(e+(t+=l))%e])&&(c=s.find())&&!ge(u,c))break}while(t<n&&t>r)}return s}return{cachedCursor:void 0,add:function(i,a,s){var c=o[t%e];function l(n){var r=++t%e,a=o[r];a&&a.clear(),o[r]=i.setBookmark(n)}if(c){var u=c.find();u&&!ge(u,a)&&l(a)}else l(a);l(s),n=t,(r=t-e+1)<0&&(r=0)},find:function(e,n){var r=t,o=i(e,n);return t=r,o&&o.find()},move:i}},Q=function(e){return e?{changes:e.changes,expectCursorActivityForChange:e.expectCursorActivityForChange}:{changes:[],expectCursorActivityForChange:!1}};function G(){this.latestRegister=void 0,this.isPlaying=!1,this.isRecording=!1,this.replaySearchQueries=[],this.onRecordingDone=void 0,this.lastInsertModeChanges=Q()}function X(e){return e.state.vim||(e.state.vim={inputState:new ee,lastEditInputState:void 0,lastEditActionCommand:void 0,lastHPos:-1,lastHSPos:-1,lastMotion:null,marks:{},fakeCursor:null,insertMode:!1,insertModeRepeat:void 0,visualMode:!1,visualLine:!1,visualBlock:!1,lastSelection:null,lastPastedText:null,sel:{},options:{}}),e.state.vim}function Z(){for(var e in z={searchQuery:null,searchIsReversed:!1,lastSubstituteReplacePart:void 0,jumpList:q(),macroModeState:new G,lastCharacterSearch:{increment:0,forward:!0,selectedCharacter:""},registerController:new re({}),searchHistoryController:new oe,exCommandHistoryController:new oe},D){var t=D[e];t.value=t.defaultValue}}G.prototype={exitMacroRecordMode:function(){var e=z.macroModeState;e.onRecordingDone&&e.onRecordingDone(),e.onRecordingDone=void 0,e.isRecording=!1},enterMacroRecordMode:function(e,t){var n=z.registerController.getRegister(t);n&&(n.clear(),this.latestRegister=t,e.openDialog&&(this.onRecordingDone=e.openDialog("(recording)["+t+"]",null,{bottom:!0})),this.isRecording=!0)}};var Y={buildKeyMap:function(){},getRegisterController:function(){return z.registerController},resetVimGlobalState_:Z,getVimGlobalState_:function(){return z},maybeInitVimState_:X,suppressErrorLogging:!1,InsertModeKey:gt,map:function(e,t,n){ct.map(e,t,n)},unmap:function(e,t){ct.unmap(e,t)},noremap:function(e,t,n){function r(e){return e?[e]:["normal","insert","visual"]}for(var o=r(n),i=m.length,a=i-g;a<i&&o.length;a++){var s=m[a];if(!(s.keys!=t||n&&s.context&&s.context!==n||"ex"===s.type.substr(0,2)||"key"===s.type.substr(0,3))){var c={};for(var l in s)c[l]=s[l];c.keys=e,n&&!c.context&&(c.context=n),this._mapCommand(c);var u=r(s.context);o=o.filter((function(e){return-1===u.indexOf(e)}))}}},mapclear:function(e){var t=m.length,n=g,r=m.slice(0,t-n);if(m=m.slice(t-n),e)for(var o=r.length-1;o>=0;o--){var i=r[o];if(e!==i.context)if(i.context)this._mapCommand(i);else{var a=["normal","insert","visual"];for(var s in a)if(a[s]!==e){var c={};for(var l in i)c[l]=i[l];c.context=a[s],this._mapCommand(c)}}}},setOption:F,getOption:U,defineOption:W,defineEx:function(e,t,n){if(t){if(0!==e.indexOf(t))throw new Error('(Vim.defineEx) "'+t+'" is not a prefix of "'+e+'", command not registered')}else t=e;st[e]=n,ct.commandMap_[t]={name:e,shortName:t,type:"api"}},handleKey:function(e,t,n){var r=this.findKey(e,t,n);if("function"==typeof r)return r()},findKey:function(e,t,n){var r,o=X(e);function i(){var r=z.macroModeState;if(r.isRecording){if("q"==t)return r.exitMacroRecordMode(),te(e),!0;"mapping"!=n&&function(e,t){if(e.isPlaying)return;var n=e.latestRegister,r=z.registerController.getRegister(n);r&&r.pushText(t)}(r,t)}}function a(){if("<Esc>"==t)return te(e),o.visualMode?Te(e):o.insertMode&&lt(e),!0}return!1===(r=o.insertMode?function(){if(a())return!0;for(var n=o.inputState.keyBuffer=o.inputState.keyBuffer+t,r=1==t.length,i=ie.matchCommand(n,m,o.inputState,"insert");n.length>1&&"full"!=i.type;){n=o.inputState.keyBuffer=n.slice(1);var s=ie.matchCommand(n,m,o.inputState,"insert");"none"!=s.type&&(i=s)}if("none"==i.type)return te(e),!1;if("partial"==i.type)return J&&window.clearTimeout(J),J=window.setTimeout((function(){o.insertMode&&o.inputState.keyBuffer&&te(e)}),U("insertModeEscKeysTimeout")),!r;if(J&&window.clearTimeout(J),r){for(var c=e.listSelections(),l=0;l<c.length;l++){var u=c[l].head;e.replaceRange("",pe(u,0,-(n.length-1)),u,"+input")}z.macroModeState.lastInsertModeChanges.changes.pop()}return te(e),i.command}():function(){if(i()||a())return!0;var n=o.inputState.keyBuffer=o.inputState.keyBuffer+t;if(/^[1-9]\d*$/.test(n))return!0;if(!(r=/^(\d*)(.*)$/.exec(n)))return te(e),!1;var r,s=o.visualMode?"visual":"normal",c=ie.matchCommand(r[2]||r[1],m,o.inputState,s);return"none"==c.type?(te(e),!1):"partial"==c.type||(o.inputState.keyBuffer="",(r=/^(\d*)(.*)$/.exec(n))[1]&&"0"!=r[1]&&o.inputState.pushRepeatDigit(r[1]),c.command)}())?void 0:!0===r?function(){return!0}:function(){if(!r.operator&&!r.isEdit||!e.getOption("readOnly"))return e.operation((function(){e.curOp.isVimOp=!0;try{"keyToKey"==r.type?function(n){for(var r;n;)r=/<\w+-.+?>|<\w+>|./.exec(n),t=r[0],n=n.substring(r.index+t.length),p.Vim.handleKey(e,t,"mapping")}(r.toKeys):ie.processCommand(e,o,r)}catch(t){throw e.state.vim=void 0,X(e),p.Vim.suppressErrorLogging||console.log(t),t}return!0}))}},handleEx:function(e,t){ct.processCommand(e,t)},defineMotion:function(e,t){ae[e]=t},defineAction:function(e,t){le[e]=t},defineOperator:function(e,t){ce[e]=t},mapCommand:function(e,t,n,r,o){var i={keys:e,type:t};for(var a in i[t]=n,i[t+"Args"]=r,o)i[a]=o[a];ut(i)},_mapCommand:ut,defineRegister:function(e,t){var n=z.registerController.registers;if(!e||1!=e.length)throw Error("Register name must be 1 character");n[e]=t,K.push(e)},exitVisualMode:Te,exitInsertMode:lt};function ee(){this.prefixRepeat=[],this.motionRepeat=[],this.operator=null,this.operatorArgs=null,this.motion=null,this.motionArgs=null,this.keyBuffer=[],this.registerName=null}function te(e,t){e.state.vim.inputState=new ee,p.signal(e,"vim-command-done",t)}function ne(e,t,n){this.clear(),this.keyBuffer=[e||""],this.insertModeChanges=[],this.searchQueries=[],this.linewise=!!t,this.blockwise=!!n}function re(e){this.registers=e,this.unnamedRegister=e['"']=new ne,e["."]=new ne,e[":"]=new ne,e["/"]=new ne}function oe(){this.historyBuffer=[],this.iterator=0,this.initialPrefix=null}ee.prototype.pushRepeatDigit=function(e){this.operator?this.motionRepeat=this.motionRepeat.concat(e):this.prefixRepeat=this.prefixRepeat.concat(e)},ee.prototype.getRepeat=function(){var e=0;return(this.prefixRepeat.length>0||this.motionRepeat.length>0)&&(e=1,this.prefixRepeat.length>0&&(e*=parseInt(this.prefixRepeat.join(""),10)),this.motionRepeat.length>0&&(e*=parseInt(this.motionRepeat.join(""),10))),e},ne.prototype={setText:function(e,t,n){this.keyBuffer=[e||""],this.linewise=!!t,this.blockwise=!!n},pushText:function(e,t){t&&(this.linewise||this.keyBuffer.push("\n"),this.linewise=!0),this.keyBuffer.push(e)},pushInsertModeChanges:function(e){this.insertModeChanges.push(Q(e))},pushSearchQuery:function(e){this.searchQueries.push(e)},clear:function(){this.keyBuffer=[],this.insertModeChanges=[],this.searchQueries=[],this.linewise=!1},toString:function(){return this.keyBuffer.join("")}},re.prototype={pushText:function(e,t,n,r,o){r&&"\n"!==n.charAt(n.length-1)&&(n+="\n");var i=this.isValidRegister(e)?this.getRegister(e):null;if(i){_(e)?i.pushText(n,r):i.setText(n,r,o),this.unnamedRegister.setText(i.toString(),r)}else{switch(t){case"yank":this.registers[0]=new ne(n,r,o);break;case"delete":case"change":-1==n.indexOf("\n")?this.registers["-"]=new ne(n,r):(this.shiftNumericRegisters_(),this.registers[1]=new ne(n,r))}this.unnamedRegister.setText(n,r,o)}},getRegister:function(e){return this.isValidRegister(e)?(e=e.toLowerCase(),this.registers[e]||(this.registers[e]=new ne),this.registers[e]):this.unnamedRegister},isValidRegister:function(e){return e&&j(e,K)},shiftNumericRegisters_:function(){for(var e=9;e>=2;e--)this.registers[e]=this.getRegister(""+(e-1))}},oe.prototype={nextMatch:function(e,t){var n=this.historyBuffer,r=t?-1:1;null===this.initialPrefix&&(this.initialPrefix=e);for(var o=this.iterator+r;t?o>=0:o<n.length;o+=r)for(var i=n[o],a=0;a<=i.length;a++)if(this.initialPrefix==i.substring(0,a))return this.iterator=o,i;return o>=n.length?(this.iterator=n.length,this.initialPrefix):o<0?e:void 0},pushInput:function(e){var t=this.historyBuffer.indexOf(e);t>-1&&this.historyBuffer.splice(t,1),e.length&&this.historyBuffer.push(e)},reset:function(){this.initialPrefix=null,this.iterator=this.historyBuffer.length}};var ie={matchCommand:function(e,t,n,r){var o,i=function(e,t,n,r){for(var o,i=[],a=[],s=0;s<t.length;s++){var c=t[s];"insert"==n&&"insert"!=c.context||c.context&&c.context!=n||r.operator&&"action"==c.type||!(o=fe(e,c.keys))||("partial"==o&&i.push(c),"full"==o&&a.push(c))}return{partial:i.length&&i,full:a.length&&a}}(e,t,r,n);if(!i.full&&!i.partial)return{type:"none"};if(!i.full&&i.partial)return{type:"partial"};for(var a=0;a<i.full.length;a++){var s=i.full[a];o||(o=s)}if("<character>"==o.keys.slice(-11)){var c=function(e){var t=/^.*(<[^>]+>)$/.exec(e),n=t?t[1]:e.slice(-1);if(n.length>1)switch(n){case"<CR>":n="\n";break;case"<Space>":n=" ";break;default:n=""}return n}(e);if(/<C-.>/.test(c)||!c)return{type:"none"};n.selectedCharacter=c}return{type:"full",command:o}},processCommand:function(e,t,n){switch(t.inputState.repeatOverride=n.repeatOverride,n.type){case"motion":this.processMotion(e,t,n);break;case"operator":this.processOperator(e,t,n);break;case"operatorMotion":this.processOperatorMotion(e,t,n);break;case"action":this.processAction(e,t,n);break;case"search":this.processSearch(e,t,n);break;case"ex":case"keyToEx":this.processEx(e,t,n)}},processMotion:function(e,t,n){t.inputState.motion=n.motion,t.inputState.motionArgs=he(n.motionArgs),this.evalInput(e,t)},processOperator:function(e,t,n){var r=t.inputState;if(r.operator){if(r.operator==n.operator)return r.motion="expandToLine",r.motionArgs={linewise:!0},void this.evalInput(e,t);te(e)}r.operator=n.operator,r.operatorArgs=he(n.operatorArgs),n.exitVisualBlock&&(t.visualBlock=!1,Le(e)),t.visualMode&&this.evalInput(e,t)},processOperatorMotion:function(e,t,n){var r=t.visualMode,o=he(n.operatorMotionArgs);o&&r&&o.visualLine&&(t.visualLine=!0),this.processOperator(e,t,n),r||this.processMotion(e,t,n)},processAction:function(e,t,n){var r=t.inputState,o=r.getRepeat(),i=!!o,a=he(n.actionArgs)||{};r.selectedCharacter&&(a.selectedCharacter=r.selectedCharacter),n.operator&&this.processOperator(e,t,n),n.motion&&this.processMotion(e,t,n),(n.motion||n.operator)&&this.evalInput(e,t),a.repeat=o||1,a.repeatIsExplicit=i,a.registerName=r.registerName,te(e),t.lastMotion=null,n.isEdit&&this.recordLastEdit(t,r,n),le[n.action](e,a,t)},processSearch:function(e,t,n){if(e.getSearchCursor){var r=n.searchArgs.forward,o=n.searchArgs.wholeWordOnly;De(e).setReversed(!r);var i=r?"/":"?",a=De(e).getQuery(),s=e.getScrollInfo();switch(n.searchArgs.querySrc){case"prompt":var c=z.macroModeState;if(c.isPlaying)f(h=c.replaySearchQueries.shift(),!0,!1);else Xe(e,{onClose:function(t){e.scrollTo(s.left,s.top),f(t,!0,!0);var n=z.macroModeState;n.isRecording&&function(e,t){if(!e.isPlaying){var n=e.latestRegister,r=z.registerController.getRegister(n);r&&r.pushSearchQuery&&r.pushSearchQuery(t)}}(n,t)},prefix:i,desc:Ge,onKeyUp:function(t,n,o){var i,a,c,l=p.keyName(t);"Up"==l||"Down"==l?(i="Up"==l,a=t.target?t.target.selectionEnd:0,o(n=z.searchHistoryController.nextMatch(n,i)||""),a&&t.target&&(t.target.selectionEnd=t.target.selectionStart=Math.min(a,t.target.value.length))):"Left"!=l&&"Right"!=l&&"Ctrl"!=l&&"Alt"!=l&&"Shift"!=l&&z.searchHistoryController.reset();try{c=Ze(e,n,!0,!0)}catch(t){}c?e.scrollIntoView(et(e,!r,c),30):(tt(e),e.scrollTo(s.left,s.top))},onKeyDown:function(t,n,r){var o=p.keyName(t);"Esc"==o||"Ctrl-C"==o||"Ctrl-["==o||"Backspace"==o&&""==n?(z.searchHistoryController.pushInput(n),z.searchHistoryController.reset(),Ze(e,a),tt(e),e.scrollTo(s.left,s.top),p.e_stop(t),te(e),r(),e.focus()):"Up"==o||"Down"==o?p.e_stop(t):"Ctrl-U"==o&&(p.e_stop(t),r(""))}});break;case"wordUnderCursor":var l=Re(e,!1,!0,!1,!0),u=!0;if(l||(l=Re(e,!1,!0,!1,!1),u=!1),!l)return;var h=e.getLine(l.start.line).substring(l.start.ch,l.end.ch);h=u&&o?"\\b"+h+"\\b":h.replace(/([.?*+$\[\]\/\\(){}|\-])/g,"\\$1"),z.jumpList.cachedCursor=e.getCursor(),e.setCursor(l.start),f(h,!0,!1)}}function f(r,o,i){z.searchHistoryController.pushInput(r),z.searchHistoryController.reset();try{Ze(e,r,o,i)}catch(t){return Qe(e,"Invalid regex: "+r),void te(e)}ie.processMotion(e,t,{type:"motion",motion:"findNext",motionArgs:{forward:!0,toJumplist:n.searchArgs.toJumplist}})}},processEx:function(e,t,n){function r(t){z.exCommandHistoryController.pushInput(t),z.exCommandHistoryController.reset(),ct.processCommand(e,t)}function o(t,n,r){var o,i,a=p.keyName(t);("Esc"==a||"Ctrl-C"==a||"Ctrl-["==a||"Backspace"==a&&""==n)&&(z.exCommandHistoryController.pushInput(n),z.exCommandHistoryController.reset(),p.e_stop(t),te(e),r(),e.focus()),"Up"==a||"Down"==a?(p.e_stop(t),o="Up"==a,i=t.target?t.target.selectionEnd:0,r(n=z.exCommandHistoryController.nextMatch(n,o)||""),i&&t.target&&(t.target.selectionEnd=t.target.selectionStart=Math.min(i,t.target.value.length))):"Ctrl-U"==a?(p.e_stop(t),r("")):"Left"!=a&&"Right"!=a&&"Ctrl"!=a&&"Alt"!=a&&"Shift"!=a&&z.exCommandHistoryController.reset()}"keyToEx"==n.type?ct.processCommand(e,n.exArgs.input):t.visualMode?Xe(e,{onClose:r,prefix:":",value:"'<,'>",onKeyDown:o,selectValueOnOpen:!1}):Xe(e,{onClose:r,prefix:":",onKeyDown:o})},evalInput:function(e,t){var n,r,o,i=t.inputState,a=i.motion,s=i.motionArgs||{},c=i.operator,l=i.operatorArgs||{},u=i.registerName,h=t.sel,p=me(t.visualMode?ue(e,h.head):e.getCursor("head")),f=me(t.visualMode?ue(e,h.anchor):e.getCursor("anchor")),d=me(p),m=me(f);if(c&&this.recordLastEdit(t,i),(o=void 0!==i.repeatOverride?i.repeatOverride:i.getRepeat())>0&&s.explicitRepeat?s.repeatIsExplicit=!0:(s.noRepeat||!s.explicitRepeat&&0===o)&&(o=1,s.repeatIsExplicit=!1),i.selectedCharacter&&(s.selectedCharacter=l.selectedCharacter=i.selectedCharacter),s.repeat=o,te(e),a){var g=ae[a](e,p,s,t);if(t.lastMotion=ae[a],!g)return;if(s.toJumplist){c||null==e.ace.curOp||(e.ace.curOp.command.scrollIntoView="center-animate");var v=z.jumpList,C=v.cachedCursor;C?(Be(e,C,g),delete v.cachedCursor):Be(e,p,g)}g instanceof Array?(r=g[0],n=g[1]):n=g,n||(n=me(p)),t.visualMode?(t.visualBlock&&n.ch===1/0||(n=ue(e,n,t.visualBlock)),r&&(r=ue(e,r,!0)),r=r||m,h.anchor=r,h.head=n,Le(e),He(e,t,"<",ve(r,n)?r:n),He(e,t,">",ve(r,n)?n:r)):c||(n=ue(e,n),e.setCursor(n.line,n.ch))}if(c){if(l.lastSel){r=m;var k=l.lastSel,w=Math.abs(k.head.line-k.anchor.line),x=Math.abs(k.head.ch-k.anchor.ch);n=k.visualLine?y(m.line+w,m.ch):k.visualBlock?y(m.line+w,m.ch+x):k.head.line==k.anchor.line?y(m.line,m.ch+x):y(m.line+w,m.ch),t.visualMode=!0,t.visualLine=k.visualLine,t.visualBlock=k.visualBlock,h=t.sel={anchor:r,head:n},Le(e)}else t.visualMode&&(l.lastSel={anchor:me(h.anchor),head:me(h.head),visualBlock:t.visualBlock,visualLine:t.visualLine});var M,S,A,b,L;if(t.visualMode){if(M=ye(h.head,h.anchor),S=Ce(h.head,h.anchor),A=t.visualLine||l.linewise,L=Oe(e,{anchor:M,head:S},b=t.visualBlock?"block":A?"line":"char"),A){var O=L.ranges;if("block"==b)for(var T=0;T<O.length;T++)O[T].head.ch=we(e,O[T].head.line);else"line"==b&&(O[0].head=y(O[0].head.line+1,0))}}else{if(M=me(r||m),ve(S=me(n||d),M)){var E=M;M=S,S=E}(A=s.linewise||l.linewise)?function(e,t,n){t.ch=0,n.ch=0,n.line++}(0,M,S):s.forward&&function(e,t,n){var r=e.getRange(t,n);if(/\n\s*$/.test(r)){var o=r.split("\n");o.pop();for(var i=o.pop();o.length>0&&i&&H(i);i=o.pop())n.line--,n.ch=0;i?(n.line--,n.ch=we(e,n.line)):n.ch=0}}(e,M,S),L=Oe(e,{anchor:M,head:S},b="char",!s.inclusive||A)}e.setSelections(L.ranges,L.primary),t.lastMotion=null,l.repeat=o,l.registerName=u,l.linewise=A;var R=ce[c](e,l,L.ranges,m,n);t.visualMode&&Te(e,null!=R),R&&e.setCursor(R)}},recordLastEdit:function(e,t,n){var r=z.macroModeState;r.isPlaying||(e.lastEditInputState=t,e.lastEditActionCommand=n,r.lastInsertModeChanges.changes=[],r.lastInsertModeChanges.expectCursorActivityForChange=!1,r.lastInsertModeChanges.visualBlock=e.visualBlock?e.sel.head.line-e.sel.anchor.line:0)}},ae={moveToTopLine:function(e,t,n){var r=rt(e).top+n.repeat-1;return y(r,Ee(e.getLine(r)))},moveToMiddleLine:function(e){var t=rt(e),n=Math.floor(.5*(t.top+t.bottom));return y(n,Ee(e.getLine(n)))},moveToBottomLine:function(e,t,n){var r=rt(e).bottom-n.repeat+1;return y(r,Ee(e.getLine(r)))},expandToLine:function(e,t,n){return y(t.line+n.repeat-1,1/0)},findNext:function(e,t,n){var r=De(e),o=r.getQuery();if(o){var i=!n.forward;return i=r.isReversed()?!i:i,Ye(e,o),et(e,i,o,n.repeat)}},goToMark:function(e,t,n,r){var o=ot(e,r,n.selectedCharacter);return o?n.linewise?{line:o.line,ch:Ee(e.getLine(o.line))}:o:null},moveToOtherHighlightedEnd:function(e,t,n,r){if(r.visualBlock&&n.sameLine){var o=r.sel;return[ue(e,y(o.anchor.line,o.head.ch)),ue(e,y(o.head.line,o.anchor.ch))]}return[r.sel.head,r.sel.anchor]},jumpToMark:function(e,t,n,r){for(var o=t,i=0;i<n.repeat;i++){var a=o;for(var s in r.marks)if(N(s)){var c=r.marks[s].find();if(!((n.forward?ve(c,a):ve(a,c))||n.linewise&&c.line==a.line)){var l=ge(a,o),u=n.forward?ke(a,c,o):ke(o,c,a);(l||u)&&(o=c)}}}return n.linewise&&(o=y(o.line,Ee(e.getLine(o.line)))),o},moveByCharacters:function(e,t,n){var r=t,o=n.repeat,i=n.forward?r.ch+o:r.ch-o;return y(r.line,i)},moveByLines:function(e,t,n,r){var o=t,i=o.ch;switch(r.lastMotion){case this.moveByLines:case this.moveByDisplayLines:case this.moveByScroll:case this.moveToColumn:case this.moveToEol:i=r.lastHPos;break;default:r.lastHPos=i}var a=n.repeat+(n.repeatOffset||0),s=n.forward?o.line+a:o.line-a,c=e.firstLine(),l=e.lastLine();if(s<c&&o.line==c)return this.moveToStartOfLine(e,t,n,r);if(s>l&&o.line==l)return this.moveToEol(e,t,n,r,!0);var u=e.ace.session.getFoldLine(s);return u&&(n.forward?s>u.start.row&&(s=u.end.row+1):s=u.start.row),n.toFirstChar&&(i=Ee(e.getLine(s)),r.lastHPos=i),r.lastHSPos=e.charCoords(y(s,i),"div").left,y(s,i)},moveByDisplayLines:function(e,t,n,r){var o=t;switch(r.lastMotion){case this.moveByDisplayLines:case this.moveByScroll:case this.moveByLines:case this.moveToColumn:case this.moveToEol:break;default:r.lastHSPos=e.charCoords(o,"div").left}var i=n.repeat;if((s=e.findPosV(o,n.forward?i:-i,"line",r.lastHSPos)).hitSide)if(n.forward)var a={top:e.charCoords(s,"div").top+8,left:r.lastHSPos},s=e.coordsChar(a,"div");else{var c=e.charCoords(y(e.firstLine(),0),"div");c.left=r.lastHSPos,s=e.coordsChar(c,"div")}return r.lastHPos=s.ch,s},moveByPage:function(e,t,n){var r=t,o=n.repeat;return e.findPosV(r,n.forward?o:-o,"page")},moveByParagraph:function(e,t,n){var r=n.forward?1:-1;return $e(e,t,n.repeat,r)},moveBySentence:function(e,t,n){var r=n.forward?1:-1;return function(e,t,n,r){function o(e,t){if(t.pos+t.dir<0||t.pos+t.dir>=t.line.length){if(t.ln+=t.dir,!P(e,t.ln))return t.line=null,t.ln=null,void(t.pos=null);t.line=e.getLine(t.ln),t.pos=t.dir>0?0:t.line.length-1}else t.pos+=t.dir}function i(e,t,n,r){var i=""===(l=e.getLine(t)),a={line:l,ln:t,pos:n,dir:r},s={ln:a.ln,pos:a.pos},c=""===a.line;for(o(e,a);null!==a.line;){if(s.ln=a.ln,s.pos=a.pos,""===a.line&&!c)return{ln:a.ln,pos:a.pos};if(i&&""!==a.line&&!H(a.line[a.pos]))return{ln:a.ln,pos:a.pos};!V(a.line[a.pos])||i||a.pos!==a.line.length-1&&!H(a.line[a.pos+1])||(i=!0),o(e,a)}var l=e.getLine(s.ln);s.pos=0;for(var u=l.length-1;u>=0;--u)if(!H(l[u])){s.pos=u;break}return s}function a(e,t,n,r){var i={line:c=e.getLine(t),ln:t,pos:n,dir:r},a={ln:i.ln,pos:null},s=""===i.line;for(o(e,i);null!==i.line;){if(""===i.line&&!s)return null!==a.pos?a:{ln:i.ln,pos:i.pos};if(V(i.line[i.pos])&&null!==a.pos&&(i.ln!==a.ln||i.pos+1!==a.pos))return a;""===i.line||H(i.line[i.pos])||(s=!1,a={ln:i.ln,pos:i.pos}),o(e,i)}var c=e.getLine(a.ln);a.pos=0;for(var l=0;l<c.length;++l)if(!H(c[l])){a.pos=l;break}return a}var s={ln:t.line,pos:t.ch};for(;n>0;)s=r<0?a(e,s.ln,s.pos,r):i(e,s.ln,s.pos,r),n--;return y(s.ln,s.pos)}(e,t,n.repeat,r)},moveByScroll:function(e,t,n,r){var o=e.getScrollInfo(),i=null,a=n.repeat;a||(a=o.clientHeight/(2*e.defaultTextHeight()));var s=e.charCoords(t,"local");if(n.repeat=a,!(i=ae.moveByDisplayLines(e,t,n,r)))return null;var c=e.charCoords(i,"local");return e.scrollTo(null,o.top+c.top-s.top),i},moveByWords:function(e,t,n){return function(e,t,n,r,o,i){var a=me(t),s=[];(r&&!o||!r&&o)&&n++;for(var c=!(r&&o),l=0;l<n;l++){var u=Ne(e,t,r,i,c);if(!u){var h=we(e,e.lastLine());s.push(r?{line:e.lastLine(),from:h,to:h}:{line:0,from:0,to:0});break}s.push(u),t=y(u.line,r?u.to-1:u.from)}var p=s.length!=n,f=s[0],d=s.pop();return r&&!o?(p||f.from==a.ch&&f.line==a.line||(d=s.pop()),y(d.line,d.from)):r&&o?y(d.line,d.to-1):!r&&o?(p||f.to==a.ch&&f.line==a.line||(d=s.pop()),y(d.line,d.to)):y(d.line,d.from)}(e,t,n.repeat,!!n.forward,!!n.wordEnd,!!n.bigWord)},moveTillCharacter:function(e,t,n){var r=_e(e,n.repeat,n.forward,n.selectedCharacter),o=n.forward?-1:1;return Ie(o,n),r?(r.ch+=o,r):null},moveToCharacter:function(e,t,n){var r=n.repeat;return Ie(0,n),_e(e,r,n.forward,n.selectedCharacter)||t},moveToSymbol:function(e,t,n){return function(e,t,n,r){var o=me(e.getCursor()),i=n?1:-1,a=n?e.lineCount():-1,s=o.ch,c=o.line,l=e.getLine(c),u={lineText:l,nextCh:l.charAt(s),lastCh:null,index:s,symb:r,reverseSymb:(n?{")":"(","}":"{"}:{"(":")","{":"}"})[r],forward:n,depth:0,curMoveThrough:!1},h=Ke[r];if(!h)return o;var p=Pe[h].init,f=Pe[h].isComplete;p&&p(u);for(;c!==a&&t;){if(u.index+=i,u.nextCh=u.lineText.charAt(u.index),!u.nextCh){if(c+=i,u.lineText=e.getLine(c)||"",i>0)u.index=0;else{var d=u.lineText.length;u.index=d>0?d-1:0}u.nextCh=u.lineText.charAt(u.index)}f(u)&&(o.line=c,o.ch=u.index,t--)}if(u.nextCh||u.curMoveThrough)return y(c,u.index);return o}(e,n.repeat,n.forward,n.selectedCharacter)||t},moveToColumn:function(e,t,n,r){var o=n.repeat;return r.lastHPos=o-1,r.lastHSPos=e.charCoords(t,"div").left,function(e,t){var n=e.getCursor().line;return ue(e,y(n,t-1))}(e,o)},moveToEol:function(e,t,n,r,o){var i=y(t.line+n.repeat-1,1/0),a=e.clipPos(i);return a.ch--,o||(r.lastHPos=1/0,r.lastHSPos=e.charCoords(a,"div").left),i},moveToFirstNonWhiteSpaceCharacter:function(e,t){var n=t;return y(n.line,Ee(e.getLine(n.line)))},moveToMatchedSymbol:function(e,t){for(var n,r=t,o=r.line,i=r.ch,a=e.getLine(o);i<a.length;i++)if((n=a.charAt(i))&&-1!="()[]{}".indexOf(n)){var s=e.getTokenTypeAt(y(o,i+1));if("string"!==s&&"comment"!==s)break}if(i<a.length){var c=/[<>]/.test(a[i])?/[(){}[\]<>]/:/[(){}[\]]/;return e.findMatchingBracket(y(o,i+1),{bracketRegex:c}).to}return r},moveToStartOfLine:function(e,t){return y(t.line,0)},moveToLineOrEdgeOfDocument:function(e,t,n){var r=n.forward?e.lastLine():e.firstLine();return n.repeatIsExplicit&&(r=n.repeat-e.getOption("firstLineNumber")),y(r,Ee(e.getLine(r)))},textObjectManipulation:function(e,t,n,r){var o=n.selectedCharacter;"b"==o?o="(":"B"==o&&(o="{");var i,a=!n.textObjectInner;if({"(":")",")":"(","{":"}","}":"{","[":"]","]":"[","<":">",">":"<"}[o])i=function(e,t,n,r){var o,i,a=t,s={"(":/[()]/,")":/[()]/,"[":/[[\]]/,"]":/[[\]]/,"{":/[{}]/,"}":/[{}]/,"<":/[<>]/,">":/[<>]/}[n],c={"(":"(",")":"(","[":"[","]":"[","{":"{","}":"{","<":"<",">":"<"}[n],l=e.getLine(a.line).charAt(a.ch)===c?1:0;if(o=e.scanForBracket(y(a.line,a.ch+l),-1,void 0,{bracketRegex:s}),i=e.scanForBracket(y(a.line,a.ch+l),1,void 0,{bracketRegex:s}),!o||!i)return{start:a,end:a};if(o=o.pos,i=i.pos,o.line==i.line&&o.ch>i.ch||o.line>i.line){var u=o;o=i,i=u}r?i.ch+=1:o.ch+=1;return{start:o,end:i}}(e,t,o,a);else if({"'":!0,'"':!0,"`":!0}[o])i=function(e,t,n,r){var o,i,a,s,c=me(t),l=e.getLine(c.line).split(""),u=l.indexOf(n);c.ch<u?c.ch=u:u<c.ch&&l[c.ch]==n&&(i=c.ch,--c.ch);if(l[c.ch]!=n||i)for(a=c.ch;a>-1&&!o;a--)l[a]==n&&(o=a+1);else o=c.ch+1;if(o&&!i)for(a=o,s=l.length;a<s&&!i;a++)l[a]==n&&(i=a);if(!o||!i)return{start:c,end:c};r&&(--o,++i);return{start:y(c.line,o),end:y(c.line,i)}}(e,t,o,a);else if("W"===o)i=Re(e,a,!0,!0);else if("w"===o)i=Re(e,a,!0,!1);else{if("p"!==o)return null;if(i=$e(e,t,n.repeat,0,a),n.linewise=!0,r.visualMode)r.visualLine||(r.visualLine=!0);else{var s=r.inputState.operatorArgs;s&&(s.linewise=!0),i.end.line--}}return e.state.vim.visualMode?function(e,t,n){var r,o=e.state.vim.sel,i=o.head,a=o.anchor;ve(n,t)&&(r=n,n=t,t=r);ve(i,a)?(i=ye(t,i),a=Ce(a,n)):(a=ye(t,a),-1==(i=pe(i=Ce(i,n),0,-1)).ch&&i.line!=e.firstLine()&&(i=y(i.line-1,we(e,i.line-1))));return[a,i]}(e,i.start,i.end):[i.start,i.end]},repeatLastCharacterSearch:function(e,t,n){var r=z.lastCharacterSearch,o=n.repeat,i=n.forward===r.forward,a=(r.increment?1:0)*(i?-1:1);e.moveH(-a,"char"),n.inclusive=!!i;var s=_e(e,o,i,r.selectedCharacter);return s?(s.ch+=a,s):(e.moveH(a,"char"),t)}};function se(e,t){for(var n=[],r=0;r<t;r++)n.push(e);return n}var ce={change:function(e,t,n){var r,o,i=e.state.vim,a=n[0].anchor,s=n[0].head;if(i.visualMode)if(t.fullLine)s.ch=Number.MAX_VALUE,s.line--,e.setSelection(a,s),o=e.getSelection(),e.replaceSelection(""),r=a;else{o=e.getSelection();var c=se("",n.length);e.replaceSelections(c),r=ye(n[0].head,n[0].anchor)}else{o=e.getRange(a,s);var l=i.lastEditInputState||{};if("moveByWords"==l.motion&&!H(o)){var u=/\s+$/.exec(o);u&&l.motionArgs&&l.motionArgs.forward&&(s=pe(s,0,-u[0].length),o=o.slice(0,-u[0].length))}var h=new y(a.line-1,Number.MAX_VALUE),f=e.firstLine()==e.lastLine();s.line>e.lastLine()&&t.linewise&&!f?e.replaceRange("",h,s):e.replaceRange("",a,s),t.linewise&&(f||(e.setCursor(h),p.commands.newlineAndIndent(e)),a.ch=Number.MAX_VALUE),r=a}z.registerController.pushText(t.registerName,"change",o,t.linewise,n.length>1),le.enterInsertMode(e,{head:r},e.state.vim)},delete:function(e,t,n){var r,o,i=e.state.vim;if(i.visualBlock){o=e.getSelection();var a=se("",n.length);e.replaceSelections(a),r=n[0].anchor}else{var s=n[0].anchor,c=n[0].head;t.linewise&&c.line!=e.firstLine()&&s.line==e.lastLine()&&s.line==c.line-1&&(s.line==e.firstLine()?s.ch=0:s=y(s.line-1,we(e,s.line-1))),o=e.getRange(s,c),e.replaceRange("",s,c),r=s,t.linewise&&(r=ae.moveToFirstNonWhiteSpaceCharacter(e,s))}return z.registerController.pushText(t.registerName,"delete",o,t.linewise,i.visualBlock),ue(e,r,i.insertMode)},indent:function(e,t,n){var r=e.state.vim,o=n[0].anchor.line,i=r.visualBlock?n[n.length-1].anchor.line:n[0].head.line,a=r.visualMode?t.repeat:1;t.linewise&&i--;for(var s=o;s<=i;s++)for(var c=0;c<a;c++)e.indentLine(s,t.indentRight);return ae.moveToFirstNonWhiteSpaceCharacter(e,n[0].anchor)},indentAuto:function(e,t,n){return e.execCommand("indentAuto"),ae.moveToFirstNonWhiteSpaceCharacter(e,n[0].anchor)},changeCase:function(e,t,n,r,o){for(var i=e.getSelections(),a=[],s=t.toLower,c=0;c<i.length;c++){var l=i[c],u="";if(!0===s)u=l.toLowerCase();else if(!1===s)u=l.toUpperCase();else for(var h=0;h<l.length;h++){var p=l.charAt(h);u+=_(p)?p.toLowerCase():p.toUpperCase()}a.push(u)}return e.replaceSelections(a),t.shouldMoveCursor?o:!e.state.vim.visualMode&&t.linewise&&n[0].anchor.line+1==n[0].head.line?ae.moveToFirstNonWhiteSpaceCharacter(e,r):t.linewise?r:ye(n[0].anchor,n[0].head)},yank:function(e,t,n,r){var o=e.state.vim,i=e.getSelection(),a=o.visualMode?ye(o.sel.anchor,o.sel.head,n[0].head,n[0].anchor):r;return z.registerController.pushText(t.registerName,"yank",i,t.linewise,o.visualBlock),a}};var le={jumpListWalk:function(e,t,n){if(!n.visualMode){var r=t.repeat,o=t.forward,i=z.jumpList.move(e,o?r:-r),a=i?i.find():void 0;a=a||e.getCursor(),e.setCursor(a),e.ace.curOp.command.scrollIntoView="center-animate"}},scroll:function(e,t,n){if(!n.visualMode){var r=t.repeat||1,o=e.defaultTextHeight(),i=e.getScrollInfo().top,a=o*r,s=t.forward?i+a:i-a,c=me(e.getCursor()),l=e.charCoords(c,"local");if(t.forward)s>l.top?(c.line+=(s-l.top)/o,c.line=Math.ceil(c.line),e.setCursor(c),l=e.charCoords(c,"local"),e.scrollTo(null,l.top)):e.scrollTo(null,s);else{var u=s+e.getScrollInfo().clientHeight;u<l.bottom?(c.line-=(l.bottom-u)/o,c.line=Math.floor(c.line),e.setCursor(c),l=e.charCoords(c,"local"),e.scrollTo(null,l.bottom-e.getScrollInfo().clientHeight)):e.scrollTo(null,s)}}},scrollToCursor:function(e,t){var n=e.getCursor().line,r=e.charCoords(y(n,0),"local"),o=e.getScrollInfo().clientHeight,i=r.top,a=r.bottom-i;switch(t.position){case"center":i=i-o/2+a;break;case"bottom":i=i-o+a}e.scrollTo(null,i)},replayMacro:function(e,t,n){var r=t.selectedCharacter,o=t.repeat,i=z.macroModeState;for("@"==r?r=i.latestRegister:i.latestRegister=r;o--;)ht(e,n,i,r)},enterMacroRecordMode:function(e,t){var n=z.macroModeState,r=t.selectedCharacter;z.registerController.isValidRegister(r)&&n.enterMacroRecordMode(e,r)},toggleOverwrite:function(e){e.state.overwrite?(e.toggleOverwrite(!1),e.setOption("keyMap","vim-insert"),p.signal(e,"vim-mode-change",{mode:"insert"})):(e.toggleOverwrite(!0),e.setOption("keyMap","vim-replace"),p.signal(e,"vim-mode-change",{mode:"replace"}))},enterInsertMode:function(e,t,n){if(!e.getOption("readOnly")){n.insertMode=!0,n.insertModeRepeat=t&&t.repeat||1;var r=t?t.insertAt:null,o=n.sel,i=t.head||e.getCursor("head"),a=e.listSelections().length;if("eol"==r)i=y(i.line,we(e,i.line));else if("bol"==r)i=y(i.line,0);else if("charAfter"==r)i=pe(i,0,1);else if("firstNonBlank"==r)i=ae.moveToFirstNonWhiteSpaceCharacter(e,i);else if("startOfSelectedArea"==r){if(!n.visualMode)return;n.visualBlock?(i=y(Math.min(o.head.line,o.anchor.line),Math.min(o.head.ch,o.anchor.ch)),a=Math.abs(o.head.line-o.anchor.line)+1):i=o.head.line<o.anchor.line?o.head:y(o.anchor.line,0)}else if("endOfSelectedArea"==r){if(!n.visualMode)return;n.visualBlock?(i=y(Math.min(o.head.line,o.anchor.line),Math.max(o.head.ch+1,o.anchor.ch)),a=Math.abs(o.head.line-o.anchor.line)+1):i=o.head.line>=o.anchor.line?pe(o.head,0,1):y(o.anchor.line,0)}else if("inplace"==r){if(n.visualMode)return}else"lastEdit"==r&&(i=it(e)||i);e.setOption("disableInput",!1),t&&t.replace?(e.toggleOverwrite(!0),e.setOption("keyMap","vim-replace"),p.signal(e,"vim-mode-change",{mode:"replace"})):(e.toggleOverwrite(!1),e.setOption("keyMap","vim-insert"),p.signal(e,"vim-mode-change",{mode:"insert"})),z.macroModeState.isPlaying||(e.on("change",pt),p.on(e.getInputField(),"keydown",vt)),n.visualMode&&Te(e),Ae(e,i,a)}},toggleVisualMode:function(e,t,n){var r,o=t.repeat,i=e.getCursor();n.visualMode?n.visualLine^t.linewise||n.visualBlock^t.blockwise?(n.visualLine=!!t.linewise,n.visualBlock=!!t.blockwise,p.signal(e,"vim-mode-change",{mode:"visual",subMode:n.visualLine?"linewise":n.visualBlock?"blockwise":""}),Le(e)):Te(e):(n.visualMode=!0,n.visualLine=!!t.linewise,n.visualBlock=!!t.blockwise,r=ue(e,y(i.line,i.ch+o-1),!0),n.sel={anchor:i,head:r},p.signal(e,"vim-mode-change",{mode:"visual",subMode:n.visualLine?"linewise":n.visualBlock?"blockwise":""}),Le(e),He(e,n,"<",ye(i,r)),He(e,n,">",Ce(i,r)))},reselectLastSelection:function(e,t,n){var r=n.lastSelection;if(n.visualMode&&be(e,n),r){var o=r.anchorMark.find(),i=r.headMark.find();if(!o||!i)return;n.sel={anchor:o,head:i},n.visualMode=!0,n.visualLine=r.visualLine,n.visualBlock=r.visualBlock,Le(e),He(e,n,"<",ye(o,i)),He(e,n,">",Ce(o,i)),p.signal(e,"vim-mode-change",{mode:"visual",subMode:n.visualLine?"linewise":n.visualBlock?"blockwise":""})}},joinLines:function(e,t,n){var r,o;if(n.visualMode){if(r=e.getCursor("anchor"),ve(o=e.getCursor("head"),r)){var i=o;o=r,r=i}o.ch=we(e,o.line)-1}else{var a=Math.max(t.repeat,2);r=e.getCursor(),o=ue(e,y(r.line+a-1,1/0))}for(var s=0,c=r.line;c<o.line;c++){s=we(e,r.line);i=y(r.line+1,we(e,r.line+1));var l=e.getRange(r,i);l=t.keepSpaces?l.replace(/\n\r?/g,""):l.replace(/\n\s*/g," "),e.replaceRange(l,r,i)}var u=y(r.line,s);n.visualMode&&Te(e,!1),e.setCursor(u)},newLineAndEnterInsertMode:function(e,t,n){n.insertMode=!0;var r=me(e.getCursor());r.line!==e.firstLine()||t.after?(r.line=t.after?r.line:r.line-1,r.ch=we(e,r.line),e.setCursor(r),(p.commands.newlineAndIndentContinueComment||p.commands.newlineAndIndent)(e)):(e.replaceRange("\n",y(e.firstLine(),0)),e.setCursor(e.firstLine(),0));this.enterInsertMode(e,{repeat:t.repeat},n)},paste:function(e,t,n){var r=me(e.getCursor()),o=z.registerController.getRegister(t.registerName);if(p=o.toString()){if(t.matchIndent){var i=e.getOption("tabSize"),a=function(e){var t=e.split("\t").length-1,n=e.split(" ").length-1;return t*i+1*n},s=e.getLine(e.getCursor().line),c=a(s.match(/^\s*/)[0]),l=p.replace(/\n$/,""),u=p!==l,h=a(p.match(/^\s*/)[0]),p=l.replace(/^\s*/gm,(function(t){var n=c+(a(t)-h);if(n<0)return"";if(e.getOption("indentWithTabs")){var r=Math.floor(n/i);return Array(r+1).join("\t")}return Array(n+1).join(" ")}));p+=u?"\n":""}if(t.repeat>1)p=Array(t.repeat+1).join(p);var f,d,m=o.linewise,g=o.blockwise;if(g){p=p.split("\n"),m&&p.pop();for(var v=0;v<p.length;v++)p[v]=""==p[v]?" ":p[v];r.ch+=t.after?1:0,r.ch=Math.min(we(e,r.line),r.ch)}else m?n.visualMode?p=n.visualLine?p.slice(0,-1):"\n"+p.slice(0,p.length-1)+"\n":t.after?(p="\n"+p.slice(0,p.length-1),r.ch=we(e,r.line)):r.ch=0:r.ch+=t.after?1:0;if(n.visualMode){var C;n.lastPastedText=p;var k=function(e,t){var n=t.lastSelection,r=function(){var t=e.listSelections(),n=t[0],r=t[t.length-1];return[ve(n.anchor,n.head)?n.anchor:n.head,ve(r.anchor,r.head)?r.head:r.anchor]},o=function(){var t=e.getCursor(),r=e.getCursor(),o=n.visualBlock;if(o){var i=o.width,a=o.height;r=y(t.line+a,t.ch+i);for(var s=[],c=t.line;c<r.line;c++){var l={anchor:y(c,t.ch),head:y(c,r.ch)};s.push(l)}e.setSelections(s)}else{var u=n.anchorMark.find(),h=n.headMark.find(),p=h.line-u.line,f=h.ch-u.ch;r={line:r.line+p,ch:p?r.ch:f+r.ch},n.visualLine&&(t=y(t.line,0),r=y(r.line,we(e,r.line))),e.setSelection(t,r)}return[t,r]};return t.visualMode?r():o()}(e,n),w=k[0],x=k[1],M=e.getSelection(),S=e.listSelections(),A=new Array(S.length).join("1").split("1");n.lastSelection&&(C=n.lastSelection.headMark.find()),z.registerController.unnamedRegister.setText(M),g?(e.replaceSelections(A),x=y(w.line+p.length-1,w.ch),e.setCursor(w),Se(e,x),e.replaceSelections(p),f=w):n.visualBlock?(e.replaceSelections(A),e.setCursor(w),e.replaceRange(p,w,w),f=w):(e.replaceRange(p,w,x),f=e.posFromIndex(e.indexFromPos(w)+p.length-1)),C&&(n.lastSelection.headMark=e.setBookmark(C)),m&&(f.ch=0)}else if(g){e.setCursor(r);for(v=0;v<p.length;v++){var b=r.line+v;b>e.lastLine()&&e.replaceRange("\n",y(b,0)),we(e,b)<r.ch&&Me(e,b,r.ch)}e.setCursor(r),Se(e,y(r.line+p.length-1,r.ch)),e.replaceSelections(p),f=r}else e.replaceRange(p,r),m&&t.after?f=y(r.line+1,Ee(e.getLine(r.line+1))):m&&!t.after?f=y(r.line,Ee(e.getLine(r.line))):!m&&t.after?(d=e.indexFromPos(r),f=e.posFromIndex(d+p.length-1)):(d=e.indexFromPos(r),f=e.posFromIndex(d+p.length));n.visualMode&&Te(e,!1),e.setCursor(f)}},undo:function(e,t){e.operation((function(){de(e,p.commands.undo,t.repeat)(),e.setCursor(e.getCursor("anchor"))}))},redo:function(e,t){de(e,p.commands.redo,t.repeat)()},setRegister:function(e,t,n){n.inputState.registerName=t.selectedCharacter},setMark:function(e,t,n){He(e,n,t.selectedCharacter,e.getCursor())},replace:function(e,t,n){var r,o,i=t.selectedCharacter,a=e.getCursor(),s=e.listSelections();if(n.visualMode)a=e.getCursor("start"),o=e.getCursor("end");else{var c=e.getLine(a.line);(r=a.ch+t.repeat)>c.length&&(r=c.length),o=y(a.line,r)}if("\n"==i)n.visualMode||e.replaceRange("",a,o),(p.commands.newlineAndIndentContinueComment||p.commands.newlineAndIndent)(e);else{var l=e.getRange(a,o);if(l=l.replace(/[^\n]/g,i),n.visualBlock){var u=new Array(e.getOption("tabSize")+1).join(" ");l=(l=e.getSelection()).replace(/\t/g,u).replace(/[^\n]/g,i).split("\n"),e.replaceSelections(l)}else e.replaceRange(l,a,o);n.visualMode?(a=ve(s[0].anchor,s[0].head)?s[0].anchor:s[0].head,e.setCursor(a),Te(e,!1)):e.setCursor(pe(o,0,-1))}},incrementNumberToken:function(e,t){for(var n,r,o,i,a=e.getCursor(),s=e.getLine(a.line),c=/(-?)(?:(0x)([\da-f]+)|(0b|0|)(\d+))/gi;null!==(n=c.exec(s))&&(o=(r=n.index)+n[0].length,!(a.ch<o)););if((t.backtrack||!(o<=a.ch))&&n){var l=n[2]||n[4],u=n[3]||n[5],h=t.increase?1:-1,p={"0b":2,0:8,"":10,"0x":16}[l.toLowerCase()];i=(parseInt(n[1]+u,p)+h*t.repeat).toString(p);var f=l?new Array(u.length-i.length+1+n[1].length).join("0"):"";i="-"===i.charAt(0)?"-"+l+f+i.substr(1):l+f+i;var d=y(a.line,r),m=y(a.line,o);e.replaceRange(i,d,m),e.setCursor(y(a.line,r+i.length-1))}},repeatLastEdit:function(e,t,n){if(n.lastEditInputState){var r=t.repeat;r&&t.repeatIsExplicit?n.lastEditInputState.repeatOverride=r:r=n.lastEditInputState.repeatOverride||r,yt(e,n,r,!1)}},indent:function(e,t){e.indentLine(e.getCursor().line,t.indentRight)},exitInsertMode:lt};function ue(e,t,n){var r=Math.min(Math.max(e.firstLine(),t.line),e.lastLine()),o=we(e,r)-1;o=n?o+1:o;var i=Math.min(Math.max(0,t.ch),o);return y(r,i)}function he(e){var t={};for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}function pe(e,t,n){return"object"==typeof t&&(n=t.ch,t=t.line),y(e.line+t,e.ch+n)}function fe(e,t){if("<character>"==t.slice(-11)){var n=t.length-11,r=e.slice(0,n),o=t.slice(0,n);return r==o&&e.length>n?"full":0==o.indexOf(r)&&"partial"}return e==t?"full":0==t.indexOf(e)&&"partial"}function de(e,t,n){return function(){for(var r=0;r<n;r++)t(e)}}function me(e){return y(e.line,e.ch)}function ge(e,t){return e.ch==t.ch&&e.line==t.line}function ve(e,t){return e.line<t.line||e.line==t.line&&e.ch<t.ch}function ye(e,t){return arguments.length>2&&(t=ye.apply(void 0,Array.prototype.slice.call(arguments,1))),ve(e,t)?e:t}function Ce(e,t){return arguments.length>2&&(t=Ce.apply(void 0,Array.prototype.slice.call(arguments,1))),ve(e,t)?t:e}function ke(e,t,n){var r=ve(e,t),o=ve(t,n);return r&&o}function we(e,t){return e.getLine(t).length}function xe(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}function Me(e,t,n){var r=we(e,t),o=new Array(n-r+1).join(" ");e.setCursor(y(t,r)),e.replaceRange(o,e.getCursor())}function Se(e,t){var n=[],r=e.listSelections(),o=me(e.clipPos(t)),i=!ge(t,o),a=function(e,t,n){for(var r=0;r<e.length;r++){var o="head"!=n&&ge(e[r].anchor,t),i="anchor"!=n&&ge(e[r].head,t);if(o||i)return r}return-1}(r,e.getCursor("head")),s=ge(r[a].head,r[a].anchor),c=r.length-1,l=c-a>a?c:0,u=r[l].anchor,h=Math.min(u.line,o.line),p=Math.max(u.line,o.line),f=u.ch,d=o.ch,m=r[l].head.ch-f,g=d-f;m>0&&g<=0?(f++,i||d--):m<0&&g>=0?(f--,s||d++):m<0&&-1==g&&(f--,d++);for(var v=h;v<=p;v++){var C={anchor:new y(v,f),head:new y(v,d)};n.push(C)}return e.setSelections(n),t.ch=d,u.ch=f,u}function Ae(e,t,n){for(var r=[],o=0;o<n;o++){var i=pe(t,o,0);r.push({anchor:i,head:i})}e.setSelections(r,0)}function be(e,t){var n=t.sel.anchor,r=t.sel.head;t.lastPastedText&&(r=e.posFromIndex(e.indexFromPos(n)+t.lastPastedText.length),t.lastPastedText=null),t.lastSelection={anchorMark:e.setBookmark(n),headMark:e.setBookmark(r),anchor:me(n),head:me(r),visualMode:t.visualMode,visualLine:t.visualLine,visualBlock:t.visualBlock}}function Le(e,t,n){var r=e.state.vim,o=Oe(e,t=t||r.sel,n=n||r.visualLine?"line":r.visualBlock?"block":"char");e.setSelections(o.ranges,o.primary),dt(e)}function Oe(e,t,n,r){var o=me(t.head),i=me(t.anchor);if("char"==n){var a=r||ve(t.head,t.anchor)?0:1,s=ve(t.head,t.anchor)?1:0;return o=pe(t.head,0,a),{ranges:[{anchor:i=pe(t.anchor,0,s),head:o}],primary:0}}if("line"==n){if(ve(t.head,t.anchor))o.ch=0,i.ch=we(e,i.line);else{i.ch=0;var c=e.lastLine();o.line>c&&(o.line=c),o.ch=we(e,o.line)}return{ranges:[{anchor:i,head:o}],primary:0}}if("block"==n){for(var l=Math.min(i.line,o.line),u=Math.min(i.ch,o.ch),h=Math.max(i.line,o.line),p=Math.max(i.ch,o.ch)+1,f=h-l+1,d=o.line==l?0:f-1,m=[],g=0;g<f;g++)m.push({anchor:y(l+g,u),head:y(l+g,p)});return{ranges:m,primary:d}}}function Te(e,t){var n=e.state.vim;!1!==t&&e.setCursor(ue(e,n.sel.head)),be(e,n),n.visualMode=!1,n.visualLine=!1,n.visualBlock=!1,p.signal(e,"vim-mode-change",{mode:"normal"}),n.fakeCursor&&n.fakeCursor.clear()}function Ee(e){if(!e)return 0;var t=e.search(/\S/);return-1==t?e.length:t}function Re(e,t,n,r,o){for(var i=function(e){var t=e.getCursor("head");return 1==e.getSelection().length&&(t=ye(t,e.getCursor("anchor"))),t}(e),a=e.getLine(i.line),s=i.ch,c=o?L[0]:O[0];!c(a.charAt(s));)if(++s>=a.length)return null;r?c=O[0]:(c=L[0])(a.charAt(s))||(c=L[1]);for(var l=s,u=s;c(a.charAt(l))&&l<a.length;)l++;for(;c(a.charAt(u))&&u>=0;)u--;if(u++,t){for(var h=l;/\s/.test(a.charAt(l))&&l<a.length;)l++;if(h==l){for(var p=u;/\s/.test(a.charAt(u-1))&&u>0;)u--;u||(u=p)}}return{start:y(i.line,u),end:y(i.line,l)}}function Be(e,t,n){ge(t,n)||z.jumpList.add(e,t,n)}function Ie(e,t){z.lastCharacterSearch.increment=e,z.lastCharacterSearch.forward=t.forward,z.lastCharacterSearch.selectedCharacter=t.selectedCharacter}var Ke={"(":"bracket",")":"bracket","{":"bracket","}":"bracket","[":"section","]":"section","*":"comment","/":"comment",m:"method",M:"method","#":"preprocess"},Pe={bracket:{isComplete:function(e){if(e.nextCh===e.symb){if(e.depth++,e.depth>=1)return!0}else e.nextCh===e.reverseSymb&&e.depth--;return!1}},section:{init:function(e){e.curMoveThrough=!0,e.symb=(e.forward?"]":"[")===e.symb?"{":"}"},isComplete:function(e){return 0===e.index&&e.nextCh===e.symb}},comment:{isComplete:function(e){var t="*"===e.lastCh&&"/"===e.nextCh;return e.lastCh=e.nextCh,t}},method:{init:function(e){e.symb="m"===e.symb?"{":"}",e.reverseSymb="{"===e.symb?"}":"{"},isComplete:function(e){return e.nextCh===e.symb}},preprocess:{init:function(e){e.index=0},isComplete:function(e){if("#"===e.nextCh){var t=e.lineText.match(/#(\w+)/)[1];if("endif"===t){if(e.forward&&0===e.depth)return!0;e.depth++}else if("if"===t){if(!e.forward&&0===e.depth)return!0;e.depth--}if("else"===t&&0===e.depth)return!0}return!1}}};function Ne(e,t,n,r,o){var i=t.line,a=t.ch,s=e.getLine(i),c=n?1:-1,l=r?O:L;if(o&&""==s){if(i+=c,s=e.getLine(i),!P(e,i))return null;a=n?0:s.length}for(;;){if(o&&""==s)return{from:0,to:0,line:i};for(var u=c>0?s.length:-1,h=u,p=u;a!=u;){for(var f=!1,d=0;d<l.length&&!f;++d)if(l[d](s.charAt(a))){for(h=a;a!=u&&l[d](s.charAt(a));)a+=c;if(f=h!=(p=a),h==t.ch&&i==t.line&&p==h+c)continue;return{from:Math.min(h,p+1),to:Math.max(h,p),line:i}}f||(a+=c)}if(!P(e,i+=c))return null;s=e.getLine(i),a=c>0?0:s.length}}function _e(e,t,n,r){for(var o,i=e.getCursor(),a=i.ch,s=0;s<t;s++){if(-1==(o=Ve(a,e.getLine(i.line),r,n,!0)))return null;a=o}return y(e.getCursor().line,o)}function He(e,t,n,r){j(n,I)&&(t.marks[n]&&t.marks[n].clear(),t.marks[n]=e.setBookmark(r))}function Ve(e,t,n,r,o){var i;return r?-1==(i=t.indexOf(n,e+1))||o||(i-=1):-1==(i=t.lastIndexOf(n,e-1))||o||(i+=1),i}function $e(e,t,n,r,o){var i,a=t.line,s=e.firstLine(),c=e.lastLine(),l=a;function u(t){return!/\S/.test(e.getLine(t))}function h(e,t,n){return n?u(e)!=u(e+t):!u(e)&&u(e+t)}function p(t){r=r>0?1:-1;var n=e.ace.session.getFoldLine(t);n&&t+r>n.start.row&&t+r<n.end.row&&(r=(r>0?n.end.row:n.start.row)-t)}if(r){for(;s<=l&&l<=c&&n>0;)p(l),h(l,r)&&n--,l+=r;return new y(l,0)}var f=e.state.vim;if(f.visualLine&&h(a,1,!0)){var d=f.sel.anchor;h(d.line,-1,!0)&&(o&&d.line==a||(a+=1))}var m=u(a);for(l=a;l<=c&&n;l++)h(l,1,!0)&&(o&&u(l)==m||n--);for(i=new y(l,0),l>c&&!m?m=!0:o=!1,l=a;l>s&&(o&&u(l)!=m&&l!=a||!h(l,-1,!0));l--);return{start:new y(l,0),end:i}}function je(){}function De(e){var t=e.state.vim;return t.searchState_||(t.searchState_=new je)}function We(e,t,n,r,o){e.openDialog?e.openDialog(t,r,{bottom:!0,value:o.value,onKeyDown:o.onKeyDown,onKeyUp:o.onKeyUp,selectValueOnOpen:!1,onClose:function(){e.state.vim&&(e.state.vim.status="",e.ace.renderer.$loop.schedule(e.ace.renderer.CHANGE_CURSOR))}}):r(prompt(n,""))}function Fe(e,t){var n=Ue(e,t)||[];if(!n.length)return[];var r=[];if(0===n[0]){for(var o=0;o<n.length;o++)"number"==typeof n[o]&&r.push(e.substring(n[o]+1,n[o+1]));return r}}function Ue(e,t){t||(t="/");for(var n=!1,r=[],o=0;o<e.length;o++){var i=e.charAt(o);n||i!=t||r.push(o),n=!n&&"\\"==i}return r}W("pcre",!0,"boolean"),je.prototype={getQuery:function(){return z.query},setQuery:function(e){z.query=e},getOverlay:function(){return this.searchOverlay},setOverlay:function(e){this.searchOverlay=e},isReversed:function(){return z.isReversed},setReversed:function(e){z.isReversed=e},getScrollbarAnnotate:function(){return this.annotate},setScrollbarAnnotate:function(e){this.annotate=e}};var ze={"\\n":"\n","\\r":"\r","\\t":"\t"};var Je={"\\/":"/","\\\\":"\\","\\n":"\n","\\r":"\r","\\t":"\t"};function qe(e,t,n){if(z.registerController.getRegister("/").setText(e),e instanceof RegExp)return e;var r,o,i=Ue(e,"/");i.length?(r=e.substring(0,i[0]),o=-1!=e.substring(i[0]).indexOf("i")):r=e;return r?(U("pcre")||(r=function(e){for(var t=!1,n=[],r=-1;r<e.length;r++){var o=e.charAt(r)||"",i=e.charAt(r+1)||"",a=i&&-1!="|(){".indexOf(i);t?("\\"===o&&a||n.push(o),t=!1):"\\"===o?(t=!0,i&&-1!="}".indexOf(i)&&(a=!0),a&&"\\"!==i||n.push(o)):(n.push(o),a&&"\\"!==i&&n.push("\\"))}return n.join("")}(r)),n&&(t=/^[^A-Z]*$/.test(r)),new RegExp(r,t||o?"i":void 0)):null}function Qe(e,t){e.openNotification?e.openNotification('<span style="color: red">'+t+"</span>",{bottom:!0,duration:5e3}):alert(t)}var Ge="(Javascript regexp)";function Xe(e,t){var n,r,o,i=(t.prefix||"")+" "+(t.desc||"");We(e,(n=t.prefix,r=t.desc,o='<span style="font-family: monospace; white-space: pre">'+(n||"")+'<input type="text" autocorrect="off" autocapitalize="none" autocomplete="off"></span>',r&&(o+=' <span style="color: #888">'+r+"</span>"),o),i,t.onClose,t)}function Ze(e,t,n,r){if(t){var o=De(e),i=qe(t,!!n,!!r);if(i)return Ye(e,i),function(e,t){if(e instanceof RegExp&&t instanceof RegExp){for(var n=["global","multiline","ignoreCase","source"],r=0;r<n.length;r++){var o=n[r];if(e[o]!==t[o])return!1}return!0}return!1}(i,o.getQuery())||o.setQuery(i),i}}function Ye(e,t){var n=De(e),r=n.getOverlay();r&&t==r.query||(r&&e.removeOverlay(r),r=function(e){if("^"==e.source.charAt(0))var t=!0;return{token:function(n){if(!t||n.sol()){var r=n.match(e,!1);if(r)return 0==r[0].length?(n.next(),"searching"):n.sol()||(n.backUp(1),e.exec(n.next()+r[0]))?(n.match(e),"searching"):(n.next(),null);for(;!n.eol()&&(n.next(),!n.match(e,!1)););}else n.skipToEnd()},query:e}}(t),e.addOverlay(r),e.showMatchesOnScrollbar&&(n.getScrollbarAnnotate()&&n.getScrollbarAnnotate().clear(),n.setScrollbarAnnotate(e.showMatchesOnScrollbar(t))),n.setOverlay(r))}function et(e,t,n,r){return void 0===r&&(r=1),e.operation((function(){for(var o=e.getCursor(),i=e.getSearchCursor(n,o),a=0;a<r;a++){var s=i.find(t);if(0==a&&s&&ge(i.from(),o)&&(s=i.find(t)),!s&&!(i=e.getSearchCursor(n,t?y(e.lastLine()):y(e.firstLine(),0))).find(t))return}return i.from()}))}function tt(e){var t=De(e);e.removeOverlay(De(e).getOverlay()),t.setOverlay(null),t.getScrollbarAnnotate()&&(t.getScrollbarAnnotate().clear(),t.setScrollbarAnnotate(null))}function nt(e,t,n){return"number"!=typeof e&&(e=e.line),t instanceof Array?j(e,t):n?e>=t&&e<=n:e==t}function rt(e){var t=e.ace.renderer;return{top:t.getFirstFullyVisibleRow(),bottom:t.getLastFullyVisibleRow()}}function ot(e,t,n){if("'"==n||"`"==n)return z.jumpList.find(e,-1)||y(0,0);if("."==n)return it(e);var r=t.marks[n];return r&&r.find()}function it(e){var t=e.ace.session.$undoManager;if(t&&t.$lastDelta)return d(t.$lastDelta.end)}var at=function(){this.buildCommandMap_()};at.prototype={processCommand:function(e,t,n){var r=this;e.operation((function(){e.curOp.isVimOp=!0,r._processCommand(e,t,n)}))},_processCommand:function(e,t,n){var r=e.state.vim,o=z.registerController.getRegister(":"),i=o.toString();r.visualMode&&Te(e);var a=new p.StringStream(t);o.setText(t);var s,c,l=n||{};l.input=t;try{this.parseInput_(e,a,l)}catch(t){throw Qe(e,t),t}if(l.commandName){if(s=this.matchCommand_(l.commandName)){if(c=s.name,s.excludeFromCommandHistory&&o.setText(i),this.parseCommandArgs_(a,l,s),"exToKey"==s.type){for(var u=0;u<s.toKeys.length;u++)p.Vim.handleKey(e,s.toKeys[u],"mapping");return}if("exToEx"==s.type)return void this.processCommand(e,s.toInput)}}else void 0!==l.line&&(c="move");if(c)try{st[c](e,l),s&&s.possiblyAsync||!l.callback||l.callback()}catch(t){throw Qe(e,t),t}else Qe(e,'Not an editor command ":'+t+'"')},parseInput_:function(e,t,n){t.eatWhile(":"),t.eat("%")?(n.line=e.firstLine(),n.lineEnd=e.lastLine()):(n.line=this.parseLineSpec_(e,t),void 0!==n.line&&t.eat(",")&&(n.lineEnd=this.parseLineSpec_(e,t)));var r=t.match(/^(\w+)/);return n.commandName=r?r[1]:t.match(/.*/)[0],n},parseLineSpec_:function(e,t){var n=t.match(/^(\d+)/);if(n)return parseInt(n[1],10)-1;switch(t.next()){case".":return this.parseLineSpecOffset_(t,e.getCursor().line);case"$":return this.parseLineSpecOffset_(t,e.lastLine());case"'":var r=t.next(),o=ot(e,e.state.vim,r);if(!o)throw new Error("Mark not set");return this.parseLineSpecOffset_(t,o.line);case"-":case"+":return t.backUp(1),this.parseLineSpecOffset_(t,e.getCursor().line);default:return void t.backUp(1)}},parseLineSpecOffset_:function(e,t){var n=e.match(/^([+-])?(\d+)/);if(n){var r=parseInt(n[2],10);"-"==n[1]?t-=r:t+=r}return t},parseCommandArgs_:function(e,t,n){if(!e.eol()){t.argString=e.match(/.*/)[0];var r=n.argDelimiter||/\s+/,o=xe(t.argString).split(r);o.length&&o[0]&&(t.args=o)}},matchCommand_:function(e){for(var t=e.length;t>0;t--){var n=e.substring(0,t);if(this.commandMap_[n]){var r=this.commandMap_[n];if(0===r.name.indexOf(e))return r}}return null},buildCommandMap_:function(){this.commandMap_={};for(var e=0;e<v.length;e++){var t=v[e],n=t.shortName||t.name;this.commandMap_[n]=t}},map:function(e,t,n){if(":"!=e&&":"==e.charAt(0)){if(n)throw Error("Mode not supported for ex mappings");var r=e.substring(1);":"!=t&&":"==t.charAt(0)?this.commandMap_[r]={name:r,type:"exToEx",toInput:t.substring(1),user:!0}:this.commandMap_[r]={name:r,type:"exToKey",toKeys:t,user:!0}}else if(":"!=t&&":"==t.charAt(0)){var o={keys:e,type:"keyToEx",exArgs:{input:t.substring(1)}};n&&(o.context=n),m.unshift(o)}else{o={keys:e,type:"keyToKey",toKeys:t};n&&(o.context=n),m.unshift(o)}},unmap:function(e,t){if(":"!=e&&":"==e.charAt(0)){if(t)throw Error("Mode not supported for ex mappings");var n=e.substring(1);if(this.commandMap_[n]&&this.commandMap_[n].user)return void delete this.commandMap_[n]}else for(var r=e,o=0;o<m.length;o++)if(r==m[o].keys&&m[o].context===t)return void m.splice(o,1)}};var st={colorscheme:function(e,t){!t.args||t.args.length<1?Qe(e,e.getOption("theme")):e.setOption("theme",t.args[0])},map:function(e,t,n){var r=t.args;!r||r.length<2?e&&Qe(e,"Invalid mapping: "+t.input):ct.map(r[0],r[1],n)},imap:function(e,t){this.map(e,t,"insert")},nmap:function(e,t){this.map(e,t,"normal")},vmap:function(e,t){this.map(e,t,"visual")},unmap:function(e,t,n){var r=t.args;!r||r.length<1?e&&Qe(e,"No such mapping: "+t.input):ct.unmap(r[0],n)},move:function(e,t){ie.processCommand(e,e.state.vim,{type:"motion",motion:"moveToLineOrEdgeOfDocument",motionArgs:{forward:!1,explicitRepeat:!0,linewise:!0},repeatOverride:t.line+1})},set:function(e,t){var n=t.args,r=t.setCfg||{};if(!n||n.length<1)e&&Qe(e,"Invalid mapping: "+t.input);else{var o=n[0].split("="),i=o[0],a=o[1],s=!1;if("?"==i.charAt(i.length-1)){if(a)throw Error("Trailing characters: "+t.argString);i=i.substring(0,i.length-1),s=!0}void 0===a&&"no"==i.substring(0,2)&&(i=i.substring(2),a=!1);var c=D[i]&&"boolean"==D[i].type;if(c&&null==a&&(a=!0),!c&&void 0===a||s){var l=U(i,e,r);l instanceof Error?Qe(e,l.message):Qe(e,!0===l||!1===l?" "+(l?"":"no")+i:"  "+i+"="+l)}else{var u=F(i,a,e,r);u instanceof Error&&Qe(e,u.message)}}},setlocal:function(e,t){t.setCfg={scope:"local"},this.set(e,t)},setglobal:function(e,t){t.setCfg={scope:"global"},this.set(e,t)},registers:function(e,t){var n=t.args,r=z.registerController.registers,o="----------Registers----------<br><br>";if(n){n=n.join("");for(var i=0;i<n.length;i++){if(a=n.charAt(i),z.registerController.isValidRegister(a))o+='"'+a+"    "+(r[a]||new ne).toString()+"<br>"}}else for(var a in r){var s=r[a].toString();s.length&&(o+='"'+a+"    "+s+"<br>")}Qe(e,o)},sort:function(e,t){var n,r,o,i,a;var s=function(){if(t.argString){var e=new p.StringStream(t.argString);if(e.eat("!")&&(n=!0),e.eol())return;if(!e.eatSpace())return"Invalid arguments";var s=e.match(/([dinuox]+)?\s*(\/.+\/)?\s*/);if(!s&&!e.eol())return"Invalid arguments";if(s[1]){r=-1!=s[1].indexOf("i"),o=-1!=s[1].indexOf("u");var c=-1!=s[1].indexOf("d")||-1!=s[1].indexOf("n")&&1,l=-1!=s[1].indexOf("x")&&1,u=-1!=s[1].indexOf("o")&&1;if(c+l+u>1)return"Invalid arguments";i=(c?"decimal":l&&"hex")||u&&"octal"}s[2]&&(a=new RegExp(s[2].substr(1,s[2].length-2),r?"i":""))}}();if(s)Qe(e,s+": "+t.argString);else{var c=t.line||e.firstLine(),l=t.lineEnd||t.line||e.lastLine();if(c!=l){var u=y(c,0),h=y(l,we(e,l)),f=e.getRange(u,h).split("\n"),d=a||("decimal"==i?/(-?)([\d]+)/:"hex"==i?/(-?)(?:0x)?([0-9a-f]+)/i:"octal"==i?/([0-7]+)/:null),m="decimal"==i?10:"hex"==i?16:"octal"==i?8:null,g=[],v=[];if(i||a)for(var C=0;C<f.length;C++){var k=a?f[C].match(a):null;k&&""!=k[0]?g.push(k):!a&&d.exec(f[C])?g.push(f[C]):v.push(f[C])}else v=f;if(g.sort(a?function(e,t){var o;return n&&(o=e,e=t,t=o),r&&(e[0]=e[0].toLowerCase(),t[0]=t[0].toLowerCase()),e[0]<t[0]?-1:1}:M),a)for(C=0;C<g.length;C++)g[C]=g[C].input;else i||v.sort(M);if(f=n?g.concat(v):v.concat(g),o){var w,x=f;f=[];for(C=0;C<x.length;C++)x[C]!=w&&f.push(x[C]),w=x[C]}e.replaceRange(f.join("\n"),u,h)}}function M(e,t){var o;n&&(o=e,e=t,t=o);r&&(e=e.toLowerCase(),t=t.toLowerCase());var a=i&&d.exec(e),s=i&&d.exec(t);return a?(a=parseInt((a[1]+a[2]).toLowerCase(),m))-(s=parseInt((s[1]+s[2]).toLowerCase(),m)):e<t?-1:1}},global:function(e,t){var n=t.argString;if(n){var r,o=void 0!==t.line?t.line:e.firstLine(),i=t.lineEnd||t.line||e.lastLine(),a=function(e){return Fe(e,"/")}(n),s=n;if(a.length&&(s=a[0],r=a.slice(1,a.length).join("/")),s)try{Ze(e,s,!0,!0)}catch(t){return void Qe(e,"Invalid regex: "+s)}for(var c=De(e).getQuery(),l=[],u="",h=o;h<=i;h++){c.test(e.getLine(h))&&(l.push(h+1),u+=e.getLine(h)+"<br>")}if(r){var p=0,f=function(){if(p<l.length){var t=l[p]+r;ct.processCommand(e,t,{callback:f})}p++};f()}else Qe(e,u)}else Qe(e,"Regular Expression missing from global")},substitute:function(e,t){if(!e.getSearchCursor)throw new Error("Search feature not available. Requires searchcursor.js or any other getSearchCursor implementation.");var n,r,o,i,a=t.argString,s=a?Fe(a,a[0]):[],c="",l=!1,u=!1;if(s.length)n=s[0],U("pcre")&&""!==n&&(n=new RegExp(n).source),c=s[1],n&&"$"===n[n.length-1]&&(n=n.slice(0,n.length-1)+"\\n",c=c?c+"\n":"\n"),void 0!==c&&(c=U("pcre")?function(e){for(var t=new p.StringStream(e),n=[];!t.eol();){for(;t.peek()&&"\\"!=t.peek();)n.push(t.next());var r=!1;for(var o in Je)if(t.match(o,!0)){r=!0,n.push(Je[o]);break}r||n.push(t.next())}return n.join("")}(c.replace(/([^\\])&/g,"$1$$&")):function(e){for(var t,n=!1,r=[],o=-1;o<e.length;o++){var i=e.charAt(o)||"",a=e.charAt(o+1)||"";ze[i+a]?(r.push(ze[i+a]),o++):n?(r.push(i),n=!1):"\\"===i?(n=!0,t=a,b.test(t)||"$"===a?r.push("$"):"/"!==a&&"\\"!==a&&r.push("\\")):("$"===i&&r.push("$"),r.push(i),"/"===a&&r.push("\\"))}return r.join("")}(c),z.lastSubstituteReplacePart=c),r=s[2]?s[2].split(" "):[];else if(a&&a.length)return void Qe(e,"Substitutions should be of the form :s/pattern/replace/");if(r&&(o=r[0],i=parseInt(r[1]),o&&(-1!=o.indexOf("c")&&(l=!0,o.replace("c","")),-1!=o.indexOf("g")&&(u=!0,o.replace("g","")),n=U("pcre")?n+"/"+o:n.replace(/\//g,"\\/")+"/"+o)),n)try{Ze(e,n,!0,!0)}catch(t){return void Qe(e,"Invalid regex: "+n)}if(void 0!==(c=c||z.lastSubstituteReplacePart)){var h=De(e).getQuery(),f=void 0!==t.line?t.line:e.getCursor().line,d=t.lineEnd||f;f==e.firstLine()&&d==e.lastLine()&&(d=1/0),i&&(d=(f=d)+i-1);var m=ue(e,y(f,0)),g=e.getSearchCursor(h,m);!function(e,t,n,r,o,i,a,s,c){e.state.vim.exMode=!0;var l=!1,u=i.from();function h(){e.operation((function(){for(;!l;)f(),d();m()}))}function f(){var t=e.getRange(i.from(),i.to()).replace(a,s);i.replace(t)}function d(){for(;i.findNext()&&nt(i.from(),r,o);)if(n||!u||i.from().line!=u.line)return e.scrollIntoView(i.from(),30),e.setSelection(i.from(),i.to()),u=i.from(),void(l=!1);l=!0}function m(t){if(t&&t(),e.focus(),u){e.setCursor(u);var n=e.state.vim;n.exMode=!1,n.lastHPos=n.lastHSPos=u.ch}c&&c()}function g(t,n,r){switch(p.e_stop(t),p.keyName(t)){case"Y":f(),d();break;case"N":d();break;case"A":var o=c;c=void 0,e.operation(h),c=o;break;case"L":f();case"Q":case"Esc":case"Ctrl-C":case"Ctrl-[":m(r)}return l&&m(r),!0}if(d(),l)return void Qe(e,"No matches for "+a.source);if(!t)return h(),void(c&&c());Xe(e,{prefix:"replace with <strong>"+s+"</strong> (y/n/a/q/l)",onKeyDown:g})}(e,l,u,f,d,g,h,c,t.callback)}else Qe(e,"No previous substitute regular expression")},redo:p.commands.redo,undo:p.commands.undo,write:function(e){p.commands.save?p.commands.save(e):e.save&&e.save()},nohlsearch:function(e){tt(e)},yank:function(e){var t=me(e.getCursor()).line,n=e.getLine(t);z.registerController.pushText("0","yank",n,!0,!0)},delmarks:function(e,t){if(t.argString&&xe(t.argString))for(var n=e.state.vim,r=new p.StringStream(xe(t.argString));!r.eol();){r.eatSpace();var o=r.pos;if(!r.match(/[a-zA-Z]/,!1))return void Qe(e,"Invalid argument: "+t.argString.substring(o));var i=r.next();if(r.match("-",!0)){if(!r.match(/[a-zA-Z]/,!1))return void Qe(e,"Invalid argument: "+t.argString.substring(o));var a=i,s=r.next();if(!(N(a)&&N(s)||_(a)&&_(s)))return void Qe(e,"Invalid argument: "+a+"-");var c=a.charCodeAt(0),l=s.charCodeAt(0);if(c>=l)return void Qe(e,"Invalid argument: "+t.argString.substring(o));for(var u=0;u<=l-c;u++){var h=String.fromCharCode(c+u);delete n.marks[h]}}else delete n.marks[i]}else Qe(e,"Argument required")}},ct=new at;function lt(e){var t=e.state.vim,n=z.macroModeState,r=z.registerController.getRegister("."),o=n.isPlaying,i=n.lastInsertModeChanges;o||(e.off("change",pt),p.off(e.getInputField(),"keydown",vt)),!o&&t.insertModeRepeat>1&&(yt(e,t,t.insertModeRepeat-1,!0),t.lastEditInputState.repeatOverride=t.insertModeRepeat),delete t.insertModeRepeat,t.insertMode=!1,e.setCursor(e.getCursor().line,e.getCursor().ch-1),e.setOption("keyMap","vim"),e.setOption("disableInput",!0),e.toggleOverwrite(!1),r.setText(i.changes.join("")),p.signal(e,"vim-mode-change",{mode:"normal"}),n.isRecording&&function(e){if(e.isPlaying)return;var t=e.latestRegister,n=z.registerController.getRegister(t);n&&n.pushInsertModeChanges&&n.pushInsertModeChanges(e.lastInsertModeChanges)}(n)}function ut(e){m.unshift(e)}function ht(e,t,n,r){var o=z.registerController.getRegister(r);if(":"==r)return o.keyBuffer[0]&&ct.processCommand(e,o.keyBuffer[0]),void(n.isPlaying=!1);var i=o.keyBuffer,a=0;n.isPlaying=!0,n.replaySearchQueries=o.searchQueries.slice(0);for(var s=0;s<i.length;s++)for(var c,l,u=i[s];u;)if(l=(c=/<\w+-.+?>|<\w+>|./.exec(u))[0],u=u.substring(c.index+l.length),p.Vim.handleKey(e,l,"macro"),t.insertMode){var h=o.insertModeChanges[a++].changes;z.macroModeState.lastInsertModeChanges.changes=h,Ct(e,h,1),lt(e)}n.isPlaying=!1}function pt(e,t){var n=z.macroModeState,r=n.lastInsertModeChanges;if(!n.isPlaying)for(;t;){if(r.expectCursorActivityForChange=!0,r.ignoreCount>1)r.ignoreCount--;else if("+input"==t.origin||"paste"==t.origin||void 0===t.origin){var o=e.listSelections().length;o>1&&(r.ignoreCount=o);var i=t.text.join("\n");r.maybeReset&&(r.changes=[],r.maybeReset=!1),i&&(e.state.overwrite&&!/\n/.test(i)?r.changes.push([i]):r.changes.push(i))}t=t.next}}function ft(e){var t=e.state.vim;if(t.insertMode){var n=z.macroModeState;if(n.isPlaying)return;var r=n.lastInsertModeChanges;r.expectCursorActivityForChange?r.expectCursorActivityForChange=!1:r.maybeReset=!0}else e.curOp.isVimOp||mt(e,t);t.visualMode&&dt(e)}function dt(e){var t=e.state.vim,n=ue(e,me(t.sel.head)),r=pe(n,0,1);t.fakeCursor&&t.fakeCursor.clear(),t.fakeCursor=e.markText(n,r,{className:"cm-animate-fat-cursor"})}function mt(e,t,n){var r=e.getCursor("anchor"),o=e.getCursor("head");if(t.visualMode&&!e.somethingSelected()?Te(e,!1):t.visualMode||t.insertMode||!e.somethingSelected()||(t.visualMode=!0,t.visualLine=!1,p.signal(e,"vim-mode-change",{mode:"visual"})),t.visualMode){var i=ve(o,r)?0:-1,a=ve(o,r)?-1:0;o=pe(o,0,i),r=pe(r,0,a),t.sel={anchor:r,head:o},He(e,t,"<",ye(o,r)),He(e,t,">",Ce(o,r))}else t.insertMode||n||(t.lastHPos=e.getCursor().ch)}function gt(e){this.keyName=e}function vt(e){var t=z.macroModeState.lastInsertModeChanges,n=p.keyName(e);n&&(-1==n.indexOf("Delete")&&-1==n.indexOf("Backspace")||p.lookupKey(n,"vim-insert",(function(){return t.maybeReset&&(t.changes=[],t.maybeReset=!1),t.changes.push(new gt(n)),!0})))}function yt(e,t,n,r){var o=z.macroModeState;o.isPlaying=!0;var i=!!t.lastEditActionCommand,a=t.inputState;function s(){i?ie.processAction(e,t,t.lastEditActionCommand):ie.evalInput(e,t)}function c(n){if(o.lastInsertModeChanges.changes.length>0){n=t.lastEditActionCommand?n:1;var r=o.lastInsertModeChanges;Ct(e,r.changes,n)}}if(t.inputState=t.lastEditInputState,i&&t.lastEditActionCommand.interlaceInsertRepeat)for(var l=0;l<n;l++)s(),c(1);else r||s(),c(n);t.inputState=a,t.insertMode&&!r&&lt(e),o.isPlaying=!1}function Ct(e,t,n){function r(t){return"string"==typeof t?p.commands[t](e):t(e),!0}var o=e.getCursor("head"),i=z.macroModeState.lastInsertModeChanges.visualBlock;i&&(Ae(e,o,i+1),n=e.listSelections().length,e.setCursor(o));for(var a=0;a<n;a++){i&&e.setCursor(pe(o,a,0));for(var s=0;s<t.length;s++){var c=t[s];if(c instanceof gt)p.lookupKey(c.keyName,"vim-insert",r);else if("string"==typeof c){var l=e.getCursor();e.replaceRange(c,l,l)}else{var u=e.getCursor(),h=pe(u,0,c[0].length);e.replaceRange(c[0],u,h)}}}i&&e.setCursor(pe(o,0,1))}p.keyMap.vim={attach:w,detach:k,call:x},W("insertModeEscKeysTimeout",200,"number"),p.keyMap["vim-insert"]={fallthrough:["default"],attach:w,detach:k,call:x},p.keyMap["vim-replace"]={Backspace:"goCharLeft",fallthrough:["vim-insert"],attach:w,detach:k,call:x},Z(),p.Vim=C();var kt={return:"CR",backspace:"BS",delete:"Del",esc:"Esc",left:"Left",right:"Right",up:"Up",down:"Down",space:"Space",home:"Home",end:"End",pageup:"PageUp",pagedown:"PageDown",enter:"CR"};var wt=(C=p.Vim).handleKey.bind(C);function xt(e){var t=new e.constructor;return Object.keys(e).forEach((function(n){var r=e[n];Array.isArray(r)?r=r.slice():r&&"object"==typeof r&&r.constructor!=Object&&(r=xt(r)),t[n]=r})),e.sel&&(t.sel={head:e.sel.head&&me(e.sel.head),anchor:e.sel.anchor&&me(e.sel.anchor)}),t}C.handleKey=function(e,t,n){return e.operation((function(){return wt(e,t,n)}),!0)},exports.CodeMirror=p;var Mt=C.maybeInitVimState_;function St(e,t){t.off("beforeEndOperation",St);var n=t.state.cm.vimCmd;n&&t.execCommand(n.exec?n:n.name,n.args),t.curOp=t.prevOp}exports.handler={$id:"ace/keyboard/vim",drawCursor:function(e,n,o,i,a){var s=this.state.vim||{},c=o.characterWidth,l=o.lineHeight,u=n.top,h=n.left;s.insertMode||!(i.cursor?t.comparePoints(i.cursor,i.start)<=0:a.selection.isBackwards()||a.selection.isEmpty())&&h>c&&(h-=c);!s.insertMode&&s.status&&(u+=l/=2),r.translate(e,h,u),r.setStyle(e.style,"width",c+"px"),r.setStyle(e.style,"height",l+"px")},handleKeyboard:function(e,t,n,r,o){var i=e.editor,a=i.state.cm,s=Mt(a);if(-1!=r){if(s.insertMode||(-1==t?(n.charCodeAt(0)>255&&e.inputKey&&(n=e.inputKey)&&4==e.inputHash&&(n=n.toUpperCase()),e.inputChar=n):4==t||0==t?e.inputKey==n&&e.inputHash==t&&e.inputChar?(n=e.inputChar,t=-1):(e.inputChar=null,e.inputKey=n,e.inputHash=t):e.inputChar=e.inputKey=null),"c"==n&&1==t&&!c.isMac&&i.getCopyText())return i.once("copy",(function(){i.selection.clearSelection()})),{command:"null",passEvent:!0};if("esc"==n&&!s.insertMode&&!s.visualMode&&!a.ace.inMultiSelectMode){var l=De(a).getOverlay();l&&a.removeOverlay(l)}if(-1==t||1&t||0===t&&n.length>1){var u=s.insertMode,h=function(e,t,n){t.length>1&&"n"==t[0]&&(t=t.replace("numpad","")),t=kt[t]||t;var r="";return n.ctrlKey&&(r+="C-"),n.altKey&&(r+="A-"),(r||t.length>1)&&n.shiftKey&&(r+="S-"),(r+=t).length>1&&(r="<"+r+">"),r}(0,n,o||{});null==s.status&&(s.status="");var p=function(e,t,n){var r=!1,o=C.maybeInitVimState_(e),i=o.visualBlock||o.wasInVisualBlock,a=e.ace.inMultiSelectMode;if(o.wasInVisualBlock&&!a?o.wasInVisualBlock=!1:a&&o.visualBlock&&(o.wasInVisualBlock=!0),"<Esc>"!=t||o.insertMode||o.visualMode||!a)if(i||!a||e.ace.inVirtualSelectionMode)r=C.handleKey(e,t,n);else{var s=xt(o);e.operation((function(){e.ace.forEachSelection((function(){var o=e.ace.selection;e.state.vim.lastHPos=null==o.$desiredColumn?o.lead.column:o.$desiredColumn;var i=e.getCursor("head"),a=e.getCursor("anchor"),c=ve(i,a)?0:-1,l=ve(i,a)?-1:0;i=pe(i,0,c),a=pe(a,0,l),e.state.vim.sel.head=i,e.state.vim.sel.anchor=a,r=wt(e,t,n),o.$desiredColumn=-1==e.state.vim.lastHPos?null:e.state.vim.lastHPos,e.virtualSelectionMode()&&(e.state.vim=xt(s))})),e.curOp.cursorActivity&&!r&&(e.curOp.cursorActivity=!1)}),!0)}else e.ace.exitMultiSelectMode();return!r||o.visualMode||o.insert||o.visualMode==e.somethingSelected()||mt(e,o,!0),r}(a,h,"user");if(s=Mt(a),p&&null!=s.status?s.status+=h:null==s.status&&(s.status=""),a._signal("changeStatus"),!p&&(-1!=t||u))return;return{command:"null",passEvent:!p}}}},attach:function(e){e.state||(e.state={});var t=new p(e);function n(){var n=Mt(t).insertMode;t.ace.renderer.setStyle("normal-mode",!n),e.textInput.setCommandMode(!n),e.renderer.$keepTextAreaAtCursor=n,e.renderer.$blockCursor=!n}e.state.cm=t,e.$vimModeHandler=this,p.keyMap.vim.attach(t),Mt(t).status=null,t.on("vim-command-done",(function(){t.virtualSelectionMode()||(Mt(t).status=null,t.ace._signal("changeStatus"),t.ace.session.markUndoGroup())})),t.on("changeStatus",(function(){t.ace.renderer.updateCursor(),t.ace._signal("changeStatus")})),t.on("vim-mode-change",(function(){t.virtualSelectionMode()||(n(),t._signal("changeStatus"))})),n(),e.renderer.$cursorLayer.drawCursor=this.drawCursor.bind(t)},detach:function(e){var t=e.state.cm;p.keyMap.vim.detach(t),t.destroy(),e.state.cm=null,e.$vimModeHandler=null,e.renderer.$cursorLayer.drawCursor=null,e.renderer.setStyle("normal-mode",!1),e.textInput.setCommandMode(!1),e.renderer.$keepTextAreaAtCursor=!0},getStatusText:function(e){var t=e.state.cm,n=Mt(t);if(n.insertMode)return"INSERT";var r="";return n.visualMode&&(r+="VISUAL",n.visualLine&&(r+=" LINE"),n.visualBlock&&(r+=" BLOCK")),n.status&&(r+=(r?" ":"")+n.status),r}},C.defineOption({name:"wrap",set:function(e,t){t&&t.ace.setOption("wrap",e)},type:"boolean"},!1),C.defineEx("write","w",(function(){console.log(":write is not implemented")})),m.push({keys:"zc",type:"action",action:"fold",actionArgs:{open:!1}},{keys:"zC",type:"action",action:"fold",actionArgs:{open:!1,all:!0}},{keys:"zo",type:"action",action:"fold",actionArgs:{open:!0}},{keys:"zO",type:"action",action:"fold",actionArgs:{open:!0,all:!0}},{keys:"za",type:"action",action:"fold",actionArgs:{toggle:!0}},{keys:"zA",type:"action",action:"fold",actionArgs:{toggle:!0,all:!0}},{keys:"zf",type:"action",action:"fold",actionArgs:{open:!0,all:!0}},{keys:"zd",type:"action",action:"fold",actionArgs:{open:!0,all:!0}},{keys:"<C-A-k>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorAbove"}},{keys:"<C-A-j>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorBelow"}},{keys:"<C-A-S-k>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorAboveSkipCurrent"}},{keys:"<C-A-S-j>",type:"action",action:"aceCommand",actionArgs:{name:"addCursorBelowSkipCurrent"}},{keys:"<C-A-h>",type:"action",action:"aceCommand",actionArgs:{name:"selectMoreBefore"}},{keys:"<C-A-l>",type:"action",action:"aceCommand",actionArgs:{name:"selectMoreAfter"}},{keys:"<C-A-S-h>",type:"action",action:"aceCommand",actionArgs:{name:"selectNextBefore"}},{keys:"<C-A-S-l>",type:"action",action:"aceCommand",actionArgs:{name:"selectNextAfter"}}),le.aceCommand=function(e,t,n){e.vimCmd=t,e.ace.inVirtualSelectionMode?e.ace.on("beforeEndOperation",St):St(null,e.ace)},le.fold=function(e,t,n){e.ace.execCommand(["toggleFoldWidget","toggleFoldWidget","foldOther","unfoldall"][(t.all?2:0)+(t.open?1:0)])},exports.handler.defaultKeymap=m,exports.handler.actions=le,exports.Vim=C})),ace.require(["ace/keyboard/vim"],(function(e){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=e)}));