/*
 * Decompiled with CFR 0.152.
 */
package compat;

import devplugin.ContextMenuIf;
import devplugin.Date;
import devplugin.Program;
import devplugin.Version;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import tvbrowser.TVBrowser;
import util.ui.Localizer;
import util.ui.ProgramList;

public final class ProgramListCompat {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramListCompat.class);

    public static void addMouseAndKeyListeners(ProgramList list, ContextMenuIf caller) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 31)) >= 0) {
            try {
                Method addMouseAndKeyListeners = ProgramList.class.getDeclaredMethod("addMouseAndKeyListeners", ContextMenuIf.class);
                addMouseAndKeyListeners.invoke((Object)list, caller);
            }
            catch (Exception exception) {}
        } else {
            list.addMouseListeners(caller);
        }
    }

    public static void addDateSeparators(ProgramList list) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 22)) >= 0) {
            try {
                Method addDateSeparators = ProgramList.class.getDeclaredMethod("addDateSeparators", new Class[0]);
                addDateSeparators.invoke((Object)list, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getNewIndexForOldIndex(ProgramList list, int index) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 22)) >= 0) {
            try {
                Method getNewIndexForOldIndex = ProgramList.class.getDeclaredMethod("getNewIndexForOldIndex", Integer.TYPE);
                index = (Integer)getNewIndexForOldIndex.invoke((Object)list, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return index;
    }

    public static String getPreviousActionTooltip() {
        String result = LOCALIZER.msg("prevTooltip", "Scrolls to previous day from current view position (if there is previous day in the list)");
        if (TVBrowser.VERSION.compareTo(new Version(3, 22)) >= 0) {
            try {
                Method getPreviousActionTooltip = ProgramList.class.getDeclaredMethod("getPreviousActionTooltip", new Class[0]);
                result = (String)getPreviousActionTooltip.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getNextActionTooltip() {
        String result = LOCALIZER.msg("nextTooltip", "Scrolls to next day from current view position (if there is next day in the list)");
        if (TVBrowser.VERSION.compareTo(new Version(3, 22)) >= 0) {
            try {
                Method getNextActionTooltip = ProgramList.class.getDeclaredMethod("getNextActionTooltip", new Class[0]);
                result = (String)getNextActionTooltip.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static void scrollToPreviousDayIfAvailable(ProgramList list) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 22)) >= 0) {
            try {
                Method scrollToPreviousDayIfAvailable = ProgramList.class.getDeclaredMethod("scrollToPreviousDayIfAvailable", new Class[0]);
                scrollToPreviousDayIfAvailable.invoke((Object)list, new Object[0]);
            }
            catch (Exception exception) {}
        } else {
            ProgramListCompat.scrollToPreviousDayIfAvailableCompat(list);
        }
    }

    public static void scrollToNextDayIfAvailable(ProgramList list) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 22)) >= 0) {
            try {
                Method scrollToNextDayIfAvailable = ProgramList.class.getDeclaredMethod("scrollToNextDayIfAvailable", new Class[0]);
                scrollToNextDayIfAvailable.invoke((Object)list, new Object[0]);
            }
            catch (Exception exception) {}
        } else {
            ProgramListCompat.scrollToNextDayIfAvailableCompat(list);
        }
    }

    public static void scrollToNextDateIfAvailable(ProgramList list, Date date) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 34)) >= 0) {
            try {
                Method scrollToNextDateIfAvailable = ProgramList.class.getDeclaredMethod("scrollToNextDateIfAvailable", Date.class);
                scrollToNextDateIfAvailable.invoke((Object)list, date);
            }
            catch (Exception exception) {}
        } else {
            ProgramListCompat.scrollToNextDateIfAvailableCompat(list, date);
        }
    }

    public static void scrollToTimeFromCurrentViewIfAvailable(ProgramList list, int time) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 34)) >= 0) {
            try {
                Method scrollToTimeFromCurrentViewIfAvailable = ProgramList.class.getDeclaredMethod("scrollToTimeFromCurrentViewIfAvailable", Integer.TYPE);
                scrollToTimeFromCurrentViewIfAvailable.invoke((Object)list, time);
            }
            catch (Exception exception) {}
        } else {
            ProgramListCompat.scrollToTimeFromCurrentViewIfAvailableCompat(list, time);
        }
    }

    public static void scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailable(ProgramList list, int time) {
        if (TVBrowser.VERSION.compareTo(new Version(3, 34)) >= 0) {
            try {
                Method scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailable = ProgramList.class.getDeclaredMethod("scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailable", Integer.TYPE);
                scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailable.invoke((Object)list, time);
            }
            catch (Exception exception) {}
        } else {
            ProgramListCompat.scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailableCompat(list, time);
        }
    }

    private static void scrollToNextDateIfAvailableCompat(ProgramList list, Date date) {
        int i = 0;
        while (i < list.getModel().getSize()) {
            Object test = list.getModel().getElementAt(i);
            if (test instanceof Program && date.compareTo(((Program)test).getDate()) == 0) {
                Point p = list.indexToLocation(i);
                if (list.getVisibleRect() != null) {
                    list.scrollRectToVisible(new Rectangle(p.x, p.y, 1, list.getVisibleRect().height));
                    list.repaint();
                }
                return;
            }
            ++i;
        }
    }

    private static void scrollToTimeFromCurrentViewIfAvailableCompat(ProgramList list, int time) {
        int index = list.locationToIndex(list.getVisibleRect().getLocation());
        if (index < list.getModel().getSize() - 1) {
            Object o = list.getModel().getElementAt(index);
            if (o instanceof String) {
                o = list.getModel().getElementAt(index + 1);
                ++index;
            }
            if (index < list.getModel().getSize() - 1) {
                boolean down;
                Date current = ((Program)o).getDate();
                int i = index + 1;
                boolean bl = down = time <= ((Program)o).getStartTime();
                if (down) {
                    i = index - 1;
                }
                Point scrollPoint = null;
                if (down && ((Program)o).getStartTime() == time) {
                    scrollPoint = i > 0 && list.getModel().getElementAt(i) instanceof String ? list.indexToLocation(i) : list.indexToLocation(i + 1);
                }
                while (!(down ? i < 0 : i >= list.getModel().getSize())) {
                    Object test = list.getModel().getElementAt(i);
                    if (test instanceof Program) {
                        Program prog = (Program)test;
                        int startTime = prog.getStartTime();
                        if (prog.getDate().compareTo(current) == 0) {
                            if (down ? startTime < time : startTime >= time) {
                                if (scrollPoint != null) break;
                                if (i > 0 && list.getModel().getElementAt(i - 1) instanceof String || startTime > time) {
                                    scrollPoint = list.indexToLocation(i - 1);
                                    break;
                                }
                                scrollPoint = list.indexToLocation(i);
                                break;
                            }
                            if (down && startTime == time) {
                                if (i > 0 && list.getModel().getElementAt(i - 1) instanceof String) {
                                    scrollPoint = list.indexToLocation(i - 1);
                                    break;
                                }
                                scrollPoint = list.indexToLocation(i);
                            }
                        } else if (scrollPoint == null) {
                            if (down && i < list.getModel().getSize() - 1) {
                                scrollPoint = list.indexToLocation(i + 1);
                                break;
                            }
                            if (!down && i > 0) {
                                scrollPoint = list.indexToLocation(i - 1);
                                break;
                            }
                            scrollPoint = list.indexToLocation(i);
                            break;
                        }
                    } else if (test instanceof String && scrollPoint == null) {
                        if (down || i == 0) {
                            scrollPoint = list.indexToLocation(i);
                            break;
                        }
                        scrollPoint = list.indexToLocation(i - 1);
                        break;
                    }
                    if (down) {
                        --i;
                        continue;
                    }
                    ++i;
                }
                if (scrollPoint == null) {
                    if (down) {
                        if (list.getModel().getSize() > 0) {
                            scrollPoint = list.indexToLocation(0);
                        }
                    } else if (list.getModel().getSize() > 0) {
                        scrollPoint = list.indexToLocation(list.getModel().getSize() - 1);
                    }
                }
                if (scrollPoint != null && list.getVisibleRect() != null) {
                    list.scrollRectToVisible(new Rectangle(scrollPoint.x, scrollPoint.y, 1, list.getVisibleRect().height));
                    list.repaint();
                }
            }
        }
    }

    private static void scrollToFirstOccurrenceOfTimeFromCurrentViewOnwardIfAvailableCompat(ProgramList list, int time) {
        int index = list.locationToIndex(list.getVisibleRect().getLocation());
        if (index < list.getModel().getSize() - 1) {
            Object o = list.getModel().getElementAt(index);
            if (o instanceof String) {
                o = list.getModel().getElementAt(index + 1);
                ++index;
            }
            if (index < list.getModel().getSize() - 1 && ((Program)o).getStartTime() != time) {
                Date current = ((Program)o).getDate();
                if (((Program)o).getStartTime() > time) {
                    time += 1440;
                }
                int i = index + 1;
                while (i < list.getModel().getSize()) {
                    Object test = list.getModel().getElementAt(i);
                    if (test instanceof Program) {
                        Program prog = (Program)test;
                        int startTime = prog.getStartTime();
                        if (prog.getDate().compareTo(current) > 0) {
                            startTime += 1440;
                        }
                        if (prog.getDate().compareTo(current) >= 0 && startTime >= time) {
                            Point p = list.indexToLocation(i);
                            if (i > 0 && list.getModel().getElementAt(i - 1) instanceof String || startTime > time) {
                                p = list.indexToLocation(i - 1);
                            }
                            if (list.getVisibleRect() != null) {
                                list.scrollRectToVisible(new Rectangle(p.x, p.y, 1, list.getVisibleRect().height));
                                list.repaint();
                            }
                            return;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private static void scrollToPreviousDayIfAvailableCompat(ProgramList list) {
        int index = list.locationToIndex(list.getVisibleRect().getLocation()) - 1;
        if (index > 0) {
            Object o = list.getModel().getElementAt(index);
            if (o instanceof String) {
                o = list.getModel().getElementAt(index - 1);
                --index;
            }
            if (index > 0) {
                Date current = ((Program)o).getDate();
                int i = index - 1;
                while (i >= 0) {
                    Object test = list.getModel().getElementAt(i);
                    if (test instanceof Program && current.compareTo(((Program)test).getDate()) > 0) {
                        list.ensureIndexIsVisible(i + 1);
                        return;
                    }
                    --i;
                }
            }
        }
        if (list.getModel().getSize() > 0) {
            list.ensureIndexIsVisible(0);
        }
    }

    private static void scrollToNextDayIfAvailableCompat(ProgramList list) {
        int index = list.locationToIndex(list.getVisibleRect().getLocation());
        if (index < list.getModel().getSize() - 1) {
            Object o = list.getModel().getElementAt(index);
            if (o instanceof String) {
                o = list.getModel().getElementAt(index + 1);
                ++index;
            }
            if (index < list.getModel().getSize() - 1) {
                Date current = ((Program)o).getDate();
                int i = index + 1;
                while (i < list.getModel().getSize()) {
                    Object test = list.getModel().getElementAt(i);
                    if (test instanceof Program && current.compareTo(((Program)test).getDate()) < 0) {
                        Point p = list.indexToLocation(i);
                        if (list.getVisibleRect() != null) {
                            list.scrollRectToVisible(new Rectangle(p.x, p.y, 1, list.getVisibleRect().height));
                        }
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    public static boolean isDateSeparatorSupported() {
        return TVBrowser.VERSION.compareTo(new Version(3, 22, true)) >= 0;
    }
}

