/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.JTaskPaneGroup;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class GroupOfTaskPaneGroup
implements PropertyChangeListener {
    private JTaskPaneGroup selection;

    public void add(JTaskPaneGroup taskpaneGroup) {
        this.register(taskpaneGroup);
        if (this.selection == null) {
            if (taskpaneGroup.isExpanded()) {
                this.selection = taskpaneGroup;
            }
        } else {
            taskpaneGroup.setExpanded(false);
        }
        this.maybeUpdateSelection(taskpaneGroup);
    }

    public void remove(JTaskPaneGroup taskpaneGroup) {
        this.unregister(taskpaneGroup);
        if (this.selection == taskpaneGroup) {
            this.selection = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        JTaskPaneGroup taskpaneGroup = (JTaskPaneGroup)event.getSource();
        this.maybeUpdateSelection(taskpaneGroup);
    }

    private void maybeUpdateSelection(JTaskPaneGroup taskpaneGroup) {
        if (this.selection != taskpaneGroup && taskpaneGroup.isExpanded()) {
            if (this.selection != null) {
                this.selection.setExpanded(false);
            }
            this.selection = taskpaneGroup;
        }
    }

    private void register(JTaskPaneGroup taskpaneGroup) {
        taskpaneGroup.addPropertyChangeListener("expanded", this);
    }

    private void unregister(JTaskPaneGroup taskpaneGroup) {
        taskpaneGroup.removePropertyChangeListener("expanded", this);
    }
}

