/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import devplugin.Channel;
import devplugin.ProgramFieldType;
import devplugin.Version;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Authenticator;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.SocketException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.FileLoggingHandler;
import tvbrowser.UdpThread;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.PendingMarkings;
import tvbrowser.core.PluginLoader;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.plugin.programformating.GlobalPluginProgramFormatingManager;
import tvbrowser.core.protocolhandler.ProtocolHandler;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.searchplugin.SearchPlugin;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.configassistant.TvBrowserPictureSettingsUpdateDialog;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.UpdateDlg;
import tvbrowser.ui.settings.GeneralSettingsTab;
import tvbrowser.ui.settings.LookAndFeelSettingsTab;
import tvbrowser.ui.settings.MarkingsSettingsTab;
import tvbrowser.ui.settings.ProgramPanelSettingsTab;
import tvbrowser.ui.splashscreen.DummySplash;
import tvbrowser.ui.splashscreen.Splash;
import tvbrowser.ui.splashscreen.SplashScreen;
import tvbrowser.ui.tray.SystemTray;
import tvbrowser.ui.update.PluginAutoUpdater;
import tvbrowser.ui.update.SoftwareUpdateDlg;
import tvbrowser.ui.update.SoftwareUpdateItem;
import tvbrowser.ui.update.TvBrowserVersionChangeDlg;
import tvdataservice.MarkedProgramsMap;
import util.browserlauncher.Launch;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.io.IOUtilities;
import util.io.Mirror;
import util.io.windows.registry.RegistryKey;
import util.io.windows.registry.RegistryValue;
import util.misc.BooleanResult;
import util.misc.OperatingSystem;
import util.ui.EnhancedPanelBuilder;
import util.ui.ImageUtilities;
import util.ui.ProgramPanel;
import util.ui.ScrollableJPanel;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.textcomponentpopup.TextComponentPopupEventQueue;

public class TVBrowser {
    private static final Logger LOG = Logger.getLogger(TVBrowser.class.getName());
    private static Localizer LOCALIZER;
    private static String CUR_LOOK_AND_FEEL;
    public static final ArrayList<Image> ICONS_WINDOW;
    private static final boolean IS_STABLE = true;
    private static final int MAJRO_VERSION = 4;
    private static final int MINOR_VERSION = 27;
    private static final int SUB_MINOR_VERSION = 0;
    private static final String[] ALL_VERSIONS;
    private static final boolean mIsTransportable;
    public static final Version VERSION;
    public static final String MAINWINDOW_TITLE;
    private static SystemTray mTray;
    private static MainFrame mainFrame;
    private static AtomicReference<UdpThread> mToggleSocket;
    private static AtomicReference<RandomAccessFile> mLockFile;
    private static AtomicReference<RandomAccessFile> mToggleLockFile;
    private static AtomicReference<FileLock> mLock;
    private static AtomicReference<FileLock> mToggleLock;
    private static WindowAdapter mMainWindowAdapter;
    private static boolean mSaveThreadShouldStop;
    private static boolean mSaveThreadIsRunning;
    private static boolean mShowStartScreen;
    private static boolean mFullscreen;
    private static boolean mMinimized;
    private static boolean mSafeMode;
    private static boolean lookAndFeelInitialized;
    private static Timer mAutoDownloadWaitingTimer;
    private static String[] RESTART_CMD;
    private static String mProtocolMessage;
    private static Version VERSION_LAST;
    private static boolean IS_TVB_UPDATE;

    public static void main(String[] args) {
        StringBuilder oldDefaultTvDataDir;
        String tvDataDir;
        Version currentVersion;
        System.setProperty("http.agent", MAINWINDOW_TITLE);
        TVBrowser.parseCommandline(args);
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout((Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("awt.dynamicLayoutSupported"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOCALIZER = Localizer.getLocalizerFor(TVBrowser.class);
        if (!new File("imgs").exists()) {
            String msg = "Please start TV-Browser in the TV-Browser directory!";
            if (LOCALIZER != null) {
                msg = LOCALIZER.msg("error.2", "Please start TV-Browser in the TV-Browser directory!");
            }
            UiUtilities.showMessageDialogOnMouseScreen(msg, Localizer.getLocalization("i18n_info"), 1);
            System.exit(1);
        }
        if (mIsTransportable) {
            System.getProperties().remove("propertiesfile");
        }
        final Logger mainLogger = Logger.getLogger("");
        mainLogger.getHandlers()[0].setFormatter(TVBrowser.createFormatter());
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable t) {
                mainLogger.log(Level.SEVERE, "UNCAUGHT EXCEPTION IN THREAD '" + thread.getName() + "'", t);
            }
        });
        if (mIsTransportable) {
            File settingsDir = new File("settings");
            try {
                File test = File.createTempFile("write", "test", settingsDir);
                test.delete();
            }
            catch (IOException e) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JTextArea area = new JTextArea(LOCALIZER.msg("error.noWriteRightsText", "You are using the transportable version of TV-Browser but you have no writing rights in the settings directory:\n\n{0}'\n\nTV-Browser will be closed.", settingsDir.getAbsolutePath()));
                area.setFont(new JLabel().getFont());
                area.setFont(area.getFont().deriveFont(14.0f).deriveFont(1));
                area.setLineWrap(true);
                area.setWrapStyleWord(true);
                area.setPreferredSize(new Dimension(500, 100));
                area.setEditable(false);
                area.setBorder(null);
                area.setOpaque(false);
                UiUtilities.showMessageDialogOnMouseScreen(area, LOCALIZER.msg("error.noWriteRightsTitle", "No write rights in settings directory"), 0);
                System.exit(1);
            }
        }
        RESTART_CMD = TVBrowser.generateRestartCMD();
        Settings.loadSettings();
        Locale.setDefault(new Locale(Settings.Locales.LANGUAGE.getString(), Settings.Locales.COUNTRY.getString()));
        if (Settings.General.DATE_FIRST_START.getDate() == null) {
            Settings.General.DATE_FIRST_START.setDate(devplugin.Date.getCurrentDate());
        }
        if (!TVBrowser.createLockFile(TVBrowser.mLockFile, TVBrowser.mLock, (String)".lock", (String[])new String[0]).mResult) {
            LockFileResult resultLockFile = TVBrowser.createLockGlobalToggle();
            int port = Integer.MIN_VALUE;
            if (mProtocolMessage != null) {
                if (resultLockFile.mLines != null && resultLockFile.mLines.length == 1) {
                    try {
                        port = Integer.parseInt(resultLockFile.mLines[0]);
                    }
                    catch (NumberFormatException area) {
                        // empty catch block
                    }
                }
                if (!resultLockFile.mResult && port != Integer.MIN_VALUE) {
                    try (DatagramSocket socket = new DatagramSocket();){
                        byte[] buf = mProtocolMessage.getBytes();
                        DatagramPacket packet = new DatagramPacket(buf, buf.length, InetAddress.getByName("localhost"), port);
                        socket.send(packet);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                }
                System.exit(-1);
            }
            TVBrowser.updateLookAndFeel();
            TVBrowser.showTVBrowserIsAlreadyRunningMessageBox(resultLockFile);
        } else {
            TVBrowser.createLockGlobalToggle();
        }
        String logDirectory = Settings.Directories.LOG.getString();
        if (logDirectory != null) {
            try {
                File logDir = new File(logDirectory);
                logDir.mkdirs();
                mainLogger.addHandler(new FileLoggingHandler(logDir.getAbsolutePath() + "/tvbrowser.log", TVBrowser.createFormatter()));
            }
            catch (IOException exc) {
                String msg = LOCALIZER.msg("error.4", "Can't create log file.");
                ErrorHandler.handle(msg, exc);
            }
        } else {
            ConsoleHandler handlerObj = new ConsoleHandler();
            handlerObj.setLevel(Level.OFF);
            mainLogger.addHandler(handlerObj);
            if (TVBrowser.isStable()) {
                mainLogger.setLevel(Level.WARNING);
            }
            mainLogger.setUseParentHandlers(false);
        }
        TVBrowser.updateProxySettings();
        VERSION_LAST = Settings.General.TV_BROWSER_VERSION_USED_LAST.getVersion();
        if (VERSION.isNewerThan(VERSION_LAST)) {
            TVBrowser.updateLookAndFeel();
            TVBrowser.updatePluginsOnVersionChange();
            IS_TVB_UPDATE = true;
        } else if (VERSION_LAST != null && (Settings.General.DATE_OLD_SETTINGS_CHECKED_LAST.getDate() == null || Settings.General.DATE_OLD_SETTINGS_CHECKED_LAST.getDate().addDays(180).compareTo(devplugin.Date.getCurrentDate()) < 0)) {
            TVBrowser.updateLookAndFeel();
            TVBrowser.seachForOldVersionFiles();
        }
        String timezone = Settings.Locales.TIMEZONE.getString();
        if (timezone != null) {
            TimeZone.setDefault(TimeZone.getTimeZone(timezone));
        }
        LOG.info("Using timezone " + TimeZone.getDefault().getDisplayName());
        Localizer.emptyLocalizerCache();
        LOCALIZER = Localizer.getLocalizerFor(TVBrowser.class);
        ProgramInfo.resetLocalizer();
        ReminderPlugin.resetLocalizer();
        devplugin.Date.resetLocalizer();
        ProgramFieldType.resetLocalizer();
        Version tmpVer = Settings.General.TV_BROWSER_VERSION_USED_LAST.getVersion();
        Version version = currentVersion = tmpVer != null ? new Version(tmpVer.getMajor(), tmpVer.getMinor(), tmpVer.getSubMinor(), Settings.General.TV_BROWSER_VERSION_USED_LAST_IS_STABLE.getBoolean()) : tmpVer;
        if (!TVBrowser.isTransportable() && Launch.isOsWindowsNtBranch() && new Version(3, 0, true).isNewerThan(currentVersion) && !(tvDataDir = Settings.Directories.TV_DATA.getString().replace("/", File.separator)).startsWith(System.getenv("appdata")) && (oldDefaultTvDataDir = new StringBuilder(System.getProperty("user.home")).append(File.separator).append("TV-Browser").append(File.separator).append("tvdata")).toString().equals(tvDataDir)) {
            Settings.Directories.TV_DATA.setString(Settings.Directories.TV_DATA.getDefault());
        }
        Settings.General.TV_BROWSER_VERSION_USED_LAST.setVersion(VERSION);
        Settings.General.TV_BROWSER_VERSION_USED_LAST_IS_STABLE.setBoolean(VERSION.isStable());
        AtomicReference<Splash> splashRef = new AtomicReference<Splash>();
        if (mShowStartScreen && Settings.General.START_SCREEN_SHOW.getBoolean()) {
            splashRef.set(new SplashScreen());
            ((Splash)splashRef.get()).showSplash();
        } else {
            if (java.awt.SplashScreen.getSplashScreen() != null && java.awt.SplashScreen.getSplashScreen().isVisible()) {
                java.awt.SplashScreen.getSplashScreen().close();
            }
            splashRef.set(new DummySplash());
        }
        LOG.info("Deleting expired TV listings...");
        TvDataBase.getInstance().deleteExpiredFiles(1, false);
        MarkedProgramsMap.getInstance();
        if (!mSafeMode) {
            PluginLoader.getInstance().installPendingPlugins();
        }
        PluginProxyManager.getInstance();
        if (!mSafeMode) {
            PluginLoader.getInstance().loadAllPlugins();
        }
        SearchPlugin.getInstance();
        LOG.info("Loading TV listings service...");
        ((Splash)splashRef.get()).setMessage(LOCALIZER.msg("startScreen.dataService", "Loading TV listings service..."));
        TvDataServiceProxyManager.getInstance().init();
        if (!Settings.Window.ASSISTANT_SHOW.getBoolean() && TvDataServiceProxyManager.getInstance().getDataServices().length < 1 && !mSafeMode) {
            ((Splash)splashRef.get()).hideSplash();
            TVBrowser.updateLookAndFeel();
            TVBrowser.loadDataServicesAtStartup();
        } else {
            ChannelList.createForTvBrowserStart();
            ChannelList.initSubscribedChannels();
        }
        ChannelList.checkForJointChannels();
        GenericFilterMap.getInstance();
        if (!lookAndFeelInitialized) {
            LOG.info("Loading Look&Feel...");
            ((Splash)splashRef.get()).setMessage(LOCALIZER.msg("startScreen.laf", "Loading look and feel..."));
            TVBrowser.updateLookAndFeel();
        }
        LOG.info("Loading plugins...");
        ((Splash)splashRef.get()).setMessage(LOCALIZER.msg("startScreen.plugins", "Loading plugins..."));
        try {
            InternalPluginProxyList.getInstance();
            PluginProxyManager.getInstance().init();
        }
        catch (TvBrowserException exc) {
            ErrorHandler.handle(exc);
        }
        GenericFilterMap.getInstance().initializeFilters();
        PendingMarkings.markMapEntries();
        ((Splash)splashRef.get()).setMessage(LOCALIZER.msg("startScreen.tvData", "Checking TV database..."));
        LOG.info("Checking TV listings inventory...");
        TvDataBase.getInstance().checkTvDataInventory(1);
        LOG.info("Starting up...");
        ((Splash)splashRef.get()).setMessage(LOCALIZER.msg("startScreen.ui", "Starting up..."));
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new TextComponentPopupEventQueue());
        boolean fStartMinimized = Settings.General.MINIMIZE_AFTER_STARTUP.getBoolean() || mMinimized;
        SwingUtilities.invokeLater(() -> {
            TVBrowser.initUi((Splash)splashRef.get(), fStartMinimized);
            new Thread("Start finished callbacks"){

                @Override
                public void run() {
                    InternalPluginProxyIf[] internalPlugins;
                    this.setPriority(1);
                    mainFrame.handleTvBrowserStartFinished();
                    for (InternalPluginProxyIf internalPlugin : internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys()) {
                        internalPlugin.handleTvBrowserStartFinished();
                    }
                    GlobalPluginProgramFormatingManager.getInstance();
                    if (IS_TVB_UPDATE) {
                        PluginProxyManager.getInstance().fireTvBrowserVersionUpdate(VERSION_LAST);
                        TvDataServiceProxyManager.getInstance().fireTvBrowserVersionUpdate(VERSION_LAST);
                    }
                    PluginProxyManager.getInstance().fireTvBrowserStartFinished();
                    TvDataServiceProxyManager.getInstance().fireTvBrowserStartFinished();
                    TvDataBase.getInstance().handleTvBrowserStartFinished();
                    mainFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowIconified(WindowEvent e) {
                            mSaveThreadShouldStop = true;
                            TVBrowser.flushSettings(true);
                        }

                        @Override
                        public void windowDeiconified(WindowEvent e) {
                            mSaveThreadShouldStop = false;
                            if (!mSaveThreadIsRunning) {
                                TVBrowser.startPeriodicSaveSettings();
                            }
                        }
                    });
                    TVBrowser.startPeriodicSaveSettings();
                    ChannelList.completeChannelLoading();
                    TVBrowser.initializeAutomaticDownload();
                    ProtocolHandler.getInstance().handleMessage(mProtocolMessage);
                }
            }.start();
            SwingUtilities.invokeLater(() -> {
                if (Launch.isOsWindowsNtBranch()) {
                    try {
                        int i1;
                        RegistryValue killWait;
                        RegistryKey desktopSettings = new RegistryKey("HKCU", "Control Panel\\Desktop");
                        RegistryValue autoEnd = desktopSettings.getValue("AutoEndTasks");
                        if (autoEnd.getData().equals("1") && !(killWait = desktopSettings.getValue("WaitToKillAppTimeout")).isUnknown() && (i1 = Integer.parseInt(killWait.getData())) < 5000) {
                            JOptionPane pane = new JOptionPane();
                            String cancel = LOCALIZER.msg("registryCancel", "Close TV-Browser");
                            String dontDoIt = LOCALIZER.msg("registryJumpOver", "Not this time");
                            pane.setOptions(new String[]{Localizer.getLocalization("i18n_ok"), dontDoIt, cancel});
                            pane.setOptionType(1);
                            pane.setMessageType(2);
                            pane.setMessage(LOCALIZER.msg("registryWarning", "The fast shutdown of Windows is activated.\nThe timeout to wait for before Windows is closing an application is too short,\nto give TV-Browser enough time to save all settings.\n\nThe setting hasn't the default value. It was changed by a tool or by you.\nTV-Browser will now try to change the timeout.\n\nIf you don't want to change this timeout select 'Not this time' or 'Close TV-Browser'."));
                            pane.setInitialValue(LOCALIZER.msg("registryCancel", "Close TV-Browser"));
                            JDialog d = pane.createDialog(UiUtilities.getLastModalChildOf(mainFrame), UIManager.getString("OptionPane.messageDialogTitle"));
                            d.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                            UiUtilities.centerAndShow(d);
                            if (pane.getValue() == null || pane.getValue().equals(cancel)) {
                                mainFrame.quit();
                            } else if (!pane.getValue().equals(dontDoIt)) {
                                try {
                                    killWait.setData("5000");
                                    boolean result = desktopSettings.setValue(killWait);
                                    if (!result) {
                                        throw new Exception("Registry Value could not be set.");
                                    }
                                    JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(mainFrame), LOCALIZER.msg("registryChanged", "The timeout was changed successfully.\nPlease reboot Windows!"));
                                }
                                catch (Exception registySetting) {
                                    JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(mainFrame), LOCALIZER.msg("registryNotChanged", "<html>The Registry value couldn't be changed. Maybe you haven't the right to do it.<br>If it is so contact you Administrator and let him do it for you.<br><br><b><Attention:/b> The following description is for experts. If you change or delete the wrong value in the Registry you could destroy your Windows installation.<br><br>To get no warning on TV-Browser start the Registry value <b>WaitToKillAppTimeout</b> in the Registry path<br><b>HKEY_CURRENT_USER\\Control Panel\\Desktop</b> have to be at least <b>5000</b> or the value for <b>AutoEndTasks</b> in the same path have to be <b>0</b>.</html>"), Localizer.getLocalization("i18n_error"), 0);
                                }
                            }
                        }
                    }
                    catch (Throwable desktopSettings) {
                        // empty catch block
                    }
                }
                if (currentVersion != null && currentVersion.isOlderThan(new Version(2, 22))) {
                    TvBrowserPictureSettingsUpdateDialog.createAndShow(mainFrame);
                }
                if (currentVersion != null && currentVersion.isOlderThan(new Version(2, 51, true))) {
                    Settings.Data.ACCEPTED_LICENSES.setStringArray(new String[0]);
                }
                if (currentVersion != null && currentVersion.isOlderThan(new Version(4, 21, 96, false))) {
                    String refresh = GeneralSettingsTab.LOCALIZER.msg("titleRefresh", "Refresh");
                    JCheckBox gradient = new JCheckBox(ProgramPanelSettingsTab.LOCALIZER.msg("color.programGradientHighlighting", "Highlight programs with gradient colors"), Settings.ProgramPanel.HIGHLIGHTING_COLOR_GRADIENT.getBoolean());
                    JCheckBox update = new JCheckBox(LOCALIZER.msg("update.primeTimeActivate", "Activate prime time update"), Settings.General.AUTO_UPDATE_PRIME_TIME.getBoolean());
                    EnhancedPanelBuilder pb = new EnhancedPanelBuilder("5dlu,10dlu,default,default:grow");
                    pb.addParagraph(refresh);
                    pb.addRowFull(UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("update.primeTimeUpdate", "Independent of the configuration of the automatically data update, TV-Browser since 4.2.2 provides the option to activate an automatically data update of the prime time (after 6 pm). If activated TV-Browser will download the data for today and tomorrow each day right before the prime time. You can configure this options under <b><i>{0}, {1}</i></b>&nbsp;&nbsp;or directly here.", GeneralSettingsTab.LOCALIZER.msg("general", "General settings"), refresh)), 2);
                    pb.addRowFull(update, 2);
                    pb.addParagraph(MarkingsSettingsTab.LOCALIZER.msg("title", "Highlighting"));
                    pb.addRowFull(UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("update.gradientColors", "Since TV-Browser 4.2.2 programs can be highlighted by more than one color at the same time. This is done by showing a color. The previous highlighting with only the color of the highest priority is still available and can be configured right here or anytime under <b><i>{0}->{1}, {2}</i></b>.", LookAndFeelSettingsTab.LOCALIZER.msg("graphical", "Graphical settings"), ProgramPanelSettingsTab.LOCALIZER.msg("title", "Program display"), ProgramPanelSettingsTab.LOCALIZER.msg("Colors", "Colors"))), 2);
                    pb.addRowFull(gradient, 2);
                    int fMarkPriorityOld = FavoritesPluginProxy.getInstance().getMarkPriorityMaxForProgram(null);
                    int rMarkPriorityOld = ReminderPluginProxy.getInstance().getMarkPriorityMaxForProgram(null);
                    Method fSetMarkPriority = null;
                    Method rSetMarkPriority = null;
                    try {
                        fSetMarkPriority = FavoritesPlugin.class.getDeclaredMethod("setMarkPriority", Integer.TYPE);
                        rSetMarkPriority = ReminderPlugin.class.getDeclaredMethod("setMarkPriority", Integer.TYPE);
                        fSetMarkPriority.setAccessible(true);
                        rSetMarkPriority.setAccessible(true);
                        fSetMarkPriority.invoke((Object)FavoritesPlugin.getInstance(), 4);
                        rSetMarkPriority.invoke((Object)ReminderPlugin.getInstance(), 0);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException registySetting) {
                        // empty catch block
                    }
                    ProgramPanel p = new ProgramPanel(PluginManagerImpl.getInstance().getExampleProgram());
                    pb.addRow(p, 3);
                    p.getProgram().mark(FavoritesPluginProxy.getInstance());
                    p.getProgram().mark(ReminderPluginProxy.getInstance());
                    gradient.addItemListener(e -> {
                        Settings.ProgramPanel.HIGHLIGHTING_COLOR_GRADIENT.setBoolean(1 == e.getStateChange());
                        p.repaint();
                    });
                    pb.getPanel().setBorder(Borders.DIALOG);
                    pb.getPanel().setPreferredSize(new Dimension(Sizes.dialogUnitXAsPixel((int)450, (Component)pb.getPanel()), Sizes.dialogUnitYAsPixel((int)210, (Component)pb.getPanel())));
                    UiUtilities.showMessageDialogOnMouseScreen(pb.getPanel(), LOCALIZER.msg("update.title", "Changed functionality since TV-Browser {0}", "4.2.2"), -1);
                    if (fSetMarkPriority != null && rSetMarkPriority != null) {
                        try {
                            fSetMarkPriority.invoke((Object)FavoritesPlugin.getInstance(), fMarkPriorityOld);
                            rSetMarkPriority.invoke((Object)ReminderPlugin.getInstance(), rMarkPriorityOld);
                            fSetMarkPriority.setAccessible(false);
                            rSetMarkPriority.setAccessible(false);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                    p.getProgram().unmark(FavoritesPluginProxy.getInstance());
                    p.getProgram().unmark(ReminderPluginProxy.getInstance());
                    Settings.ProgramPanel.HIGHLIGHTING_COLOR_GRADIENT.setBoolean(gradient.isSelected());
                    Settings.General.AUTO_UPDATE_PRIME_TIME.setBoolean(update.isSelected());
                }
                if (currentVersion != null && currentVersion.isOlderThan(new Version(2, 60, true))) {
                    int startOfDay = Settings.ProgramTable.START_OF_DAY.getInt();
                    int endOfDay = Settings.ProgramTable.END_OF_DAY.getInt();
                    if (endOfDay - startOfDay < -1) {
                        Settings.ProgramTable.END_OF_DAY.setInt(startOfDay);
                        JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(mainFrame), LOCALIZER.msg("timeInfoText", "The time range of the program table was corrected because the defined day was shorter than 24 hours.\n\nIf the program table should show less than 24h use a time filter for that. That time filter can be selected\nto be the default filter by selecting it in the filter settings and pressing on the button 'Default'."), LOCALIZER.msg("timeInfoTitle", "Times corrected"), 1);
                        Settings.handleChangedSettings();
                    }
                }
                if (currentVersion != null && currentVersion.isOlderThan(new Version(3, 43, 52, false))) {
                    FilterComponentList.getInstance().store();
                }
                if (currentVersion != null && currentVersion.isOlderThan(new Version(3, 30, 51, false))) {
                    Settings.updateContextMenuSettings();
                }
                if (currentVersion != null && currentVersion.isOlderThan(new Version(3, 33, 51, false))) {
                    Settings.Channels.SUBSCRIBED.setChannelArray(ChannelList.getSubscribedChannels());
                }
                if (currentVersion != null && currentVersion.isOlderThan(new Version(3, 39, 7, false))) {
                    ProgramFieldType[] typeArr = Settings.ProgramPanel.INFO_FIELDS.getProgramFieldTypeArray();
                    String[] separators = Settings.ProgramPanel.INFO_FIELDS_SEPARATORS.getStringArray();
                    ArrayList<String> separatorList = new ArrayList<String>();
                    for (int i2 = 0; i2 < typeArr.length - 1; ++i2) {
                        if (i2 < separators.length - 1 && separators[i2].equals("\n")) {
                            separatorList.add(separators[i2]);
                            continue;
                        }
                        separatorList.add(" - ");
                    }
                    Settings.ProgramPanel.INFO_FIELDS_SEPARATORS.setStringArray(separatorList.toArray(new String[separatorList.size()]));
                }
                if (currentVersion != null && currentVersion.isOlderThan(new Version(4, 21, 51, false))) {
                    int[] colors = new int[]{Settings.propProgramPanelMarkedMinPriorityColor.getColor().getRGB(), Settings.propProgramPanelMarkedLowerMediumPriorityColor.getColor().getRGB(), Settings.propProgramPanelMarkedMediumPriorityColor.getColor().getRGB(), Settings.propProgramPanelMarkedHigherMediumPriorityColor.getColor().getRGB(), Settings.propProgramPanelMarkedMaxPriorityColor.getColor().getRGB()};
                    Settings.Markings.HIGHLIGHTING_COLORS.setIntArray(colors);
                    Settings.updateColors();
                }
                MainFrame.getInstance().getProgramTableScrollPane().requestFocusInWindow();
            });
        });
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook"){

            @Override
            public void run() {
                TVBrowser.deleteLockFile(mLockFile.get(), mLock.get(), ".lock");
                TVBrowser.deleteLockGlobalToggle();
                MainFrame.getInstance().quit(false);
            }
        });
    }

    private static String[] generateRestartCMD() {
        try {
            String SUN_JAVA_COMMAND = "sun.java.command";
            ArrayList<String> cmd = new ArrayList<String>();
            String java = System.getProperty("java.home");
            if (java == null) {
                return null;
            }
            java = Launch.getOs() == 1 ? java.concat("\\bin\\javaw") : java.concat("/bin/java");
            cmd.add(java);
            boolean splash = false;
            List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : vmArguments) {
                if (arg.startsWith("-splash:")) {
                    splash = true;
                }
                if (arg.contains("-agentlib")) continue;
                cmd.add(arg);
            }
            if (System.getProperty("sun.java.command") == null) {
                return null;
            }
            String[] mainCommand = System.getProperty("sun.java.command").split(" ");
            if (System.getProperty("java.class.path") != null && !System.getProperty("java.class.path").isBlank()) {
                cmd.add("-cp");
                cmd.add(System.getProperty("java.class.path"));
            }
            if (!splash) {
                cmd.add("-splash:imgs/splash.png");
            }
            cmd.add("-m");
            cmd.add(mainCommand[0]);
            String[] cmdarr = new String[cmd.size()];
            for (int i = 0; i < cmd.size(); ++i) {
                cmdarr[i] = (String)cmd.get(i);
            }
            return cmdarr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean restartEnabled() {
        return RESTART_CMD != null;
    }

    public static void addRestart() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(250L);
                        Runtime.getRuntime().exec(RESTART_CMD);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void seachForOldVersionFiles() {
        String messageId = "TVBrowser#DeleteOldVersionFiles";
        if (!DontShowAgainOptionBox.isHiddenMessageBox("TVBrowser#DeleteOldVersionFiles")) {
            File settingsDir = new File(Settings.getUserSettingsDirName()).getParentFile();
            long cutoff = System.currentTimeMillis() - 15552000000L;
            ArrayList<File> oldDirs = new ArrayList<File>();
            for (int i = ALL_VERSIONS.length - 1; i > 0; --i) {
                File test = new File(settingsDir + File.separator + ALL_VERSIONS[i] + File.separator + "settings.prop");
                if (!test.isFile() || test.lastModified() >= cutoff) continue;
                oldDirs.add(test);
            }
            if (!oldDirs.isEmpty()) {
                Collections.sort(oldDirs, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        int result = 0;
                        if (o1.lastModified() > o2.lastModified()) {
                            result = -1;
                        } else if (o1.lastModified() < o2.lastModified()) {
                            result = 1;
                        }
                        return result;
                    }
                });
                try {
                    UIThreadRunner.invokeAndWait(() -> {
                        JButton selectAll = new JButton(Localizer.getLocalization("i18n_select_all"));
                        selectAll.setEnabled(true);
                        JButton clearSelection = new JButton(Localizer.getLocalization("i18n_clear_selection"));
                        clearSelection.setEnabled(false);
                        JButton delete = new JButton(LOCALIZER.msg("deleteOldSettingsDelete", "Delete selected settings"));
                        delete.setEnabled(false);
                        delete.addActionListener(e -> {
                            Container container = delete.getParent();
                            while ((container = container.getParent()) != null && !(container instanceof JOptionPane)) {
                            }
                            if (container != null && container instanceof JOptionPane) {
                                JOptionPane p = (JOptionPane)container;
                                p.setValue(delete);
                            }
                        });
                        DateFormat dateFormat = DateFormat.getDateInstance(2);
                        Localizer settingsLocalizer = Localizer.getLocalizerFor(Settings.class);
                        ScrollableJPanel boxPanel = new ScrollableJPanel();
                        boxPanel.setLayout(new BoxLayout(boxPanel, 1));
                        AtomicInteger count = new AtomicInteger(0);
                        ItemListener listener = e -> {
                            if (e.getStateChange() == 1) {
                                count.incrementAndGet();
                            } else if (e.getStateChange() == 2) {
                                count.decrementAndGet();
                            }
                            delete.setEnabled(count.get() > 0);
                            selectAll.setEnabled(count.get() != oldDirs.size());
                            clearSelection.setEnabled(delete.isEnabled());
                        };
                        JCheckBox[] selection = new JCheckBox[oldDirs.size()];
                        for (int i = 0; i < selection.length; ++i) {
                            File dir = (File)oldDirs.get(i);
                            selection[i] = new JCheckBox(settingsLocalizer.msg("selectImportDirectoryInfo", "{0} (last used: {1})", dir.getParentFile().getName(), dateFormat.format(new Date(dir.lastModified()))));
                            selection[i].addItemListener(listener);
                            boxPanel.add(selection[i]);
                        }
                        JScrollPane scroll = new JScrollPane(boxPanel);
                        scroll.setBorder(null);
                        scroll.setViewportBorder(null);
                        scroll.getViewport().setOpaque(false);
                        selectAll.addActionListener(e -> {
                            for (JCheckBox box : selection) {
                                box.setSelected(true);
                            }
                        });
                        clearSelection.addActionListener(e -> {
                            for (JCheckBox box : selection) {
                                box.setSelected(false);
                            }
                        });
                        JPanel buttons = new JPanel((LayoutManager)new FormLayout("default,60dlu,default", "default"));
                        buttons.add((Component)clearSelection, CC.xy((int)1, (int)1));
                        buttons.add((Component)selectAll, CC.xy((int)3, (int)1));
                        ArrayList<Object> message = new ArrayList<Object>();
                        message.add(LOCALIZER.msg("deleteOldSettingsMessage", "TV-Browser has found settings of old versions of TV-Browser\nthat were not used for at least half a year.\n\nYou can select the versions of TV-Browser you no longer use,\nfor which the old setttings should be deleted now.\n\n"));
                        message.add(scroll);
                        message.add(buttons);
                        Object[] options = new Object[]{delete, Localizer.getLocalization("i18n_cancel")};
                        int option = DontShowAgainOptionBox.showOptionDialog("TVBrowser#DeleteOldVersionFiles", null, message.toArray(), LOCALIZER.msg("deleteOldSettingsTitle", "TV-Browser: Delete old versions settings files"), 3, 0, options, options[1], null);
                        if (0 == option) {
                            for (int i = 0; i < selection.length; ++i) {
                                if (!selection[i].isSelected()) continue;
                                TVBrowser.eraseDirectory(((File)oldDirs.get(i)).getParentFile());
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Settings.General.DATE_OLD_SETTINGS_CHECKED_LAST.setDate(devplugin.Date.getCurrentDate());
        }
    }

    private static void eraseDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile() && !file.delete()) {
                        file.deleteOnExit();
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    TVBrowser.eraseDirectory(file);
                }
            }
            if (!directory.delete()) {
                directory.deleteOnExit();
            }
        }
    }

    private static void startPeriodicSaveSettings() {
        Thread saveThread = new Thread("Store settings periodically"){

            @Override
            public void run() {
                mSaveThreadIsRunning = true;
                mSaveThreadShouldStop = false;
                while (!mSaveThreadShouldStop) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (mSaveThreadShouldStop || TvDataUpdater.getInstance().isDownloading()) continue;
                    TVBrowser.flushSettings(true);
                }
                mSaveThreadIsRunning = false;
            }
        };
        saveThread.setPriority(1);
        saveThread.start();
    }

    private static void showUsage(String[] args) {
        System.out.println("command line options:");
        System.out.println("    -minimized      The main window will be minimized after start up");
        System.out.println("    -nostartscreen  No start screen during start up");
        System.out.println("    -fullscreen     Start in fullscreen-mode");
        System.out.println("    -ignorejvm      Don't check for Sun Java");
        System.out.println("    -safemode       Don't load Plugins");
        System.out.println();
    }

    private static void parseCommandline(String[] args) {
        TVBrowser.showUsage(args);
        for (String argument : args) {
            if (argument.equalsIgnoreCase("-help") || argument.equalsIgnoreCase("-h")) {
                System.exit(0);
                continue;
            }
            if (argument.equalsIgnoreCase("-minimized") || argument.equalsIgnoreCase("-m")) {
                mMinimized = true;
                continue;
            }
            if (argument.equalsIgnoreCase("-nostartscreen") || argument.equalsIgnoreCase("-n")) {
                mShowStartScreen = false;
                continue;
            }
            if (argument.equalsIgnoreCase("-fullscreen") || argument.equalsIgnoreCase("-f")) {
                mFullscreen = true;
                continue;
            }
            if (argument.equalsIgnoreCase("-safemode") || argument.equalsIgnoreCase("-s")) {
                mSafeMode = true;
                continue;
            }
            if (argument.startsWith("tvb://")) {
                mProtocolMessage = argument;
                continue;
            }
            if (argument.startsWith("-D")) {
                if (argument.indexOf("=") >= 2) {
                    String key = argument.substring(2, argument.indexOf("="));
                    String value = StringUtils.substringAfter((String)argument, (String)"=");
                    if (key.equals("user.language")) {
                        System.getProperties().setProperty("user.language", value);
                        Locale.setDefault(new Locale(value));
                        continue;
                    }
                    System.setProperty(key, value);
                    continue;
                }
                LOG.warning("Wrong Syntax in parameter: '" + argument + "'");
                continue;
            }
            if (argument.trim().isEmpty()) continue;
            LOG.warning("Unknown command line parameter: '" + argument + "'");
        }
    }

    private static LockFileResult createLockGlobalToggle() {
        LockFileResult result = new LockFileResult(true, null);
        if (Settings.General.SERVER_RESTORE_ENABLED.getBoolean()) {
            String[] lines = null;
            try {
                mToggleSocket.set(new UdpThread());
                lines = new String[]{String.valueOf(mToggleSocket.get().getSocket().getLocalPort())};
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            result = TVBrowser.createLockFile(mToggleLockFile, mToggleLock, ".toggle", lines);
        }
        return result;
    }

    private static void deleteLockGlobalToggle() {
        if (mToggleSocket.get() != null) {
            mToggleSocket.get().halt();
            mToggleSocket.set(null);
        }
        TVBrowser.deleteLockFile(mToggleLockFile.get(), mToggleLock.get(), ".toggle");
    }

    public static void updateLockGlobalToggle() {
        if (Settings.General.SERVER_RESTORE_ENABLED.getBoolean() && mToggleSocket.get() == null) {
            if (TVBrowser.createLockGlobalToggle().mResult) {
                mToggleSocket.get().start();
            }
        } else if (!Settings.General.SERVER_RESTORE_ENABLED.getBoolean() && mToggleSocket.get() != null) {
            TVBrowser.deleteLockGlobalToggle();
        }
    }

    private static String[] readLockFileContent(File lockInfo) {
        String[] readLines = null;
        if (lockInfo.isFile()) {
            ArrayList<String> readList = new ArrayList<String>();
            try (RandomAccessFile in = new RandomAccessFile(lockInfo, "r");){
                String line = null;
                while ((line = in.readLine()) != null) {
                    readList.add(line);
                }
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
            if (!readList.isEmpty()) {
                readLines = readList.toArray(new String[0]);
            }
        }
        return readLines;
    }

    private static LockFileResult createLockFile(AtomicReference<RandomAccessFile> lockFileAccess, AtomicReference<FileLock> lockTarget, String file, String ... lines) {
        block7: {
            String dir = Settings.getUserDirectoryName();
            if (!new File(dir).isDirectory()) {
                new File(dir).mkdirs();
            }
            File lockFile = new File(dir, file);
            File lockInfo = new File(dir, file + "_info");
            if (lockFile.exists()) {
                try {
                    lockFileAccess.set(new RandomAccessFile(lockFile.toString(), "rw"));
                    lockTarget.set(lockFileAccess.get().getChannel().tryLock());
                    if (lockTarget.get() == null) {
                        return new LockFileResult(false, TVBrowser.readLockFileContent(lockInfo));
                    }
                    TVBrowser.writeLinesToLogFile(lockInfo, lines);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new LockFileResult(false, TVBrowser.readLockFileContent(lockInfo));
                }
            }
            try {
                lockFile.createNewFile();
                lockFileAccess.set(new RandomAccessFile(lockFile.toString(), "rw"));
                lockTarget.set(lockFileAccess.get().getChannel().tryLock());
                TVBrowser.writeLinesToLogFile(lockInfo, lines);
            }
            catch (Exception e) {
                if (!(e instanceof IOException)) break block7;
                LOG.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return new LockFileResult(true, null);
    }

    private static void writeLinesToLogFile(File lockInfo, String[] lines) {
        if (lines != null && lines.length > 0) {
            try (RandomAccessFile fileLockAccess = new RandomAccessFile(lockInfo, "rw");){
                for (String line : lines) {
                    fileLockAccess.writeBytes(line + "\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void deleteLockFile(RandomAccessFile fileLockAccess, FileLock fileLock, String file) {
        String dir = Settings.getUserDirectoryName();
        File lockFile = new File(dir, file);
        File lockInfo = new File(dir, file + "_info");
        if (lockFile.isFile()) {
            try {
                fileLock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileLockAccess.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!lockFile.delete()) {
                lockFile.deleteOnExit();
            }
        }
        if (lockInfo.isFile() && !lockInfo.delete()) {
            lockInfo.deleteOnExit();
        }
    }

    private static void showTVBrowserIsAlreadyRunningMessageBox(LockFileResult resultLockFile) {
        try {
            UIThreadRunner.invokeAndWait(() -> {
                int port = Integer.MIN_VALUE;
                if (resultLockFile.mLines != null && resultLockFile.mLines.length == 1) {
                    try {
                        port = Integer.parseInt(resultLockFile.mLines[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                Object[] options = new Object[!resultLockFile.mResult && port != Integer.MIN_VALUE ? 3 : 2];
                int index = 0;
                if (!resultLockFile.mResult && port != Integer.MIN_VALUE) {
                    options[index++] = LOCALIZER.msg("showTvBrowser", "Open running TV-Browser");
                }
                options[index++] = Localizer.getLocalization("i18n_close");
                options[index] = LOCALIZER.msg("startAnyway", "start anyway");
                int result = UiUtilities.showOptionDialogOnMouseScreen(LOCALIZER.msg("alreadyRunning", "TV-Browser is already running"), LOCALIZER.msg("alreadyRunning", "TV-Browser is already running"), -1, 2, null, options, options[0]);
                if (result == 0 && !resultLockFile.mResult && port != Integer.MIN_VALUE) {
                    try (DatagramSocket socket = new DatagramSocket();){
                        byte[] buf = "open_tvb".getBytes();
                        DatagramPacket packet = new DatagramPacket(buf, buf.length, InetAddress.getByName("localhost"), port);
                        socket.send(packet);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(-1);
                    }
                } else if (result == 0 || !resultLockFile.mResult && result == 1) {
                    System.exit(-1);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void initUi(Splash splash, boolean startMinimized) {
        mainFrame = MainFrame.getInstance();
        PluginProxyManager.getInstance().setParentFrame(mainFrame);
        TvDataServiceProxyManager.getInstance().setParamFrame(mainFrame);
        mainFrame.setIconImages(ICONS_WINDOW);
        mTray = new SystemTray();
        if (mTray.initSystemTray()) {
            mTray.createMenus();
            if (mToggleSocket.get() != null) {
                mToggleSocket.get().setTray(mTray);
                mToggleSocket.get().start();
            }
        } else {
            if (mToggleSocket.get() != null) {
                mToggleSocket.get().initMainFrame();
            }
            LOG.info("platform independent mode is ON");
            TVBrowser.addTrayWindowListener();
        }
        LOG.info("Setting frame size and location");
        int windowWidth = Settings.Window.WIDTH.getInt();
        int windowHeight = Settings.Window.HEIGHT.getInt();
        mainFrame.setSize(windowWidth, windowHeight);
        int windowX = Settings.Window.X.getInt();
        int windowY = Settings.Window.Y.getInt();
        boolean maximized = Settings.Window.MAXIMIZED.getBoolean();
        Rectangle screen = mainFrame.getGraphicsConfiguration().getBounds();
        GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(mainFrame.getGraphicsConfiguration());
        screen.x += insets.left;
        screen.y += insets.top;
        screen.width = screen.width - insets.left - insets.right;
        screen.height = screen.height - insets.top - insets.bottom;
        if (maximized || windowX == -1 && windowY == -1 || (double)(windowX + windowWidth) < screen.getX() || (double)windowX > screen.getX() + screen.getWidth() - 30.0 || (double)(windowY + windowHeight) < screen.getY() || (double)windowY > screen.getY() + screen.getHeight() - 30.0 || windowWidth < 200 || windowHeight < 200) {
            UiUtilities.centerAndShow(mainFrame, false);
        } else {
            mainFrame.setLocation(windowX, windowY);
        }
        SwingUtilities.invokeLater(() -> {
            Point p = mainFrame.getLocation();
            if ((double)windowX < screen.getX() || (double)windowY < screen.getY() || (double)windowX > screen.getX() + screen.getWidth() - 30.0 || (double)windowY > screen.getY() + screen.getHeight() - 30.0) {
                UiUtilities.centerAndShow(mainFrame, false);
            } else if (!(maximized || p.x == windowX && windowY == p.y)) {
                mainFrame.setLocation(windowX - Math.abs(p.x - windowX), windowY - Math.abs(p.y - windowY));
            }
        });
        mainFrame.setVisible(true);
        ErrorHandler.setFrame(mainFrame);
        splash.hideSplash();
        mainFrame.repaint();
        if (maximized) {
            SwingUtilities.invokeLater(() -> {
                mainFrame.setExtendedState(6);
                SwingUtilities.invokeLater(() -> mainFrame.repaint());
            });
        }
        if (startMinimized) {
            mainFrame.setExtendedState(1);
        }
        if (mFullscreen || Settings.General.IS_USING_FULLSCREEN.getBoolean()) {
            SwingUtilities.invokeLater(() -> mainFrame.switchFullscreenMode());
        }
        if (Settings.Window.ASSISTANT_SHOW.getBoolean()) {
            LOG.info("Running setup assistant");
            mainFrame.runSetupAssistant();
        }
        if (Launch.isMacOs()) {
            try {
                Class<?> fullScreenUtilities = Class.forName("com.apple.eawt.FullScreenUtilities");
                fullScreenUtilities.getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE).invoke(null, mainFrame, true);
                if (Settings.Window.MAC_OS_FULL_SCREEN.getBoolean()) {
                    Class<?> app = Class.forName("com.apple.eawt.Application");
                    Object o = app.getMethod("getApplication", new Class[0]).invoke(app, new Object[0]);
                    app.getMethod("requestToggleFullScreen", Window.class).invoke(o, mainFrame);
                }
                Class<?> fullScreenListenerClass = Class.forName("com.apple.eawt.FullScreenListener");
                Object fullScreenListener = Proxy.newProxyInstance(fullScreenListenerClass.getClassLoader(), new Class[]{fullScreenListenerClass}, (proxy, method, methodArgs) -> {
                    if (method.getName().equals("windowEnteredFullScreen")) {
                        Settings.Window.MAC_OS_FULL_SCREEN.setBoolean(true);
                    } else if (method.getName().equals("windowExitedFullScreen")) {
                        Settings.Window.MAC_OS_FULL_SCREEN.setBoolean(false);
                    }
                    return null;
                });
                fullScreenUtilities.getMethod("addFullScreenListenerTo", Window.class, fullScreenListenerClass).invoke(null, mainFrame, fullScreenListener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void initializeAutomaticDownload() {
        if (!Settings.Window.ASSISTANT_SHOW.getBoolean()) {
            SwingUtilities.invokeLater(() -> {
                boolean automaticDownloadStarted = TVBrowser.handleAutomaticDownload(0);
                boolean dataAvailable = TvDataBase.getInstance().dataAvailable(new devplugin.Date());
                if (!automaticDownloadStarted && !dataAvailable && ChannelList.getNumberOfSubscribedChannels() > 0) {
                    mainFrame.askForDataUpdateNoDataAvailable();
                }
                mainFrame.scrollToNowFirst();
            });
        }
    }

    public static synchronized void flushSettings(boolean log) {
        if (mainFrame == null || mainFrame.getWidth() == 0) {
            return;
        }
        if (log) {
            LOG.info("Channel Settings (day light saving time corrections/icons)");
        }
        InternalPluginProxyList.getInstance().storeData(log);
        mainFrame.storeSettings();
        if (log) {
            LOG.info("Storing window size and location");
            int state = mainFrame.getExtendedState();
            if (!mainFrame.isFullScreenMode() && MainFrame.getInstance().isVisible()) {
                boolean maximized = (state & 6) == 6;
                Settings.Window.MAXIMIZED.setBoolean(maximized);
                if (!(maximized || Launch.isMacOs() && Settings.Window.MAC_OS_FULL_SCREEN.getBoolean())) {
                    Settings.Window.WIDTH.setInt(mainFrame.getWidth());
                    Settings.Window.HEIGHT.setInt(mainFrame.getHeight());
                    Settings.Window.X.setInt(mainFrame.getX());
                    Settings.Window.Y.setInt(mainFrame.getY());
                }
            }
        }
        if (log) {
            LOG.info("Storing settings");
        }
        try {
            Settings.storeSettings(log);
        }
        catch (TvBrowserException e) {
            ErrorHandler.handle(e);
        }
    }

    private static void addTrayWindowListener() {
        if (mMainWindowAdapter == null) {
            mMainWindowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (Settings.General.ONLY_MINIMIZE_WHEN_WINDOW_CLOSING.getBoolean()) {
                        MainFrame.getInstance().setExtendedState(1);
                    } else {
                        mainFrame.quit();
                    }
                }
            };
        }
        mainFrame.addWindowListener(mMainWindowAdapter);
    }

    public static boolean isUsingSystemTray() {
        return mTray.isTrayUsed();
    }

    public static void loadTray() {
        if (!mTray.isTrayUsed()) {
            mTray.initSystemTray();
        }
        if (mTray.isTrayUsed()) {
            mTray.createMenus();
            if (mMainWindowAdapter != null) {
                mainFrame.removeWindowListener(mMainWindowAdapter);
            }
        }
    }

    public static void removeTray() {
        if (mTray.isTrayUsed()) {
            mTray.setVisible(false);
            TVBrowser.addTrayWindowListener();
            if (!MainFrame.getInstance().isVisible()) {
                SwingUtilities.invokeLater(() -> MainFrame.getInstance().showFromTray(1));
            }
        }
    }

    public static boolean showBalloonTip(String caption, String message, TrayIcon.MessageType messageType) {
        if (mTray.isTrayUsed()) {
            return mTray.showBalloonTip(caption, message, messageType);
        }
        return false;
    }

    public static boolean handleAutomaticDownload(int autoDownloadTime) {
        final BooleanResult result = TVBrowser.isAutomaticDownloadDateReached(autoDownloadTime);
        if (ChannelList.getNumberOfSubscribedChannels() == 0 || result.isAllFalse()) {
            return false;
        }
        if (mAutoDownloadWaitingTimer != null && mAutoDownloadWaitingTimer.isRunning()) {
            return true;
        }
        if (autoDownloadTime != -1 && Settings.General.AUTO_DOWNLOAD_WAITING_ENABLED.getBoolean() && Settings.General.AUTO_DOWNLOAD_WAITING_TIME.getShort() > 0 || result.getResultForIndex(1)) {
            final long timerStart = Calendar.getInstance().getTimeInMillis();
            if (mAutoDownloadWaitingTimer == null) {
                mAutoDownloadWaitingTimer = new Timer(1000, new ActionListener(){
                    private boolean mIsProcessing = false;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!this.mIsProcessing) {
                            this.mIsProcessing = true;
                            try {
                                int seconds = (int)((double)(Calendar.getInstance().getTimeInMillis() - timerStart) / 1000.0);
                                seconds = (!result.getResultForIndex(0) && result.getResultForIndex(1) ? 40 : Settings.General.AUTO_DOWNLOAD_WAITING_TIME.getShort()) - seconds;
                                if (seconds <= 0) {
                                    mAutoDownloadWaitingTimer.stop();
                                    mainFrame.getStatusBarLabel().setText("");
                                    TVBrowser.performAutomaticDownload(result);
                                } else if (mainFrame.isUpdatingData()) {
                                    mAutoDownloadWaitingTimer.stop();
                                    mainFrame.getStatusBarLabel().setText("");
                                } else {
                                    mainFrame.getStatusBarLabel().setText(LOCALIZER.msg("downloadwait", "Automatic download starts in {0} seconds.", seconds));
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            this.mIsProcessing = false;
                        }
                    }
                });
                mAutoDownloadWaitingTimer.setRepeats(true);
                mAutoDownloadWaitingTimer.start();
            } else {
                mAutoDownloadWaitingTimer.restart();
            }
        } else if (autoDownloadTime != -1) {
            return TVBrowser.performAutomaticDownload(result);
        }
        return result.getResultForIndex(0) && !result.getResultForIndex(1);
    }

    public static boolean isWaitingForUpdateStart() {
        return mAutoDownloadWaitingTimer != null && mAutoDownloadWaitingTimer.isRunning();
    }

    private static BooleanResult isAutomaticDownloadDateReached(int autoDownloadTime) {
        String autoDLType = Settings.General.AUTO_DOWNLOAD_TYPE.getString();
        devplugin.Date lastDownloadDate = Settings.Data.DOWNLOAD_DATE_LAST.getDate();
        devplugin.Date today = devplugin.Date.getCurrentDate();
        devplugin.Date nextDownloadDate = autoDLType.equals("daily") ? lastDownloadDate.addDays(1) : (autoDLType.equals("every3days") ? lastDownloadDate.addDays(3) : (autoDLType.equals("weekly") ? lastDownloadDate.addDays(7) : lastDownloadDate));
        boolean download = autoDownloadTime != -1 && autoDownloadTime <= IOUtilities.getMinutesAfterMidnight() && !autoDLType.equals("never") && nextDownloadDate.getNumberOfDaysSince(today) <= 0;
        boolean primeTime = Settings.General.AUTO_UPDATE_PRIME_TIME.getBoolean();
        if (primeTime) {
            int compare = devplugin.Date.getCurrentDate().compareTo(Settings.Data.DOWNLOAD_DATE_LAST.getDate());
            primeTime = (Math.random() > 0.8 || IOUtilities.getMinutesAfterMidnight() >= 1070 && IOUtilities.getMinutesAfterMidnight() <= 1215) && IOUtilities.getMinutesAfterMidnight() >= 1050 && IOUtilities.getMinutesAfterMidnight() <= 1215 && (compare > 0 || compare == 0 && Settings.Data.DOWNLOAD_TIME_LAST.getInt() < 1050);
        }
        BooleanResult result = new BooleanResult(download, primeTime);
        result.setResultNames("AutoDownload", "PrimeTime");
        return result;
    }

    private static boolean performAutomaticDownload(BooleanResult resultInfo) {
        boolean result = false;
        if (!mainFrame.isUpdatingData()) {
            if (resultInfo.getResultForIndex(0)) {
                if (Settings.General.ASK_FOR_AUTO_DOWNLOAD.getBoolean()) {
                    mainFrame.updateTvData();
                } else {
                    String[] dataServiceIDs = Settings.Data.DATA_SERVICES_FOR_UPDATE.getStringArray();
                    TvDataServiceProxy[] proxies = dataServiceIDs == null ? UpdateDlg.getActiveDataServices() : TvDataServiceProxyManager.getInstance().getTvDataServices(dataServiceIDs);
                    if (mainFrame.licenseForTvDataServicesWasAccepted(proxies)) {
                        mainFrame.runUpdateThread(Settings.General.AUTO_DOWNLOAD_PERIOD.getInt(), proxies, true);
                    }
                }
                result = true;
            } else if (resultInfo.getResultForIndex(1)) {
                TvDataServiceProxy[] proxies;
                Channel[] channels;
                HashSet<TvDataServiceProxy> dataServices = new HashSet<TvDataServiceProxy>();
                for (Channel channel : channels = Settings.Channels.SUBSCRIBED.getChannelArray()) {
                    if (channel instanceof DummyChannel || channel.getDataServiceProxy() == null || dataServices.contains(channel.getDataServiceProxy())) continue;
                    dataServices.add(channel.getDataServiceProxy());
                }
                if (!dataServices.isEmpty() && mainFrame.licenseForTvDataServicesWasAccepted(proxies = dataServices.toArray(new TvDataServiceProxy[0]))) {
                    mainFrame.runUpdateThread(Settings.General.AUTO_DOWNLOAD_PERIOD.getInt(), proxies, true);
                }
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookAndFeel() {
        File test;
        String[] parts;
        try {
            if (OperatingSystem.isWindows()) {
                UIManager.installLookAndFeel("Extended Windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            }
            UIManager.installLookAndFeel("Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            UIManager.installLookAndFeel("Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            UIManager.installLookAndFeel("Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (OperatingSystem.isLinux() && System.getProperty("java.runtime.name", "").startsWith("OpenJDK") && (parts = System.getProperty("java.version", "").split("\\.")).length > 1 && (test = new File("/etc/java-" + parts[1] + "-openjdk/accessibility.properties")).isFile()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(test), "UTF-8"));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (line.trim().startsWith("#") || !line.contains("assistive_technologies") || !line.contains("org.GNOME.Accessibility.AtkWrapper")) continue;
                    Settings.LookAndFeel.SELECTED.setDefault(UiUtilities.getDefaultLookAndFeelClassName(true));
                    UIManager.LookAndFeelInfo[] lnfs = UIManager.getInstalledLookAndFeels();
                    ArrayList<UIManager.LookAndFeelInfo> cleanedLooksList = new ArrayList<UIManager.LookAndFeelInfo>(lnfs.length - 1);
                    if (lnfs != null) {
                        for (UIManager.LookAndFeelInfo lookAndFeel : lnfs) {
                            if (lookAndFeel.getClassName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel")) continue;
                            cleanedLooksList.add(lookAndFeel);
                        }
                    }
                    UIManager.setInstalledLookAndFeels(cleanedLooksList.toArray(new UIManager.LookAndFeelInfo[cleanedLooksList.size()]));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (Settings.LookAndFeel.SELECTED.getString().equals("com.l2fprod.gui.plaf.skin.SkinLookAndFeel")) {
            Settings.LookAndFeel.SELECTED.setString(Settings.LookAndFeel.SELECTED.getDefault());
        } else if (Settings.LookAndFeel.SELECTED.getString().startsWith("com.jgoodies") && !Settings.LookAndFeel.SELECTED.getString().startsWith("com.jgoodies.looks.windows.WindowsLookAndFeel")) {
            Options.setPopupDropShadowEnabled((boolean)Settings.LookAndFeel.JGOODIES_SHADOW.getBoolean());
            UIManager.put("jgoodies.popupDropShadowEnabled", Settings.LookAndFeel.JGOODIES_SHADOW.getBoolean());
            try {
                LookUtils.setLookAndTheme((LookAndFeel)((LookAndFeel)Class.forName(Settings.LookAndFeel.SELECTED.getString()).getConstructor(new Class[0]).newInstance(new Object[0])), Class.forName(Settings.LookAndFeel.JGOODIES_THEME.getString()).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable e) {
                ErrorHandler.handle("Could not load themepack.\nJGoodies is disabled now", e);
                Settings.LookAndFeel.SELECTED.setString(Settings.LookAndFeel.SELECTED.getDefault());
            }
        }
        if (CUR_LOOK_AND_FEEL == null || !CUR_LOOK_AND_FEEL.equals(Settings.LookAndFeel.SELECTED.getString())) {
            try {
                CUR_LOOK_AND_FEEL = Settings.LookAndFeel.SELECTED.getString();
                boolean foundCurrent = TVBrowser.lookAndFeelExists(CUR_LOOK_AND_FEEL);
                if (!foundCurrent && JOptionPane.showConfirmDialog(null, LOCALIZER.msg("lnfMissing", "The look and feel '{0}' is no longer available,\nso the default look and feel will be used.\n\nDo you want to set the look and feel option to the default look and feel?", CUR_LOOK_AND_FEEL), LOCALIZER.msg("lnfMissing.title", "Look and feel missing"), 2) == 0) {
                    Settings.LookAndFeel.SELECTED.resetToDefault();
                    CUR_LOOK_AND_FEEL = Settings.LookAndFeel.SELECTED.getString();
                    foundCurrent = true;
                }
                if (foundCurrent) {
                    UIThreadRunner.invokeAndWait(() -> {
                        try {
                            UIManager.setLookAndFeel(CUR_LOOK_AND_FEEL);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        LOG.info("setting look and feel to " + CUR_LOOK_AND_FEEL);
                    });
                }
            }
            catch (Exception exc) {
                String msg = LOCALIZER.msg("error.1", "Unable to set look and feel.", exc);
                ErrorHandler.handle(msg, exc);
            }
        }
        UIManager.put("TaskPane.foreground", UIManager.get("Button.foreground"));
        if (UIManager.getColor("List.selectionBackground") == null) {
            UIManager.put("List.selectionBackground", UIManager.getColor("Tree.selectionBackground"));
        }
        if (UIManager.getColor("List.selectionForeground") == null) {
            UIManager.put("List.selectionForeground", UIManager.getColor("Tree.selectionForeground"));
        }
        if (UIManager.getColor("MenuItem.selectionForeground") == null) {
            UIManager.put("MenuItem.selectionForeground", UIManager.getColor("Tree.selectionForeground"));
        }
        if (UIManager.getColor("ComboBox.disabledForeground") == null) {
            UIManager.put("ComboBox.disabledForeground", Color.gray);
        }
        if (mainFrame != null) {
            SwingUtilities.updateComponentTreeUI(mainFrame);
            mainFrame.validate();
        }
        lookAndFeelInitialized = true;
    }

    private static Formatter createFormatter() {
        return new Formatter(){

            @Override
            public synchronized String format(LogRecord record) {
                StringBuilder sb = new StringBuilder();
                DateFormat mTimeFormat = DateFormat.getTimeInstance(2);
                String message = this.formatMessage(record);
                sb.append(mTimeFormat.format(new Date(System.currentTimeMillis())));
                sb.append(' ');
                sb.append(record.getLevel().getLocalizedName());
                sb.append(": ");
                sb.append(message);
                sb.append('\n');
                if (record.getThrown() != null) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        record.getThrown().printStackTrace(pw);
                        pw.close();
                        sb.append(sw.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return sb.toString();
            }
        };
    }

    public static void shutdown(boolean log) {
        mSaveThreadShouldStop = true;
        TVBrowser.flushSettings(log);
    }

    public static void updateProxySettings() {
        String httpHost = "";
        String httpPort = "";
        String httpUser = "";
        String httpPassword = "";
        if (Settings.Proxy.USE.getBoolean()) {
            httpHost = Settings.Proxy.HOST.getString();
            httpPort = Settings.Proxy.PORT.getString();
            if (Settings.Proxy.AUTHENTIFY_AT_PROXY.getBoolean()) {
                httpUser = Settings.Proxy.USER.getString();
                httpPassword = Settings.Proxy.PASSWORD.getString();
                if (httpPassword == null) {
                    httpPassword = "";
                }
                final String user = httpUser;
                final String pw = httpPassword;
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(user, pw.toCharArray());
                    }
                });
            }
        }
        System.setProperty("http.proxyHost", httpHost);
        System.setProperty("http.proxyPort", httpPort);
        System.setProperty("http.proxyUser", httpUser);
        System.setProperty("http.proxyPassword", httpPassword);
        System.setProperty("https.proxyHost", httpHost);
        System.setProperty("https.proxyPort", httpPort);
        System.setProperty("https.proxyUser", httpUser);
        System.setProperty("https.proxyPassword", httpPassword);
    }

    public static boolean isTransportable() {
        return mIsTransportable;
    }

    public static boolean isStable() {
        return true;
    }

    public static String getCurrentVersionString() {
        return ALL_VERSIONS[0];
    }

    public static String[] getAllVersionStrings() {
        return (String[])ALL_VERSIONS.clone();
    }

    private static boolean lookAndFeelExists(String lnf) {
        boolean foundLNF = false;
        for (UIManager.LookAndFeelInfo lnfInfo : UIManager.getInstalledLookAndFeels()) {
            if (!lnfInfo.getClassName().equals(lnf)) continue;
            foundLNF = true;
            break;
        }
        return foundLNF;
    }

    public static void stopAutomaticDownload() {
        if (mAutoDownloadWaitingTimer != null) {
            mAutoDownloadWaitingTimer.stop();
            mainFrame.getStatusBarLabel().setText("");
            mAutoDownloadWaitingTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDataServicesAtStartup() {
        block18: {
            try {
                block19: {
                    SoftwareUpdateItem[] updateItems = PluginAutoUpdater.getDataServicesForFirstStartup();
                    if (updateItems.length <= 0) break block18;
                    boolean oldValue = Settings.Plugins.BETA_WARNING.getBoolean();
                    Settings.Plugins.BETA_WARNING.setBoolean(false);
                    SoftwareUpdateDlg updateDlg = new SoftwareUpdateDlg(UiUtilities.getLastModalChildOf(mainFrame), 2, updateItems, false, null);
                    updateDlg.setLocationRelativeTo(null);
                    updateDlg.setVisible(true);
                    Settings.Plugins.BETA_WARNING.setBoolean(oldValue);
                    PluginLoader.getInstance().installPendingPlugins();
                    PluginLoader.getInstance().loadAllPlugins();
                    PluginProxy epgPaid = PluginProxyManager.getInstance().getPluginForId("java.epgpaiddata.EPGpaidData");
                    if (epgPaid != null) {
                        try {
                            PluginProxyManager.getInstance().activatePlugin(epgPaid);
                        }
                        catch (TvBrowserException tvBrowserException) {
                            // empty catch block
                        }
                    }
                    try {
                        PluginAutoUpdater.downloadMirrorList();
                        Mirror defaultChannelList = PluginAutoUpdater.getPluginUpdatesMirror();
                        File supportedChannelLists = new File(Settings.getUserSettingsDirName(), "channellist_supported.gz");
                        if (!IOUtilities.download(new URL(defaultChannelList.getUrl() + "/" + supportedChannelLists.getName()), supportedChannelLists, 5000)) break block19;
                        String country = Settings.getCountry();
                        BufferedReader in = null;
                        try {
                            in = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(supportedChannelLists))));
                            String line = null;
                            while ((line = in.readLine()) != null) {
                                if (!country.equals(line)) continue;
                                File defaultCountryChannels = new File(Settings.getUserSettingsDirName(), "channellist_" + country + ".gz");
                                IOUtilities.download(new URL(defaultChannelList.getUrl() + "/" + defaultCountryChannels.getName()), defaultCountryChannels, 5000);
                                break;
                            }
                        }
                        catch (Throwable t) {
                            try {
                                t.printStackTrace();
                                break block19;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                IOUtilities.close(in);
                            }
                        }
                        IOUtilities.close(in);
                    }
                    catch (IOException ioe1) {
                        ioe1.printStackTrace();
                    }
                }
                TvDataServiceProxyManager.getInstance().init();
                ChannelList.createForTvBrowserStart();
                ChannelList.initSubscribedChannels();
                String[] deactivatedPlugins = PluginProxyManager.getInstance().getDeactivatedPluginIds();
                if (deactivatedPlugins.length > 0) {
                    String[] propDeactivatedPlugins = Settings.Plugins.DEACTIVATED.getStringArray();
                    for (String deactivatedPlugin : deactivatedPlugins) {
                        boolean activate = true;
                        for (String test : propDeactivatedPlugins) {
                            if (!test.equals(deactivatedPlugin)) continue;
                            activate = false;
                            break;
                        }
                        if (!activate) continue;
                        PluginProxy deactivated = PluginProxyManager.getInstance().getPluginForId(deactivatedPlugin);
                        try {
                            PluginProxyManager.getInstance().activatePlugin(deactivated);
                        }
                        catch (TvBrowserException tvBrowserException) {
                            // empty catch block
                        }
                    }
                    mainFrame.updatePluginsMenu();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void updatePluginsOnVersionChange() {
        boolean oldBetaWarning = Settings.Plugins.BETA_WARNING.getBoolean();
        try {
            UIThreadRunner.invokeAndWait(() -> {
                Version obligartoryUpdate = new Version(4, 24, 51, false);
                TvBrowserVersionChangeDlg versionChange = new TvBrowserVersionChangeDlg(Settings.General.TV_BROWSER_VERSION_USED_LAST.getVersion(), obligartoryUpdate);
                versionChange.setIconImages(ICONS_WINDOW);
                versionChange.pack();
                versionChange.setLocationRelativeTo(null);
                versionChange.setVisible(true);
                versionChange.toFront();
                versionChange.requestFocus();
                Settings.Plugins.BETA_WARNING.setBoolean(oldBetaWarning);
                if (versionChange.getIsToCloseTvBrowser()) {
                    System.exit(0);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isSafeMode() {
        return mSafeMode;
    }

    static {
        ICONS_WINDOW = new ArrayList(4);
        ALL_VERSIONS = new String[]{"4.2.7", "4.2.6.95 Beta1", "4.2.6.50 SVN", "4.2.6", "4.2.5.50 SVN", "4.2.5", "4.2.4.95 Beta1", "4.2.4.51 SVN", "4.2.4.50 SVN", "4.2.4", "4.2.3.95 Beta1", "4.2.3.50 SVN", "4.2.3", "4.2.2.96 RC1", "4.2.2.95 Beta1", "4.2.2.52 SVN", "4.2.2.51 SVN", "4.2.2.50 SVN", "4.2.2", "4.2.1.96 RC1", "4.2.1.95 Beta1", "4.2.1.52 SVN", "4.2.1.51 SVN", "4.2.1.50 SVN", "4.2.1", "4.2.0.97 RC1", "4.2.0.51 SVN", "4.2.0.50 SVN", "4.2", "4.0.9.98 RC3", "4.0.9.98 RC2", "4.0.9.97 RC1", "4.0.9.96 Beta2", "4.0.9.95 Beta1", "4.0.1.50 SVN", "4.0.1", "4.0.0.97 RC1", "4.0.0.96 Beta2", "4.0.0.95 Beta1", "4.0.0.50 SVN", "4", "3.4.4.98 RC3", "3.4.4.97 RC2", "3.4.4.95 Beta1", "3.4.4.50 SVN", "3.4.4", "3.4.3.96 RC1", "3.4.3.95 Beta1", "3.4.3.52 SVN", "3.4.3.51 SVN", "3.4.3.50 SVN", "3.4.3", "3.4.2.50 SVN", "3.4.2", "3.4.1.96 RC1", "3.4.1.95 Beta1", "3.4.1.50-SVN", "3.4.1a", "3.4.1", "3.4.0.99 RC", "3.4.0.98 RC", "3.4.0.97 RC", "3.4.0.96 RC", "3.4.0.95 Beta", "3.4.0.50-SVN", "3.4.0.1 Hotfix", "3.4", "3.3.97 RC", "3.3.96 Beta", "3.3.95 Beta", "3.3.3.51 SVN", "3.3.3.50 SVN", "3.3.3", "3.3.3beta1", "3.3.2.50 SVN", "3.3.2", "3.3.2beta1", "3.3.1.50 SVN", "3.3.1", "3.3.1RC1", "3.3.1beta1", "3.3.0.51 SVN", "3.3.0.50 SVN", "3.3a", "3.3", "3.3RC2", "3.3RC1", "3.3beta1", "3.2.1.51 SVN", "3.2.1.50 SVN", "3.2.1", "3.2.1RC1", "3.2.1beta2", "3.2.1beta1", "3.2.0.50 SVN", "3.2", "3.2RC1", "3.2beta2", "3.2beta1", "3.1.0.50 SVN", "3.1", "3.1RC2", "3.1RC1", "3.1beta2", "3.1beta1", "3.0.2.99 SVN", "3.0.2", "3.0.2 RC2", "3.0.2 RC1", "3.0.2beta1", "3.0.1.99 SVN", "3.0.1", "3.0", "3.0 RC3", "3.0 RC2", "3.0 RC1", "3.0beta2", "3.0beta1", "3.0 (alpha2)", "3.0 (alpha1)", "3.0 (alpha)", "3.0 (SVN)", "2.7.6", "2.7.5", "2.7.5 (SVN)", "2.7.4", "2.7.4 (SVN)", "2.7.3", "2.7.3beta", "2.7.3 (SVN)", "2.7.2", "2.7.2 RC3", "2.7.2 RC2", "2.7.2 RC1", "2.7.2beta", "2.7.2 (SVN)", "2.7.1", "2.7.1 RC1", "2.7.1beta1", "2.7.x (SVN)", "2.7", "2.7 RC2", "2.7 RC1", "2.7beta2", "2.7beta1", "2.7 (SVN)", "2.6.3", "2.6.3beta", "2.6.2", "2.6.1", "2.6.1beta", "2.6.1 (SVN)", "2.6", "2.6beta2", "2.6beta1", "2.6alpha3", "2.6alpha2", "2.6alpha1", "2.6 (alpha)", "2.5.3", "2.5.3beta3", "2.5.3beta2", "2.5.3beta1", "2.5.3 (alpha)", "2.5.2", "2.5.1", "2.5.1beta3", "2.5.1beta2", "2.5.1beta1", "2.5", "2.5beta3", "2.5beta2", "2.5beta1", "2.5 alpha", "2.2.5", "2.2.4", "2.2.3", "2.2.2", "2.2.2beta2", "2.2.2beta1", "2.2.1", "2.2.1beta3", "2.2", "2.2beta2", "2.2beta1", "2.2 (SVN)"};
        ICONS_WINDOW.add(ImageUtilities.createImage("imgs/tvbrowser128.png"));
        ICONS_WINDOW.add(ImageUtilities.createImage("imgs/tvbrowser48.png"));
        ICONS_WINDOW.add(ImageUtilities.createImage("imgs/tvbrowser32.png"));
        ICONS_WINDOW.add(ImageUtilities.createImage("imgs/tvbrowser16.png"));
        File file = new File("NIGHTLY_VALUES");
        mIsTransportable = new File("settings").isDirectory();
        VERSION = new Version(4, 27, 0, true, ALL_VERSIONS[0] + (mIsTransportable ? " transportable" : ""));
        MAINWINDOW_TITLE = "TV-Browser " + VERSION.toString();
        mToggleSocket = new AtomicReference<Object>(null);
        mLockFile = new AtomicReference<Object>(null);
        mToggleLockFile = new AtomicReference<Object>(null);
        mLock = new AtomicReference<Object>(null);
        mToggleLock = new AtomicReference<Object>(null);
        mShowStartScreen = true;
        mFullscreen = false;
        mMinimized = false;
        mSafeMode = false;
        lookAndFeelInitialized = false;
        RESTART_CMD = null;
        mProtocolMessage = null;
        VERSION_LAST = null;
        IS_TVB_UPDATE = false;
    }

    private static final class LockFileResult {
        private boolean mResult;
        private String[] mLines;

        public LockFileResult(boolean result, String[] lines) {
            this.mResult = result;
            this.mLines = lines;
        }
    }
}

