/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import devplugin.ChannelFilter;
import devplugin.ChannelFilterChangeListener;
import devplugin.FilterChangeListenerV2;
import devplugin.FilterManager;
import devplugin.PluginsProgramFilter;
import devplugin.ProgramFilter;
import java.util.ArrayList;
import javax.swing.JFrame;
import tvbrowser.core.filters.ChannelFilterList;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.PluginFilter;
import tvbrowser.core.filters.SeparatorFilter;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.ui.filter.dlgs.EditFilterComponentDlg;
import tvbrowser.ui.mainframe.MainFrame;

public class FilterManagerImpl
implements FilterManager {
    private static FilterManagerImpl mInstance;

    private FilterManagerImpl() {
        mInstance = this;
    }

    public static FilterManager getInstance() {
        if (mInstance == null) {
            new FilterManagerImpl();
        }
        return mInstance;
    }

    @Override
    public ProgramFilter getCurrentFilter() {
        return MainFrame.getInstance().getProgramFilter();
    }

    @Override
    public void setCurrentFilter(ProgramFilter filter) {
        MainFrame.getInstance().setProgramFilter(filter);
    }

    @Override
    public ProgramFilter[] getAvailableFilters() {
        ProgramFilter[] filter;
        ArrayList<ProgramFilter> filters = new ArrayList<ProgramFilter>();
        FilterList filterList = FilterList.getInstance();
        for (ProgramFilter filt : filter = filterList.getFilterArr()) {
            if (filt == null || filt instanceof SeparatorFilter) continue;
            filters.add(filt);
        }
        return filters.toArray(new ProgramFilter[filters.size()]);
    }

    @Override
    public boolean addFilter(PluginsProgramFilter filter) {
        if (FilterList.getInstance().getFilterByName(filter.getName()) == null) {
            FilterList.getInstance().addProgramFilter(filter);
            MainFrame.getInstance().updateFilterMenu();
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteFilter(PluginsProgramFilter filter) {
        if (PluginProxyManager.getInstance().getActivatedPluginForId(filter.getPluginAccessOfFilter().getId()).isAllowedToDeleteProgramFilter(filter)) {
            if (this.getCurrentFilter() == filter) {
                this.setCurrentFilter(FilterList.getInstance().getDefaultFilter());
            }
            FilterList.getInstance().remove(filter, true);
            FilterList.getInstance().store();
            MainFrame.getInstance().updateFilterMenu();
            return true;
        }
        return false;
    }

    @Override
    public ProgramFilter getDefaultFilter() {
        return FilterList.getInstance().getDefaultFilter();
    }

    @Override
    public ProgramFilter getAllFilter() {
        return FilterList.getInstance().getAllFilter();
    }

    @Override
    public boolean isPluginFilter(ProgramFilter filter) {
        return filter instanceof PluginFilter;
    }

    @Override
    public String[] getChannelFilterComponentNames() {
        return FilterComponentList.getInstance().getChannelFilterNames();
    }

    @Override
    public String addNewChannelFilterComponent() {
        EditFilterComponentDlg dlg = new EditFilterComponentDlg((JFrame)null, null, ChannelFilterComponent.class);
        FilterComponent rule = dlg.getFilterComponent();
        if (rule == null) {
            return null;
        }
        if (!(rule instanceof ChannelFilterComponent)) {
            return null;
        }
        FilterComponentList.getInstance().add(rule);
        FilterComponentList.getInstance().store();
        return rule.getName();
    }

    @Override
    public void registerFilterChangeListener(FilterChangeListenerV2 listener) {
        FilterList.getInstance().getFilterTreeModel().registerFilterChangeListener(listener);
    }

    @Override
    public void unregisterFilterChangeListener(FilterChangeListenerV2 listener) {
        FilterList.getInstance().getFilterTreeModel().unregisterFilterChangeListener(listener);
    }

    @Override
    public ChannelFilter getCurrentChannelFilter() {
        return MainFrame.getInstance().getChannelFilter();
    }

    @Override
    public void setChannelFilter(ChannelFilter filter) {
        MainFrame.getInstance().setChannelFilter(filter);
    }

    @Override
    public ChannelFilter[] getAvailableChannelFilters() {
        return ChannelFilterList.getInstance().getAvailableChannelFilter();
    }

    @Override
    public void registerChannelFilterChangeListener(ChannelFilterChangeListener listener) {
        ChannelFilterList.getInstance().registerChannelFilterChangeListener(listener);
    }

    @Override
    public void unregisterChannelFilterChangeListener(ChannelFilterChangeListener listener) {
        ChannelFilterList.getInstance().unregisterChannelFilterChangeListener(listener);
    }

    @Override
    public ProgramFilter getFilterByName(String name) {
        return FilterList.getInstance().getFilterByName(name);
    }
}

