/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Program;
import devplugin.ProgramFieldType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.i18n.Localizer;

public class AgeLimitFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(AgeLimitFilterComponent.class);
    private int mRequiredAge = 14;
    private JSpinner mAgeSpinner;

    public AgeLimitFilterComponent(String name, String description) {
        super(name, description);
    }

    public AgeLimitFilterComponent() {
        this("", "");
    }

    @Override
    public boolean accept(Program program) {
        int ageLimit = program.getIntField(ProgramFieldType.AGE_LIMIT_TYPE);
        return ageLimit > 0 && ageLimit <= this.mRequiredAge;
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("description", "");
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel content = new JPanel(new BorderLayout());
        this.mAgeSpinner = new JSpinner(new SpinnerNumberModel(16, 6, 21, 1));
        this.mAgeSpinner.setValue(this.mRequiredAge);
        content.add((Component)this.mAgeSpinner, "South");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)content, "North");
        return centerPanel;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mRequiredAge = in.readInt();
    }

    @Override
    public void saveSettings() {
        this.mRequiredAge = (Integer)this.mAgeSpinner.getValue();
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mRequiredAge);
    }

    public String toString() {
        return mLocalizer.msg("label", "Age limit");
    }
}

