/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Date;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.i18n.Localizer;

public class DateFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DateFilterComponent.class);
    private JSpinner mFromSpinner;
    private JSpinner mToSpinner;
    private int mStartDays = 0;
    private int mEndDays = 7;

    public DateFilterComponent(String name, String description) {
        super(name, description);
    }

    public DateFilterComponent() {
        this("", "");
    }

    @Override
    public boolean accept(Program program) {
        Date progDate = program.getDate();
        Date currentDate = Date.getCurrentDate();
        Date mStartDate = currentDate.addDays(this.mStartDays);
        Date mEndDate = currentDate.addDays(this.mEndDays);
        return mStartDate.compareTo(progDate) <= 0 && progDate.compareTo(mEndDate) <= 0;
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("description", "");
    }

    @Override
    public JPanel getSettingsPanel() {
        FormLayout layout = new FormLayout("pref, 3dlu, fill:pref:grow, 3dlu, pref", "");
        JPanel content = new JPanel((LayoutManager)layout);
        content.setBorder(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        int currentRow = 1;
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        content.add((Component)new JLabel(mLocalizer.msg("from.1", "From today plus")), cc.xy(1, currentRow));
        this.mFromSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 28, 1));
        this.mFromSpinner.setValue(this.mStartDays);
        content.add((Component)this.mFromSpinner, cc.xy(3, currentRow));
        content.add((Component)new JLabel(mLocalizer.msg("from.2", "days")), cc.xy(5, currentRow));
        layout.appendRow(RowSpec.decode((String)"pref"));
        content.add((Component)new JLabel(mLocalizer.msg("to.1", "Until today plus")), cc.xy(1, currentRow += 2));
        this.mToSpinner = new JSpinner(new SpinnerNumberModel(7, 0, 28, 1));
        this.mToSpinner.setValue(this.mEndDays);
        content.add((Component)this.mToSpinner, cc.xy(3, currentRow));
        content.add((Component)new JLabel(mLocalizer.msg("to.2", "days")), cc.xy(5, currentRow));
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)content, "North");
        return centerPanel;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mStartDays = in.readInt();
        this.mEndDays = in.readInt();
    }

    @Override
    public void saveSettings() {
        this.mStartDays = (Integer)this.mFromSpinner.getValue();
        this.mEndDays = (Integer)this.mToSpinner.getValue();
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mStartDays);
        out.writeInt(this.mEndDays);
    }

    public String toString() {
        return mLocalizer.msg("date", "Date");
    }
}

