/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Program;
import devplugin.ProgramSearcher;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import tvbrowser.core.filters.filtercomponents.MassFilterSettingsDialog;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.ui.SearchFormSettings;
import util.ui.SearchableTextAreaPanel;
import util.ui.UiUtilities;

public class MassFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(MassFilterComponent.class);
    private String mText = "";
    private SearchFormSettings mSearchFormSettings = new SearchFormSettings("");
    private SearchFormSettings mNewSearchFormSettings;
    private ProgramSearcher[] mSearcher;
    private SearchableTextAreaPanel mTextInput;
    private JPanel mSettingsPanel;

    public MassFilterComponent() {
        this("", "");
    }

    public MassFilterComponent(String name, String description) {
        super(name, description);
    }

    private ProgramSearcher[] getSearcher() {
        if (this.mSearcher == null) {
            String[] keys;
            ArrayList<ProgramSearcher> list = new ArrayList<ProgramSearcher>();
            for (String key : keys = this.mText.split("\\n")) {
                try {
                    list.add(this.mSearchFormSettings.createSearcher(key.trim()));
                }
                catch (TvBrowserException ex) {
                    ex.printStackTrace();
                }
            }
            this.mSearcher = list.toArray(new ProgramSearcher[list.size()]);
        }
        return this.mSearcher;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean accept(Program program) {
        if (this.getSearcher() != null) {
            for (ProgramSearcher searcher : this.getSearcher()) {
                if (!searcher.matches(program, this.mSearchFormSettings.getFieldTypes())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mText = (String)in.readObject();
        this.mSearchFormSettings = new SearchFormSettings(in);
        this.mSearcher = null;
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeObject(this.mText);
        this.mSearchFormSettings.writeData(out);
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("desc", "help-text");
    }

    @Override
    public JPanel getSettingsPanel() {
        this.mNewSearchFormSettings = this.mSearchFormSettings;
        this.mSettingsPanel = new JPanel((LayoutManager)new FormLayout("default:grow,default", "fill:50dlu:grow,2dlu,default"));
        this.mTextInput = new SearchableTextAreaPanel(this.mText, false);
        this.mSettingsPanel.add((Component)this.mTextInput, CC.xyw((int)1, (int)1, (int)2));
        JButton config = new JButton(mLocalizer.msg("configure", "Search options"));
        config.addActionListener(e -> this.showConfigDialog());
        this.mSettingsPanel.add((Component)config, CC.xy((int)2, (int)3));
        return this.mSettingsPanel;
    }

    private void showConfigDialog() {
        Window parent = UiUtilities.getBestDialogParent(this.mSettingsPanel);
        MassFilterSettingsDialog dialog = new MassFilterSettingsDialog(parent, this.mNewSearchFormSettings);
        dialog.setVisible(true);
        this.mNewSearchFormSettings = dialog.getSearchFormSettings();
    }

    @Override
    public void saveSettings() {
        this.mText = this.mTextInput.getText("\n");
        this.mSearchFormSettings = this.mNewSearchFormSettings;
        this.mSearcher = null;
    }

    public String toString() {
        return mLocalizer.msg("name", "Mass-Filter");
    }
}

