/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.i18n.Localizer;

public class MonthFilterComponent
extends AbstractFilterComponent {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(MonthFilterComponent.class);
    private JComboBox<Month> mFromBoxMonth;
    private JComboBox<Month> mToBoxMonth;
    private JComboBox<Integer> mFromBoxDay;
    private JComboBox<Integer> mToBoxDay;
    private int mStartDay = 1;
    private int mEndDay = 31;
    private int mStartMonth = 1;
    private int mEndMonth = 12;

    public MonthFilterComponent(String name, String description) {
        super(name, description);
    }

    public MonthFilterComponent() {
        this("", "");
    }

    @Override
    public boolean accept(Program program) {
        boolean result = false;
        if (this.mStartMonth <= this.mEndMonth) {
            result = program.getDate().getMonth() >= this.mStartMonth && program.getDate().getMonth() <= this.mEndMonth;
        } else {
            boolean bl = result = program.getDate().getMonth() >= this.mStartMonth || program.getDate().getMonth() <= this.mEndMonth;
        }
        if (result && program.getDate().getMonth() == this.mStartMonth) {
            boolean bl = result = program.getDate().getDayOfMonth() >= this.mStartDay;
        }
        if (result && program.getDate().getMonth() == this.mEndMonth) {
            result = program.getDate().getDayOfMonth() <= this.mEndDay;
        }
        return result;
    }

    @Override
    public String getTypeDescription() {
        return LOCALIZER.msg("description", "Accepts all programs with month between (inclusive) start and end.");
    }

    private void handleItemEventFor(ItemEvent e, JComboBox<Integer> box) {
        if (e.getStateChange() == 1) {
            int value = (Integer)box.getSelectedItem();
            box.removeAllItems();
            int days = ((Month)e.getItem()).mCalendar.getActualMaximum(5);
            for (int i = 1; i <= days; ++i) {
                box.addItem(i);
                if (value != i) continue;
                box.setSelectedIndex(box.getItemCount() - 1);
            }
        }
    }

    @Override
    public JPanel getSettingsPanel() {
        FormLayout layout = new FormLayout("default, 3dlu, default, 3dlu, default", "");
        JPanel content = new JPanel((LayoutManager)layout);
        content.setBorder(Borders.DIALOG);
        CellConstraints cc = new CellConstraints();
        int currentRow = 1;
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        this.mFromBoxDay = new JComboBox();
        this.mFromBoxDay.addItem(this.mStartDay);
        this.mFromBoxDay.setSelectedIndex(0);
        this.mToBoxDay = new JComboBox();
        this.mToBoxDay.addItem(this.mEndDay);
        this.mToBoxDay.setSelectedIndex(0);
        this.mFromBoxMonth = new JComboBox();
        this.mFromBoxMonth.addItemListener(e -> this.handleItemEventFor(e, this.mFromBoxDay));
        this.mToBoxMonth = new JComboBox();
        this.mToBoxMonth.addItemListener(e -> this.handleItemEventFor(e, this.mToBoxDay));
        for (int month = 0; month <= 11; ++month) {
            this.mFromBoxMonth.addItem(new Month(month));
            this.mToBoxMonth.addItem(new Month(month));
            if (this.mStartMonth - 1 == month) {
                this.mFromBoxMonth.setSelectedIndex(this.mFromBoxMonth.getItemCount() - 1);
            }
            if (this.mEndMonth - 1 != month) continue;
            this.mToBoxMonth.setSelectedIndex(this.mToBoxMonth.getItemCount() - 1);
        }
        content.add((Component)new JLabel(LOCALIZER.msg("from", "From")), cc.xy(1, currentRow));
        content.add(this.mFromBoxDay, cc.xy(3, currentRow));
        content.add(this.mFromBoxMonth, cc.xy(5, currentRow));
        layout.appendRow(RowSpec.decode((String)"pref"));
        content.add((Component)new JLabel(LOCALIZER.msg("to", "Until")), cc.xy(1, currentRow += 2));
        content.add(this.mToBoxDay, cc.xy(3, currentRow));
        content.add(this.mToBoxMonth, cc.xy(5, currentRow));
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)content, "North");
        return centerPanel;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mStartMonth = in.readInt();
        this.mEndMonth = in.readInt();
        this.mStartDay = in.readInt();
        this.mEndDay = in.readInt();
    }

    @Override
    public void saveSettings() {
        this.mStartMonth = ((Month)this.mFromBoxMonth.getSelectedItem()).mCalendar.get(2) + 1;
        this.mEndMonth = ((Month)this.mToBoxMonth.getSelectedItem()).mCalendar.get(2) + 1;
        this.mStartDay = (Integer)this.mFromBoxDay.getSelectedItem();
        this.mEndDay = (Integer)this.mToBoxDay.getSelectedItem();
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mStartMonth);
        out.writeInt(this.mEndMonth);
        out.writeInt(this.mStartDay);
        out.writeInt(this.mEndDay);
    }

    public String toString() {
        return LOCALIZER.msg("month", "Month");
    }

    private static final class Month {
        private Calendar mCalendar = Calendar.getInstance();

        public Month(int month) {
            this.mCalendar.set(1, 2022);
            this.mCalendar.set(5, 1);
            this.mCalendar.set(2, month);
        }

        public String toString() {
            return this.mCalendar.getDisplayName(2, 2, Locale.getDefault());
        }
    }
}

