/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.JPanel;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNode;
import tvbrowser.extras.favoritesplugin.dlgs.ManageFavoritesPanel;
import util.i18n.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ManageFavoritesDialog
extends JDialog
implements WindowClosingIf {
    protected static final Localizer LOCALIZER = Localizer.getLocalizerFor(ManageFavoritesDialog.class);
    private static ManageFavoritesDialog mInstance = null;
    private ManageFavoritesPanel mManagePanel;

    public ManageFavoritesDialog(Window parent, Favorite[] favoriteArr, int splitPanePosition, boolean showNew, Favorite initialSelection) {
        super(parent);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(favoriteArr, splitPanePosition, showNew, initialSelection);
    }

    private void init(Favorite[] favoriteArr, int splitPanePosition, boolean showNew, Favorite initialSelection) {
        try {
            mInstance = this;
            this.mManagePanel = new ManageFavoritesPanel(favoriteArr, splitPanePosition, showNew, initialSelection, false, false);
            ((JPanel)this.getContentPane()).setBorder(Borders.DIALOG);
            ((JPanel)this.getContentPane()).setLayout(new BorderLayout());
            ((JPanel)this.getContentPane()).add((Component)this.mManagePanel, "Center");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    mInstance = null;
                }
            });
            UiUtilities.registerForClosing(this);
            if (showNew) {
                this.setTitle(LOCALIZER.msg("newTitle", "New programs found"));
            } else {
                this.setTitle(LOCALIZER.msg("title", "Manage favorite programs"));
            }
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ManageFavoritesDialog.this.close();
                }
            });
        }
        catch (Throwable t) {
            FavoritesPlugin.LOG.log(Level.SEVERE, "ERROR OPENING MANAGE DIALOG", t);
        }
    }

    public static ManageFavoritesDialog getInstance() {
        return mInstance;
    }

    @Override
    public void close() {
        mInstance = null;
        this.mManagePanel.close();
        this.dispose();
    }

    public void favoriteSelectionChanged() {
        this.mManagePanel.favoriteSelectionChanged();
    }

    public int getSplitpanePosition() {
        return this.mManagePanel.getSplitpanePosition();
    }

    public void setSplitpanePosition(int val) {
        this.mManagePanel.setSplitpanePosition(val);
    }

    public void addFavorite(Favorite fav, Object dummy) {
        this.mManagePanel.addFavorite(fav, dummy);
    }

    public void editSelectedFavorite() {
        this.mManagePanel.editSelectedFavorite();
    }

    public void newFavorite(FavoriteNode parent) {
        this.mManagePanel.newFavorite(parent);
    }

    public void showSendDialog() {
        this.mManagePanel.showSendDialog();
    }

    public void deleteSelectedFavorite() {
        this.mManagePanel.deleteSelectedFavorite();
    }

    public boolean programListIsEmpty() {
        return this.mManagePanel.programListIsEmpty();
    }

    public boolean isShowingNewFoundPrograms() {
        return this.mManagePanel.isShowingNewFoundPrograms();
    }

    public void newFolder(FavoriteNode parent, Window partenWindow, String name) {
        this.mManagePanel.newFolder(parent, partenWindow, name);
    }

    public void reload(boolean keepPath) {
        this.mManagePanel.reload(keepPath);
    }
}

