/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.reminderplugin.FrameReminders;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderConstants;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderSettings;
import tvbrowser.ui.filter.dlgs.EditFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import util.i18n.Localizer;
import util.ui.DefaultMarkingPrioritySelectionPanel;
import util.ui.EnhancedPanelBuilder;
import util.ui.ExecuteSettingsDialog;
import util.ui.ExtensionFileFilter;
import util.ui.FileCheckBox;
import util.ui.ProgramReceiveTargetSelectionPanel;
import util.ui.ScrollableJPanel;
import util.ui.UiUtilities;

public class ReminderSettingsTab
implements SettingsTab {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ReminderSettingsTab.class);
    private ReminderSettings mSettings = ReminderPlugin.getInstance().getSettings();
    private JCheckBox mFrameRemindersChB;
    private JCheckBox mFrameRemindersCloseIfEmptry;
    private JCheckBox mFrameRemindersToFrontOnAdd;
    private JCheckBox mFrameRemindersAutoResizeEnabled;
    private JRadioButton mFrameRemindersAutoResizeTypeTop;
    private JRadioButton mFrameRemindersAutoResizeTypeBottom;
    private JCheckBox mPrefilter;
    private JCheckBox mStickyReminders;
    private JSpinner mStickyMinutes;
    private JCheckBox mReminderWindowChB;
    private JRadioButton[] mReminderWindowPosition;
    private FileCheckBox mSoundFileChB;
    private JCheckBox mBeep;
    private JCheckBox mExecChB;
    private JCheckBox mShowTimeSelectionDlg;
    private JCheckBox mShowRemovedDlg;
    private JCheckBox mShowTimeCounter;
    private JCheckBox mProvideTab;
    private JCheckBox mShowDateSeparators;
    private JButton mExecFileDialogBtn;
    private JCheckBox mShowAlwaysOnTop;
    private JSpinner mAutoCloseReminderTimeSp;
    private JRadioButton mCloseOnEnd;
    private JRadioButton mCloseNever;
    private JRadioButton mCloseOnTime;
    private JRadioButton mScrollTimeToNext;
    private JRadioButton mScrollTimeOnDay;
    private JComboBox<RemindValue> mDefaultReminderEntryList;
    private String mExecFileStr;
    private String mExecParamStr;
    private Object mTestSound;
    private ProgramReceiveTargetSelectionPanel mPluginTargetSelectionPanel;
    private DefaultMarkingPrioritySelectionPanel mMarkingsPanel;

    @Override
    public JPanel createSettingsPanel() {
        FormLayout layout = new FormLayout("5dlu,pref,5dlu,pref,pref:grow,3dlu,pref,3dlu,pref,5dlu");
        layout.setColumnGroups((int[][])new int[][]{{7, 9}});
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(layout, (JPanel)new ScrollableJPanel());
        pb.border(Borders.DIALOG);
        Object[] extArr = new String[]{".wav", ".aif", ".rmf", ".au", ".mid"};
        String soundFName = this.mSettings.get("soundfile");
        String msg = LOCALIZER.msg("soundFileFilter", "Sound file ({0})", "*" + StringUtils.join((Object[])extArr, (String)", *"));
        this.mFrameRemindersChB = new JCheckBox(LOCALIZER.msg("frameReminders", "Window with collected reminders"), this.mSettings.isSet("showFrameReminders"));
        this.mFrameRemindersToFrontOnAdd = new JCheckBox(LOCALIZER.msg("frameRemindersToFrontOnAdd", "Show window at front, when reminder is added"), this.mSettings.isSet("frameRemindersToFrontOnAdd"));
        this.mFrameRemindersCloseIfEmptry = new JCheckBox(LOCALIZER.msg("frameRemindersCloseIfEmpty", "Close window automatically when last reminder is removed of it"), this.mSettings.isSet("autoCloseFrameRemindersIfEmpty"));
        this.mFrameRemindersAutoResizeEnabled = new JCheckBox(LOCALIZER.msg("autoResizeEnabled", "Automatically resize"), this.mSettings.isSet("autoResizeEnabled"));
        this.mFrameRemindersAutoResizeTypeTop = new JRadioButton(LOCALIZER.msg("autoResizeType.top", "Align to top of screen"), this.mSettings.isAutoResizeTop());
        this.mFrameRemindersAutoResizeTypeBottom = new JRadioButton(LOCALIZER.msg("autoResizeType.bottom", "Align to bottom of screen"), this.mSettings.isAutoResizeBottom());
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.mFrameRemindersAutoResizeTypeTop);
        bg1.add(this.mFrameRemindersAutoResizeTypeBottom);
        this.mFrameRemindersToFrontOnAdd.setEnabled(this.mFrameRemindersChB.isSelected());
        this.mFrameRemindersCloseIfEmptry.setEnabled(this.mFrameRemindersChB.isSelected());
        this.mFrameRemindersAutoResizeEnabled.setEnabled(this.mFrameRemindersChB.isSelected());
        this.mFrameRemindersAutoResizeTypeTop.setEnabled(this.mFrameRemindersChB.isSelected() && this.mFrameRemindersAutoResizeEnabled.isSelected());
        this.mFrameRemindersAutoResizeTypeBottom.setEnabled(this.mFrameRemindersChB.isSelected() && this.mFrameRemindersAutoResizeEnabled.isSelected());
        JPanel frameRemindersCfg = new JPanel((LayoutManager)new FormLayout("12dlu,12dlu,default:grow", "default,1dlu,default,1dlu,default,3dlu,default,1dlu,default,1dlu,default"));
        frameRemindersCfg.add((Component)this.mFrameRemindersChB, CC.xyw((int)1, (int)1, (int)3));
        frameRemindersCfg.add((Component)this.mFrameRemindersToFrontOnAdd, CC.xyw((int)2, (int)3, (int)2));
        frameRemindersCfg.add((Component)this.mFrameRemindersCloseIfEmptry, CC.xyw((int)2, (int)5, (int)2));
        frameRemindersCfg.add((Component)this.mFrameRemindersAutoResizeEnabled, CC.xyw((int)2, (int)7, (int)2));
        frameRemindersCfg.add((Component)this.mFrameRemindersAutoResizeTypeTop, CC.xy((int)3, (int)9));
        frameRemindersCfg.add((Component)this.mFrameRemindersAutoResizeTypeBottom, CC.xy((int)3, (int)11));
        this.mReminderWindowChB = new JCheckBox(LOCALIZER.msg("reminderWindow", "Single reminder window"), this.mSettings.isSet("usemsgbox"));
        if (this.mFrameRemindersChB.isSelected() && this.mReminderWindowChB.isSelected()) {
            this.mReminderWindowChB.setSelected(false);
        }
        this.mShowAlwaysOnTop = new JCheckBox(LOCALIZER.msg("alwaysOnTop", "Show always on top"), this.mSettings.isSet("alwaysOnTop"));
        this.mShowAlwaysOnTop.setEnabled(this.mReminderWindowChB.isSelected());
        JPanel reminderWindowCfg = new JPanel((LayoutManager)new FormLayout("12dlu,default:grow", "default,1dlu,default,1dlu,default,1dlu,default"));
        reminderWindowCfg.add((Component)this.mReminderWindowChB, CC.xyw((int)1, (int)1, (int)2));
        reminderWindowCfg.add((Component)this.mShowAlwaysOnTop, CC.xy((int)2, (int)7));
        JPanel postionPanel = new JPanel((LayoutManager)new FormLayout("default,default,default,default,default,default", "default,default,default,default,default,default"));
        int xPos = 1;
        int yPos = 1;
        int selected = this.mSettings.getAsInt("reminderWindowPosition");
        this.mReminderWindowPosition = new JRadioButton[13];
        ButtonGroup positionGroup = new ButtonGroup();
        for (int i = 0; i < 13; ++i) {
            this.mReminderWindowPosition[i] = new JRadioButton();
            this.mReminderWindowPosition[i].setSelected(i == selected);
            this.mReminderWindowPosition[i].setEnabled(this.mReminderWindowChB.isSelected());
            positionGroup.add(this.mReminderWindowPosition[i]);
            if (i == 3 || i == 8) {
                xPos = 2;
                ++yPos;
            } else if (i == 5 || i == 10) {
                xPos = 1;
                ++yPos;
            }
            postionPanel.add((Component)this.mReminderWindowPosition[i], CC.xy((int)xPos, (int)yPos));
            xPos += 2;
        }
        JLabel posLabel = new JLabel(LOCALIZER.msg("positionOnScreen", "Position on screen"));
        posLabel.setEnabled(this.mReminderWindowChB.isSelected());
        reminderWindowCfg.add((Component)posLabel, CC.xy((int)2, (int)3));
        reminderWindowCfg.add((Component)postionPanel, CC.xy((int)2, (int)5));
        this.mSoundFileChB = new FileCheckBox(LOCALIZER.msg("playlingSound", "Play sound"), new File(soundFName), 0, false);
        JFileChooser soundChooser = new JFileChooser();
        soundChooser.setFileFilter(new ExtensionFileFilter((String[])extArr, msg));
        this.mSoundFileChB.setFileChooser(soundChooser);
        this.mSoundFileChB.setSelected(this.mSettings.isSet("usesound"));
        this.mBeep = new JCheckBox(LOCALIZER.msg("beep", "Speaker sound"), this.mSettings.isSet("usebeep"));
        this.mExecFileStr = this.mSettings.get("execfile");
        this.mExecParamStr = this.mSettings.get("execparam");
        final JButton soundTestBt = new JButton(LOCALIZER.msg("test", "Test"));
        this.mExecChB = new JCheckBox(LOCALIZER.msg("executeProgram", "Execute program"));
        this.mExecChB.setSelected(this.mSettings.isSet("useexec"));
        this.mExecFileDialogBtn = new JButton(LOCALIZER.msg("executeConfig", "Configure"));
        this.mExecFileDialogBtn.setEnabled(this.mExecChB.isSelected());
        this.mPrefilter = new JCheckBox(LOCALIZER.msg("prefilter", "Activated"), this.mSettings.isSet("prefilter"));
        JLabel helpPrefilter = new JLabel(LOCALIZER.msg("prefilter.help", "Reminders are only shown for programs that are accepted by the filter"));
        helpPrefilter.setEnabled(this.mPrefilter.isSelected());
        JButton editFilter = new JButton(LOCALIZER.msg("editFilter", "Edit filter"));
        editFilter.setEnabled(this.mPrefilter.isSelected());
        editFilter.addActionListener(e -> {
            UserFilter filter = GenericFilterMap.getInstance().getGenericInternalFilter("_reminderPrefilter");
            EditFilterDlg editFilter1 = new EditFilterDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), FilterList.getInstance(), filter, false);
            if (editFilter1.getOkWasPressed()) {
                GenericFilterMap.getInstance().updateGenericInternalFilter("_reminderPrefilter", filter);
            }
        });
        this.mPrefilter.addItemListener(e -> {
            editFilter.setEnabled(e.getStateChange() == 1);
            helpPrefilter.setEnabled(editFilter.isEnabled());
        });
        this.mPluginTargetSelectionPanel = new ProgramReceiveTargetSelectionPanel(MainFrame.getInstance(), ReminderPlugin.getInstance().getClientPluginsTargets(), null, ReminderPluginProxy.getInstance(), false, null);
        int autoCloseReminderTime = 10;
        try {
            autoCloseReminderTime = this.mSettings.getAsInt("autoCloseReminderTime");
            if (autoCloseReminderTime == 0) {
                autoCloseReminderTime = 10;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mCloseOnEnd = new JRadioButton(LOCALIZER.msg("autoCloseReminderAtProgramEnd", "Program end"), this.mSettings.isAutoCloseOnEnd());
        this.mCloseOnEnd.setEnabled(this.mReminderWindowChB.isSelected() || this.mFrameRemindersChB.isSelected());
        this.mCloseNever = new JRadioButton(LOCALIZER.msg("autoCloseNever", "Never close"), this.mSettings.isAutoCloseNever());
        this.mCloseNever.setEnabled(this.mReminderWindowChB.isSelected() || this.mFrameRemindersChB.isSelected());
        this.mCloseOnTime = new JRadioButton(LOCALIZER.ellipsisMsg("autoCloseAfterTime", "After time"), this.mSettings.isAutoCloseOnTime());
        this.mCloseOnTime.setEnabled(this.mReminderWindowChB.isSelected() || this.mFrameRemindersChB.isSelected());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mCloseOnEnd);
        bg.add(this.mCloseNever);
        bg.add(this.mCloseOnTime);
        this.mAutoCloseReminderTimeSp = new JSpinner(new SpinnerNumberModel(autoCloseReminderTime, autoCloseReminderTime < 5 ? 1 : 5, 600, 1));
        this.mAutoCloseReminderTimeSp.setEnabled(this.mCloseOnTime.isSelected() && (this.mReminderWindowChB.isSelected() || this.mFrameRemindersChB.isSelected()));
        this.mShowTimeCounter = new JCheckBox(LOCALIZER.msg("showTimeCounter", "Show time counter"), this.mSettings.isSet("showTimeCounter"));
        this.mShowTimeCounter.setEnabled(!this.mCloseNever.isSelected() && (this.mReminderWindowChB.isSelected() || this.mFrameRemindersChB.isSelected()));
        EnhancedPanelBuilder autoClosePanel = new EnhancedPanelBuilder(new FormLayout("12dlu,default,2dlu,default:grow"), "2dlu");
        autoClosePanel.addRowFull(false, (Component)this.mCloseOnEnd);
        autoClosePanel.addRowFull(this.mCloseNever);
        autoClosePanel.addRowFull(this.mCloseOnTime);
        autoClosePanel.addRow(this.mAutoCloseReminderTimeSp, 2);
        JLabel secondsLabel = autoClosePanel.labelAdd(LOCALIZER.msg("seconds", "seconds (0 = off)"), 4);
        autoClosePanel.addRowFull("10dlu,default", (Component)this.mShowTimeCounter);
        secondsLabel.setEnabled(this.mCloseOnTime.isSelected() && this.mReminderWindowChB.isSelected());
        String defaultReminderEntryStr = this.mSettings.get("defaultReminderEntry");
        this.mDefaultReminderEntryList = new JComboBox<RemindValue>(ReminderConstants.REMIND_BEFORE_VALUE_ARR);
        if (defaultReminderEntryStr != null) {
            try {
                int inx = Integer.parseInt(defaultReminderEntryStr);
                if (inx < 0) {
                    inx = 0;
                }
                if (inx < ReminderConstants.REMIND_BEFORE_VALUE_ARR.length) {
                    this.mDefaultReminderEntryList.setSelectedIndex(inx);
                }
            }
            catch (NumberFormatException inx) {
                // empty catch block
            }
        }
        this.mShowTimeSelectionDlg = new JCheckBox(LOCALIZER.msg("showTimeSelectionDialog", "Show time selection dialog"));
        this.mShowTimeSelectionDlg.setSelected(this.mSettings.isSet("showTimeSelectionDialog"));
        this.mShowRemovedDlg = new JCheckBox(LOCALIZER.msg("showRemovedDialog", "Show removed reminders after data update"));
        this.mShowRemovedDlg.setSelected(this.mSettings.isSet("showRemovedDialog"));
        this.mShowDateSeparators = new JCheckBox(LOCALIZER.msg("showDateSeparators", "Show date separator in program list"));
        this.mShowDateSeparators.setSelected(ReminderPlugin.getInstance().showDateSeparators());
        this.mProvideTab = new JCheckBox(LOCALIZER.msg("provideTab", "Provide tab in TV-Browser main window"));
        this.mProvideTab.setSelected(this.mSettings.isSet("provideTab"));
        this.mStickyReminders = new JCheckBox(LOCALIZER.msg("stickyReminders", "Sticky reminders"));
        this.mStickyReminders.setSelected(this.mSettings.isSet("stickyReminders"));
        this.mStickyMinutes = new JSpinner(new SpinnerNumberModel(this.mSettings.getAsInt("stickyMinutes"), 5, 30, 1));
        this.mStickyMinutes.setEnabled(this.mStickyReminders.isSelected());
        EnhancedPanelBuilder filter = new EnhancedPanelBuilder(new FormLayout("default,5dlu,default,0dlu:grow"), "2dlu");
        JPanel sticky = new JPanel((LayoutManager)new FormLayout("10dlu,default,2dlu,default,2dlu,default", "default"));
        JLabel stickyLabel1 = new JLabel(LOCALIZER.msg("stickyReminders.label", "Keep reminders for moved programs of around maximum"));
        stickyLabel1.setEnabled(this.mStickyReminders.isSelected());
        JLabel stickyLabel2 = new JLabel(Localizer.getLocalization("i18n_minutes"));
        stickyLabel2.setEnabled(this.mStickyReminders.isSelected());
        sticky.add((Component)stickyLabel1, CC.xy((int)2, (int)1));
        sticky.add((Component)this.mStickyMinutes, CC.xy((int)4, (int)1));
        sticky.add((Component)stickyLabel2, CC.xy((int)6, (int)1));
        this.mStickyReminders.addItemListener(e -> {
            this.mStickyMinutes.setEnabled(e.getStateChange() == 1);
            stickyLabel1.setEnabled(this.mStickyMinutes.isEnabled());
            stickyLabel2.setEnabled(this.mStickyMinutes.isEnabled());
        });
        filter.addRow(false, (Component)this.mPrefilter, 1);
        filter.add(editFilter, 3);
        filter.addRowFull(helpPrefilter);
        JPanel reminderEntry = new JPanel(new FlowLayout(3, 0, 0));
        reminderEntry.add(this.mDefaultReminderEntryList);
        this.mScrollTimeToNext = new JRadioButton(LOCALIZER.msg("timeButtonScrollNext", "Scroll to next occurence of time from shown programs onward"), this.mSettings.isSet("scrollTimeTypeNext"));
        this.mScrollTimeOnDay = new JRadioButton(LOCALIZER.msg("timeButtonScrollDay", "Scroll to occurence of time on shown day in list"), !this.mScrollTimeToNext.isSelected());
        JLabel scrollTimeLabel = new JLabel(LOCALIZER.msg("timeButtonBehaviour", "Time buttons behaviour:"));
        this.mScrollTimeToNext.setEnabled(this.mProvideTab.isSelected());
        this.mScrollTimeOnDay.setEnabled(this.mProvideTab.isSelected());
        scrollTimeLabel.setEnabled(this.mProvideTab.isSelected());
        ButtonGroup time = new ButtonGroup();
        time.add(this.mScrollTimeToNext);
        time.add(this.mScrollTimeOnDay);
        EnhancedPanelBuilder timeButtonBehaviour = new EnhancedPanelBuilder(new FormLayout("10dlu,default:grow"));
        timeButtonBehaviour.addRow(scrollTimeLabel, 2);
        timeButtonBehaviour.addRow(this.mScrollTimeToNext, 2);
        timeButtonBehaviour.addRow(this.mScrollTimeOnDay, 2);
        this.mProvideTab.addItemListener(e -> {
            scrollTimeLabel.setEnabled(e.getStateChange() == 1);
            this.mScrollTimeToNext.setEnabled(scrollTimeLabel.isEnabled());
            this.mScrollTimeOnDay.setEnabled(scrollTimeLabel.isEnabled());
        });
        pb.addSeparatorRowFull(false, LOCALIZER.msg("remindBy", "Remind me by"));
        pb.addRow(frameRemindersCfg, 2, 6);
        pb.addRow(reminderWindowCfg, 2, 6);
        pb.addRow("1dlu,default", (Component)this.mSoundFileChB, 2, 4);
        pb.add(this.mSoundFileChB.getButton(), 7);
        pb.add(soundTestBt, 9);
        pb.addRow("1dlu,default", (Component)this.mBeep, 2);
        pb.addRow("1dlu,default", (Component)this.mExecChB, 2, 4);
        pb.add(this.mExecFileDialogBtn, 7, 3);
        pb.addParagraph(LOCALIZER.msg("prefilterLabel", "Prefiltering of Reminders"));
        pb.addRowFull(filter.getPanel(), 2);
        pb.addParagraph(LOCALIZER.msg("sendToPlugin", "Send reminded program to"));
        pb.addRowFull(this.mPluginTargetSelectionPanel);
        JLabel c = (JLabel)pb.addParagraph(LOCALIZER.msg("autoCloseReminder", "Automatically close reminder")).getComponent(0);
        c.setEnabled(this.mReminderWindowChB.isSelected() || this.mFrameRemindersChB.isSelected());
        pb.addRow(autoClosePanel.getPanel(), 2, 5);
        pb.addParagraph(LOCALIZER.msg("defaltReminderEntry", "Default reminder time"));
        pb.addRow(reminderEntry, 2, 4);
        pb.addParagraph(LOCALIZER.msg("miscSettings", "Misc settings"));
        pb.addRow(this.mShowTimeSelectionDlg, 2, 7);
        pb.addRow("3dlu,default", (Component)this.mShowRemovedDlg, 2, 7);
        pb.addRow("3dlu,default", (Component)this.mShowDateSeparators, 2, 7);
        pb.addRow("3dlu,default", (Component)this.mProvideTab, 2, 7);
        pb.addRow(false, (Component)timeButtonBehaviour.getPanel(), 2, 7);
        pb.addRow(this.mStickyReminders, 2, 7);
        pb.addRow(sticky, 2, 7);
        pb.addParagraph(DefaultMarkingPrioritySelectionPanel.getTitle());
        this.mMarkingsPanel = DefaultMarkingPrioritySelectionPanel.createPanel(ReminderPlugin.getInstance().getMarkPriority(), false, false);
        pb.addRowFull(this.mMarkingsPanel, 2);
        this.mFrameRemindersChB.addItemListener(e -> {
            if (e.getStateChange() == 1 && this.mReminderWindowChB.isSelected()) {
                this.mReminderWindowChB.setSelected(false);
            }
            this.mFrameRemindersCloseIfEmptry.setEnabled(e.getStateChange() == 1);
            this.mFrameRemindersToFrontOnAdd.setEnabled(e.getStateChange() == 1);
            this.mFrameRemindersAutoResizeEnabled.setEnabled(e.getStateChange() == 1);
            this.mFrameRemindersAutoResizeTypeTop.setEnabled(e.getStateChange() == 1 && this.mFrameRemindersAutoResizeEnabled.isSelected());
            this.mFrameRemindersAutoResizeTypeBottom.setEnabled(e.getStateChange() == 1 && this.mFrameRemindersAutoResizeEnabled.isSelected());
            c.setEnabled(e.getStateChange() == 1 || this.mReminderWindowChB.isSelected());
            secondsLabel.setEnabled((e.getStateChange() == 1 || this.mReminderWindowChB.isSelected()) && this.mCloseOnTime.isSelected());
            this.mCloseOnEnd.setEnabled(e.getStateChange() == 1 || this.mReminderWindowChB.isSelected());
            this.mCloseNever.setEnabled(e.getStateChange() == 1 || this.mReminderWindowChB.isSelected());
            this.mCloseOnTime.setEnabled(e.getStateChange() == 1 || this.mReminderWindowChB.isSelected());
            this.mShowTimeCounter.setEnabled((e.getStateChange() == 1 || this.mReminderWindowChB.isSelected()) && !this.mCloseNever.isSelected());
            this.mAutoCloseReminderTimeSp.setEnabled((e.getStateChange() == 1 || this.mReminderWindowChB.isSelected()) && this.mCloseOnTime.isSelected());
        });
        this.mFrameRemindersAutoResizeEnabled.addItemListener(e -> {
            this.mFrameRemindersAutoResizeTypeTop.setEnabled(e.getStateChange() == 1 && this.mFrameRemindersChB.isSelected());
            this.mFrameRemindersAutoResizeTypeBottom.setEnabled(e.getStateChange() == 1 && this.mFrameRemindersChB.isSelected());
        });
        this.mReminderWindowChB.addItemListener(e -> {
            this.mShowAlwaysOnTop.setEnabled(e.getStateChange() == 1);
            if (e.getStateChange() == 1 && this.mFrameRemindersChB.isSelected()) {
                this.mFrameRemindersChB.setSelected(false);
            }
            for (int i = 0; i < this.mReminderWindowPosition.length; ++i) {
                this.mReminderWindowPosition[i].setEnabled(e.getStateChange() == 1);
            }
            posLabel.setEnabled(e.getStateChange() == 1);
            c.setEnabled(e.getStateChange() == 1 || this.mFrameRemindersChB.isSelected());
            secondsLabel.setEnabled((e.getStateChange() == 1 || this.mFrameRemindersChB.isSelected()) && this.mCloseOnTime.isSelected());
            this.mCloseOnEnd.setEnabled(e.getStateChange() == 1 || this.mFrameRemindersChB.isSelected());
            this.mCloseNever.setEnabled(e.getStateChange() == 1 || this.mFrameRemindersChB.isSelected());
            this.mCloseOnTime.setEnabled(e.getStateChange() == 1 || this.mFrameRemindersChB.isSelected());
            this.mShowTimeCounter.setEnabled((e.getStateChange() == 1 || this.mFrameRemindersChB.isSelected()) && !this.mCloseNever.isSelected());
            this.mAutoCloseReminderTimeSp.setEnabled((e.getStateChange() == 1 || this.mFrameRemindersChB.isSelected()) && this.mCloseOnTime.isSelected());
        });
        soundTestBt.addActionListener(evt -> {
            if (evt.getActionCommand().compareTo(LOCALIZER.msg("test", "Test")) == 0) {
                this.mTestSound = ReminderPlugin.playSound(this.mSoundFileChB.getTextField().getText());
                if (this.mTestSound != null) {
                    soundTestBt.setText(LOCALIZER.msg("stop", "Stop"));
                }
                if (this.mTestSound != null) {
                    if (this.mTestSound instanceof SourceDataLine) {
                        ((SourceDataLine)this.mTestSound).addLineListener(new LineListener(){

                            @Override
                            public void update(LineEvent event) {
                                if (event.getType() == LineEvent.Type.CLOSE || event.getType() == LineEvent.Type.STOP) {
                                    soundTestBt.setText(LOCALIZER.msg("test", "Test"));
                                }
                            }
                        });
                    } else if (this.mTestSound instanceof Sequencer) {
                        new Thread("Test MIDI sound"){

                            @Override
                            public void run() {
                                this.setPriority(1);
                                while (((Sequencer)ReminderSettingsTab.this.mTestSound).isRunning()) {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (Exception exception) {}
                                }
                                soundTestBt.setText(LOCALIZER.msg("test", "Test"));
                            }
                        }.start();
                    }
                }
            } else if (this.mTestSound != null) {
                if (this.mTestSound instanceof SourceDataLine && ((SourceDataLine)this.mTestSound).isRunning()) {
                    ((SourceDataLine)this.mTestSound).stop();
                } else if (this.mTestSound instanceof Sequencer && ((Sequencer)this.mTestSound).isRunning()) {
                    ((Sequencer)this.mTestSound).stop();
                }
            }
        });
        this.mSoundFileChB.getCheckBox().addActionListener(e -> soundTestBt.setEnabled(this.mSoundFileChB.isSelected()));
        this.mSoundFileChB.getTextField().addKeyListener(new KeyAdapter((String[])extArr, soundTestBt){
            final /* synthetic */ String[] val$extArr;
            final /* synthetic */ JButton val$soundTestBt;
            {
                this.val$extArr = stringArray;
                this.val$soundTestBt = jButton;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String text = ReminderSettingsTab.this.mSoundFileChB.getTextField().getText();
                if (new File(text).isFile()) {
                    boolean notFound = true;
                    for (String extension : this.val$extArr) {
                        if (!StringUtils.endsWithIgnoreCase((CharSequence)text, (CharSequence)extension)) continue;
                        notFound = false;
                        break;
                    }
                    if (notFound) {
                        this.val$soundTestBt.setEnabled(false);
                    } else {
                        this.val$soundTestBt.setEnabled(true);
                    }
                } else {
                    this.val$soundTestBt.setEnabled(false);
                }
            }
        });
        this.mSoundFileChB.getTextField().getKeyListeners()[0].keyReleased(null);
        this.mExecChB.addActionListener(e -> {
            this.mExecFileDialogBtn.setEnabled(this.mExecChB.isSelected());
            if (this.mExecFileDialogBtn.isEnabled()) {
                this.showFileSettingsDialog();
            }
        });
        this.mExecFileDialogBtn.addActionListener(e -> this.showFileSettingsDialog());
        ItemListener autoCloseListener = e -> {
            this.mAutoCloseReminderTimeSp.setEnabled(this.mCloseOnTime.isSelected());
            secondsLabel.setEnabled(this.mCloseOnTime.isSelected());
            this.mShowTimeCounter.setEnabled(this.mCloseOnTime.isSelected() || this.mCloseOnEnd.isSelected());
        };
        this.mCloseOnEnd.addItemListener(autoCloseListener);
        this.mCloseOnTime.addItemListener(autoCloseListener);
        this.mCloseOnTime.addItemListener(e -> this.mShowTimeCounter.setEnabled(e.getStateChange() == 1));
        return pb.getPanel();
    }

    private void showFileSettingsDialog() {
        Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        ExecuteSettingsDialog execSettingsDialog = new ExecuteSettingsDialog(parent, this.mExecFileStr, this.mExecParamStr);
        execSettingsDialog.setVisible(true);
        if (execSettingsDialog.wasOKPressed()) {
            this.mExecFileStr = execSettingsDialog.getExecutable();
            this.mExecParamStr = execSettingsDialog.getParameters();
        }
    }

    @Override
    public void saveSettings() {
        this.mSettings.set("soundfile", this.mSoundFileChB.getTextField().getText());
        this.mSettings.set("execfile", this.mExecFileStr);
        this.mSettings.set("execparam", this.mExecParamStr);
        this.mSettings.set("showFrameReminders", this.mFrameRemindersChB.isSelected());
        this.mSettings.set("frameRemindersToFrontOnAdd", this.mFrameRemindersToFrontOnAdd.isSelected());
        this.mSettings.set("autoCloseFrameRemindersIfEmpty", this.mFrameRemindersCloseIfEmptry.isSelected());
        this.mSettings.set("autoResizeEnabled", this.mFrameRemindersAutoResizeEnabled.isSelected());
        this.mSettings.set("typeAutoResize", this.mFrameRemindersAutoResizeTypeTop.isSelected() ? "top" : "bottom");
        FrameReminders update = FrameReminders.getInstance(false);
        if (update != null) {
            update.updateWindowSettings();
        }
        this.mSettings.set("usemsgbox", this.mReminderWindowChB.isSelected());
        this.mSettings.set("usesound", this.mSoundFileChB.isSelected());
        this.mSettings.set("usebeep", this.mBeep.isSelected());
        this.mSettings.set("useexec", this.mExecChB.isSelected());
        this.mSettings.set("prefilter", this.mPrefilter.isSelected() && !GenericFilterMap.getInstance().getGenericInternalFilter("_reminderPrefilter").getRule().isBlank());
        ReminderPlugin.getInstance().setClientPluginsTargets(this.mPluginTargetSelectionPanel.getCurrentSelection());
        this.mSettings.set("autoCloseBehaviour", this.mCloseOnEnd.isSelected() ? "onEnd" : (this.mCloseNever.isSelected() ? "never" : "onTime"));
        this.mSettings.set("autoCloseReminderTime", this.mAutoCloseReminderTimeSp.getValue().toString());
        this.mSettings.set("defaultReminderEntry", this.mDefaultReminderEntryList.getSelectedIndex());
        this.mSettings.set("showTimeSelectionDialog", this.mShowTimeSelectionDlg.isSelected());
        this.mSettings.set("showRemovedDialog", this.mShowRemovedDlg.isSelected());
        this.mSettings.set("showTimeCounter", !this.mCloseNever.isSelected() && this.mShowTimeCounter.isSelected());
        this.mSettings.set("alwaysOnTop", this.mShowAlwaysOnTop.isSelected());
        this.mSettings.set("provideTab", this.mProvideTab.isSelected());
        this.mSettings.set("stickyReminders", this.mStickyReminders.isSelected());
        this.mSettings.set("stickyMinutes", this.mStickyMinutes.getValue().toString());
        this.mSettings.set("scrollTimeTypeNext", this.mScrollTimeToNext.isSelected());
        for (int i = 0; i < this.mReminderWindowPosition.length; ++i) {
            if (!this.mReminderWindowPosition[i].isSelected()) continue;
            this.mSettings.set("reminderWindowPosition", i);
            break;
        }
        ReminderPlugin.getInstance().setShowDateSeparators(this.mShowDateSeparators.isSelected());
        ReminderPlugin.getInstance().setMarkPriority(this.mMarkingsPanel.getSelectedPriority());
        ReminderPlugin.getInstance().addPanel();
        Thread saveThread = new Thread("Save reminders"){

            @Override
            public void run() {
                ReminderPlugin.getInstance().saveReminders();
            }
        };
        saveThread.setPriority(1);
        saveThread.start();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "appointment", 16);
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("tabName", "Reminder");
    }
}

