/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import util.i18n.Localizer;
import util.ui.UiUtilities;

public class DontShowAgainOptionBox {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DontShowAgainOptionBox.class);

    public static int showOptionDialog(String messageBoxId, Component parent, Object message, String title, int messageType, int optionType, Object[] options, Object initialValue, String dontShowAgainLabel) {
        if (Settings.Other.MESSAGE_BOXES_HIDDEN.containsItem(messageBoxId)) {
            return 0;
        }
        JCheckBox askAgain = new JCheckBox(dontShowAgainLabel == null ? mLocalizer.msg("dontShowAgain", "Don't show this message again") : dontShowAgainLabel);
        ArrayList<Object> shownObjects = new ArrayList<Object>();
        if (message.getClass().isArray()) {
            Object[] arr;
            for (Object o : arr = (Object[])message) {
                shownObjects.add(o);
            }
        } else {
            shownObjects.add(message);
        }
        if (!(shownObjects.get(shownObjects.size() - 1) instanceof String) || !((String)shownObjects.get(shownObjects.size() - 1)).endsWith("\n\n")) {
            shownObjects.add("\n");
        }
        shownObjects.add(askAgain);
        int result = UiUtilities.showOptionDialogOnBestScreen(parent, shownObjects.toArray(), title, optionType, messageType, null, options, initialValue);
        if (askAgain.isSelected()) {
            Settings.Other.MESSAGE_BOXES_HIDDEN.addItem(messageBoxId);
        }
        return result;
    }

    public static int showOptionDialog(String messageBoxId, Component parent, String message, String title, int messageType, int optionType, Object[] options, Object initialValue, String dontShowAgainLabel) {
        return DontShowAgainOptionBox.showOptionDialog(messageBoxId, parent, (Object)message, title, messageType, optionType, options, initialValue, dontShowAgainLabel);
    }

    public static int showOptionDialog(String messageBoxId, Component parent, String message, String title, int messageType) {
        return DontShowAgainOptionBox.showOptionDialog(messageBoxId, parent, message, title, messageType, -1, null, null, null);
    }

    public static int showOptionDialog(String messageBoxId, Component parent, Object message, String title, int messageType) {
        return DontShowAgainOptionBox.showOptionDialog(messageBoxId, parent, message, title, messageType, -1, null, null, null);
    }

    public static int showOptionDialog(String messageBoxId, Component parent, String message, String title, int messageType, int optionType) {
        return DontShowAgainOptionBox.showOptionDialog(messageBoxId, parent, message, title, messageType, optionType, null, null, null);
    }

    public static int showOptionDialog(String messageBoxId, Component parentComponent, String message, String title) {
        return DontShowAgainOptionBox.showOptionDialog(messageBoxId, parentComponent, message, title, 1);
    }

    public static int showOptionDialog(String messageBoxId, Component parentComponent, String message) {
        return DontShowAgainOptionBox.showOptionDialog(messageBoxId, parentComponent, message, UIManager.getString("OptionPane.messageDialogTitle"));
    }

    public static boolean isHiddenMessageBox(String messageBoxId) {
        return Settings.Other.MESSAGE_BOXES_HIDDEN.containsItem(messageBoxId);
    }
}

