/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.ui.filter.dlgs.FilterComponentPanel;
import tvbrowser.ui.filter.dlgs.FilterHighlightingSelectionPanel;
import tvbrowser.ui.filter.dlgs.FilterItem;
import tvbrowser.ui.filter.dlgs.Utilities;
import util.i18n.Localizer;
import util.ui.DragAndDropMouseListener;
import util.ui.EnhancedPanelBuilder;
import util.ui.FilterSelectionPanel;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class EditFilterDlg
extends JDialog
implements ActionListener,
DocumentListener,
CaretListener,
WindowClosingIf,
ListDropAction<FilterItem> {
    static final Localizer LOCALIZER = Localizer.getLocalizerFor(EditFilterDlg.class);
    static final Localizer FILTER_LOCALIZER = Localizer.getLocalizerFor(UserFilter.class);
    private Window mParent;
    private JTextField mFilterNameTF;
    private JTextField mFilterRuleTF;
    private UserFilter mFilter = null;
    private JLabel mFilterRuleErrorLb;
    private JLabel mColLb;
    private String mFilterName = null;
    private FilterList mFilterList;
    private JList<FilterItem> mFilterConstruction;
    private FilterComponentPanel mFilterComponent;
    private FilterHighlightingSelectionPanel mFilterHighlight;
    private DefaultListModel<FilterItem> mFilterConstructionListModel;
    private boolean mFromFilterList;
    private boolean mOkWasPressed;
    private JButton mOkBtn;
    private JButton mCancelBtn;

    public EditFilterDlg(Window parent, FilterList filterList, UserFilter filter, boolean fromFilterList) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(parent, filterList, filter, fromFilterList);
    }

    private void init(Window parent, FilterList filterList, UserFilter filter, boolean fromFilterList) {
        UiUtilities.registerForClosing(this);
        try {
            this.mFromFilterList = fromFilterList;
            this.mOkWasPressed = false;
            if (filter == null) {
                this.setTitle(LOCALIZER.msg("titleNew", "Create filter"));
            } else {
                this.setTitle(LOCALIZER.msg("titleEdit", "Edit filter {0}", fromFilterList ? filter.toString() : "").replaceAll("\\s+", " "));
                this.mFilterName = filter.toString();
            }
            this.mFilterList = filterList;
            this.mParent = parent;
            this.mFilter = filter;
            this.mFilterNameTF = new JTextField(new PlainDocument(){

                @Override
                public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                    str = str.replaceAll("[\\p{Punct}&&[^_]]", "_");
                    super.insertString(offset, str, a);
                }
            }, "", 30);
            this.mFilterNameTF.getDocument().addDocumentListener(this);
            this.mFilterNameTF.setEditable(fromFilterList);
            this.mFilterRuleTF = new JTextField();
            this.mFilterRuleTF.getDocument().addDocumentListener(this);
            this.mFilterRuleTF.addCaretListener(this);
            this.mFilterHighlight = new FilterHighlightingSelectionPanel(this.mFilter);
            ButtonBarBuilder bottomBar = Utilities.createFilterButtonBar();
            this.mOkBtn = new JButton(Localizer.getLocalization("i18n_ok"));
            this.mOkBtn.addActionListener(this);
            this.getRootPane().setDefaultButton(this.mOkBtn);
            this.mCancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
            this.mCancelBtn.addActionListener(this);
            bottomBar.addButton((JComponent[])new JButton[]{this.mOkBtn, this.mCancelBtn});
            this.mFilterComponent = new FilterComponentPanel(this, this.mFilterRuleTF, this.mFilter);
            this.mFilterConstructionListModel = new DefaultListModel();
            this.mFilterConstruction = new JList<FilterItem>(this.mFilterConstructionListModel);
            this.mFilterConstruction.setSelectionMode(0);
            this.mFilterConstruction.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    try {
                        if (label.getBorder() != null && label.getBorder().getClass().getName().contains("GTKPainter$ListTableFocusBorder")) {
                            label.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
                        }
                        if (value instanceof FilterItem) {
                            FilterItem item = (FilterItem)value;
                            FormLayout layout = new FormLayout("default:grow", "default");
                            for (int i = 0; i < item.getLevel(); ++i) {
                                layout.insertColumn(1, ColumnSpec.decode((String)"9dlu"));
                            }
                            JPanel panel = new JPanel((LayoutManager)layout);
                            panel.setOpaque(isSelected);
                            if (isSelected) {
                                panel.setBackground(list.getSelectionBackground());
                                label.setForeground(list.getSelectionForeground());
                            } else {
                                panel.setBackground(list.getBackground());
                                label.setForeground(list.getForeground());
                            }
                            label.setOpaque(false);
                            if (item.isAndItem() || item.isOrItem() || item.isNotItem()) {
                                label.setFont(label.getFont().deriveFont(1));
                                layout.insertColumn(1, ColumnSpec.decode((String)"3dlu"));
                                panel.add((Component)label, CC.xy((int)Math.max(1, item.getLevel() + 2), (int)1));
                            } else if (item.isOpenBracketItem() || item.isCloseBracketItem()) {
                                label.setFont(label.getFont().deriveFont(1));
                                panel.add((Component)label, CC.xy((int)Math.max(1, item.getLevel() + 1), (int)1));
                            } else {
                                panel.add((Component)label, CC.xy((int)Math.max(1, item.getLevel() + 1), (int)1));
                                label.setText(FilterComponentList.getLabelForComponent(item.getComponent(), label.getText()));
                            }
                            if (index > 0) {
                                FilterItem test = (FilterItem)list.getModel().getElementAt(index - 1);
                                FilterItem test2 = null;
                                if (index < list.getModel().getSize() - 2) {
                                    test2 = (FilterItem)list.getModel().getElementAt(index + 1);
                                }
                                if (test.isCloseBracketItem() && !item.isAndItem() && !item.isOrItem() && !item.isCloseBracketItem()) {
                                    label.setForeground(Color.red);
                                } else if (item.isNotItem() && (!test.isAndItem() && !test.isOrItem() || test.isNotItem()) && (test2 == null || test2.getComponent() == null)) {
                                    label.setForeground(Color.red);
                                } else if ((item.isAndItem() || item.isOrItem()) && (test.isAndItem() || test.isOrItem() || test.isOpenBracketItem())) {
                                    label.setForeground(Color.red);
                                } else if (item.getComponent() != null && test2 != null && test2.isNotItem()) {
                                    label.setForeground(Color.red);
                                } else if (!(test2 == null || !test2.isOpenBracketItem() || item.isAndItem() || item.isOrItem() || item.isNotItem() || item.isOpenBracketItem())) {
                                    label.setForeground(Color.red);
                                } else if (index == list.getModel().getSize() - 1 && (item.isAndItem() || item.isNotItem() || item.isOrItem() || item.isOpenBracketItem())) {
                                    label.setForeground(Color.red);
                                } else if (item.getComponent() != null && test.getComponent() != null) {
                                    label.setForeground(Color.red);
                                }
                            }
                            return panel;
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    return label;
                }
            });
            ListDragAndDropHandler dnDHandler = new ListDragAndDropHandler(this.mFilterComponent.getList(), this.mFilterConstruction, this);
            new DragAndDropMouseListener<FilterItem>(this.mFilterComponent.getList(), this.mFilterConstruction, this, dnDHandler, false);
            new DragAndDropMouseListener<FilterItem>(this.mFilterConstruction, this.mFilterComponent.getList(), this, dnDHandler);
            this.mFilterComponent.registerMouseListener();
            EnhancedPanelBuilder listPanel = new EnhancedPanelBuilder(new FormLayout("5dlu,min:grow,5dlu,10dlu,5dlu,min:grow,5dlu"));
            listPanel.addSeparatorRow(false, LOCALIZER.msg("componentsTitle", "Available filter components:"), 5, 3);
            listPanel.add(DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("filterConstruction", "Filter construction")), 1, 3);
            listPanel.addRow("fill:50dlu:grow", (Component)this.mFilterComponent, 6);
            listPanel.add(new JScrollPane(this.mFilterConstruction), 2);
            EnhancedPanelBuilder filterCreation = new EnhancedPanelBuilder(new FormLayout("5dlu,fill:min:grow,5dlu,default,5dlu"));
            filterCreation.border(Borders.DIALOG);
            if (fromFilterList) {
                filterCreation.addSeparatorRowFull(LOCALIZER.msg("filterName", "Filter name:"));
                filterCreation.addRow(this.mFilterNameTF, 2, 3);
                filterCreation.addRow("10dlu", false);
            }
            filterCreation.addSeparatorRowFull(false, LOCALIZER.msg("ruleString", "Filter rule:"));
            filterCreation.addRow(this.mFilterRuleTF, 2);
            this.mColLb = filterCreation.labelAdd("0", 4);
            this.mFilterRuleErrorLb = filterCreation.addLabelRow(false, LOCALIZER.msg("ruleExample", "example: component1 or (component2 and not component3)"), 2);
            filterCreation.addRow("fill:min:grow", (Component)listPanel.getPanel(), 1, 4);
            filterCreation.addRowFull(UiUtilities.createHelpTextArea(LOCALIZER.msg("help", "To create or edit a filter you can enter the rules in the text field or drag and drop the rules to the left side.")), 2);
            filterCreation.addParagraph(LOCALIZER.msg("highlighting", "Highlighting"));
            filterCreation.addRow(this.mFilterHighlight, 1, 4);
            filterCreation.addRowFull(new JSeparator(0));
            filterCreation.addRowFull(bottomBar.getPanel());
            if (this.mFilter != null) {
                this.mFilterName = filter.getName();
                this.mFilterNameTF.setText(this.mFilter.toString());
                this.mFilterRuleTF.setText(this.mFilter.getRule());
                this.fillFilterConstruction();
            }
            this.updateBtns();
            this.setMinimumSize(new Dimension(600, 570));
            this.setLayout(new BorderLayout());
            this.add((Component)filterCreation.getPanel(), "Center");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Settings.layoutWindow("editFilterDlg", this, this.getMinimumSize(), this.mParent);
        this.setVisible(true);
    }

    void updateBtns() {
        boolean validRule;
        boolean bl = validRule = !this.mFilterRuleTF.getText().isBlank();
        if (validRule) {
            try {
                UserFilter.testTokenTree(this.mFilterRuleTF.getText(), false);
                this.mFilterRuleErrorLb.setForeground(UIManager.getColor("Label.foreground"));
                this.mFilterRuleErrorLb.setText(LOCALIZER.msg("ruleExample", "example: component1 or (component2 and not component3)"));
            }
            catch (ParserException e) {
                this.mFilterRuleErrorLb.setForeground(Color.red);
                this.mFilterRuleErrorLb.setText(e.getMessage());
                validRule = false;
            }
            if (this.mFilterRuleTF.hasFocus()) {
                this.fillFilterConstruction();
            }
        }
        this.mOkBtn.setEnabled(StringUtils.isNotBlank((CharSequence)this.mFilterNameTF.getText().strip()) && !this.mFilterNameTF.getText().strip().equals(FilterSelectionPanel.getNewFilterName()) && this.mFilterComponent.getList().getModel().getSize() > 0 && validRule);
        this.mFilterHighlight.setEnabled(this.mOkBtn.isEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.mOkBtn) {
            String filterName = this.mFilterNameTF.getText().strip();
            String filterRule = this.mFilterRuleTF.getText().strip();
            boolean bl = this.mOkWasPressed = this.mFilter == null || !this.mFilter.getName().equals(filterName) || !this.mFilter.getRule().equals(filterRule);
            if (this.mOkWasPressed) {
                if (this.mFromFilterList) {
                    if (!filterName.equalsIgnoreCase(this.mFilterName) && this.mFilterList.containsFilter(filterName)) {
                        JOptionPane.showMessageDialog(this, LOCALIZER.msg("alreadyExists", "Filter '{0}' already exists.", filterName));
                        this.mOkWasPressed = false;
                    } else {
                        if (this.mFilter == null) {
                            this.mFilter = new UserFilter(this.mFilterNameTF.getText());
                        } else {
                            this.mFilter.setName(this.mFilterNameTF.getText());
                        }
                        try {
                            this.mFilter.setRule(this.mFilterRuleTF.getText());
                        }
                        catch (ParserException exc) {
                            this.mOkWasPressed = false;
                            JOptionPane.showMessageDialog(this, LOCALIZER.msg("invalidRule", "Invalid rule: ") + exc.getMessage());
                        }
                    }
                } else {
                    try {
                        this.mFilter.setRule(this.mFilterRuleTF.getText());
                    }
                    catch (ParserException e1) {
                        this.mOkWasPressed = false;
                        JOptionPane.showMessageDialog(this, LOCALIZER.msg("invalidRule", "Invalid rule: ") + e1.getMessage());
                    }
                }
            }
            this.setVisible(false);
            if (this.mFilterComponent.getFilterComponentWasTouched()) {
                FilterComponentList.getInstance().store();
            }
            if (this.mFilterHighlight.wasChanged()) {
                this.mFilterHighlight.save(this.mFilter);
            }
        } else if (o == this.mCancelBtn) {
            if (this.mFilterComponent.getFilterComponentWasTouched()) {
                FilterComponentList.getInstance().store();
            }
            this.setVisible(false);
        }
    }

    public boolean getOkWasPressed() {
        return this.mOkWasPressed;
    }

    public UserFilter getUserFilter() {
        return this.mFilter;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateBtns();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateBtns();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateBtns();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.mColLb.setText("pos: " + this.mFilterRuleTF.getCaretPosition());
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    public boolean checkValueForRuleType(String value, String ruleType) {
        if (ruleType != null) {
            if (ruleType.equals(FilterItem.AND_KEY) && (value.toLowerCase().equals("and") || value.toLowerCase().equals("und"))) {
                return true;
            }
            if (ruleType.equals(FilterItem.OR_KEY) && (value.toLowerCase().equals("or") || value.toLowerCase().equals("oder"))) {
                return true;
            }
            if (ruleType.equals(FilterItem.NOT_KEY) && (value.toLowerCase().equals("not") || value.toLowerCase().equals("nicht"))) {
                return true;
            }
            if (ruleType.equals(FilterItem.OPEN_BRACKET_KEY) && value.toLowerCase().equals("(")) {
                return true;
            }
            if (ruleType.equals(FilterItem.CLOSE_BRACKET_KEY) && value.toLowerCase().equals(")")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void drop(JList<FilterItem> source, JList<FilterItem> target, int row, boolean move) {
        try {
            int i;
            this.mFilterNameTF.requestFocus();
            if (target.equals(this.mFilterConstruction)) {
                if (source.equals(this.mFilterComponent.getList())) {
                    FilterItem value = source.getSelectedValue();
                    ((DefaultListModel)target.getModel()).add(row, value.clone(0));
                    int level = 0;
                    for (int i2 = 0; i2 < target.getModel().getSize(); ++i2) {
                        FilterItem item = target.getModel().getElementAt(i2);
                        if (item.toString().equals("(")) {
                            item.setLevel(level++);
                            continue;
                        }
                        if (item.toString().equals(")")) {
                            --level;
                            level = Math.max(level, 0);
                            item.setLevel(level);
                            continue;
                        }
                        item.setLevel(level);
                    }
                } else {
                    UiUtilities.moveSelectedItems(target, row, false);
                    int level = 0;
                    for (i = 0; i < target.getModel().getSize(); ++i) {
                        FilterItem item = target.getModel().getElementAt(i);
                        if (item.toString().equals("(")) {
                            item.setLevel(level++);
                            continue;
                        }
                        if (item.toString().equals(")")) {
                            --level;
                            level = Math.max(level, 0);
                            item.setLevel(level);
                            continue;
                        }
                        item.setLevel(level);
                    }
                }
            } else if (source.equals(this.mFilterConstruction)) {
                ((DefaultListModel)source.getModel()).remove(source.getSelectedIndex());
                int level = 0;
                for (i = 0; i < source.getModel().getSize(); ++i) {
                    FilterItem item = source.getModel().getElementAt(i);
                    if (item.toString().equals("(")) {
                        item.setLevel(level++);
                        continue;
                    }
                    if (item.toString().equals(")")) {
                        --level;
                        level = Math.max(level, 0);
                        item.setLevel(level);
                        continue;
                    }
                    item.setLevel(level);
                }
            }
            StringBuilder build = new StringBuilder();
            for (i = 0; i < this.mFilterConstruction.getModel().getSize(); ++i) {
                build.append(this.mFilterConstruction.getModel().getElementAt(i).toString()).append(" ");
            }
            if (build.length() > 0) {
                build.delete(build.length() - 1, build.length());
            }
            this.mFilterRuleTF.setText(build.toString());
            if (source != null) {
                source.repaint();
            }
            if (target != null) {
                target.repaint();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void fillFilterConstruction() {
        this.mFilterConstructionListModel.clear();
        ArrayList<String> values = new ArrayList<String>();
        String rule = this.mFilterRuleTF.getText();
        for (int i = rule.length() - 1; i >= 0; --i) {
            if (rule.charAt(i) == ' ') {
                values.add(0, rule.substring(i).trim());
                rule = rule.substring(0, i).trim();
                i = rule.length();
                continue;
            }
            if (rule.charAt(i) != '(' && rule.charAt(i) != ')') continue;
            String test = rule.substring(i + 1).trim();
            if (test.length() > 0) {
                values.add(0, test);
            }
            values.add(0, rule.substring(i, i + 1));
            rule = rule.substring(0, i).trim();
            i = rule.length();
        }
        if (!rule.isEmpty()) {
            values.add(0, rule.trim());
        }
        int level = 0;
        for (String value : values) {
            if (this.checkValueForRuleType(value, FilterItem.AND_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(FilterItem.AND_KEY, level));
            } else if (this.checkValueForRuleType(value, FilterItem.OR_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(FilterItem.OR_KEY, level));
            } else if (this.checkValueForRuleType(value, FilterItem.NOT_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(FilterItem.NOT_KEY, level));
            } else if (this.checkValueForRuleType(value, FilterItem.OPEN_BRACKET_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(FilterItem.OPEN_BRACKET_KEY, level));
                ++level;
            } else if (this.checkValueForRuleType(value, FilterItem.CLOSE_BRACKET_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(FilterItem.CLOSE_BRACKET_KEY, --level));
            } else {
                for (FilterComponent element : FilterComponentList.getInstance().getAvailableFilterComponents()) {
                    if (!element.getName().equals(value)) continue;
                    this.mFilterConstructionListModel.addElement(new FilterItem(element, level));
                }
            }
            level = Math.max(level, 0);
        }
    }

    String getFilterName() {
        return this.mFilterNameTF.getText();
    }

    void repaintFilterConstruction() {
        this.mFilterConstruction.repaint();
    }
}

