/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ChannelFilter;
import devplugin.ContextMenuSeparatorAction;
import devplugin.Date;
import devplugin.PluginInfo;
import devplugin.ProgramFilter;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import tvbrowser.TVBrowser;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.filters.ChannelFilterList;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.ButtonActionIf;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.filter.dlgs.EditFilterComponentDlg;
import tvbrowser.ui.filter.dlgs.FilterButtons;
import tvbrowser.ui.licensebox.LicenseBox;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.MenuHelpTextAdapter;
import tvbrowser.ui.mainframe.actions.TVBrowserAction;
import tvbrowser.ui.mainframe.actions.TVBrowserActions;
import tvbrowser.ui.mainframe.toolbar.ContextMenu;
import tvbrowser.ui.settings.ToolBarDragAndDropSettings;
import tvdataservice.MarkedProgramsMap;
import util.browserlauncher.Launch;
import util.exc.TvBrowserException;
import util.i18n.Localizer;
import util.misc.OperatingSystem;
import util.ui.FixedSizeIcon;
import util.ui.ImageIconEnhanced;
import util.ui.ScrollableMenu;
import util.ui.TVBrowserIcons;
import util.ui.UIThreadRunner;
import util.ui.UiUtilities;
import util.ui.persona.Persona;

public abstract class MenuBar
extends JMenuBar
implements ActionListener {
    public static final Localizer mLocalizer = Localizer.getLocalizerFor(MainFrame.class);
    private MainFrame mMainFrame;
    protected JMenuItem mQuitMI;
    protected JMenuItem mRestartMI;
    protected JMenuItem mToolbarMI;
    protected JMenuItem mSettingsMI;
    protected JMenuItem mAboutMI;
    protected JMenuItem mDebugMI;
    protected JMenuItem mDonateMI;
    protected JMenuItem mOpenSettingsMI;
    protected JMenu mPluginsMenu;
    protected JMenu mHelpMenu;
    protected JMenu mEditMenu;
    private JMenuItem mStatusbarMI;
    private JMenuItem mTimeBtnsMI;
    private JMenuItem mDatelistMI;
    private JMenuItem mChannellistMI;
    private JMenuItem mPluginOverviewMI;
    private JMenuItem mViewFilterBarMI;
    private JMenuItem mPluginManagerMI;
    private JMenuItem mInstallPluginsMI;
    private JMenuItem mDonorMI;
    private JMenuItem mFaqMI;
    private JMenuItem mBackupMI;
    private JMenuItem mForumMI;
    private JMenuItem mWebsiteMI;
    private JMenuItem mHandbookMI;
    private JMenuItem mDownloadMI;
    private JMenuItem mConfigAssistantMI;
    private JMenuItem mKeyboardShortcutsMI;
    private JMenuItem mEditTimeButtonsMenuItem;
    private JMenuItem mToolbarCustomizeMI;
    private JMenuItem mFullscreenMI;
    private JMenuItem mPluginInfoDlgMI;
    private JMenuItem mCopySettingsToSystem;
    private JMenuItem mMenubarMI;
    private JMenu mFiltersMenu;
    private JMenu mLicenseMenu;
    private JMenu mGoMenu;
    private JMenu mViewMenu;
    private JMenu mToolbarMenu;
    private JMenu mPluginHelpMenu;
    private JMenu mGotoDateMenu;
    private JMenu mGotoChannelMenu;
    private JMenu mGotoTimeMenu;
    private JMenu mFontSizeMenu;
    private JMenu mColumnWidthMenu;
    private JMenu mChannelGroupMenu;
    private boolean mCopySettingsRequested = false;
    private JLabel mLabel;
    private Border mDefaultBorder = this.getBorder();
    private Thread mInitializeThread;

    protected MenuBar(MainFrame mainFrame, JLabel label) {
        this.mMainFrame = mainFrame;
        this.mLabel = label;
        this.createNeededMenuItems();
        this.mInitializeThread = new Thread("MENU BAR INITIALIZE THREAD"){

            @Override
            public void run() {
                MenuBar.this.createMenuItems();
            }
        };
        this.mInitializeThread.start();
    }

    private void createNeededMenuItems() {
        this.mSettingsMI = this.createMenuItem(TVBrowserActions.settings);
        this.mQuitMI = this.createMenuItem("menuitem.exit", "Exit", TVBrowserIcons.quit(16));
        this.mQuitMI.addActionListener(this);
        this.mRestartMI = this.createMenuItem("menuitem.restart", "Restart", TVBrowserIcons.restart(16));
        this.mRestartMI.addActionListener(this);
        this.mGoMenu = this.createMenu("menu.go", "Go", true);
        this.mViewMenu = this.createMenu("menu.view", "View", true);
        this.mToolbarMenu = this.createMenu("menuitem.viewToolbar", "Toolbar");
        this.mChannelGroupMenu = this.createMenu("menuitem.channelgroup", "Channel group");
        this.mGotoDateMenu = this.createMenu("menuitem.date", "date");
        this.mGotoTimeMenu = this.createMenu("menuitem.time", "time");
        this.mPluginHelpMenu = this.createMenu("menuitem.pluginHelp", "Plugin help");
        this.mFontSizeMenu = this.createMenu("menuitem.fontSize", "Font size");
        this.mColumnWidthMenu = this.createMenu("menuitem.columnWidth", "ColumnWidth");
        this.mFiltersMenu = this.createScrollableMenu("menuitem.filters", "Filter");
        this.mLicenseMenu = this.createLicenseMenuItems();
    }

    protected MainFrame getMainFrame() {
        return this.mMainFrame;
    }

    public JLabel getLabel() {
        return this.mLabel;
    }

    public void showUpdateMenuItem() {
    }

    public void showStopMenuItem() {
    }

    private void createMenuItems() {
        MenuHelpTextAdapter.create(this.mQuitMI, mLocalizer.msg("menuinfo.quit", ""), this.mLabel);
        MenuHelpTextAdapter.create(this.mRestartMI, mLocalizer.msg("menuinfo.restart", ""), this.mLabel);
        this.mToolbarMI = new JCheckBoxMenuItem(ToolBarDragAndDropSettings.LOCALIZER.msg("showToolbar", "Show toolbar"));
        this.mToolbarMI.setSelected(Settings.ToolBar.IS_VISIBLE.getBoolean());
        this.mToolbarMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mToolbarMI, mLocalizer.msg("menuinfo.toolbar", ""), this.mLabel);
        this.mMenubarMI = new JCheckBoxMenuItem(ContextMenu.mLocalizer.msg("showMenubar", "Show menubar"));
        this.mMenubarMI.setSelected(Settings.Window.MENU_BAR_VISIBLE.getBoolean());
        this.mMenubarMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mMenubarMI, mLocalizer.msg("menuinfo.menuBar", ""), this.mLabel);
        this.mToolbarCustomizeMI = new JMenuItem(ContextMenu.mLocalizer.ellipsisMsg("configure", "Configure"));
        this.mToolbarCustomizeMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mToolbarCustomizeMI, mLocalizer.msg("menuinfo.customizeToolbar", ""), this.mLabel);
        if (!OperatingSystem.isMacOs() || TVBrowser.isTransportable()) {
            this.mToolbarMenu.add(this.mMenubarMI);
            this.mMenubarMI.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        }
        this.mToolbarMenu.add(this.mToolbarMI);
        this.mToolbarMenu.addSeparator();
        this.mToolbarMenu.add(this.mToolbarCustomizeMI);
        this.mStatusbarMI = this.createCheckBoxItem("menuitem.viewStatusbar", "Statusbar");
        this.mStatusbarMI.setSelected(Settings.Window.STATUS_BAR_VISIBLE.getBoolean());
        this.mStatusbarMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mStatusbarMI, mLocalizer.msg("menuinfo.statusbar", ""), this.mLabel);
        this.mTimeBtnsMI = this.createCheckBoxItem("menuitem.timebuttons", "Time buttons");
        this.mTimeBtnsMI.setSelected(Settings.Window.TIME_BUTTONS_SHOW.getBoolean());
        this.mTimeBtnsMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mTimeBtnsMI, mLocalizer.msg("menuinfo.timebuttons", ""), this.mLabel);
        this.mDatelistMI = this.createCheckBoxItem("menuitem.datelist", "Date list");
        this.mDatelistMI.setSelected(Settings.Window.DATE_SELECTION_SHOW.getBoolean());
        this.mDatelistMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mDatelistMI, mLocalizer.msg("menuinfo.datelist", ""), this.mLabel);
        this.mChannellistMI = this.createCheckBoxItem("menuitem.channellist", "channel list");
        this.mChannellistMI.setSelected(Settings.Window.CHANNEL_SELECTION_SHOW.getBoolean());
        this.mChannellistMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mChannellistMI, mLocalizer.msg("menuinfo.channellist", ""), this.mLabel);
        this.mPluginOverviewMI = this.createCheckBoxItem("menuitem.pluginOverview", "Plugin overview");
        this.mPluginOverviewMI.setSelected(Settings.Window.PLUGIN_VIEW_SHOW.getBoolean());
        this.mPluginOverviewMI.addActionListener(this);
        this.mPluginOverviewMI.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "view-tree", 16));
        MenuHelpTextAdapter.create(this.mPluginOverviewMI, mLocalizer.msg("menuinfo.pluginOverview", ""), this.mLabel);
        this.mViewFilterBarMI = this.createCheckBoxItem("menuitem.viewFilterBar", "Filter bar");
        this.mViewFilterBarMI.setSelected(Settings.Window.FILTER_BAR_SHOW.getBoolean());
        this.mViewFilterBarMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mViewFilterBarMI, mLocalizer.msg("menuinfo.filterbar", ""), this.mLabel);
        this.mFiltersMenu.setIcon(TVBrowserIcons.filter(16));
        this.updateFiltersMenu();
        this.updateChannelGroupMenu(this.mChannelGroupMenu);
        this.mGotoDateMenu.setIcon(IconLoader.getInstance().getIconFromTheme("apps", "office-calendar", 16));
        this.mGotoChannelMenu = new ScrollableMenu(Localizer.getLocalization("i18n_channel"));
        this.mGotoChannelMenu.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "scroll-to-channel", 16));
        this.mGotoTimeMenu.setIcon(IconLoader.getInstance().getIconFromTheme("actions", "scroll-to-time", 16));
        this.mGoMenu.add(this.createMenuItem(TVBrowserActions.goToPreviousDay));
        this.mGoMenu.add(this.createMenuItem(TVBrowserActions.goToNextDay));
        this.mGoMenu.add(this.createMenuItem(TVBrowserActions.goToPreviousWeek));
        this.mGoMenu.add(this.createMenuItem(TVBrowserActions.goToNextWeek));
        this.mGoMenu.add(this.createMenuItem(TVBrowserActions.goToToday));
        this.mGoMenu.addSeparator();
        this.mGoMenu.add(this.mGotoDateMenu);
        this.mGoMenu.add(this.mGotoChannelMenu);
        this.mGoMenu.add(this.mGotoTimeMenu);
        this.mGoMenu.addSeparator();
        this.mGoMenu.add(this.createMenuItem(TVBrowserActions.scrollToNow));
        this.mFullscreenMI = this.createCheckBoxItem("menuitem.fullscreen", "Fullscreen");
        this.mFullscreenMI.setIcon(TVBrowserIcons.fullScreen(16));
        this.mFullscreenMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mFullscreenMI, mLocalizer.msg("menuinfo.fullscreen", ""), this.mLabel);
        this.updateDateItems();
        this.updateChannelItems();
        this.updateTimeItems();
        ImageIcon urlHelpImg = IconLoader.getInstance().getIconFromTheme("apps", "help-browser", 16);
        ImageIcon urlBrowserImg = IconLoader.getInstance().getIconFromTheme("apps", "internet-web-browser", 16);
        this.mInstallPluginsMI = this.createMenuItem("menuitem.installPlugins", "Install/Update Plugins", urlBrowserImg, true);
        this.mInstallPluginsMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mInstallPluginsMI, mLocalizer.msg("menuinfo.installPlugins", "Add additional functions to TV-Browser/search for updates for installed Plugins"), this.mLabel);
        this.mPluginManagerMI = this.createMenuItem("menuitem.managePlugins", "Manage Plugins", null, true);
        this.mPluginManagerMI.addActionListener(this);
        this.mPluginManagerMI.setIcon(TVBrowserIcons.plugin(16));
        MenuHelpTextAdapter.create(this.mPluginManagerMI, mLocalizer.msg("menuinfo.findplugins", ""), this.mLabel);
        this.mHandbookMI = this.createMenuItem("menuitem.handbook", "Handbook", urlHelpImg);
        this.mHandbookMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mHandbookMI, mLocalizer.msg("website.handbook", ""), this.mLabel);
        this.mKeyboardShortcutsMI = this.createMenuItem("menuitem.keyboardshortcuts", "Keyboard shortcuts", urlHelpImg);
        this.mKeyboardShortcutsMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mKeyboardShortcutsMI, mLocalizer.msg("website.keyboardshortcuts", ""), this.mLabel);
        this.mFaqMI = this.createMenuItem("menuitem.faq", "FAQ", urlHelpImg);
        this.mFaqMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mFaqMI, mLocalizer.msg("website.faq", ""), this.mLabel);
        this.mBackupMI = this.createMenuItem("menuitem.backup", "Backup", urlHelpImg);
        this.mBackupMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mBackupMI, mLocalizer.msg("website.backup", ""), this.mLabel);
        this.mWebsiteMI = this.createMenuItem("menuitem.website", "Website", urlBrowserImg);
        this.mWebsiteMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mWebsiteMI, mLocalizer.msg("website.tvbrowser", ""), this.mLabel);
        this.mForumMI = this.createMenuItem("menuitem.forum", "Bulletin board", urlBrowserImg);
        this.mForumMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mForumMI, mLocalizer.msg("website.forum", ""), this.mLabel);
        this.mDownloadMI = this.createMenuItem("menuitem.download", "Download", urlBrowserImg);
        this.mDownloadMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mForumMI, mLocalizer.msg("website.download", "http://tvbrowser.org/download_tvbrowser.php"), this.mLabel);
        this.mDonorMI = this.createMenuItem("menuitem.donors", "Donors", urlBrowserImg);
        this.mDonorMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mDonorMI, mLocalizer.msg("website.donors", "http://tvbrowser.org/donors.html"), this.mLabel);
        this.mConfigAssistantMI = this.createMenuItem("menuitem.configAssistant", "Setup assistant", TVBrowserIcons.preferences(16));
        this.mConfigAssistantMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mConfigAssistantMI, mLocalizer.msg("menuinfo.configAssistant", ""), this.mLabel);
        if (TVBrowser.isTransportable()) {
            this.mCopySettingsToSystem = this.createMenuItem("menuitem.copySettings", "Copy settings to system", IconLoader.getInstance().getIconFromTheme("actions", "edit-copy", 16));
            this.mCopySettingsToSystem.addActionListener(this);
            MenuHelpTextAdapter.create(this.mCopySettingsToSystem, mLocalizer.msg("menuinfo.copySettings", "Copy settings of transportable version to the system"), this.mLabel);
        }
        this.mPluginInfoDlgMI = this.createMenuItem("menuitem.pluginInfoDlg", "What are Plugins?", urlHelpImg);
        this.mPluginInfoDlgMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mPluginInfoDlgMI, mLocalizer.msg("menuinfo.pluginInfoDlg", "Describes the Plugin functionality of TV-Browser."), this.mLabel);
        this.mDebugMI = this.createMenuItem("menuitem.debug", "Create debug info", new ImageIconEnhanced("imgs/tvbrowser16.png"), false);
        this.mDebugMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mDebugMI, mLocalizer.msg("menuinfo.debug", ""), this.mLabel);
        this.mOpenSettingsMI = this.createMenuItem("menuitem.openSettings", "Open settings directory", new ImageIconEnhanced("imgs/tvbrowser16.png"), false);
        this.mOpenSettingsMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mOpenSettingsMI, mLocalizer.msg("menuinfo.openSettings", ""), this.mLabel);
        this.mDonateMI = this.createMenuItem("menuitem.donate", "How to donate?", TVBrowserIcons.webBrowser(16), false);
        this.mDonateMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mDonateMI, mLocalizer.msg("menuinfo.donate", ""), this.mLabel);
        this.mAboutMI = this.createMenuItem("menuitem.about", "About", new ImageIconEnhanced("imgs/tvbrowser16.png"), false);
        this.mAboutMI.addActionListener(this);
        MenuHelpTextAdapter.create(this.mAboutMI, mLocalizer.msg("menuinfo.about", ""), this.mLabel);
        this.mPluginHelpMenu.setIcon(urlHelpImg);
        this.updatePluginHelpMenuItems();
        this.mFontSizeMenu.add(this.createMenuItem(TVBrowserActions.fontSizeLarger));
        this.mFontSizeMenu.add(this.createMenuItem(TVBrowserActions.fontSizeSmaller));
        this.mFontSizeMenu.addSeparator();
        this.mFontSizeMenu.add(this.createMenuItem(TVBrowserActions.fontSizeDefault));
        this.mFontSizeMenu.setIcon(TVBrowserIcons.zoomIn(16));
        this.mColumnWidthMenu.add(this.createMenuItem(TVBrowserActions.columnWidthLarger));
        this.mColumnWidthMenu.add(this.createMenuItem(TVBrowserActions.columnWidthSmaller));
        this.mColumnWidthMenu.addSeparator();
        this.mColumnWidthMenu.add(this.createMenuItem(TVBrowserActions.columnWidthDefault));
        this.mViewMenu.add(this.mToolbarMenu);
        this.mViewMenu.add(this.mPluginOverviewMI);
        this.mViewMenu.add(this.mTimeBtnsMI);
        this.mViewMenu.add(this.mDatelistMI);
        this.mViewMenu.add(this.mChannellistMI);
        this.mViewMenu.add(this.mStatusbarMI);
        this.mViewMenu.add(this.mViewFilterBarMI);
        this.mViewMenu.addSeparator();
        this.mViewMenu.add(this.mFiltersMenu);
        this.mViewMenu.add(this.mChannelGroupMenu);
        this.mViewMenu.add(this.mFontSizeMenu);
        this.mViewMenu.add(this.mColumnWidthMenu);
        this.mViewMenu.addSeparator();
        this.mViewMenu.add(this.mFullscreenMI);
    }

    private JMenuItem createMenuItem(String localizerKey, String defaultLabel, Icon icon, boolean ellipsis) {
        JMenuItem item = new JMenuItem();
        this.setLabelAndAccessKeys(localizerKey, defaultLabel, item, ellipsis);
        if (icon != null) {
            item.setIcon(icon);
        }
        return item;
    }

    private JMenuItem createMenuItem(TVBrowserAction action) {
        JMenuItem item = new JMenuItem(action);
        this.setLabelAndAccessKeys("", action.getMenuText(), item, action.useEllipsis());
        item.setIcon(action.getIcon());
        MenuHelpTextAdapter.create(item, action.getMenuHelpText(), this.mLabel);
        KeyStroke accelerator = action.getAccelerator();
        if (accelerator != null) {
            item.setAccelerator(accelerator);
        }
        return item;
    }

    private JCheckBoxMenuItem createCheckBoxItem(String localizerKey, String defaultLabel) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        this.setLabelAndAccessKeys(localizerKey, defaultLabel, item, false);
        return item;
    }

    private JMenuItem createMenuItem(String localizerKey, String defaultLabel, Icon icon) {
        return this.createMenuItem(localizerKey, defaultLabel, icon, false);
    }

    protected JMenu createScrollableMenu(String localizerKey, String defaultLabel) {
        ScrollableMenu menu = new ScrollableMenu();
        this.setLabelAndAccessKeys(localizerKey, defaultLabel, menu, false);
        return menu;
    }

    protected JMenu createMenu(String localizerKey, String defaultLabel) {
        return this.createMenu(localizerKey, defaultLabel, false);
    }

    protected JMenu createMenu(String localizerKey, String defaultLabel, boolean paintForPersona) {
        JMenu menu = new JMenu();
        if (paintForPersona) {
            menu = Persona.getInstance().createPersonaMenu();
        }
        this.setLabelAndAccessKeys(localizerKey, defaultLabel, menu, false);
        return menu;
    }

    private void setLabelAndAccessKeys(String localizerKey, String defaultLabel, JMenuItem item, boolean ellipsis) {
        Object label = localizerKey != null && !localizerKey.isEmpty() ? (ellipsis ? mLocalizer.ellipsisMsg(localizerKey, defaultLabel) : mLocalizer.msg(localizerKey, defaultLabel)) : (ellipsis ? mLocalizer.ellipsis(defaultLabel) : defaultLabel);
        int index = ((String)label).indexOf(38);
        String mnemonic = "";
        if (index >= 0) {
            mnemonic = ((String)label).substring(index + 1, index + 2);
            label = ((String)label).substring(0, index) + ((String)label).substring(index + 1);
        } else {
            String mnemonicKey = localizerKey + ".mnemonic";
            if (mLocalizer.hasMessage(mnemonicKey)) {
                mnemonic = mLocalizer.msg(mnemonicKey, "");
            }
        }
        item.setText((String)label);
        if (!OperatingSystem.isMacOs()) {
            if (mnemonic != null && !mnemonic.isEmpty()) {
                item.setMnemonic(mnemonic.charAt(0));
            }
            if (index >= 0) {
                item.setDisplayedMnemonicIndex(index);
            }
        }
    }

    void updateChannelGroupMenu() {
        try {
            UIThreadRunner.invokeAndWait(() -> this.updateChannelGroupMenu(this.mChannelGroupMenu));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void updateChannelGroupMenu(JMenu menu) {
        String[] channelFilterNames;
        menu.removeAll();
        String channelFilterName = Settings.Channels.GROUP_LAST_USED.getString();
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(mLocalizer.msg("channelGroupAll", "All channels"));
        menuItem.setSelected(channelFilterName == null);
        menuItem.addActionListener(e -> MainFrame.getInstance().setChannelFilter(null));
        menu.add(menuItem);
        for (String filterName : channelFilterNames = FilterComponentList.getInstance().getChannelFilterNames()) {
            try {
                menuItem = new JRadioButtonMenuItem(ChannelFilter.createChannelFilterForName(filterName).toString());
                menuItem.addActionListener(e -> MainFrame.getInstance().setChannelFilter(ChannelFilterList.getInstance().getChannelFilterForName(filterName)));
                menu.add(menuItem);
                if (channelFilterName == null || !filterName.equals(channelFilterName)) continue;
                menuItem.setSelected(true);
            }
            catch (ClassCastException e1) {
                e1.printStackTrace();
            }
            catch (TvBrowserException e1) {
                e1.printStackTrace();
            }
        }
        menu.add(new JSeparator());
        JMenuItem menuItemAdd = this.createMenuItem("channelGroupNew", "Add channel group", null, true);
        menuItemAdd.addActionListener(e -> {
            Window w = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
            EditFilterComponentDlg dlg = null;
            dlg = w instanceof JDialog ? new EditFilterComponentDlg((JDialog)w, null, ChannelFilterComponent.class) : new EditFilterComponentDlg((JFrame)w, null, ChannelFilterComponent.class);
            FilterComponent rule = dlg.getFilterComponent();
            if (rule != null && rule instanceof ChannelFilterComponent) {
                FilterComponentList.getInstance().add(rule);
                FilterComponentList.getInstance().store();
                MainFrame.getInstance().setChannelFilter(ChannelFilterList.getInstance().getChannelFilterForName(rule.getName()));
            }
        });
        menu.add(menuItemAdd);
        JMenuItem menuItemEdit = this.createMenuItem("channelGroupEdit", "Edit current channel group", null, true);
        menuItemEdit.addActionListener(e -> {
            FilterComponent test;
            ChannelFilter rule = MainFrame.getInstance().getChannelFilter();
            if (rule != null && (test = FilterComponentList.getInstance().getFilterComponentByName(rule.getName())) instanceof ChannelFilterComponent) {
                FilterComponentList.getInstance().remove(test.getName());
                EditFilterComponentDlg dlg = new EditFilterComponentDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), test);
                FilterComponent newRule = dlg.getFilterComponent();
                if (newRule == null) {
                    newRule = test;
                }
                FilterComponentList.getInstance().add(newRule);
                FilterComponentList.getInstance().store();
                MainFrame.getInstance().setChannelFilter(ChannelFilterList.getInstance().getChannelFilterForName(newRule.getName()));
            }
        });
        menu.add(menuItemEdit);
        menuItemEdit.setEnabled(!MainFrame.isStarting() && MainFrame.getInstance().getChannelFilter() != null);
    }

    private JMenuItem createDateMenuItem(Date date) {
        JMenuItem item = new JMenuItem(date.getLongDateString());
        item.addActionListener(e -> this.mMainFrame.goTo(date));
        return item;
    }

    private JMenuItem createChannelMenuItem(Channel channel) {
        ImageIcon icon = null;
        if (Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.getBoolean()) {
            icon = UiUtilities.createChannelIcon(channel.getJointChannel() != null ? channel.getJointChannelIcon() : channel.getIcon());
        }
        StringBuilder text = new StringBuilder();
        if (Settings.IconAndNames.SHOW_SORT_NUMBER_IN_PROGRAM_LISTS.getBoolean() && channel.getSortNumber().trim().length() > 0) {
            text.append(channel.getSortNumber().trim()).append(". ");
        }
        text.append(channel.getJointChannel() != null ? channel.getJointChannelName() : channel.getName());
        JMenuItem item = new JMenuItem(text.toString(), icon);
        item.addActionListener(e -> this.mMainFrame.showChannel(channel));
        return item;
    }

    private JMenuItem createTimeMenuItem(int time) {
        int h = time / 60;
        int min = time % 60;
        JMenuItem item = new JMenuItem((h < 10 ? "0" : "") + h + ":" + (min < 10 ? "0" : "") + min);
        item.addActionListener(e -> this.mMainFrame.scrollToTime(time, true));
        return item;
    }

    protected JMenuItem[] createFilterMenuItems() {
        ButtonGroup group = new ButtonGroup();
        FilterList filterList = FilterList.getInstance();
        ProgramFilter[] filterArr = filterList.getFilterArr();
        JMenuItem[] result = new JRadioButtonMenuItem[filterArr.length];
        for (int i = 0; i < filterArr.length; ++i) {
            ProgramFilter filter = filterArr[i];
            result[i] = new JRadioButtonMenuItem(filter.toString());
            JMenuItem item = result[i];
            group.add(item);
            result[i].addActionListener(arg_0 -> this.lambda$createFilterMenuItems$8(filter, (JRadioButtonMenuItem)item, arg_0));
        }
        result[0].setSelected(true);
        return result;
    }

    private JMenu createLicenseMenuItems() {
        TvDataServiceProxy[] services;
        JMenu licenseMenu = new JMenu();
        for (TvDataServiceProxy service : services = TvDataServiceProxyManager.getInstance().getDataServices()) {
            String license = service.getInfo().getLicense();
            if (license == null) continue;
            String name = service.getInfo().getName();
            JMenuItem item = new JMenuItem(name, new ImageIconEnhanced("imgs/tvbrowser16.png"));
            this.setMnemonic(item);
            item.addActionListener(e -> {
                LicenseBox box = new LicenseBox(this.mMainFrame, license, false);
                UiUtilities.centerAndShow(box);
            });
            licenseMenu.add(item);
        }
        if (licenseMenu.getItemCount() > 1) {
            this.setLabelAndAccessKeys("menuitem.licenseMultiple", "Terms of Use", licenseMenu, false);
        } else {
            this.setLabelAndAccessKeys("menuitem.license", "Terms of Use", licenseMenu, true);
        }
        return licenseMenu;
    }

    private void setMnemonic(JMenuItem item) {
        if (!OperatingSystem.isMacOs()) {
            item.setMnemonic(item.getText().charAt(0));
        }
    }

    public void updatePluginsMenu() {
        this.setPluginMenuItems(this.createPluginMenuItems());
    }

    public void updateTimeItems() {
        int[] times;
        this.mGotoTimeMenu.removeAll();
        for (int time : times = Settings.Buttons.TIME_BUTTONS.getIntArray()) {
            this.mGotoTimeMenu.add(this.createTimeMenuItem(time));
        }
        this.mGotoTimeMenu.addSeparator();
        this.mEditTimeButtonsMenuItem = this.createMenuItem("menuitem.editTimeItems", "Edit Items", null, true);
        this.mEditTimeButtonsMenuItem.addActionListener(this);
        this.mGotoTimeMenu.add(this.mEditTimeButtonsMenuItem);
    }

    public void updateViewToolbarItem() {
        this.mToolbarMI.setSelected(Settings.ToolBar.IS_VISIBLE.getBoolean());
        this.mMenubarMI.setSelected(Settings.Window.MENU_BAR_VISIBLE.getBoolean());
    }

    public void updateChannelItems() {
        this.mGotoChannelMenu.removeAll();
        Channel[] channels = ChannelList.getSubscribedChannels();
        String[] separatorArr = Settings.Channels.SUBSCRIBED_SEPARATORS.getStringArray();
        Channel previousChannel = null;
        int lastSeparatorIndex = 0;
        if (channels.length > 0) {
            this.mGotoChannelMenu.add(this.createChannelMenuItem(channels[0]));
            previousChannel = channels[0];
        }
        for (int i = 1; i < channels.length; ++i) {
            for (int j = lastSeparatorIndex; j < separatorArr.length; ++j) {
                String separator = separatorArr[j];
                if (!separator.endsWith(channels[i].getUniqueId()) || previousChannel == null || !separator.startsWith(previousChannel.getUniqueId())) continue;
                this.mGotoChannelMenu.addSeparator();
                lastSeparatorIndex = j + 1;
            }
            previousChannel = channels[i];
            if (channels[i - 1].getJointChannel() != null && channels[i - 1].getJointChannel().equals(channels[i])) continue;
            this.mGotoChannelMenu.add(this.createChannelMenuItem(channels[i]));
        }
        this.mGotoChannelMenu.setEnabled(channels.length > 0);
    }

    public void updateDateItems() {
        this.mGotoDateMenu.removeAll();
        Date curDate = new Date();
        Date maxDate = TvDataBase.getInstance().getMaxSupportedDate();
        while (maxDate.getNumberOfDaysSince(curDate) >= 0 && TvDataBase.getInstance().dataAvailable(curDate)) {
            if (curDate.isFirstDayOfWeek() && this.mGotoDateMenu.getItemCount() > 0) {
                this.mGotoDateMenu.addSeparator();
            }
            this.mGotoDateMenu.add(this.createDateMenuItem(curDate));
            curDate = curDate.addDays(1);
        }
        this.mGotoDateMenu.setEnabled(ChannelList.getNumberOfSubscribedChannels() > 0);
    }

    public void updateFiltersMenu() {
        try {
            this.mFiltersMenu.removeAll();
            FilterButtons.createFilterButtons(this.mFiltersMenu, this.mMainFrame);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.mViewFilterBarMI.setEnabled(!this.mMainFrame.isDefaultFilterActivated());
    }

    protected void setPluginMenuItems(JMenuItem[] items) {
        JMenuItem[] internalPluginItems;
        this.mPluginsMenu.removeAll();
        for (JMenuItem menuItem : internalPluginItems = this.createInternalPluginMenuItems()) {
            this.mPluginsMenu.add(menuItem);
        }
        JMenuItem[] pluginItems = this.createPluginMenuItems();
        if (pluginItems.length > 0) {
            this.mPluginsMenu.addSeparator();
        }
        for (JMenuItem pluginItem : pluginItems) {
            this.mPluginsMenu.add(pluginItem);
        }
        this.mPluginsMenu.addSeparator();
        this.mPluginsMenu.add(this.mInstallPluginsMI);
        this.mPluginsMenu.add(this.mPluginManagerMI);
    }

    public static JMenuItem createMenuItem(ActionMenu menu, ButtonActionIf buttonActionIf, JLabel label) {
        String desc;
        Object accelerator;
        JMenuItem result;
        Icon icon = (Icon)menu.getAction().getValue("SmallIcon");
        if (icon != null && (icon.getIconWidth() != 42 || icon.getIconHeight() != 22)) {
            icon = new FixedSizeIcon(16, 16, icon);
        }
        if (menu.hasSubItems()) {
            ActionMenu[] subItems;
            result = new ScrollableMenu(menu.getTitle());
            if (icon != null) {
                result.setIcon(icon);
            }
            for (ActionMenu subItem : subItems = menu.getSubItems()) {
                JMenuItem menuItem = MenuBar.createMenuItem(subItem, null, label);
                if (menuItem != null) {
                    result.add(menuItem);
                    continue;
                }
                ((JMenu)result).addSeparator();
            }
        } else {
            if (ContextMenuSeparatorAction.getInstance().equals(menu.getAction())) {
                return null;
            }
            result = new JMenuItem(menu.getAction());
            if (icon != null) {
                result.setIcon(icon);
            }
        }
        if ((accelerator = menu.getAction().getValue("####KEYBOARD_ACCELERATOR####")) != null && accelerator instanceof KeyStroke) {
            result.setAccelerator((KeyStroke)accelerator);
        }
        String string = desc = buttonActionIf != null ? buttonActionIf.getButtonActionDescription() : (String)menu.getAction().getValue("ShortDescription");
        if (desc != null) {
            MenuHelpTextAdapter.create(result, desc, label);
        }
        return result;
    }

    protected JMenuItem[] createInternalPluginMenuItems() {
        InternalPluginProxyIf[] internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys();
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        for (InternalPluginProxyIf internalPlugin : internalPlugins) {
            if (!(internalPlugin instanceof ButtonActionIf)) continue;
            this.fillButtonActionList(list, (ButtonActionIf)((Object)internalPlugin));
        }
        return this.createSortedArrayFromList(list);
    }

    protected JMenuItem[] createPluginMenuItems() {
        TvDataServiceProxy[] dataServices;
        PluginProxy[] plugins = PluginProxyManager.getInstance().getActivatedPlugins();
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        for (PluginProxy plugin : plugins) {
            this.fillButtonActionList(list, plugin);
        }
        for (TvDataServiceProxy dataService : dataServices = TvDataServiceProxyManager.getInstance().getDataServices()) {
            this.fillButtonActionList(list, dataService);
        }
        return this.createSortedArrayFromList(list);
    }

    private void fillButtonActionList(ArrayList<JMenuItem> list, ButtonActionIf buttonActionIf) {
        ActionMenu actionMenu = buttonActionIf.getButtonAction();
        if (actionMenu != null) {
            JMenuItem item = MenuBar.createMenuItem(actionMenu, buttonActionIf, this.mLabel);
            this.setMnemonic(item);
            list.add(item);
        }
    }

    private JMenuItem[] createSortedArrayFromList(ArrayList<JMenuItem> itemList) {
        JMenuItem[] result = itemList.toArray(new JMenuItem[itemList.size()]);
        Arrays.sort(result, new Comparator<JMenuItem>(){

            @Override
            public int compare(JMenuItem item1, JMenuItem item2) {
                return item1.getText().compareTo(item2.getText());
            }
        });
        return result;
    }

    protected void updatePluginHelpMenuItems() {
        this.mPluginHelpMenu.removeAll();
        PluginProxy[] plugins = PluginProxyManager.getInstance().getActivatedPlugins();
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        for (PluginProxy plugin : plugins) {
            String helpUrl = plugin.getInfo().getHelpUrl();
            if (helpUrl == null) {
                helpUrl = PluginInfo.getHelpUrl(plugin.getId());
            }
            if (helpUrl == null) continue;
            JMenuItem item = this.pluginHelpMenuItem(plugin.getInfo().getName(), helpUrl);
            item.setIcon(plugin.getPluginIcon());
            list.add(item);
        }
        JMenuItem[] result = list.toArray(new JMenuItem[list.size()]);
        Arrays.sort(result, new Comparator<JMenuItem>(){

            @Override
            public int compare(JMenuItem item1, JMenuItem item2) {
                return item1.getText().compareTo(item2.getText());
            }
        });
        InternalPluginProxyIf[] internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys();
        for (InternalPluginProxyIf internalPlugin : internalPlugins) {
            JMenuItem item = this.pluginHelpMenuItem(internalPlugin.toString(), PluginInfo.getHelpUrl(internalPlugin.getId()));
            item.setIcon(internalPlugin.getIcon());
            this.mPluginHelpMenu.add(item);
        }
        if (result.length > 0) {
            this.mPluginHelpMenu.addSeparator();
        }
        for (JMenuItem pluginMenuItem : result) {
            this.mPluginHelpMenu.add(pluginMenuItem);
        }
    }

    private JMenuItem pluginHelpMenuItem(String name, String helpUrl) {
        JMenuItem item = new JMenuItem(name);
        this.setMnemonic(item);
        item.addActionListener(e -> Launch.openURL(helpUrl));
        return item;
    }

    public void setPluginViewItemChecked(boolean selected) {
        this.mPluginOverviewMI.setSelected(selected);
    }

    public void setFullscreenItemChecked(boolean selected) {
        this.mFullscreenMI.setSelected(selected);
    }

    public void setTimeCooserItemChecked(boolean selected) {
        this.mTimeBtnsMI.setSelected(selected);
    }

    public void setDateListItemChecked(boolean selected) {
        this.mDatelistMI.setSelected(selected);
    }

    public void setChannelListItemChecked(boolean selected) {
        this.mChannellistMI.setSelected(selected);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mTimeBtnsMI) {
            this.mMainFrame.setShowTimeButtons(this.mTimeBtnsMI.isSelected());
        } else if (source == this.mQuitMI) {
            this.mMainFrame.quit();
        } else if (source == this.mRestartMI) {
            TVBrowser.addRestart();
            this.mMainFrame.quit();
        } else if (source == this.mToolbarMI) {
            this.mMainFrame.setShowToolbar(this.mToolbarMI.isSelected());
        } else if (source == this.mMenubarMI) {
            this.mMainFrame.setShowMenubar(this.mMenubarMI.isSelected());
        } else if (source == this.mStatusbarMI) {
            this.mMainFrame.setShowStatusbar(this.mStatusbarMI.isSelected());
        } else if (source == this.mViewFilterBarMI) {
            this.mMainFrame.updateFilterPanel();
        } else if (source == this.mDatelistMI) {
            this.mMainFrame.setShowDatelist(this.mDatelistMI.isSelected());
        } else if (source == this.mChannellistMI) {
            this.mMainFrame.setShowChannellist(this.mChannellistMI.isSelected());
        } else if (source == this.mPluginOverviewMI) {
            boolean selected = this.mPluginOverviewMI.isSelected();
            this.mMainFrame.setShowPluginOverview(selected);
            this.mMainFrame.setPluginViewButton(selected);
        } else if (source == this.mFullscreenMI) {
            this.mMainFrame.switchFullscreenMode();
        } else if (source == this.mPluginManagerMI) {
            this.mMainFrame.showSettingsDialog("#plugins");
        } else if (source == this.mInstallPluginsMI) {
            this.mMainFrame.showUpdatePluginsDlg(true);
        } else if (source == this.mHandbookMI) {
            Launch.openURL(mLocalizer.msg("website.handbook", ""));
        } else if (source == this.mKeyboardShortcutsMI) {
            Launch.openURL(mLocalizer.msg("website.keyboardshortcuts", ""));
        } else if (source == this.mFaqMI) {
            Launch.openURL(mLocalizer.msg("website.faq", ""));
        } else if (source == this.mBackupMI) {
            Launch.openURL(mLocalizer.msg("website.backup", ""));
        } else if (source == this.mWebsiteMI) {
            Launch.openURL(mLocalizer.msg("website.tvbrowser", ""));
        } else if (source == this.mForumMI) {
            Launch.openURL(mLocalizer.msg("website.forum", ""));
        } else if (source == this.mDownloadMI) {
            Launch.openURL(mLocalizer.msg("website.download", "http://tvbrowser.org/download_tvbrowser.php"));
        } else if (source == this.mDonorMI) {
            Launch.openURL(mLocalizer.msg("website.donors", "http://tvbrowser.org/donors.html"));
        } else if (source == this.mConfigAssistantMI) {
            this.mMainFrame.runSetupAssistant();
        } else if (source == this.mCopySettingsToSystem) {
            this.mCopySettingsRequested = true;
            this.mMainFrame.copySettingsToSystem();
            this.mCopySettingsRequested = false;
        } else if (source == this.mPluginInfoDlgMI) {
            this.mMainFrame.showPluginInfoDlg();
        } else if (source == this.mAboutMI) {
            this.mMainFrame.showAboutBox();
        } else if (source == this.mEditTimeButtonsMenuItem) {
            this.mMainFrame.showSettingsDialog("#timebuttons");
        } else if (source == this.mToolbarCustomizeMI) {
            new ToolBarDragAndDropSettings();
        } else if (source == this.mDebugMI) {
            Channel[] channels;
            PluginProxy[] plugins;
            StringBuilder infoBuilder = new StringBuilder();
            infoBuilder.append("System: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" ").append(System.getProperty("os.arch")).append(" ").append(System.getProperty("file.encoding"));
            infoBuilder.append("\nJava: ").append(System.getProperty("java.runtime.name")).append(" ").append(System.getProperty("java.version")).append(" ").append(System.getProperty("java.home"));
            infoBuilder.append("\nTV-Browser: ").append(TVBrowser.VERSION).append(" ").append(new File("").getAbsolutePath());
            infoBuilder.append("\nUser settings: ").append(System.getProperty("user.dir")).append(" ").append(System.getProperty("user.language")).append(" ").append(System.getProperty("user.country")).append(" ").append(System.getProperty("user.timezone"));
            infoBuilder.append("\nLookAndFeel: ").append(Settings.LookAndFeel.SELECTED.getString());
            infoBuilder.append("\nPlastic-Theme: ").append(Settings.LookAndFeel.JGOODIES_THEME.getString());
            infoBuilder.append("\nPersona: ").append(Persona.getInstance().getName());
            infoBuilder.append("\nIcons: ").append(Settings.LookAndFeel.ICON_THEME.getString());
            infoBuilder.append("\nInfo-Icons: ").append(Settings.LookAndFeel.INFO_ICON_THEME_ID.getString());
            infoBuilder.append("\nProgram table style: ").append(Settings.ProgramTable.STYLE_BACKGROUND.getString()).append(",").append(Settings.ProgramTable.LAYOUT.getString());
            infoBuilder.append("\nProgram table times: ").append(Settings.ProgramTable.START_OF_DAY.getInt()).append("-").append(Settings.ProgramTable.END_OF_DAY.getInt());
            infoBuilder.append("\nNumber of markings: ").append(MarkedProgramsMap.getInstance().getMarkedPrograms().length);
            infoBuilder.append("\nActive filter: ").append(this.mMainFrame.getProgramFilter());
            infoBuilder.append("\nDefault fonts: ").append(Settings.Fonts.USE_DEFAULT.getBoolean());
            infoBuilder.append("\n\nInstalled plugins:");
            for (PluginProxy plugin : plugins = PluginProxyManager.getInstance().getAllPlugins()) {
                infoBuilder.append("\n  ").append(plugin.getId()).append(" ").append(plugin.isActivated());
            }
            infoBuilder.append("\n\nSubscribed channels:");
            for (Channel ch : channels = ChannelList.getSubscribedChannels()) {
                infoBuilder.append("\n  ").append(ch.getName()).append(" ").append(ch.getDataServicePackageName());
            }
            infoBuilder.append("\n\nData available:");
            Date test = Date.getCurrentDate().addDays(-1);
            Date maxDate = TvDataBase.getInstance().getMaxSupportedDate();
            while (test.compareTo(maxDate) < 0) {
                infoBuilder.append("\n  ").append(test).append(" ").append(TvDataBase.getInstance().dataAvailable(test));
                test = test.addDays(1);
            }
            StringSelection stringSelection = new StringSelection(infoBuilder.toString());
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
            JOptionPane.showMessageDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), mLocalizer.msg("debugCopied", "Debug information copied to clipboard."), Localizer.getLocalization("i18n_info"), 1);
        } else if (source == this.mOpenSettingsMI) {
            Settings.openSettingsDir();
        } else if (source == this.mDonateMI) {
            Launch.openURL("https://www.tvbrowser.org/index.php?id=donations");
        }
    }

    public boolean isShowFilterPanelEnabled() {
        return this.mViewFilterBarMI.isSelected();
    }

    protected void createHelpMenuItems(boolean showAbout) {
    }

    protected final void addAdditionalMenus(final Runnable callback) {
        if (this.mInitializeThread != null && this.mInitializeThread.isAlive()) {
            new Thread("ADD ADITONAL MENUS WAITING THREAD"){

                @Override
                public void run() {
                    while (MenuBar.this.mInitializeThread.isAlive()) {
                        try {
                            4.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    callback.run();
                    MenuBar.this.updatePersona();
                }
            }.start();
        }
    }

    protected void createCommonMenus(boolean aboutMenu) {
        if (!(OperatingSystem.isWindows() || OperatingSystem.isMacOs() && !aboutMenu)) {
            this.mEditMenu = this.createMenu("menu.edit", "&Edit", true);
            this.add(this.mEditMenu);
        }
        this.add(this.mViewMenu);
        this.add(this.mGoMenu);
        JMenu tvListingsMenu = this.createMenu("menu.tvData", "TV &data", true);
        this.add(tvListingsMenu);
        tvListingsMenu.add(this.createMenuItem(TVBrowserActions.update));
        tvListingsMenu.add(this.createMenuItem(TVBrowserActions.configureChannels));
        tvListingsMenu.addSeparator();
        tvListingsMenu.add(this.mLicenseMenu);
        this.mPluginsMenu = this.createMenu("menu.plugins", "&Tools", true);
        this.add(this.mPluginsMenu);
        this.updatePluginsMenu();
        this.mHelpMenu = this.createMenu("menu.help", "&Help", true);
        this.add(this.mHelpMenu);
        this.mHelpMenu.add(this.mConfigAssistantMI);
        if (TVBrowser.isTransportable()) {
            this.mHelpMenu.add(this.mCopySettingsToSystem);
        }
        this.mHelpMenu.addSeparator();
        this.mHelpMenu.add(this.mHandbookMI);
        this.mHelpMenu.add(this.mKeyboardShortcutsMI);
        this.mHelpMenu.add(this.mFaqMI);
        this.mHelpMenu.add(this.mBackupMI);
        this.mHelpMenu.add(this.mPluginHelpMenu);
        this.mHelpMenu.add(this.mPluginInfoDlgMI);
        this.mHelpMenu.addSeparator();
        this.mHelpMenu.add(this.mWebsiteMI);
        this.mHelpMenu.add(this.mForumMI);
        this.mHelpMenu.add(this.mDownloadMI);
        this.mHelpMenu.add(this.mDonorMI);
        this.mHelpMenu.addSeparator();
        this.mHelpMenu.add(this.mDonateMI);
        if (Desktop.isDesktopSupported()) {
            this.mHelpMenu.add(this.mOpenSettingsMI);
        }
        this.mHelpMenu.add(this.mDebugMI);
        if (aboutMenu) {
            this.mHelpMenu.add(this.mAboutMI);
        }
        InputMap map = (InputMap)UIManager.get("SplitPane.ancestorInputMap");
        KeyStroke keyStrokeF6 = KeyStroke.getKeyStroke(117, 0);
        KeyStroke keyStrokeF8 = KeyStroke.getKeyStroke(119, 0);
        map.remove(keyStrokeF6);
        map.remove(keyStrokeF8);
        this.mPluginOverviewMI.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.mTimeBtnsMI.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.mDatelistMI.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.mChannellistMI.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.mFullscreenMI.setAccelerator(KeyStroke.getKeyStroke(122, 0));
    }

    public boolean getUserRequestedCopyToSystem() {
        return this.mCopySettingsRequested;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (Persona.getInstance().getAccentColor() != null) {
            g.setColor(Persona.getInstance().getAccentColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            super.paintComponent(g);
        }
        if (Persona.getInstance().getHeaderImage() != null) {
            try {
                g.drawImage(Persona.getInstance().getHeaderImage(), 0, 0, this.getWidth(), Persona.getInstance().getHeaderImage().getHeight(), Persona.getInstance().getHeaderImage().getWidth() - this.getWidth(), 0, Persona.getInstance().getHeaderImage().getWidth(), Persona.getInstance().getHeaderImage().getHeight(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null) {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.setOpaque(true);
            this.setBorder(this.mDefaultBorder);
        }
        this.repaint();
    }

    private /* synthetic */ void lambda$createFilterMenuItems$8(ProgramFilter filter, JRadioButtonMenuItem item, ActionEvent event) {
        this.mMainFrame.setProgramFilter(filter);
        item.setSelected(true);
    }
}

