/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Channel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.Settings;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.ui.mainframe.PanelButton;
import tvbrowser.ui.mainframe.PeriodItem;
import tvbrowser.ui.mainframe.TvDataServiceCheckBox;
import util.i18n.Localizer;
import util.ui.EnhancedPanelBuilder;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class UpdateDlg
extends JDialog
implements ActionListener,
WindowClosingIf {
    private static long LAST_CLOSED = 0L;
    private static boolean SHOW = true;
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(UpdateDlg.class);
    protected static final int CANCEL = -1;
    protected static final int GETALL = 28;
    private JButton mCancelBtn;
    private JButton mUpdateBtn;
    private int mResult = 0;
    private JComboBox<PeriodItem> mManuelDownloadPeriodSelection;
    private JComboBox<PeriodItem> mAutoDownloadPeriodSelection;
    private TvDataServiceCheckBox[] mDataServiceCbArr;
    private TvDataServiceProxy[] mSelectedTvDataServiceArr;
    private JCheckBox mAutoUpdate;
    private JCheckBox mSaveAsDefaultPeriod;
    private JCheckBox mSaveAsDefaultDataservices;
    private JCheckBox mHideForSession;
    private JRadioButton mStartUpdate;
    private JRadioButton mRecurrentUpdate;

    public static final boolean isToShow() {
        return LAST_CLOSED + 500L < System.currentTimeMillis();
    }

    public static final boolean isToKeepHidden() {
        return !SHOW;
    }

    public UpdateDlg(JFrame parent, boolean modal, String reason) {
        super((Frame)parent, modal);
        UiUtilities.registerForClosing(this);
        this.mResult = -1;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setTitle(LOCALIZER.msg("dlgTitle", "TV data update"));
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.mUpdateBtn = new JButton(LOCALIZER.msg("updateNow", "Update now"));
        this.mUpdateBtn.addActionListener(this);
        buttonPanel.add(this.mUpdateBtn);
        this.getRootPane().setDefaultButton(this.mUpdateBtn);
        this.mCancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCancelBtn.addActionListener(this);
        buttonPanel.add(this.mCancelBtn);
        contentPane.add((Component)buttonPanel, "South");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        if (reason != null && !reason.isEmpty()) {
            String question = LOCALIZER.msg("question", "Do you want to update now?");
            JLabel lbReason = new JLabel("<html>" + reason + "<br>" + question + "</html>");
            JPanel panelReason = new JPanel(new BorderLayout(7, 0));
            panelReason.add((Component)lbReason, "West");
            northPanel.add(panelReason);
            northPanel.add(new JLabel(" "));
        }
        EnhancedPanelBuilder panel1 = new EnhancedPanelBuilder(new FormLayout("10dlu,default,5dlu:grow,5dlu"));
        panel1.addSeparatorRowFull(false, LOCALIZER.msg("period", "Update program for"));
        this.mManuelDownloadPeriodSelection = new JComboBox<PeriodItem>(PeriodItem.getPeriodItems());
        this.mSaveAsDefaultPeriod = new JCheckBox(LOCALIZER.msg("saveDefault", "Save as default"), Settings.Data.SAVE_DEFAULT_DATA_UPDATE_VALUES_DEFAULT.getBoolean());
        this.mHideForSession = new JCheckBox(LOCALIZER.msg("hideForSession", "Don't ask again in this session."));
        this.mHideForSession.addActionListener(this);
        panel1.addRow(this.mManuelDownloadPeriodSelection, 2, 2);
        panel1.addRow(false, (Component)this.mSaveAsDefaultPeriod, 2, 2);
        panel1.addRow(this.mHideForSession, 2, 2);
        northPanel.add(panel1.getPanel());
        TvDataServiceProxy[] serviceArr = UpdateDlg.getActiveDataServices();
        if (serviceArr.length > 1) {
            JPanel dataServicePanel = new JPanel();
            dataServicePanel.setLayout(new BoxLayout(dataServicePanel, 1));
            this.mDataServiceCbArr = new TvDataServiceCheckBox[serviceArr.length];
            String[] checkedServiceNames = Settings.Data.DATA_SERVICES_FOR_UPDATE.getStringArray();
            boolean expand = false;
            for (int i = 0; i < serviceArr.length; ++i) {
                this.mDataServiceCbArr[i] = new TvDataServiceCheckBox(serviceArr[i]);
                boolean isSelected = this.tvDataServiceIsChecked(serviceArr[i], checkedServiceNames);
                this.mDataServiceCbArr[i].setSelected(isSelected);
                if (!isSelected) {
                    expand = true;
                }
                dataServicePanel.add(this.mDataServiceCbArr[i]);
            }
            this.mSaveAsDefaultDataservices = new JCheckBox(LOCALIZER.msg("saveDefault", "Save as default"), Settings.Data.SAVE_DEFAULT_DATA_UPDATE_VALUES_DEFAULT.getBoolean());
            dataServicePanel.add(Box.createRigidArea(new Dimension(0, Sizes.dialogUnitXAsPixel((int)5, (Component)dataServicePanel))));
            dataServicePanel.add(this.mSaveAsDefaultDataservices);
            dataServicePanel.setVisible(expand);
            PanelButton open = new PanelButton(dataServicePanel, this);
            EnhancedPanelBuilder ds = new EnhancedPanelBuilder(new FormLayout("10dlu,default:grow,5dlu,default"));
            ds.addParagraph(LOCALIZER.msg("dataSources", "Data sources"), 1, 2);
            ds.add(open, 4);
            ds.addRowFull(dataServicePanel, 2);
            northPanel.add(ds.getPanel());
        }
        int period = Settings.Data.DOWNLOAD_PERIOD.getInt();
        PeriodItem pi = new PeriodItem(period);
        this.mManuelDownloadPeriodSelection.setSelectedItem(pi);
        JPanel boxPanel = new JPanel((LayoutManager)new FormLayout("10dlu,0dlu,default:grow", "default,2dlu,default,default,4dlu,default,3dlu,default"));
        this.mAutoUpdate = new JCheckBox(LOCALIZER.msg("autoUpdateMessage", "Update data automatically"), !Settings.General.AUTO_DOWNLOAD_TYPE.getString().equals("never"));
        boxPanel.setVisible(!this.mAutoUpdate.isSelected());
        this.mStartUpdate = new JRadioButton(LOCALIZER.msg("onStartUp", "Only on TV-Browser startup"), !Settings.General.AUTO_DATA_DOWNLOAD_ENABLED.getBoolean() && this.mAutoUpdate.isSelected());
        this.mRecurrentUpdate = new JRadioButton(LOCALIZER.msg("recurrent", "Recurrent"), Settings.General.AUTO_DATA_DOWNLOAD_ENABLED.getBoolean());
        this.mAutoDownloadPeriodSelection = new JComboBox<PeriodItem>(PeriodItem.getPeriodItems());
        period = Settings.General.AUTO_DOWNLOAD_PERIOD.getInt();
        pi = new PeriodItem(period);
        this.mAutoDownloadPeriodSelection.setSelectedItem(pi);
        JLabel label = new JLabel(LOCALIZER.msg("period", "Update program for") + ":");
        boxPanel.add((Component)this.mAutoUpdate, CC.xyw((int)1, (int)1, (int)3));
        boxPanel.add((Component)this.mStartUpdate, CC.xyw((int)2, (int)3, (int)2));
        boxPanel.add((Component)this.mRecurrentUpdate, CC.xyw((int)2, (int)4, (int)2));
        boxPanel.add((Component)label, CC.xyw((int)2, (int)6, (int)2));
        boxPanel.add(this.mAutoDownloadPeriodSelection, CC.xy((int)3, (int)8));
        this.mRecurrentUpdate.setEnabled(this.mAutoUpdate.isSelected());
        this.mStartUpdate.setEnabled(this.mAutoUpdate.isSelected());
        label.setEnabled(this.mAutoUpdate.isSelected());
        this.mAutoDownloadPeriodSelection.setEnabled(this.mAutoUpdate.isSelected());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mStartUpdate);
        bg.add(this.mRecurrentUpdate);
        PanelButton open = new PanelButton(boxPanel, this);
        EnhancedPanelBuilder pb = new EnhancedPanelBuilder(new FormLayout("10dlu,default:grow,5dlu,default"));
        pb.addParagraph(LOCALIZER.msg("autoUpdateTitle", "Automatic update"), 1, 2);
        pb.add(open, 4);
        pb.addRow(boxPanel, 2, 2);
        this.mAutoUpdate.addItemListener(e -> {
            this.mRecurrentUpdate.setEnabled(e.getStateChange() == 1);
            this.mStartUpdate.setEnabled(e.getStateChange() == 1);
            label.setEnabled(e.getStateChange() == 1);
            this.mAutoDownloadPeriodSelection.setEnabled(e.getStateChange() == 1);
        });
        northPanel.add(pb.getPanel());
        contentPane.add((Component)northPanel, "North");
        this.mUpdateBtn.requestFocusInWindow();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LAST_CLOSED = System.currentTimeMillis();
            }
        });
    }

    public static TvDataServiceProxy[] getActiveDataServices() {
        ArrayList<TvDataServiceProxy> services = new ArrayList<TvDataServiceProxy>();
        for (Channel channel : ChannelList.getSubscribedChannels()) {
            if (channel instanceof DummyChannel || channel.getDataServiceProxy() == null || services.contains(channel.getDataServiceProxy())) continue;
            services.add(channel.getDataServiceProxy());
        }
        return services.toArray(new TvDataServiceProxy[services.size()]);
    }

    private boolean tvDataServiceIsChecked(TvDataServiceProxy service, String[] serviceNames) {
        if (serviceNames == null) {
            return true;
        }
        for (String serviceName : serviceNames) {
            if (service.getId().compareTo(serviceName) != 0) continue;
            return true;
        }
        return false;
    }

    public int getResult() {
        return SHOW ? this.mResult : ((PeriodItem)this.mManuelDownloadPeriodSelection.getSelectedItem()).getDays();
    }

    public TvDataServiceProxy[] getSelectedTvDataServices() {
        if (!SHOW) {
            this.selectDataServices();
        }
        if (this.mSelectedTvDataServiceArr == null) {
            this.mSelectedTvDataServiceArr = UpdateDlg.getActiveDataServices();
        }
        return this.mSelectedTvDataServiceArr;
    }

    private void selectDataServices() {
        if (this.mDataServiceCbArr == null) {
            this.mSelectedTvDataServiceArr = UpdateDlg.getActiveDataServices();
        } else {
            ArrayList<TvDataServiceProxy> dataServiceList = new ArrayList<TvDataServiceProxy>();
            for (TvDataServiceCheckBox element : this.mDataServiceCbArr) {
                if (!element.isSelected()) continue;
                dataServiceList.add(element.getTvDataService());
            }
            this.mSelectedTvDataServiceArr = new TvDataServiceProxy[dataServiceList.size()];
            dataServiceList.toArray(this.mSelectedTvDataServiceArr);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mCancelBtn) {
            this.close();
        } else if (source == this.mHideForSession) {
            SHOW = !this.mHideForSession.isSelected();
        } else if (source == this.mUpdateBtn) {
            PeriodItem pi = (PeriodItem)this.mManuelDownloadPeriodSelection.getSelectedItem();
            this.mResult = pi.getDays();
            this.selectDataServices();
            if (this.mSaveAsDefaultPeriod.isSelected()) {
                Settings.Data.DOWNLOAD_PERIOD.setInt(this.mResult);
            }
            if (this.mSaveAsDefaultDataservices == null || this.mSaveAsDefaultDataservices.isSelected()) {
                String[] dataServiceArr = new String[this.mSelectedTvDataServiceArr.length];
                for (int i = 0; i < dataServiceArr.length; ++i) {
                    dataServiceArr[i] = this.mSelectedTvDataServiceArr[i].getId();
                }
                Settings.Data.DATA_SERVICES_FOR_UPDATE.setStringArray(dataServiceArr);
            }
            if (this.mAutoUpdate.isSelected()) {
                if (Settings.General.AUTO_DOWNLOAD_TYPE.getString().equals("never")) {
                    Settings.General.AUTO_DOWNLOAD_TYPE.setString(Settings.General.AUTO_DOWNLOAD_TYPE.getDefault());
                }
                Settings.General.AUTO_DOWNLOAD_PERIOD.setInt(((PeriodItem)this.mAutoDownloadPeriodSelection.getSelectedItem()).getDays());
            } else {
                Settings.General.AUTO_DOWNLOAD_TYPE.setString("never");
            }
            Settings.General.AUTO_DATA_DOWNLOAD_ENABLED.setBoolean(this.mAutoUpdate.isSelected() && this.mRecurrentUpdate.isSelected());
            this.setVisible(false);
        }
    }

    @Override
    public void close() {
        LAST_CLOSED = System.currentTimeMillis();
        this.mResult = -1;
        this.setVisible(false);
    }

    public void setNumberOfDays(int numberOfDays) {
        for (PeriodItem item : PeriodItem.getPeriodItems()) {
            if (item.getDays() < numberOfDays) continue;
            this.mManuelDownloadPeriodSelection.setSelectedItem(item);
            return;
        }
    }
}

