/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.pluginview;

import devplugin.Date;
import devplugin.Plugin;
import devplugin.PluginTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tvbrowser.core.TvDataUpdateListener;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.pluginview.Node;
import tvbrowser.ui.pluginview.PluginTree;

public class PluginTreeModel
extends DefaultTreeModel {
    private static PluginTreeModel sInstance;
    private boolean mDisableUpdate;

    private PluginTreeModel() {
        super(new Node(0, (Object)"Plugins"));
        TvDataUpdater.getInstance().addTvDataUpdateListener(new TvDataUpdateListener(){

            @Override
            public void tvDataUpdateFinished() {
                PluginTreeModel.this.mDisableUpdate = false;
            }

            @Override
            public void tvDataUpdateStarted(Date until) {
                PluginTreeModel.this.mDisableUpdate = true;
            }
        });
    }

    public void update() {
        if (!this.mDisableUpdate) {
            MutableTreeNode rootNode = (MutableTreeNode)this.getRoot();
            Enumeration<? extends TreeNode> e = rootNode.children();
            while (e.hasMoreElements() && !this.mDisableUpdate) {
                TreeNode n = e.nextElement();
                if (!(n instanceof DefaultMutableTreeNode)) continue;
                Object o = ((DefaultMutableTreeNode)n).getUserObject();
                if (o instanceof Plugin) {
                    Plugin p = (Plugin)o;
                    p.getRootNode().update();
                    continue;
                }
                if (n.equals(FavoritesPlugin.getInstance().getRootNode().getMutableTreeNode())) {
                    FavoritesPlugin.getInstance().getRootNode().update();
                    continue;
                }
                if (!n.equals(ReminderPlugin.getRootNode().getMutableTreeNode())) continue;
                ReminderPlugin.getRootNode().update();
            }
        }
    }

    public void setDisableUpdate(boolean disabled) {
        this.mDisableUpdate = disabled;
    }

    public void addCustomNode(PluginTreeNode n) {
        this.insertSorted(n);
    }

    public void addPluginTree(PluginProxy plugin) {
        PluginTreeNode pluginRoot = null;
        if (plugin.canUseProgramTree()) {
            pluginRoot = plugin.getRootNode();
        } else if (plugin.hasArtificialPluginTree()) {
            pluginRoot = plugin.getArtificialRootNode();
        }
        if (pluginRoot != null) {
            this.addCustomNode(pluginRoot);
        }
    }

    private void insertSorted(PluginTreeNode pluginRoot) {
        MutableTreeNode rootNode = (MutableTreeNode)this.getRoot();
        ArrayList<String> pluginNames = new ArrayList<String>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            pluginNames.add(rootNode.getChildAt(i).toString());
        }
        Collections.sort(pluginNames);
        int index = pluginNames.indexOf(pluginRoot.getUserObject().toString());
        index = index == -1 ? Collections.binarySearch(pluginNames, pluginRoot.getUserObject().toString()) : -index - 1;
        rootNode.insert(pluginRoot.getMutableTreeNode(), -index - 1);
        if (pluginRoot.getMutableTreeNode().getIcon() == null) {
            if (pluginRoot.getUserObject() instanceof Plugin) {
                pluginRoot.getMutableTreeNode().setIcon(PluginProxyManager.getInstance().getActivatedPluginForId(((Plugin)pluginRoot.getUserObject()).getId()).getPluginIcon());
            } else if (pluginRoot.getUserObject() instanceof PluginProxy) {
                pluginRoot.getMutableTreeNode().setIcon(((PluginProxy)pluginRoot.getUserObject()).getPluginIcon());
            }
        }
    }

    public void removeAllChildNodes() {
        MutableTreeNode rootNode = (MutableTreeNode)this.getRoot();
        while (rootNode.getChildCount() > 0) {
            rootNode.remove(0);
        }
    }

    public static Plugin getPlugin(TreePath path) {
        if (path.getPathCount() > 1) {
            Object o = path.getPathComponent(1);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            if ((o = node.getUserObject()) instanceof Plugin) {
                Plugin plugin = (Plugin)o;
                return plugin;
            }
        }
        return null;
    }

    public static PluginProxy getPluginProxy(TreePath path) {
        if (path.getPathCount() > 1) {
            Object o = path.getPathComponent(1);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            if ((o = node.getUserObject()) instanceof PluginProxy) {
                PluginProxy proxy = (PluginProxy)o;
                return proxy;
            }
        }
        return null;
    }

    @Override
    public void reload(TreeNode node) {
        PluginTree t;
        TreePath selection = PluginTree.getInstance() != null ? PluginTree.getInstance().getSelectionPath() : null;
        TreePath treePath = new TreePath(this.getPathToRoot(node));
        Enumeration<TreePath> e = null;
        if (treePath != null && (t = PluginTree.getInstance()) != null) {
            e = PluginTree.getInstance().getExpandedDescendants(treePath);
        }
        super.reload(node);
        if (e != null) {
            while (e.hasMoreElements()) {
                TreePath tree = e.nextElement();
                Object[] o = tree.getPath();
                block1: for (int i = 1; i < o.length; ++i) {
                    TreeNode[] pathNodes = this.getPathToRoot((TreeNode)o[i]);
                    if (node != null && pathNodes[0].toString().compareTo("Plugins") == 0) continue;
                    TreeNode n1 = (TreeNode)o[i - 1];
                    Enumeration<? extends TreeNode> e1 = n1.children();
                    while (e1.hasMoreElements()) {
                        TreeNode n2 = e1.nextElement();
                        if (n2.toString().compareTo(o[i].toString()) != 0) continue;
                        o[i] = n2;
                        continue block1;
                    }
                }
                tree = new TreePath(o);
                PluginTree.getInstance().expandPath(tree);
            }
        }
        if (selection != null) {
            PluginTree.getInstance().setSelectionPath(selection);
        }
    }

    public static PluginTreeModel getInstance() {
        if (sInstance == null) {
            sInstance = new PluginTreeModel();
        }
        return sInstance;
    }

    @Override
    public boolean isLeaf(Object nodeObject) {
        if (nodeObject instanceof Node) {
            Node node = (Node)nodeObject;
            return node.getChildCount() == 0;
        }
        return super.isLeaf(nodeObject);
    }
}

