/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.SettingsTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import tvbrowser.core.Settings;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.TrayBaseSettingsTab;
import tvbrowser.ui.settings.tablebackgroundstyles.DayTimeBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.SingleColorBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.SingleImageBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.TableBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.TimeBlockBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.UiColorBackgroundStyle;
import tvbrowser.ui.settings.tablebackgroundstyles.UiTimeBlockBackgroundStyle;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.i18n.Localizer;
import util.ui.CaretPositionCorrector;
import util.ui.ExtensionFileFilter;
import util.ui.UiUtilities;

public class ProgramTableSettingsTab
implements SettingsTab,
ActionListener {
    static final Localizer LOCALIZER = Localizer.getLocalizerFor(ProgramTableSettingsTab.class);
    private JPanel mSettingsPn;
    private JComboBox<String> mProgramArrangementCB;
    private JComboBox<TableBackgroundStyle> mBackgroundStyleCB;
    private JButton mConfigBackgroundStyleBt;
    private JButton mDefaultBtn;
    private JSpinner mColWidth;
    private JSpinner mStartOfDayTimeSp;
    private JSpinner mEndOfDayTimeSp;
    private JCheckBox mMouseOverCb;
    private ColorLabel mMouseOverColorLb;
    private ColorLabel mForegroundColorLb;
    private short mLastSelectedLayoutIndex;
    private JCheckBox mAutoScrollCb;
    private JCheckBox mScrollHorizontalCb;
    private ColorButton mProgramPanelForegroundColorChangeBtn;
    private JComponent mForegroundSeparator;
    private JLabel mForegroundLabel;
    private JCheckBox mTypeAsYouFind;
    private JCheckBox mAutoChangeDate;
    private ColorLabel mLightColorLb;
    private ColorLabel mDarkColorLb;
    private ColorButton mLight;
    private ColorButton mDark;
    private JCheckBox mShowScrollHighlight;
    private JCheckBox mHighlightChannelScroll;
    private JCheckBox mHighlightChannelMouse;
    private ColorLabel mScrollChannelLb;
    private ColorButton mScrollChannelColor;

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mDefaultBtn) {
            this.mColWidth.setValue(Settings.ProgramTable.COLUMN_WIDTH.getDefault());
        }
    }

    @Override
    public JPanel createSettingsPanel() {
        FormLayout layout = new FormLayout("5dlu, pref, 3dlu, pref, 3dlu, pref, fill:pref:grow, 3dlu", "");
        this.mSettingsPn = new JPanel((LayoutManager)layout);
        this.mSettingsPn.setBorder(Borders.DIALOG);
        int currentRow = 1;
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"10dlu"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("layout", "Layout")), CC.xyw((int)1, (int)currentRow, (int)8));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("programArrangement", "Program arrangement")), CC.xy((int)2, (int)(currentRow += 2)));
        String[] arrangementArr = new String[]{LOCALIZER.msg("timeSynchronous", "Time synchronous"), LOCALIZER.msg("realSynchronous", "Real time synchronous"), LOCALIZER.msg("compact", "Compact"), LOCALIZER.msg("realCompact", "Real compact"), LOCALIZER.msg("timeBlock", "Time block"), LOCALIZER.msg("compactTimeBlock", "Compact time block"), LOCALIZER.msg("optimizedCompactTimeBlock", "Optimized compact time block")};
        this.mProgramArrangementCB = new JComboBox<String>(arrangementArr);
        if (Settings.ProgramTable.LAYOUT.getString().equals("compact")) {
            this.mProgramArrangementCB.setSelectedIndex(2);
        } else if (Settings.ProgramTable.LAYOUT.getString().equals("realCompact")) {
            this.mProgramArrangementCB.setSelectedIndex(3);
        } else if (Settings.ProgramTable.LAYOUT.getString().equals("timeSynchronous")) {
            this.mProgramArrangementCB.setSelectedIndex(0);
        } else if (Settings.ProgramTable.LAYOUT.getString().equals("timeBlock")) {
            this.mProgramArrangementCB.setSelectedIndex(4);
        } else if (Settings.ProgramTable.LAYOUT.getString().equals("compactTimeBlock")) {
            this.mProgramArrangementCB.setSelectedIndex(5);
        } else if (Settings.ProgramTable.LAYOUT.getString().equals("optimizedCompactTimeBlock")) {
            this.mProgramArrangementCB.setSelectedIndex(6);
        } else {
            this.mProgramArrangementCB.setSelectedIndex(1);
        }
        this.mLastSelectedLayoutIndex = (short)this.mProgramArrangementCB.getSelectedIndex();
        this.mSettingsPn.add(this.mProgramArrangementCB, CC.xy((int)4, (int)currentRow));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"10dlu"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("columnwidth", "column width")), CC.xyw((int)1, (int)(currentRow += 2), (int)8));
        int width = Settings.ProgramTable.COLUMN_WIDTH.getInt();
        if (width > 2000) {
            width = 2000;
        }
        if (width < 100) {
            width = 100;
        }
        this.mColWidth = new JSpinner(new SpinnerNumberModel(width, 100, 2000, 1));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("widthInPixels", "Width in Pixels")), CC.xy((int)2, (int)(currentRow += 2)));
        this.mSettingsPn.add((Component)this.mColWidth, CC.xy((int)4, (int)currentRow));
        this.mDefaultBtn = new JButton(Localizer.getLocalization("i18n_default"));
        this.mDefaultBtn.addActionListener(this);
        this.mSettingsPn.add((Component)this.mDefaultBtn, CC.xy((int)6, (int)currentRow));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"10dlu"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("range", "Range")), CC.xyw((int)1, (int)(currentRow += 2), (int)8));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("startOfDay", "Start of day")), CC.xy((int)2, (int)(currentRow += 2)));
        TwoSpinnerDateModel startModel = new TwoSpinnerDateModel();
        this.mStartOfDayTimeSp = new JSpinner(startModel);
        startModel.setMe(this.mStartOfDayTimeSp);
        JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(this.mStartOfDayTimeSp, Settings.getTimePattern());
        this.mStartOfDayTimeSp.setEditor(dateEditor);
        this.mSettingsPn.add((Component)this.mStartOfDayTimeSp, CC.xy((int)4, (int)currentRow));
        this.mSettingsPn.add((Component)new JLabel("(" + Localizer.getLocalization("i18n_today") + ")"), CC.xy((int)6, (int)currentRow));
        CaretPositionCorrector.createCorrector(dateEditor.getTextField(), new char[]{':'}, -1);
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("endOfDay", "End of day")), CC.xy((int)2, (int)(currentRow += 2)));
        TwoSpinnerDateModel endModel = new TwoSpinnerDateModel();
        this.mEndOfDayTimeSp = new JSpinner(endModel);
        endModel.setMe(this.mEndOfDayTimeSp);
        dateEditor = new JSpinner.DateEditor(this.mEndOfDayTimeSp, Settings.getTimePattern());
        this.mEndOfDayTimeSp.setEditor(dateEditor);
        this.mSettingsPn.add((Component)this.mEndOfDayTimeSp, CC.xy((int)4, (int)currentRow));
        this.mSettingsPn.add((Component)new JLabel("(" + LOCALIZER.msg("nextDay", "next day") + ")"), CC.xy((int)6, (int)currentRow));
        CaretPositionCorrector.createCorrector(dateEditor.getTextField(), new char[]{':'}, -1);
        Calendar cal = Calendar.getInstance();
        cal.set(11, Settings.ProgramTable.START_OF_DAY.getHourOfDay());
        cal.set(12, Settings.ProgramTable.START_OF_DAY.getMinutesOfHour());
        this.mStartOfDayTimeSp.setValue(cal.getTime());
        cal.set(11, Settings.ProgramTable.END_OF_DAY.getHourOfDay());
        cal.set(12, Settings.ProgramTable.END_OF_DAY.getMinutesOfHour());
        this.mEndOfDayTimeSp.setValue(cal.getTime());
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"10dlu"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("tableBackground", "Table background")), CC.xyw((int)1, (int)(currentRow += 2), (int)8));
        this.mSettingsPn.add((Component)new JLabel(LOCALIZER.msg("tableBackgroundStyle", "Table background style")), CC.xy((int)2, (int)(currentRow += 2)));
        TableBackgroundStyle[] styles = this.getTableBackgroundStyles();
        this.mBackgroundStyleCB = new JComboBox<TableBackgroundStyle>(styles);
        String style = Settings.ProgramTable.STYLE_BACKGROUND.getString();
        for (int i = 0; i < styles.length; ++i) {
            if (!styles[i].getSettingsString().equals(style)) continue;
            this.mBackgroundStyleCB.setSelectedIndex(i);
            break;
        }
        this.mBackgroundStyleCB.addItemListener(e -> this.updateBackgroundStyleConfigureButton());
        this.mSettingsPn.add(this.mBackgroundStyleCB, CC.xy((int)4, (int)currentRow));
        this.mConfigBackgroundStyleBt = new JButton(LOCALIZER.ellipsisMsg("configure", "Configure"));
        this.mConfigBackgroundStyleBt.addActionListener(e -> {
            ConfigureBackgroundStyleDialog dlg = new ConfigureBackgroundStyleDialog(this.mBackgroundStyleCB, (TableBackgroundStyle)this.mBackgroundStyleCB.getSelectedItem());
            dlg.show();
        });
        this.mSettingsPn.add((Component)this.mConfigBackgroundStyleBt, CC.xy((int)6, (int)currentRow));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        this.mForegroundColorLb = new ColorLabel(Settings.ProgramPanel.COLOR_FOREGROUND.getColor());
        this.mForegroundColorLb.setStandardColor(Settings.ProgramPanel.COLOR_FOREGROUND.getDefaultColor());
        this.mProgramPanelForegroundColorChangeBtn = new ColorButton(this.mForegroundColorLb);
        this.mForegroundSeparator = DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("foreground", "Foreground"));
        this.mForegroundLabel = new JLabel(LOCALIZER.msg("fontColor", "Font color"));
        this.mSettingsPn.add((Component)this.mForegroundSeparator, CC.xyw((int)1, (int)(currentRow += 2), (int)8));
        this.mSettingsPn.add((Component)this.mForegroundLabel, CC.xy((int)2, (int)(currentRow += 2)));
        this.mSettingsPn.add((Component)this.mForegroundColorLb, CC.xy((int)4, (int)currentRow));
        this.mSettingsPn.add((Component)this.mProgramPanelForegroundColorChangeBtn, CC.xy((int)6, (int)currentRow));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"10dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"10dlu"));
        layout.appendRow(RowSpec.decode((String)"default"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"default"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"default"));
        layout.appendRow(RowSpec.decode((String)"3dlu"));
        layout.appendRow(RowSpec.decode((String)"default"));
        layout.appendRow(RowSpec.decode((String)"10dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        layout.appendRow(RowSpec.decode((String)"5dlu"));
        layout.appendRow(RowSpec.decode((String)"pref"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("mouse", "Mouse")), CC.xyw((int)1, (int)(currentRow += 2), (int)8));
        this.mMouseOverCb = new JCheckBox(LOCALIZER.msg("MouseOver", "Mouse-Over-Effect"));
        this.mMouseOverCb.setSelected(Settings.ProgramTable.MOUSE_OVER.getBoolean());
        this.mSettingsPn.add((Component)this.mMouseOverCb, CC.xy((int)2, (int)(currentRow += 2)));
        this.mMouseOverColorLb = new ColorLabel(Settings.ProgramTable.COLOR_MOUSE_OVER.getColor());
        this.mMouseOverColorLb.setStandardColor(Settings.ProgramTable.COLOR_MOUSE_OVER.getDefaultColor());
        ColorButton mouseOverColorChangeBtn = new ColorButton(this.mMouseOverColorLb);
        this.mMouseOverCb.addActionListener(e -> {
            boolean enabled = this.mMouseOverCb.isSelected();
            this.mMouseOverColorLb.setEnabled(enabled);
            mouseOverColorChangeBtn.setEnabled(enabled);
        });
        this.mMouseOverCb.getActionListeners()[0].actionPerformed(null);
        this.mTypeAsYouFind = new JCheckBox(LOCALIZER.msg("typeAsYouFind", "Type-As-You-Find enabled"), Settings.ProgramTable.FIND_AS_YOU_TYPE.getBoolean());
        this.mSettingsPn.add((Component)this.mMouseOverColorLb, CC.xy((int)4, (int)currentRow));
        this.mSettingsPn.add((Component)mouseOverColorChangeBtn, CC.xy((int)6, (int)currentRow));
        this.mAutoScrollCb = new JCheckBox(LOCALIZER.msg("mouseAutoScroll", "Throw'n scroll"));
        this.mAutoScrollCb.setSelected(Settings.ProgramTable.MOUSE_AUTO_SCROLL.getBoolean());
        this.mSettingsPn.add((Component)this.mAutoScrollCb, CC.xyw((int)2, (int)(currentRow += 2), (int)6));
        this.mScrollHorizontalCb = new JCheckBox(LOCALIZER.msg("mouseScrollHorizontal", "Scroll horizontal with mouse wheel"));
        this.mScrollHorizontalCb.setSelected(Settings.ProgramTable.SCROLL_HORIZONTAL.getBoolean());
        this.mSettingsPn.add((Component)this.mScrollHorizontalCb, CC.xyw((int)2, (int)(currentRow += 2), (int)6));
        this.mAutoChangeDate = new JCheckBox(LOCALIZER.msg("mouseAutoChangeDate", "Automatically change date when scrolling with mouse wheel against top and bottom"));
        this.mAutoChangeDate.setSelected(Settings.ProgramTable.AUTO_CHANGE_DATE.getBoolean());
        this.mSettingsPn.add((Component)this.mAutoChangeDate, CC.xyw((int)2, (int)(currentRow += 2), (int)6));
        this.mShowScrollHighlight = new JCheckBox(LOCALIZER.msg("activated", "Activated"), Settings.ProgramTable.SCROLL_TO_TIME_MARKING.getBoolean());
        this.mLightColorLb = new ColorLabel(Settings.ProgramTable.COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_LIGHT.getColor());
        this.mLightColorLb.setStandardColor(Settings.ProgramTable.COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_LIGHT.getDefaultColor());
        this.mLightColorLb.setEnabled(this.mShowScrollHighlight.isSelected());
        this.mDarkColorLb = new ColorLabel(Settings.ProgramTable.COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_DARK.getColor());
        this.mDarkColorLb.setStandardColor(Settings.ProgramTable.COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_DARK.getDefaultColor());
        this.mDarkColorLb.setEnabled(this.mShowScrollHighlight.isSelected());
        this.mLight = new ColorButton(this.mLightColorLb);
        this.mLight.setEnabled(this.mShowScrollHighlight.isSelected());
        this.mDark = new ColorButton(this.mDarkColorLb);
        this.mDark.setEnabled(this.mShowScrollHighlight.isSelected());
        JLabel mLightDesc = new JLabel(TrayBaseSettingsTab.LOCALIZER.msg("progressLight", "Background color"));
        JLabel mDarkDesc = new JLabel(TrayBaseSettingsTab.LOCALIZER.msg("progressDark", "Progress color"));
        this.mShowScrollHighlight.addItemListener(e -> {
            this.mLightColorLb.setEnabled(e.getStateChange() == 1);
            this.mDarkColorLb.setEnabled(this.mLightColorLb.isEnabled());
            this.mLight.setEnabled(this.mLightColorLb.isEnabled());
            this.mDark.setEnabled(this.mLightColorLb.isEnabled());
            mLightDesc.setEnabled(this.mLightColorLb.isEnabled());
            mDarkDesc.setEnabled(this.mLightColorLb.isEnabled());
        });
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("scrollToTimeTitle", "Highlight programs running at jump time")), CC.xyw((int)1, (int)(currentRow += 2), (int)8));
        this.mSettingsPn.add((Component)this.mShowScrollHighlight, CC.xyw((int)2, (int)(currentRow += 2), (int)2));
        this.mSettingsPn.add((Component)mLightDesc, CC.xy((int)2, (int)(currentRow += 2)));
        this.mSettingsPn.add((Component)this.mLightColorLb, CC.xy((int)4, (int)currentRow));
        this.mSettingsPn.add((Component)this.mLight, CC.xy((int)6, (int)currentRow));
        this.mSettingsPn.add((Component)mDarkDesc, CC.xy((int)2, (int)(currentRow += 2)));
        this.mSettingsPn.add((Component)this.mDarkColorLb, CC.xy((int)4, (int)currentRow));
        this.mSettingsPn.add((Component)this.mDark, CC.xy((int)6, (int)currentRow));
        this.mHighlightChannelScroll = new JCheckBox(LOCALIZER.msg("highlightChannel.scroll", "scrolled to"), Settings.ProgramTable.HIGHLIGHT_CHANNEL_COLUMN_BY_SCROLLING.getBoolean());
        this.mHighlightChannelMouse = new JCheckBox(LOCALIZER.msg("highlightChannel.mouse", "mouse pointer enters channel column header"), Settings.ProgramTable.HIGHLIGHT_CHANNEL_COLUMN_BY_MOUSE.getBoolean());
        JLabel highlightChannelColorLabel = new JLabel(LOCALIZER.msg("highlightChannel.color", "Color"));
        this.mScrollChannelLb = new ColorLabel(Settings.ProgramTable.COLOR_HIGHLIGHT_CHANNEL_PROGRAMS_BACKGROUND.getColor());
        this.mScrollChannelLb.setStandardColor(Settings.ProgramTable.COLOR_HIGHLIGHT_CHANNEL_PROGRAMS_BACKGROUND.getDefaultColor());
        this.mScrollChannelLb.setEnabled(this.mHighlightChannelScroll.isSelected());
        this.mScrollChannelColor = new ColorButton(this.mScrollChannelLb);
        this.mScrollChannelColor.setEnabled(this.mHighlightChannelScroll.isSelected());
        this.mHighlightChannelScroll.addItemListener(e -> {
            this.mScrollChannelLb.setEnabled(e.getStateChange() == 1 || this.mHighlightChannelMouse.isSelected());
            this.mScrollChannelColor.setEnabled(this.mScrollChannelLb.isEnabled());
            highlightChannelColorLabel.setEnabled(this.mScrollChannelLb.isEnabled());
        });
        this.mHighlightChannelMouse.addItemListener(e -> {
            this.mScrollChannelLb.setEnabled(e.getStateChange() == 1 || this.mHighlightChannelScroll.isSelected());
            this.mScrollChannelColor.setEnabled(this.mScrollChannelLb.isEnabled());
            highlightChannelColorLabel.setEnabled(this.mScrollChannelLb.isEnabled());
        });
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("highlightChannel.title", "Highlight channel...")), CC.xyw((int)1, (int)(currentRow += 2), (int)8));
        this.mSettingsPn.add((Component)this.mHighlightChannelScroll, CC.xyw((int)2, (int)(currentRow += 2), (int)5));
        this.mSettingsPn.add((Component)this.mHighlightChannelMouse, CC.xyw((int)2, (int)(currentRow += 2), (int)5));
        this.mSettingsPn.add((Component)highlightChannelColorLabel, CC.xy((int)2, (int)(currentRow += 2)));
        this.mSettingsPn.add((Component)this.mScrollChannelLb, CC.xy((int)4, (int)currentRow));
        this.mSettingsPn.add((Component)this.mScrollChannelColor, CC.xy((int)6, (int)currentRow));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(LOCALIZER.msg("misc", "Misc")), CC.xyw((int)1, (int)(currentRow += 2), (int)8));
        this.mSettingsPn.add((Component)this.mTypeAsYouFind, CC.xyw((int)2, (int)(currentRow += 2), (int)6));
        this.updateBackgroundStyleConfigureButton();
        return this.mSettingsPn;
    }

    private void updateBackgroundStyleConfigureButton() {
        TableBackgroundStyle style = (TableBackgroundStyle)this.mBackgroundStyleCB.getSelectedItem();
        this.mForegroundColorLb.setEnabled(!style.getSettingsString().equals("uiTimeBlock") && !style.getSettingsString().equals("uiColor"));
        this.mProgramPanelForegroundColorChangeBtn.setEnabled(this.mForegroundColorLb.isEnabled());
        this.mForegroundLabel.setEnabled(this.mForegroundColorLb.isEnabled());
        this.mForegroundSeparator.getComponent(0).setEnabled(this.mForegroundColorLb.isEnabled());
        this.mConfigBackgroundStyleBt.setEnabled(style.hasContent());
    }

    public static JButton createBrowseButton(Component parent, JTextField tf) {
        JButton bt = new JButton(LOCALIZER.msg("change", "Change"));
        bt.addActionListener(event -> {
            File selection;
            File file = new File(tf.getText());
            JFileChooser fileChooser = new JFileChooser(file.getParent());
            String[] extArr = new String[]{".jpg", ".jpeg", ".gif", ".png"};
            fileChooser.setFileFilter(new ExtensionFileFilter(extArr, ".jpg, .gif, png"));
            if (fileChooser.showOpenDialog(parent) == 0 && (selection = fileChooser.getSelectedFile()) != null) {
                tf.setText(selection.getAbsolutePath());
            }
        });
        Dimension size = bt.getPreferredSize();
        if (tf.getPreferredSize().height > size.height) {
            size.height = tf.getPreferredSize().height;
            bt.setPreferredSize(size);
        }
        return bt;
    }

    private void setBackgroundStyleForTimeBlockLayout() {
        if (!Settings.ProgramTable.LAYOUT.getString().equals("timeBlock") && !Settings.ProgramTable.LAYOUT.getString().equals("compactTimeBlock")) {
            Settings.ProgramTable.STYLE_BACKGROUND.setString("uiTimeBlock");
            Settings.ProgramTable.TIME_BLOCK_SHOW_WEST.setBoolean(true);
        }
    }

    private void resetBackgroundStyle() {
        if (Settings.ProgramTable.LAYOUT.getString().equals("timeBlock") || Settings.ProgramTable.LAYOUT.getString().equals("compactTimeBlock") || Settings.ProgramTable.LAYOUT.getString().equals("optimizedCompactTimeBlock")) {
            Settings.ProgramTable.STYLE_BACKGROUND.setString("uiColor");
            Settings.ProgramTable.TIME_BLOCK_SHOW_WEST.setBoolean(false);
        }
    }

    @Override
    public void saveSettings() {
        String backgroundStyle = ((TableBackgroundStyle)this.mBackgroundStyleCB.getSelectedItem()).getSettingsString();
        Settings.ProgramTable.STYLE_BACKGROUND.setString(backgroundStyle);
        if (this.mProgramArrangementCB.getSelectedIndex() == 2 && this.mLastSelectedLayoutIndex != 2) {
            this.resetBackgroundStyle();
            Settings.ProgramTable.LAYOUT.setString("compact");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 3 && this.mLastSelectedLayoutIndex != 3) {
            this.resetBackgroundStyle();
            Settings.ProgramTable.LAYOUT.setString("realCompact");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 0 && this.mLastSelectedLayoutIndex != 0) {
            this.resetBackgroundStyle();
            Settings.ProgramTable.LAYOUT.setString("timeSynchronous");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 4 && this.mLastSelectedLayoutIndex != 4) {
            this.setBackgroundStyleForTimeBlockLayout();
            Settings.ProgramTable.LAYOUT.setString("timeBlock");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 5 && this.mLastSelectedLayoutIndex != 5) {
            this.setBackgroundStyleForTimeBlockLayout();
            Settings.ProgramTable.LAYOUT.setString("compactTimeBlock");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 6 && this.mLastSelectedLayoutIndex != 6) {
            this.setBackgroundStyleForTimeBlockLayout();
            Settings.ProgramTable.LAYOUT.setString("optimizedCompactTimeBlock");
        } else if (this.mProgramArrangementCB.getSelectedIndex() == 1 && this.mLastSelectedLayoutIndex != 1) {
            this.resetBackgroundStyle();
            Settings.ProgramTable.LAYOUT.setString("realSynchronous");
        }
        Settings.ProgramTable.COLUMN_WIDTH.setInt((Integer)this.mColWidth.getValue());
        Settings.ProgramPanel.COLOR_FOREGROUND.setColor(this.mForegroundColorLb.getColor());
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)this.mStartOfDayTimeSp.getValue());
        int minutes = cal.get(11) * 60 + cal.get(12);
        Settings.ProgramTable.START_OF_DAY.setInt(minutes);
        cal.setTime((Date)this.mEndOfDayTimeSp.getValue());
        minutes = cal.get(11) * 60 + cal.get(12);
        Settings.ProgramTable.END_OF_DAY.setInt(minutes);
        Settings.ProgramTable.MOUSE_OVER.setBoolean(this.mMouseOverCb.isSelected());
        Settings.ProgramTable.SCROLL_HORIZONTAL.setBoolean(this.mScrollHorizontalCb.isSelected());
        Settings.ProgramTable.AUTO_CHANGE_DATE.setBoolean(this.mAutoChangeDate.isSelected());
        Settings.ProgramTable.COLOR_MOUSE_OVER.setColor(this.mMouseOverColorLb.getColor());
        Settings.ProgramTable.MOUSE_AUTO_SCROLL.setBoolean(this.mAutoScrollCb.isSelected());
        Settings.ProgramTable.SCROLL_TO_TIME_MARKING.setBoolean(this.mShowScrollHighlight.isSelected());
        Settings.ProgramTable.COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_LIGHT.setColor(this.mLightColorLb.getColor());
        Settings.ProgramTable.COLOR_SCROLL_TO_TIME_PROGRAMS_BACKGROUND_DARK.setColor(this.mDarkColorLb.getColor());
        Settings.ProgramTable.HIGHLIGHT_CHANNEL_COLUMN_BY_SCROLLING.setBoolean(this.mHighlightChannelScroll.isSelected());
        Settings.ProgramTable.HIGHLIGHT_CHANNEL_COLUMN_BY_MOUSE.setBoolean(this.mHighlightChannelMouse.isSelected());
        Settings.ProgramTable.COLOR_HIGHLIGHT_CHANNEL_PROGRAMS_BACKGROUND.setColor(this.mScrollChannelLb.getColor());
        Settings.ProgramTable.FIND_AS_YOU_TYPE.setBoolean(this.mTypeAsYouFind.isSelected());
        MainFrame.getInstance().getProgramTableScrollPane().getProgramTable().clearTimeMarkings();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return LOCALIZER.msg("title", "Program table");
    }

    private TableBackgroundStyle[] getTableBackgroundStyles() {
        return new TableBackgroundStyle[]{new SingleColorBackgroundStyle(), new UiColorBackgroundStyle(), new SingleImageBackgroundStyle(), new TimeBlockBackgroundStyle(), new UiTimeBlockBackgroundStyle(), new DayTimeBackgroundStyle()};
    }

    private class TwoSpinnerDateModel
    extends SpinnerDateModel {
        private JSpinner mMeSpinner;

        private TwoSpinnerDateModel() {
        }

        protected void setMe(JSpinner me) {
            this.mMeSpinner = me;
        }

        @Override
        public void setValue(Object value) {
            this.correctValues((Date)value);
            super.setValue(value);
        }

        @Override
        public Object getPreviousValue() {
            Date d = (Date)super.getPreviousValue();
            this.correctValues(d);
            return d;
        }

        @Override
        public Object getNextValue() {
            Date d = (Date)super.getNextValue();
            this.correctValues(d);
            return d;
        }

        private void correctValues(Date d) {
            if (this.mMeSpinner != null && ProgramTableSettingsTab.this.mStartOfDayTimeSp != null && ProgramTableSettingsTab.this.mEndOfDayTimeSp != null) {
                Calendar cal = Calendar.getInstance();
                if (this.mMeSpinner.equals(ProgramTableSettingsTab.this.mStartOfDayTimeSp)) {
                    cal.setTime((Date)ProgramTableSettingsTab.this.mEndOfDayTimeSp.getValue());
                    int endTime = cal.get(11) * 60 + cal.get(12);
                    cal.setTime(d);
                    int startTime = cal.get(11) * 60 + cal.get(12);
                    if (endTime - startTime < -1) {
                        ProgramTableSettingsTab.this.mEndOfDayTimeSp.setValue(d);
                    }
                } else {
                    cal.setTime(d);
                    int endTime = cal.get(11) * 60 + cal.get(12);
                    cal.setTime((Date)ProgramTableSettingsTab.this.mStartOfDayTimeSp.getValue());
                    int startTime = cal.get(11) * 60 + cal.get(12);
                    if (endTime - startTime < -1) {
                        ProgramTableSettingsTab.this.mStartOfDayTimeSp.setValue(d);
                    }
                }
            }
        }
    }

    private static class ConfigureBackgroundStyleDialog {
        private JDialog mDialog;
        private TableBackgroundStyle mStyle;

        public ConfigureBackgroundStyleDialog(Component parent, TableBackgroundStyle style) {
            this.mStyle = style;
            this.mDialog = UiUtilities.createDialog(parent, true);
            this.mDialog.setTitle(LOCALIZER.msg("configureBackgroundStyleDialogTitle", "Configure background style '{0}'", style.getName()));
            JPanel dialogContent = (JPanel)this.mDialog.getContentPane();
            dialogContent.setBorder(new EmptyBorder(10, 10, 11, 11));
            dialogContent.setLayout(new BorderLayout(0, 15));
            JPanel content = new JPanel(new BorderLayout());
            content.add((Component)style.createSettingsContent(), "North");
            dialogContent.add((Component)content, "Center");
            JPanel buttonPn = new JPanel(new BorderLayout());
            JPanel pn = new JPanel();
            pn.setLayout(new FlowLayout(2, 5, 0));
            JButton okBtn = new JButton(Localizer.getLocalization("i18n_ok"));
            JButton cancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
            pn.add(okBtn);
            pn.add(cancelBtn);
            okBtn.addActionListener(e -> {
                this.mStyle.storeSettings();
                this.mDialog.setVisible(false);
            });
            cancelBtn.addActionListener(e -> this.mDialog.setVisible(false));
            buttonPn.add((Component)pn, "East");
            dialogContent.add((Component)buttonPn, "South");
            this.mDialog.pack();
        }

        public void show() {
            UiUtilities.centerAndShow(this.mDialog);
        }
    }
}

