/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings.channel;

import devplugin.Channel;
import devplugin.ChannelGroup;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.table.AbstractTableModel;
import tvbrowser.core.ChannelList;

public class AvailableChannelsTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"Channel", "Provider", "Country", "Timezone"};
    private ArrayList<Channel> mChannelList = new ArrayList();

    public AvailableChannelsTableModel() {
        Channel[] ch = ChannelList.getAvailableChannels();
        for (int i = 0; i < ch.length; ++i) {
            if (ChannelList.isSubscribedChannel(ch[i])) continue;
            this.mChannelList.add(ch[i]);
        }
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this.mChannelList.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Channel.class;
        }
        return String.class;
    }

    public void removeChannel(Channel ch) {
        this.mChannelList.remove(ch);
        this.fireTableDataChanged();
    }

    public void addRow(Channel ch) {
        this.mChannelList.add(ch);
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Channel ch = this.mChannelList.get(rowIndex);
        ChannelGroup group = ch.getGroup();
        switch (columnIndex) {
            case 0: {
                return ch;
            }
            case 1: {
                if (group != null) {
                    try {
                        return group.getProviderName();
                    }
                    catch (NoSuchMethodError e) {
                        return "-";
                    }
                }
                return "-";
            }
            case 2: {
                String[] countries = ch.getAllCountries();
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < countries.length; ++i) {
                    Locale locale = new Locale(Locale.getDefault().getLanguage(), countries[i]);
                    builder.append(locale.getDisplayCountry());
                    if (i >= countries.length - 1) continue;
                    builder.append(", ");
                }
                return builder.toString();
            }
            case 3: {
                return ch.getTimeZone().getDisplayName();
            }
        }
        return ch;
    }
}

