/*
 * Decompiled with CFR 0.152.
 */
package tvdataservice;

import devplugin.Channel;
import devplugin.Date;
import devplugin.Marker;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramFieldType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tvbrowser.core.PendingMarkings;
import tvbrowser.core.TvDataBase;
import tvbrowser.core.filters.GenericFilterMap;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvdataservice.MarkedProgramsMap;
import util.io.IOUtilities;
import util.misc.HashCodeUtilities;
import util.misc.StringPool;
import util.program.ProgramUtilities;

public class MutableProgram
implements Program {
    private static final Logger mLog = Logger.getLogger(MutableProgram.class.getName());
    private static TimeZone mLocalTimeZone = TimeZone.getDefault();
    public static final int MAX_SHORT_INFO_LENGTH = 200;
    protected static final Marker[] EMPTY_MARKER_ARR = new Marker[0];
    private Vector<ChangeListener> mListenerList;
    private boolean mIsLoading;
    private String mId;
    private String mUniqueId;
    public static final String ID_DATE_FORMAT = "yyyy-MM-dd";
    private Channel mChannel;
    private Date mLocalDate;
    private Date mNormalizedDate;
    private short mNormalizedStartTime;
    private byte mState;
    protected String mTitle;
    private int[] mIntValues;
    private Object[] mObjectValues;

    public MutableProgram(Channel channel, Date localDate, int localHours, int localMinutes, boolean isLoading) {
        this(channel, localDate, isLoading);
        int localStartTime = localHours * 60 + localMinutes;
        this.setTimeField(ProgramFieldType.START_TIME_TYPE, localStartTime);
    }

    public MutableProgram(Channel channel, Date localDate, boolean isLoading) {
        if (channel == null) {
            throw new NullPointerException("channel is null");
        }
        if (localDate == null) {
            throw new NullPointerException("localDate is null");
        }
        this.mIntValues = new int[ProgramFieldType.getIntFieldCount()];
        Arrays.fill(this.mIntValues, -1);
        this.mObjectValues = new Object[ProgramFieldType.getObjectFieldCount()];
        this.mListenerList = null;
        this.mIsLoading = isLoading;
        this.mTitle = null;
        this.mChannel = channel;
        this.mLocalDate = localDate;
        this.setTextField(ProgramFieldType.TITLE_TYPE, "");
        this.mState = 0;
    }

    private Calendar getNormalizedCalendarForTime(int localStartTime) {
        Calendar channelTimeZoneCal = Calendar.getInstance(this.mChannel.getTimeZone());
        channelTimeZoneCal.set(this.mLocalDate.getYear(), this.mLocalDate.getMonth() - 1, this.mLocalDate.getDayOfMonth(), localStartTime / 60, localStartTime % 60);
        channelTimeZoneCal.set(13, 0);
        channelTimeZoneCal.set(14, 0);
        Calendar userTimeZoneCal = Calendar.getInstance(mLocalTimeZone);
        userTimeZoneCal.setTimeInMillis(channelTimeZoneCal.getTimeInMillis());
        userTimeZoneCal.add(12, this.mChannel.getTimeZoneCorrectionMinutes());
        return userTimeZoneCal;
    }

    private void normalizeTimeZone(int localStartTime) {
        Calendar userTimeZoneCal = this.getNormalizedCalendarForTime(localStartTime);
        this.mNormalizedStartTime = (short)(userTimeZoneCal.get(11) * 60 + userTimeZoneCal.get(12));
        this.mNormalizedDate = new Date(userTimeZoneCal);
        String dataServiceId = this.mChannel.getDataServiceId() != null ? this.mChannel.getDataServiceId() : "UnknownDataService";
        String groupId = this.mChannel.getGroup() != null ? this.mChannel.getGroup().getId() : "UnknownChannelGroup";
        String channelId = this.mChannel.getId() != null ? this.mChannel.getId() : "UnknownChannelId";
        String country = this.mChannel.getBaseCountry() != null ? this.mChannel.getBaseCountry() : "UnknownCountry";
        String date = new SimpleDateFormat(ID_DATE_FORMAT).format(this.getDate().getCalendar().getTime());
        this.mId = dataServiceId + '_' + groupId + '_' + country + '_' + channelId + '_' + this.getHours() + ':' + this.getMinutes() + ':' + TimeZone.getDefault().getRawOffset() / 60000;
        this.mUniqueId = dataServiceId + '_' + groupId + '_' + country + '_' + channelId + '_' + date + '_' + this.getHours() + ':' + this.getMinutes() + ':' + TimeZone.getDefault().getRawOffset() / 60000;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        if (this.mListenerList == null) {
            this.mListenerList = new Vector(1);
        }
        if (!this.mListenerList.contains(listener)) {
            this.mListenerList.add(listener);
        }
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        if (this.mListenerList == null) {
            return;
        }
        this.mListenerList.remove(listener);
    }

    protected void fireStateChanged() {
        if (this.mListenerList == null) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.mListenerList.size(); ++i) {
            this.mListenerList.get(i).stateChanged(changeEvent);
        }
    }

    @Override
    public final String getTimeString() {
        return IOUtilities.timeToString(this.getStartTime());
    }

    @Override
    public final String getEndTimeString() {
        return IOUtilities.timeToString(this.getStartTime() + this.getLength());
    }

    @Override
    public final String getDateString() {
        Date d = this.getDate();
        if (d == null) {
            mLog.info(this.mChannel.getName() + " at " + this.getHours() + ":" + this.getMinutes() + ", NO DATE : '" + this.getTitle() + "'");
            return "";
        }
        return d.toString();
    }

    @Override
    public boolean isOnAir() {
        return ProgramUtilities.isOnAir(this);
    }

    @Override
    public final void mark(Plugin javaPlugin) {
        PluginProxy plugin = PluginProxyManager.getInstance().getPluginForId(javaPlugin.getId());
        this.mark(plugin);
    }

    @Override
    public final void unmark(Plugin javaPlugin) {
        PluginProxy plugin = PluginProxyManager.getInstance().getPluginForId(javaPlugin.getId());
        this.unmark(plugin);
    }

    @Override
    public final synchronized void mark(Marker marker) {
        PluginProxy proxy;
        boolean mark = true;
        if (PendingMarkings.usePending() && GenericFilterMap.getInstance().containsKey(marker.getId())) {
            PendingMarkings.addMarker(this, marker);
            mark = false;
        }
        if (mark && (proxy = PluginProxyManager.getInstance().getActivatedPluginForId(marker.getId())) != null) {
            UserFilter filter = GenericFilterMap.getInstance().getGenericPluginFilter(proxy, true);
            boolean bl = mark = filter == null || filter.accept(this);
        }
        if (mark) {
            MarkedProgramsMap.getInstance().addMarkerForProgram(this, marker);
            this.fireStateChanged();
        }
    }

    @Override
    public final synchronized void unmark(Marker marker) {
        MarkedProgramsMap.getInstance().removeMarkerForProgram(this, marker);
        this.fireStateChanged();
    }

    @Override
    public Marker[] getMarkerArr() {
        return MarkedProgramsMap.getInstance().getMarkerForProgram(this);
    }

    @Override
    public boolean isExpired() {
        Date today = Date.getCurrentDate();
        int comp = today.compareTo(this.getDate());
        if (comp < 0) {
            return false;
        }
        if (comp > 0) {
            return !this.isOnAir();
        }
        int currentMinutesAfterMidnight = IOUtilities.getMinutesAfterMidnight();
        int programMinutesAfterMidnight = this.getStartTime() + this.getLength() - 1;
        return programMinutesAfterMidnight < currentMinutesAfterMidnight;
    }

    @Override
    public String getID() {
        return this.mId;
    }

    @Override
    public String getUniqueID() {
        return this.mUniqueId;
    }

    @Override
    public byte[] getBinaryField(ProgramFieldType type) {
        this.checkFormat(type, 2);
        return (byte[])this.getObjectValueField(type);
    }

    @Override
    public String getTextField(ProgramFieldType type) {
        this.checkFormat(type, 3);
        if (type == ProgramFieldType.TITLE_TYPE && this.mTitle != null && this.mTitle.trim().length() > 0) {
            return this.mTitle;
        }
        String value = (String)this.getObjectValueField(type);
        if (type == ProgramFieldType.SHORT_DESCRIPTION_TYPE) {
            value = this.validateShortInfo(value);
        }
        return value;
    }

    protected Object getObjectValueField(ProgramFieldType type) {
        return this.mObjectValues[type.getStorageIndex()];
    }

    @Override
    public int getIntField(ProgramFieldType type) {
        this.checkFormat(type, 4);
        return this.mIntValues[type.getStorageIndex()];
    }

    @Override
    public String getIntFieldAsString(ProgramFieldType type) {
        int value = this.getIntField(type);
        if (value == -1) {
            return null;
        }
        return Integer.toString(value);
    }

    @Override
    public int getTimeField(ProgramFieldType type) {
        this.checkFormat(type, 5);
        return this.mIntValues[type.getStorageIndex()];
    }

    @Override
    public String getTimeFieldAsString(ProgramFieldType type) {
        int value = this.getTimeField(type);
        if (value == -1) {
            return null;
        }
        Calendar userTimeZoneCal = this.getNormalizedCalendarForTime(value);
        return IOUtilities.timeToString(userTimeZoneCal.get(11) * 60 + userTimeZoneCal.get(12));
    }

    @Override
    public int getFieldCount() {
        int count = 0;
        for (int mIntValue : this.mIntValues) {
            if (mIntValue == -1) continue;
            ++count;
        }
        for (Object mObjectValue : this.mObjectValues) {
            if (mObjectValue == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<ProgramFieldType> getFieldIterator() {
        return new ProgramFieldIterator(this);
    }

    public void setBinaryField(ProgramFieldType type, byte[] value) {
        this.checkFormat(type, 2);
        this.setObjectValueField(type, value);
        this.notifyChangedStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setObjectValueField(ProgramFieldType type, Object value) {
        Object[] objectArray = this.mObjectValues;
        synchronized (this.mObjectValues) {
            this.mObjectValues[type.getStorageIndex()] = value;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void notifyChangedStatus() {
        try {
            if (!this.mIsLoading) {
                TvDataBase.getInstance().setDayProgramWasChangedByPlugin(this.getDate(), this.getChannel());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireStateChanged();
    }

    public void setTextField(ProgramFieldType type, String inValue) {
        this.checkFormat(type, 3);
        if (type == ProgramFieldType.SHORT_DESCRIPTION_TYPE) {
            inValue = this.validateShortInfo(inValue);
        }
        String value = inValue != null && inValue.equals("") ? StringPool.getString("") : (type == ProgramFieldType.ORIGIN_TYPE || type == ProgramFieldType.GENRE_TYPE ? StringPool.getString(inValue) : inValue);
        if (type == ProgramFieldType.TITLE_TYPE && value.length() > 0) {
            this.mTitle = value.replaceAll("\\r+", "").replaceAll("\\n+", " ").strip();
        }
        this.setObjectValueField(type, value);
        this.notifyChangedStatus();
    }

    private void checkFormat(ProgramFieldType type, int format) {
        if (type.getFormat() != format) {
            throw new IllegalArgumentException("The field " + type.getName() + " can't be accessed as " + ProgramFieldType.getFormatName(format) + ", because it is " + ProgramFieldType.getFormatName(type.getFormat()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntField(ProgramFieldType type, int value) {
        this.checkFormat(type, 4);
        if (type == ProgramFieldType.RATING_TYPE && (value < 0 || value > 100)) {
            mLog.warning("The value for field " + type.getName() + " must be between in [0..100], but it was set to " + value + "; program: " + this.toString());
            value = -1;
        }
        int[] nArray = this.mIntValues;
        synchronized (this.mIntValues) {
            this.mIntValues[type.getStorageIndex()] = value;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.notifyChangedStatus();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeField(ProgramFieldType type, int value) {
        this.checkFormat(type, 5);
        if (value < 0 || value >= 1440) {
            mLog.warning("The time value for field " + type.getName() + " must be between in [0..1439], but it was set to " + value + "; program: " + this.toString());
        }
        int[] nArray = this.mIntValues;
        synchronized (this.mIntValues) {
            this.mIntValues[type.getStorageIndex()] = value;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.notifyChangedStatus();
            if (type == ProgramFieldType.START_TIME_TYPE) {
                this.normalizeTimeZone(value);
            }
            return;
        }
    }

    public static String generateShortInfoFromDescription(String shortInfo) {
        int lastMidDot;
        int cutIdx;
        int lastDot = shortInfo.lastIndexOf(46, 200);
        int n = shortInfo.lastIndexOf(33, 200);
        if (n > lastDot) {
            lastDot = n;
        }
        if ((n = shortInfo.lastIndexOf(63, 200)) > lastDot) {
            lastDot = n;
        }
        if ((n = shortInfo.lastIndexOf(" - ", 200)) > lastDot) {
            lastDot = n;
        }
        if ((cutIdx = Math.max(lastDot, lastMidDot = shortInfo.lastIndexOf(183, 200))) < 100) {
            cutIdx = shortInfo.lastIndexOf(32, 200);
        }
        return shortInfo.substring(0, cutIdx + 1) + "...";
    }

    private String validateShortInfo(String shortInfo) {
        if (shortInfo != null && shortInfo.length() > 204) {
            shortInfo = MutableProgram.generateShortInfoFromDescription(shortInfo);
        }
        return shortInfo;
    }

    public void setTitle(String title) {
        this.mTitle = title.replaceAll("\\r+", "").replaceAll("\\n+", " ").strip();
        this.setTextField(ProgramFieldType.TITLE_TYPE, this.mTitle);
    }

    @Override
    public String getTitle() {
        if (this.mTitle != null && this.mTitle.trim().length() > 0) {
            return this.mTitle;
        }
        this.mTitle = this.getTextField(ProgramFieldType.TITLE_TYPE);
        return this.mTitle;
    }

    public void setShortInfo(String shortInfo) {
        this.setTextField(ProgramFieldType.SHORT_DESCRIPTION_TYPE, shortInfo);
    }

    @Override
    public String getShortInfo() {
        return this.getTextField(ProgramFieldType.SHORT_DESCRIPTION_TYPE);
    }

    public void setDescription(String description) {
        this.setTextField(ProgramFieldType.DESCRIPTION_TYPE, description);
    }

    @Override
    public String getDescription() {
        return this.getTextField(ProgramFieldType.DESCRIPTION_TYPE);
    }

    @Override
    public int getStartTime() {
        return this.mNormalizedStartTime;
    }

    @Override
    public int getHours() {
        return this.mNormalizedStartTime / 60;
    }

    @Override
    public int getMinutes() {
        return this.mNormalizedStartTime % 60;
    }

    public int getLocalStartTime() {
        return this.getTimeField(ProgramFieldType.START_TIME_TYPE);
    }

    public void setLength(int length) {
        int startTime = this.getTimeField(ProgramFieldType.START_TIME_TYPE);
        int endTime = startTime + length;
        if (endTime >= 1440) {
            endTime -= 1440;
        }
        this.setTimeField(ProgramFieldType.END_TIME_TYPE, endTime);
    }

    @Override
    public int getLength() {
        int endTime = this.getTimeField(ProgramFieldType.END_TIME_TYPE);
        if (endTime == -1) {
            return -1;
        }
        int startTime = this.getTimeField(ProgramFieldType.START_TIME_TYPE);
        if (endTime < startTime) {
            endTime += 1440;
        }
        return endTime - startTime;
    }

    public void setInfo(int info) {
        this.setIntField(ProgramFieldType.INFO_TYPE, info);
    }

    @Override
    public int getInfo() {
        return this.getIntField(ProgramFieldType.INFO_TYPE);
    }

    @Override
    public Channel getChannel() {
        return this.mChannel;
    }

    @Override
    public Date getDate() {
        return this.mNormalizedDate;
    }

    public Date getLocalDate() {
        return this.mLocalDate;
    }

    public String toString() {
        return "On " + this.mChannel.getName() + " at " + this.getHours() + ":" + String.format("%02d", this.getMinutes()) + ", " + this.getDateString() + ": '" + this.getTitle() + "'";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Program) {
            Program program = (Program)o;
            String title = this.getTitle();
            String otherTitle = program.getTitle();
            return this.getStartTime() == program.getStartTime() && this.equals(this.mChannel, program.getChannel()) && this.equals(this.getDate(), program.getDate()) && title != null && otherTitle != null && title.compareTo(otherTitle) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = HashCodeUtilities.hash(this.getStartTime());
        result = HashCodeUtilities.hash(result, this.mChannel);
        result = HashCodeUtilities.hash(result, this.getDate());
        result = HashCodeUtilities.hash(result, this.getTitle());
        return result;
    }

    public boolean equalsAllFields(MutableProgram program) {
        if (!this.equals(program)) {
            return false;
        }
        if (!Arrays.equals(this.mIntValues, program.mIntValues)) {
            return false;
        }
        for (int i = 0; i < this.mObjectValues.length; ++i) {
            if (this.mObjectValues[i] == null == (program.mObjectValues[i] == null)) continue;
            return false;
        }
        Iterator<ProgramFieldType> iterator = ProgramFieldType.getTypeIterator();
        while (iterator.hasNext()) {
            ProgramFieldType fieldType = iterator.next();
            int format = fieldType.getFormat();
            if (format != 3 && format != 2) continue;
            Object thisValue = this.getObjectValueField(fieldType);
            Object otherValue = program.getObjectValueField(fieldType);
            if (thisValue == null || thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    protected void setProgramState(int state) {
        this.mState = (byte)state;
    }

    @Override
    public int getProgramState() {
        return this.mState;
    }

    @Override
    public final void validateMarking() {
        MarkedProgramsMap.getInstance().validateMarkingForProgram(this);
        this.fireStateChanged();
    }

    public void setProgramLoadingIsComplete() {
        this.mIsLoading = false;
    }

    @Override
    @Deprecated(since="4.2.2")
    public int getMarkPriority() {
        return MarkedProgramsMap.getInstance().getMarkPriorityMaxForProgram(this);
    }

    @Override
    public int getMarkPriorityMax() {
        return MarkedProgramsMap.getInstance().getMarkPriorityMaxForProgram(this);
    }

    @Override
    public Integer[] getMarkPriorities() {
        return MarkedProgramsMap.getInstance().getMarkPrioritesForProgram(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFieldValue(ProgramFieldType type) {
        int format = type.getFormat();
        if (format == 4 || format == 5) {
            int[] nArray = this.mIntValues;
            synchronized (this.mIntValues) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.mIntValues[type.getStorageIndex()] != -1;
            }
        }
        if (format == 3 || format == 2) {
            Object[] objectArray = this.mObjectValues;
            synchronized (this.mObjectValues) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return this.mObjectValues[type.getStorageIndex()] != null;
            }
        }
        return false;
    }

    private static class ProgramFieldIterator
    implements Iterator<ProgramFieldType> {
        private int mIndex;
        private ArrayList<ProgramFieldType> mFieldTypes = new ArrayList(20);

        public ProgramFieldIterator(MutableProgram program) {
            Iterator<ProgramFieldType> iterator = ProgramFieldType.getTypeIterator();
            while (iterator.hasNext()) {
                ProgramFieldType fieldType = iterator.next();
                int format = fieldType.getFormat();
                if (format == 4) {
                    if (program.getIntField(fieldType) == -1) continue;
                    this.mFieldTypes.add(fieldType);
                    continue;
                }
                if (format == 5) {
                    if (program.getTimeField(fieldType) == -1) continue;
                    this.mFieldTypes.add(fieldType);
                    continue;
                }
                if (format == 3) {
                    if (program.getTextField(fieldType) == null) continue;
                    this.mFieldTypes.add(fieldType);
                    continue;
                }
                if (format != 2 || program.getBinaryField(fieldType) == null) continue;
                this.mFieldTypes.add(fieldType);
            }
            this.mIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < this.mFieldTypes.size();
        }

        @Override
        public ProgramFieldType next() {
            return this.mFieldTypes.get(this.mIndex++);
        }

        @Override
        public void remove() {
        }
    }
}

