/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class PropertiesSorted
extends Properties {
    private static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return String.valueOf(o1).compareToIgnoreCase(String.valueOf(o2));
        }
    };
    private static final Comparator<Map.Entry<Object, Object>> COMPARATOR_ENTRIES = new Comparator<Map.Entry<Object, Object>>(){

        @Override
        public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
            return String.valueOf(o1.getKey()).compareToIgnoreCase(String.valueOf(o2.getKey()));
        }
    };

    public static final PropertiesSorted load(File source) {
        PropertiesSorted prop = new PropertiesSorted();
        try (FileInputStream in = new FileInputStream(source);){
            prop.load(in);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return prop;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        TreeSet<Map.Entry<Object, Object>> result = new TreeSet<Map.Entry<Object, Object>>(COMPARATOR_ENTRIES);
        for (Map.Entry<Object, Object> entry : super.entrySet()) {
            result.add(entry);
        }
        return Collections.synchronizedSet(result);
    }

    @Override
    public Set<Object> keySet() {
        TreeSet<Object> result = new TreeSet<Object>(COMPARATOR);
        for (Object key : super.keySet()) {
            result.add(key);
        }
        return Collections.synchronizedSet(result);
    }

    @Override
    public Enumeration<Object> keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>();
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        Collections.sort(keyList, COMPARATOR);
        for (Object e : keyList) {
            System.out.println(e);
        }
        return keyList.elements();
    }

    public final boolean store(File target, String comments) {
        boolean result = false;
        try (FileOutputStream out = new FileOutputStream(target);){
            this.store(out, comments);
            result = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

