/*
 * Decompiled with CFR 0.152.
 */
package util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLWriter {
    public String getStringForDocument(Document doc, String encoding) {
        String result = "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n";
        result = result + this.getStringForNode(doc.getDocumentElement());
        return result;
    }

    public String getStringForNode(Node node) {
        if (node.getNodeType() == 3) {
            return this.addEntities(node.getNodeValue());
        }
        StringBuilder result = new StringBuilder("<" + node.getNodeName() + ">");
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            result.append(this.getStringForNode(child));
        }
        result.append("</" + node.getNodeName() + ">");
        return result.toString();
    }

    private String addEntities(String string) {
        string = this.replaceAll(string, "&", "&amp;");
        string = this.replaceAll(string, "<", "&lt;");
        string = this.replaceAll(string, ">", "&gt;");
        string = this.replaceAll(string, "\"", "&quot;");
        return string;
    }

    private String replaceAll(String intothis, String old, String newstr) {
        int newpos;
        int pos = 0;
        while ((newpos = ((String)intothis).indexOf(old, pos)) > -1) {
            String oldone = intothis;
            intothis = ((String)intothis).substring(0, newpos);
            intothis = (String)intothis + newstr;
            intothis = (String)intothis + oldone.substring(newpos + old.length());
            pos = newpos + newstr.length();
        }
        return intothis;
    }

    public void writeDocumentToOutputStream(Document doc, OutputStream out, String encoding) throws IOException {
        out.write(this.getStringForDocument(doc, encoding).getBytes(encoding));
    }
}

