/*
 * Decompiled with CFR 0.152.
 */
package util.paramhandler;

import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramInfo;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import util.browserlauncher.Launch;
import util.i18n.Localizer;
import util.misc.TextLineBreakerStringWidth;

public class ParamLibrary {
    private static final String KEY_TITLE = "title";
    private static final String KEY_ORIGINAL_TITLE = "original_title";
    private static final String KEY_START_DAY = "start_day";
    private static final String KEY_START_MONTH = "start_month";
    private static final String KEY_START_YEAR = "start_year";
    private static final String KEY_START_HOUR = "start_hour";
    private static final String KEY_START_MINUTE = "start_minute";
    private static final String KEY_END_MONTH = "end_month";
    private static final String KEY_END_YEAR = "end_year";
    private static final String KEY_END_DAY = "end_day";
    private static final String KEY_END_HOUR = "end_hour";
    private static final String KEY_END_MINUTE = "end_minute";
    private static final String KEY_LENGTH_MINUTES = "length_minutes";
    private static final String KEY_LENGTH_SECONDS = "length_sec";
    private static final String KEY_SHORT_INFO = "short_info";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_EPISODE = "episode";
    private static final String KEY_EPISODE_ORIGINAL = "original_episode";
    private static final String KEY_EPISODE_NUMBER = "episode_number";
    private static final String KEY_CHANNEL_NAME = "channel_name";
    private static final String KEY_CHANNEL_SORT_NUMBER = "channel_sort_number";
    private static final String KEY_URL = "url";
    private static final String KEY_START_DAY_OF_WEEK = "start_day_of_week";
    private static final String KEY_START_MONTH_NAME = "start_month_name";
    private static final String KEY_GENRE = "genre";
    private static final String KEY_START_UNIX = "start_unix";
    private static final String KEY_END_UNIX = "end_unix";
    private static final String KEY_CUSTOM = "custom";
    private static final String KEY_PRODUCTION_YEAR = "production_year";
    private static final String KEY_ACTORS = "actors";
    private static final String KEY_ORIGIN = "origin";
    private static final String KEY_SEASON_NUMBER = "season_number";
    private static final String FUNCTION_ISSET = "isset";
    private static final String FUNCTION_URLENCODE = "urlencode";
    private static final String FUNCTION_CONCAT = "concat";
    private static final String FUNCTION_CLEAN = "clean";
    private static final String FUNCTION_CLEAN_LESS = "cleanLess";
    private static final String FUNCTION_LEADING_ZERO = "leadingZero";
    private static final String FUNCTION_SPLIT_AT = "splitAt";
    private static final String FUNCTION_TESTPARAM = "testparam";
    private static final String FUNCTION_MAX_LENGTH = "maxlength";
    private static final String FUNCTION_REPLACE = "replace";
    private static final String FUNCTION_REPLACE_LINE_FEED = "replaceNewline";
    private static final String FUNCTION_ESCAPE_QUOTES = "escapeQuotes";
    private static final String FUNCTION_PROGRAM_INFO = "programInfo";
    private static final String[] KEY_ARRAY = new String[]{"title", "original_title", "start_day", "start_month", "start_year", "start_hour", "start_minute", "end_month", "end_year", "end_day", "end_hour", "end_minute", "length_minutes", "length_sec", "short_info", "description", "episode", "original_episode", "episode_number", "channel_name", "channel_sort_number", "url", "start_day_of_week", "start_month_name", "genre", "start_unix", "end_unix", "custom", "production_year", "actors", "origin", "season_number"};
    private static final String[] FUNCTION_ARRAY = new String[]{"isset", "urlencode", "concat", "clean", "cleanLess", "leadingZero", "splitAt", "testparam", "maxlength", "replace", "replaceNewline", "escapeQuotes", "programInfo"};
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(ParamLibrary.class);
    private boolean mError = false;
    private String mErrorString = "";

    public boolean hasErrors() {
        return this.mError;
    }

    public void setErrors(boolean errors) {
        this.mError = errors;
    }

    public String getErrorString() {
        return this.mErrorString;
    }

    public void setErrorString(String error) {
        this.mErrorString = error;
    }

    public String[] getPossibleKeys() {
        return KEY_ARRAY;
    }

    public String getDescriptionForKey(String key) {
        String translation = LOCALIZER.msg("parameter_" + key, "");
        if (translation.startsWith("[ParamLibrary.parameter")) {
            return LOCALIZER.msg("noDescription", "No Description available");
        }
        return translation;
    }

    public String[] getPossibleFunctions() {
        return FUNCTION_ARRAY;
    }

    public String getDescriptionForFunctions(String function) {
        String translation = LOCALIZER.msg("function_" + function, "");
        if (translation.startsWith("[ParamLibrary.function")) {
            return LOCALIZER.msg("noDescription", "No Description available");
        }
        return translation;
    }

    public String getStringForKey(Program program, String key) {
        if (key.equalsIgnoreCase(KEY_TITLE)) {
            return program.getTitle();
        }
        if (key.equalsIgnoreCase(KEY_START_DAY)) {
            return String.valueOf(program.getDate().getDayOfMonth());
        }
        if (key.equalsIgnoreCase(KEY_START_MONTH)) {
            return String.valueOf(program.getDate().getMonth());
        }
        if (key.equalsIgnoreCase(KEY_START_YEAR)) {
            return String.valueOf(program.getDate().getYear());
        }
        if (key.equalsIgnoreCase(KEY_END_DAY)) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 5));
        }
        if (key.equalsIgnoreCase(KEY_END_MONTH)) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 2) + 1);
        }
        if (key.equalsIgnoreCase(KEY_END_YEAR)) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 1));
        }
        if (key.equalsIgnoreCase(KEY_START_HOUR)) {
            return String.valueOf(program.getHours());
        }
        if (key.equalsIgnoreCase(KEY_START_MINUTE)) {
            return String.valueOf(program.getMinutes());
        }
        if (key.equalsIgnoreCase(KEY_END_HOUR)) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 11));
        }
        if (key.equalsIgnoreCase(KEY_END_MINUTE)) {
            return String.valueOf(this.getEndTimeFieldInProgram(program, 12));
        }
        if (key.equalsIgnoreCase(KEY_LENGTH_MINUTES)) {
            return String.valueOf(program.getLength());
        }
        if (key.equalsIgnoreCase(KEY_LENGTH_SECONDS)) {
            return String.valueOf(program.getLength() * 60);
        }
        if (key.equalsIgnoreCase(KEY_SHORT_INFO)) {
            return this.removeNull(program.getShortInfo());
        }
        if (key.equalsIgnoreCase(KEY_DESCRIPTION)) {
            String res = this.removeNull(program.getDescription());
            String copyright = program.getChannel().getCopyrightNotice();
            if (copyright != null) {
                return res + '\n' + copyright;
            }
            return res;
        }
        if (key.equalsIgnoreCase(KEY_CHANNEL_NAME)) {
            return this.removeNull(program.getChannel().getName());
        }
        if (key.equalsIgnoreCase(KEY_CHANNEL_SORT_NUMBER)) {
            return this.removeNull(program.getChannel().getSortNumber());
        }
        if (key.equalsIgnoreCase(KEY_START_DAY_OF_WEEK)) {
            SimpleDateFormat format = new SimpleDateFormat("EEEE");
            return format.format(new Date(program.getDate().getCalendar().getTimeInMillis()));
        }
        if (key.equalsIgnoreCase(KEY_START_MONTH_NAME)) {
            SimpleDateFormat format = new SimpleDateFormat("MMMM");
            return format.format(new Date(program.getDate().getCalendar().getTimeInMillis()));
        }
        if (key.equalsIgnoreCase(KEY_START_UNIX)) {
            return Long.toString(this.createStartTime(program).getTimeInMillis() / 1000L);
        }
        if (key.equalsIgnoreCase(KEY_END_UNIX)) {
            return Long.toString(this.createEndTime(program).getTimeInMillis() / 1000L);
        }
        if (key.equalsIgnoreCase(KEY_EPISODE_NUMBER)) {
            int epNum = program.getIntField(ProgramFieldType.EPISODE_NUMBER_TYPE);
            if (epNum == -1) {
                return "";
            }
            return Integer.toString(epNum);
        }
        if (key.equalsIgnoreCase(KEY_PRODUCTION_YEAR)) {
            int productionYear = program.getIntField(ProgramFieldType.PRODUCTION_YEAR_TYPE);
            if (productionYear < 1800) {
                return "";
            }
            return Integer.toString(productionYear);
        }
        if (key.equalsIgnoreCase(KEY_GENRE)) {
            return this.removeNull(program.getTextField(ProgramFieldType.GENRE_TYPE));
        }
        if (key.equalsIgnoreCase(KEY_ORIGIN)) {
            return this.removeNull(program.getTextField(ProgramFieldType.ORIGIN_TYPE));
        }
        if (key.equalsIgnoreCase(KEY_ORIGINAL_TITLE)) {
            return this.removeNull(program.getTextField(ProgramFieldType.ORIGINAL_TITLE_TYPE));
        }
        if (key.equalsIgnoreCase(KEY_URL)) {
            return this.removeNull(program.getTextField(ProgramFieldType.URL_TYPE));
        }
        if (key.equalsIgnoreCase(KEY_EPISODE)) {
            return this.removeNull(program.getTextField(ProgramFieldType.EPISODE_TYPE));
        }
        if (key.equalsIgnoreCase(KEY_EPISODE_ORIGINAL)) {
            return this.removeNull(program.getTextField(ProgramFieldType.ORIGINAL_EPISODE_TYPE));
        }
        if (key.equalsIgnoreCase(KEY_CUSTOM)) {
            return this.removeNull(program.getTextField(ProgramFieldType.CUSTOM_TYPE));
        }
        if (key.equalsIgnoreCase(KEY_SEASON_NUMBER)) {
            return this.removeNull(program.getIntFieldAsString(ProgramFieldType.SEASON_NUMBER_TYPE));
        }
        if (key.equalsIgnoreCase(KEY_ACTORS)) {
            return this.removeNull(program.getTextField(ProgramFieldType.ACTOR_LIST_TYPE));
        }
        try {
            Field f = ProgramFieldType.class.getDeclaredField(key.toUpperCase());
            f.setAccessible(true);
            ProgramFieldType value = (ProgramFieldType)f.get(null);
            if (value != null) {
                switch (value.getFormat()) {
                    case 4: {
                        return this.removeNull(program.getIntFieldAsString(value));
                    }
                    case 3: {
                        return this.removeNull(program.getTextField(value));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mError = true;
        this.mErrorString = LOCALIZER.msg("unkownParam", "Unknown Parameter") + ": '" + key + "'";
        return null;
    }

    private String removeNull(String str) {
        if (str == null) {
            str = "";
        }
        return str;
    }

    private int getEndTimeFieldInProgram(Program prg, int field) {
        Calendar c = this.createEndTime(prg);
        return c.get(field);
    }

    private Calendar createStartTime(Program prg) {
        Calendar c = (Calendar)prg.getDate().getCalendar().clone();
        c.set(11, prg.getHours());
        c.set(12, prg.getMinutes());
        c.set(13, 0);
        return c;
    }

    private Calendar createEndTime(Program prg) {
        Calendar c = (Calendar)prg.getDate().getCalendar().clone();
        c.set(11, prg.getHours());
        c.set(12, prg.getMinutes());
        c.add(12, prg.getLength());
        c.set(13, 0);
        return c;
    }

    public String getStringForFunction(Program prg, String function, String[] params) {
        if (function.equalsIgnoreCase(FUNCTION_ISSET)) {
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("isset2Params", "isset needs 2 Parameters");
                return null;
            }
            if (params[0] != null && params[0].length() > 0) {
                return params[0];
            }
            return params[1];
        }
        if (function.equalsIgnoreCase(FUNCTION_TESTPARAM)) {
            if (params.length < 2 || params.length > 3) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("testparam2Params", "testparam needs 2-3 Parameters");
                return null;
            }
            if (params[0] != null && !params[0].isBlank()) {
                return params[1];
            }
            if (params.length == 3) {
                return params[2];
            }
            return "";
        }
        if (function.equalsIgnoreCase(FUNCTION_URLENCODE)) {
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("urlencode2Params", "urlencode needs 2 Parameters");
                return null;
            }
            try {
                return URLEncoder.encode(params[0], params[1]);
            }
            catch (Exception e) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("urlencodeProblems", "Problems with encoding : ") + e.toString();
                return null;
            }
        }
        if (function.equalsIgnoreCase(FUNCTION_CONCAT)) {
            StringBuilder buffer = new StringBuilder();
            for (String param : params) {
                buffer.append(param);
            }
            return buffer.toString();
        }
        if (function.equalsIgnoreCase(FUNCTION_CLEAN)) {
            StringBuilder buffer = new StringBuilder();
            for (String param : params) {
                buffer.append(this.clean(param));
            }
            return buffer.toString();
        }
        if (function.equalsIgnoreCase(FUNCTION_CLEAN_LESS)) {
            StringBuilder buffer = new StringBuilder();
            for (String param : params) {
                buffer.append(this.cleanLess(param));
            }
            return buffer.toString();
        }
        if (function.equalsIgnoreCase(FUNCTION_LEADING_ZERO)) {
            if (params.length > 2) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("leadingZero2Params", "leadingZero has max. 2 Parameters");
                return null;
            }
            int num = 2;
            if (params.length == 2) {
                try {
                    num = Integer.parseInt(params[1]);
                }
                catch (Exception ex) {
                    this.mError = true;
                    this.mErrorString = LOCALIZER.msg("leadingZeroProblems", "Could not parse Number") + " : " + params[1];
                    return null;
                }
            }
            return this.addLeadingZeros(params[0], num);
        }
        if (function.equalsIgnoreCase(FUNCTION_SPLIT_AT)) {
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("splitAt2Params", "splitAt needs 2 Parameters");
                return null;
            }
            int num = 2;
            try {
                num = Integer.parseInt(params[1]);
            }
            catch (Exception ex) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("splitAtNumberProblems", "Could not parse Number") + " : " + params[1];
                return null;
            }
            TextLineBreakerStringWidth breaker = new TextLineBreakerStringWidth();
            StringBuilder result = new StringBuilder();
            try {
                String[] lines;
                for (String line : lines = breaker.breakLines(new StringReader(params[0]), num)) {
                    result.append(line);
                    result.append('\n');
                }
            }
            catch (Exception ex) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("splitAtSplitProblems", "Could not split String") + " :\n " + ex.toString();
                return null;
            }
            return result.toString().trim();
        }
        if (function.equalsIgnoreCase(FUNCTION_MAX_LENGTH)) {
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("maxlength2Params", "maxlength needs 2 Parameters");
                return null;
            }
            int num = -1;
            try {
                num = Integer.parseInt(params[1]);
            }
            catch (Exception ex) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("maxlengthNumberProblems", "Could not parse Number") + " : " + params[1];
                return null;
            }
            String result = params[0];
            if (result.length() > num) {
                result = result.substring(0, num);
            }
            return result;
        }
        if (function.equalsIgnoreCase(FUNCTION_REPLACE)) {
            String[] replaceValues;
            if (params.length != 2) {
                this.mError = true;
                this.mErrorString = LOCALIZER.msg("replace2Params", "replace needs 2 Parameters");
                return null;
            }
            String haystack = params[0];
            for (String replace : replaceValues = params[1].split(",")) {
                if (!replace.contains("::")) {
                    this.mError = true;
                    this.mErrorString = LOCALIZER.msg("replaceMissingColon", "Replace values need to contain two following colons");
                    return null;
                }
                String[] parts = replace.split("::");
                haystack = parts.length == 1 ? haystack.replace(parts[0], "") : haystack.replace(parts[0], parts[1]);
            }
            return haystack;
        }
        if (function.equalsIgnoreCase(FUNCTION_REPLACE_LINE_FEED)) {
            return params[0].replaceAll("\\r*\\n", " ").strip();
        }
        if (function.equalsIgnoreCase(FUNCTION_PROGRAM_INFO)) {
            if (params.length == 2) {
                PluginProxy plugin = PluginProxyManager.getInstance().getActivatedPluginForId("java." + params[0].toLowerCase() + "." + params[0]);
                if (plugin != null) {
                    ProgramInfo[] infos = plugin.getAddtionalProgramInfoForProgram(prg, params[1]);
                    if (infos != null) {
                        for (ProgramInfo info : infos) {
                            if (!info.getUniqueId().equals(params[1])) continue;
                            return (String)info.getValue();
                        }
                    }
                    return "";
                }
                return "PLUGIN " + params[0] + " NOT AVAILABLE";
            }
        } else if (function.equalsIgnoreCase(FUNCTION_ESCAPE_QUOTES)) {
            return Launch.getOs() == 1 ? params[0].replace("\"", "\\\"\\\"") : params[0].replace("\"", "\\\"");
        }
        this.mError = true;
        this.mErrorString = LOCALIZER.msg("unknownFunction", "Unknown function : {0}", function);
        return null;
    }

    private String addLeadingZeros(String string, int num) {
        StringBuilder buffer = new StringBuilder(string);
        while (buffer.length() < num) {
            buffer.insert(0, '0');
        }
        return buffer.toString();
    }

    private String clean(String clean) {
        char[] chars;
        StringBuilder buffer = new StringBuilder();
        for (char c : chars = clean.trim().toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                buffer.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                buffer.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                buffer.append(c);
                continue;
            }
            buffer.append('_');
        }
        String retStr = buffer.toString();
        while (retStr.indexOf("__") >= 0) {
            retStr = StringUtils.replace((String)retStr, (String)"__", (String)"_");
        }
        return retStr;
    }

    private String cleanLess(String clean) {
        char[] chars;
        StringBuilder buffer = new StringBuilder();
        for (char c : chars = clean.trim().toCharArray()) {
            if (Character.isDigit(c) || Character.isLetter(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append('_');
        }
        String retStr = buffer.toString();
        while (retStr.indexOf("__") >= 0) {
            retStr = StringUtils.replace((String)retStr, (String)"__", (String)"_");
        }
        return retStr;
    }
}

