/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import devplugin.ActionMenu;
import devplugin.Channel;
import devplugin.ChannelFilter;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.ChannelFilterList;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.ui.mainframe.ChannelChooserPanel;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.mainframe.actions.TVBrowserActions;
import tvbrowser.ui.settings.ChannelsSettingsTab;
import tvbrowser.ui.settings.channel.ChannelConfigDlg;
import util.browserlauncher.Launch;
import util.i18n.Localizer;
import util.ui.ChannelLabel;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.menu.MenuUtil;

public class ChannelContextMenu
implements ActionListener {
    public static final Localizer LOCALIZER = Localizer.getLocalizerFor(ChannelContextMenu.class);
    private JPopupMenu mMenu;
    private JMenuItem mChAdd;
    private JMenuItem mChConf;
    private JMenuItem mChGoToURL;
    private JMenu mFilterChannels;
    private Object mSource;
    private Channel mChannel;
    private Component mComponent;
    private JRadioButtonMenuItem layoutBoth;
    private JRadioButtonMenuItem layoutLogo;
    private JRadioButtonMenuItem layoutName;

    public ChannelContextMenu(MouseEvent e, Channel ch, Object src) {
        this.mSource = src;
        this.mChannel = ch;
        this.mComponent = e.getComponent();
        this.mMenu = new JPopupMenu();
        this.mChAdd = new JMenuItem(LOCALIZER.msg("addChannels", "Add/Remove channels"));
        this.mChConf = new JMenuItem(LOCALIZER.msg("configChannel", "Setup channel"), TVBrowserIcons.edit(16));
        this.mChGoToURL = new JMenuItem(LOCALIZER.msg("openURL", "Open internet page"), IconLoader.getInstance().getIconFromTheme("apps", "internet-web-browser"));
        this.mFilterChannels = new JMenu(LOCALIZER.msg("filterChannels", "Channel filter"));
        MainFrame.getInstance().updateChannelGroupMenu(this.mFilterChannels);
        this.mChAdd.addActionListener(this);
        this.mChConf.addActionListener(this);
        this.mChGoToURL.addActionListener(this);
        this.mMenu.add(this.mChGoToURL);
        if (ChannelList.isSubscribedChannel(ch) && !(ch instanceof DummyChannel)) {
            this.mMenu.add(this.mChConf);
        }
        if (!(this.mSource instanceof ChannelsSettingsTab)) {
            this.mMenu.add(this.mFilterChannels);
            this.mMenu.addSeparator();
            this.mMenu.add(this.mChAdd);
            JMenu configureLayout = new JMenu(LOCALIZER.msg("layout", "Layout"));
            this.layoutBoth = new JRadioButtonMenuItem(LOCALIZER.msg("layoutBoth", "Logo and name"));
            this.layoutLogo = new JRadioButtonMenuItem(LOCALIZER.msg("layoutLogo", "Logo"));
            this.layoutName = new JRadioButtonMenuItem(LOCALIZER.msg("layoutName", "Name"));
            configureLayout.add(this.layoutBoth);
            configureLayout.add(this.layoutLogo);
            configureLayout.add(this.layoutName);
            this.mMenu.add(configureLayout);
            this.layoutBoth.addActionListener(this);
            this.layoutLogo.addActionListener(this);
            this.layoutName.addActionListener(this);
            if (this.mSource instanceof ChannelChooserPanel) {
                if (Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.getBoolean() && Settings.IconAndNames.SHOW_NAMES_IN_CHANNEL_LIST.getBoolean()) {
                    this.layoutBoth.setSelected(true);
                } else if (Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.getBoolean()) {
                    this.layoutLogo.setSelected(true);
                } else {
                    this.layoutName.setSelected(true);
                }
            } else if (this.mSource instanceof ChannelLabel) {
                if (Settings.IconAndNames.SHOW_ICONS_IN_PROGRAM_TABLE.getBoolean() && Settings.IconAndNames.SHOW_NAMES_IN_PROGRAM_TABLE.getBoolean()) {
                    this.layoutBoth.setSelected(true);
                } else if (Settings.IconAndNames.SHOW_ICONS_IN_PROGRAM_TABLE.getBoolean()) {
                    this.layoutLogo.setSelected(true);
                } else {
                    this.layoutName.setSelected(true);
                }
            }
            this.addPluginContextMenuItems(ch);
        }
        this.mMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void addPluginContextMenuItems(Channel ch) {
        boolean separator = false;
        for (PluginProxy plugin : PluginProxyManager.getInstance().getActivatedPlugins()) {
            ActionMenu context = plugin.getContextMenuActions(ch);
            if (context == null) continue;
            if (!separator) {
                this.mMenu.addSeparator();
                separator = true;
            }
            this.mMenu.add(MenuUtil.createMenuItem(context));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mChAdd)) {
            TVBrowserActions.configureChannels.actionPerformed(null);
        } else if (e.getSource().equals(this.mChConf)) {
            if (this.mSource instanceof ChannelsSettingsTab) {
                ((ChannelsSettingsTab)this.mSource).configChannels();
            } else {
                Window parent = UiUtilities.getBestDialogParent(this.mComponent);
                ChannelConfigDlg dialog = new ChannelConfigDlg(parent, this.mChannel);
                dialog.centerAndShow();
                ChannelList.checkForJointChannels();
            }
            MainFrame.getInstance().getProgramTableScrollPane().updateChannelLabelForChannel(this.mChannel);
            MainFrame.getInstance().updateChannelChooser();
            ChannelList.storeAllSettings();
        } else if (e.getSource().equals(this.mChGoToURL)) {
            Launch.openURL(this.mChannel.getWebpage());
        } else if (e.getSource() instanceof JRadioButtonMenuItem) {
            if (e.getSource() == this.layoutBoth || e.getSource() == this.layoutName || e.getSource() == this.layoutLogo) {
                boolean showIcons;
                boolean showNames = e.getSource() == this.layoutBoth || e.getSource() == this.layoutName;
                boolean bl = showIcons = e.getSource() == this.layoutBoth || e.getSource() == this.layoutLogo;
                if (this.mSource instanceof ChannelChooserPanel) {
                    Settings.IconAndNames.SHOW_NAMES_IN_CHANNEL_LIST.setBoolean(showNames);
                    Settings.IconAndNames.SHOW_ICONS_IN_CHANNEL_LIST.setBoolean(showIcons);
                    MainFrame.getInstance().updateChannelChooser();
                } else {
                    Settings.IconAndNames.SHOW_NAMES_IN_PROGRAM_TABLE.setBoolean(showNames);
                    Settings.IconAndNames.SHOW_ICONS_IN_PROGRAM_TABLE.setBoolean(showIcons);
                    MainFrame.getInstance().getProgramTableScrollPane().updateChannelPanel();
                }
            } else {
                JRadioButtonMenuItem filterItem = (JRadioButtonMenuItem)e.getSource();
                this.setChanneFilter(ChannelFilterList.getInstance().getChannelFilterForName(filterItem.getText()));
            }
        }
    }

    private void setChanneFilter(ChannelFilter channelFilter) {
        MainFrame.getInstance().setChannelFilter(channelFilter);
    }
}

