/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EnhancedPanelBuilder
extends PanelBuilder {
    public static final String GAP_SPEC_DEFAULT = "5dlu";
    public static final String PARAGRAPH_GAP_SPEC_DEFAULT = "10dlu";
    private RowSpec mDefaultRowGapSpec;
    private RowSpec mDefaultParagraphGapSpec;

    public EnhancedPanelBuilder(FormLayout layout, JPanel parentPanel) {
        this(layout, GAP_SPEC_DEFAULT, parentPanel);
    }

    public EnhancedPanelBuilder(FormLayout layout, String defaultRowGapSpec, JPanel parentPanel) {
        this(layout, defaultRowGapSpec, PARAGRAPH_GAP_SPEC_DEFAULT, parentPanel);
    }

    public EnhancedPanelBuilder(FormLayout layout, String defaultRowGapSpec, String defaultParagraphGapSpec, JPanel parentPanel) {
        super(layout, parentPanel);
        this.mDefaultRowGapSpec = RowSpec.decode((String)defaultRowGapSpec);
        this.mDefaultParagraphGapSpec = RowSpec.decode((String)defaultParagraphGapSpec);
    }

    public EnhancedPanelBuilder(FormLayout layout) {
        this(layout, GAP_SPEC_DEFAULT);
    }

    public EnhancedPanelBuilder(FormLayout layout, String defaultRowGapSpec) {
        this(layout, defaultRowGapSpec, PARAGRAPH_GAP_SPEC_DEFAULT);
    }

    public EnhancedPanelBuilder(FormLayout layout, String defaultRowGapSpec, String defaultParagraphGapSpec) {
        super(layout);
        this.mDefaultRowGapSpec = RowSpec.decode((String)defaultRowGapSpec);
        this.mDefaultParagraphGapSpec = RowSpec.decode((String)defaultParagraphGapSpec);
    }

    public EnhancedPanelBuilder(String encodedColumnSpecs) {
        this(encodedColumnSpecs, GAP_SPEC_DEFAULT);
    }

    public EnhancedPanelBuilder(String encodedColumnSpecs, String defaultRowGapSpec) {
        this(new FormLayout(encodedColumnSpecs, ""), defaultRowGapSpec, PARAGRAPH_GAP_SPEC_DEFAULT);
    }

    public EnhancedPanelBuilder(String encodedColumnSpecs, JPanel parentPanel) {
        this(encodedColumnSpecs, GAP_SPEC_DEFAULT, parentPanel);
    }

    public EnhancedPanelBuilder(String encodedColumnSpecs, String defaultRowGapSpec, JPanel parentPanel) {
        this(encodedColumnSpecs, defaultRowGapSpec, PARAGRAPH_GAP_SPEC_DEFAULT, parentPanel);
    }

    public EnhancedPanelBuilder(String encodedColumnSpecs, String defaultRowGapSpec, String defaultParagraphGapSpec, JPanel parentPanel) {
        super(new FormLayout(encodedColumnSpecs, ""), parentPanel);
        this.mDefaultRowGapSpec = RowSpec.decode((String)defaultRowGapSpec);
        this.mDefaultParagraphGapSpec = RowSpec.decode((String)defaultParagraphGapSpec);
    }

    public JComponent addParagraph(String textWithMnemonic) {
        return this.addParagraph(textWithMnemonic, -1);
    }

    public JComponent addParagraph(String textWithMnemonic, int columnStartIndex) {
        return this.addParagraph(textWithMnemonic, columnStartIndex, -1);
    }

    public JComponent addParagraph(String textWithMnemonic, int columnStartIndex, int colSpan) {
        if (this.getRowCount() > 0) {
            this.appendRow(this.mDefaultParagraphGapSpec);
        } else {
            this.appendRow(FormSpecs.NARROW_LINE_GAP_ROWSPEC);
        }
        this.appendRow(FormSpecs.DEFAULT_ROWSPEC);
        this.incrementRowNumber(true);
        if (textWithMnemonic != null && !textWithMnemonic.isEmpty()) {
            if (columnStartIndex == -1 && colSpan == -1) {
                return this.addSeparator(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
            }
            if (columnStartIndex != -1 && colSpan == -1) {
                return this.addSeparator(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex)));
            }
            if (columnStartIndex == -1 && colSpan != -1) {
                return this.addSeparator(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)colSpan));
            }
            return this.addSeparator(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)colSpan));
        }
        return null;
    }

    public PanelBuilder addRow() {
        return this.addRow(true);
    }

    public PanelBuilder addRow(boolean withGap) {
        return this.addRow(FormSpecs.DEFAULT_ROWSPEC.encode(), withGap);
    }

    private void incrementRowNumber(boolean lineGap) {
        if (this.getRow() == 1 || !lineGap) {
            this.nextRow();
        } else {
            this.nextRow(2);
        }
    }

    public PanelBuilder addGrowingRow() {
        return this.addGrowingRow(true);
    }

    public PanelBuilder addGrowingRow(boolean withGap) {
        return this.addRow("fill:default:grow", withGap);
    }

    public PanelBuilder addRow(String rowHeightCode) {
        return this.addRow(rowHeightCode, true);
    }

    public PanelBuilder addRow(String rowHeightCode, boolean withGap) {
        if (withGap) {
            if (rowHeightCode.contains(",")) {
                String[] parts = rowHeightCode.split(",");
                if (parts.length == 2) {
                    this.appendRow(parts[0]);
                    rowHeightCode = parts[1];
                } else {
                    this.appendRow(this.mDefaultRowGapSpec);
                    rowHeightCode = parts[parts.length - 1];
                }
            } else {
                this.appendRow(this.mDefaultRowGapSpec);
            }
        }
        this.appendRow(rowHeightCode);
        this.incrementRowNumber(withGap);
        return this;
    }

    public EnhancedPanelBuilder addLineGap() {
        this.appendRow(this.mDefaultRowGapSpec);
        this.incrementRowNumber(false);
        return this;
    }

    public Component addRowFull(Component component) {
        this.addRow();
        return this.add(component, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public Component addRow(Component component, int columnIndex) {
        this.addRow();
        return this.add(component, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public Component addRowFull(Component component, int columnStartIndex) {
        this.addRow();
        return this.add(component, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public Component addRow(Component component, int columnIndex, int colSpan) {
        this.addRow();
        return this.add(component, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public Component addRowFull(boolean withGap, Component component) {
        this.addRow(withGap);
        return this.add(component, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public Component addRow(boolean withGap, Component component, int columnIndex) {
        this.addRow(withGap);
        return this.add(component, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public Component addRowFull(boolean withGap, Component component, int columnStartIndex) {
        this.addRow(withGap);
        return this.add(component, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public Component addRow(boolean withGap, Component component, int columnIndex, int colSpan) {
        this.addRow(withGap);
        return this.add(component, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public Component addRowFull(String rowHeightCode, Component component) {
        this.addRow(rowHeightCode, true);
        return this.add(component, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public Component addRow(String rowHeightCode, Component component, int columnIndex) {
        this.addRow(rowHeightCode, true);
        return this.add(component, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public Component addRowFull(String rowHeightCode, Component component, int columnStartIndex) {
        this.addRow(rowHeightCode, true);
        return this.add(component, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public Component addRow(String rowHeightCode, Component component, int columnIndex, int colSpan) {
        this.addRow(rowHeightCode, true);
        return this.add(component, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public Component addRowFull(String rowHeightCode, boolean withGap, Component component) {
        this.addRow(rowHeightCode, withGap);
        return this.add(component, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public Component addRow(String rowHeightCode, boolean withGap, Component component, int columnIndex) {
        this.addRow(rowHeightCode, withGap);
        return this.add(component, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public Component addRowFull(String rowHeightCode, boolean withGap, Component component, int columnStartIndex) {
        this.addRow(rowHeightCode, withGap);
        return this.add(component, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public Component addRow(String rowHeightCode, boolean withGap, Component component, int columnIndex, int colSpan) {
        this.addRow(rowHeightCode, withGap);
        return this.add(component, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public Component addGrowingRowFull(Component component) {
        this.addGrowingRow();
        return this.add(component, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public Component addGrowingRow(Component component, int columnIndex) {
        this.addGrowingRow();
        return this.add(component, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public Component addGrowingRowFull(Component component, int columnStartIndex) {
        this.addGrowingRow();
        return this.add(component, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public Component addGrowingRow(Component component, int columnIndex, int colSpan) {
        this.addGrowingRow();
        return this.add(component, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public Component addGrowingRowFull(boolean withGap, Component component) {
        this.addGrowingRow(withGap);
        return this.add(component, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public Component addGrowingRow(boolean withGap, Component component, int columnIndex) {
        this.addGrowingRow(withGap);
        return this.add(component, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public Component addGrowingRowFull(boolean withGap, Component component, int columnStartIndex) {
        this.addGrowingRow(withGap);
        return this.add(component, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public Component addGrowingRow(boolean withGap, Component component, int columnIndex, int colSpan) {
        this.addGrowingRow(withGap);
        return this.add(component, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public JComponent addSeparatorRowFull(String textWithMnemonic) {
        this.addRow();
        return this.addSeparator(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public JComponent addSeparatorRow(String textWithMnemonic, int columnIndex) {
        this.addRow();
        return this.addSeparator(textWithMnemonic, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public JComponent addSeparatorRowFull(String textWithMnemonic, int columnStartIndex) {
        this.addRow();
        return this.addSeparator(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public JComponent addSeparatorRow(String textWithMnemonic, int columnIndex, int colSpan) {
        this.addRow();
        return this.addSeparator(textWithMnemonic, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public JComponent addSeparatorRowFull(boolean withGap, String textWithMnemonic) {
        this.addRow(withGap);
        return this.addSeparator(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public JComponent addSeparatorRow(boolean withGap, String textWithMnemonic, int columnIndex) {
        this.addRow(withGap);
        return this.addSeparator(textWithMnemonic, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public JComponent addSeparatorRowFull(boolean withGap, String textWithMnemonic, int columnStartIndex) {
        this.addRow(withGap);
        return this.addSeparator(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public JComponent addSeparatorRow(boolean withGap, String textWithMnemonic, int columnIndex, int colSpan) {
        this.addRow(withGap);
        return this.addSeparator(textWithMnemonic, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public JComponent addSeparatorRowFull(String rowHeightCode, String textWithMnemonic) {
        this.addRow(rowHeightCode, true);
        return this.addSeparator(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public JComponent addSeparatorRow(String rowHeightCode, String textWithMnemonic, int columnIndex) {
        this.addRow(rowHeightCode, true);
        return this.addSeparator(textWithMnemonic, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public JComponent addSeparatorRowFull(String rowHeightCode, String textWithMnemonic, int columnStartIndex) {
        this.addRow(rowHeightCode, true);
        return this.addSeparator(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public JComponent addSeparatorRow(String rowHeightCode, String textWithMnemonic, int columnIndex, int colSpan) {
        this.addRow(rowHeightCode, true);
        return this.addSeparator(textWithMnemonic, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public JComponent addSeparatorRowFull(String rowHeightCode, boolean withGap, String textWithMnemonic) {
        this.addRow(rowHeightCode, withGap);
        return this.addSeparator(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public JComponent addSeparatorRow(String rowHeightCode, boolean withGap, String textWithMnemonic, int columnIndex) {
        this.addRow(rowHeightCode, withGap);
        return this.addSeparator(textWithMnemonic, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public JComponent addSeparatorRowFull(String rowHeightCode, boolean withGap, String textWithMnemonic, int columnStartIndex) {
        this.addRow(rowHeightCode, withGap);
        return this.addSeparator(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex)));
    }

    public JComponent addSeparatorRow(String rowHeightCode, boolean withGap, String textWithMnemonic, int columnIndex, int colSpan) {
        this.addRow(rowHeightCode, withGap);
        return this.addSeparator(textWithMnemonic, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public JLabel addLabelRowFull(String textWithMnemonic) {
        this.addRow();
        return this.addLabel(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public JLabel addLabelRow(String textWithMnemonic, int columnIndex) {
        this.addRow();
        return this.addLabel(textWithMnemonic, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public JLabel addLabelRowFull(String textWithMnemonic, int columnStartIndex) {
        this.addRow();
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public JLabel addLabelRow(String textWithMnemonic, int columnIndex, int colSpan) {
        this.addRow();
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public JLabel addLabelRowFull(boolean withGap, String textWithMnemonic) {
        this.addRow(withGap);
        return this.addLabel(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public JLabel addLabelRow(boolean withGap, String textWithMnemonic, int columnIndex) {
        this.addRow(withGap);
        return this.addLabel(textWithMnemonic, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public JLabel addLabelRowFull(boolean withGap, String textWithMnemonic, int columnStartIndex) {
        this.addRow(withGap);
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public JLabel addLabelRow(boolean withGap, String textWithMnemonic, int columnIndex, int colSpan) {
        this.addRow(withGap);
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public JLabel addLabelRow(String rowHeightCode, String textWithMnemonic) {
        this.addRow(rowHeightCode, true);
        return this.addLabel(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public JLabel addLabelRow(String rowHeightCode, String textWithMnemonic, int columnIndex) {
        this.addRow(rowHeightCode, true);
        return this.addLabel(textWithMnemonic, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public JLabel addLabelRowFull(String rowHeightCode, String textWithMnemonic, int columnStartIndex) {
        this.addRow(rowHeightCode, true);
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public JLabel addLabelRow(String rowHeightCode, String textWithMnemonic, int columnIndex, int colSpan) {
        this.addRow(rowHeightCode, true);
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public JLabel addLabelRowFull(String rowHeightCode, boolean withGap, String textWithMnemonic) {
        this.addRow(rowHeightCode, withGap);
        return this.addLabel(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public JLabel addLabelRow(String rowHeightCode, boolean withGap, String textWithMnemonic, int columnIndex) {
        this.addRow(rowHeightCode, withGap);
        return this.addLabel(textWithMnemonic, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public JLabel addLabelRowFull(String rowHeightCode, boolean withGap, String textWithMnemonic, int columnStartIndex) {
        this.addRow(rowHeightCode, withGap);
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public JLabel addLabelRow(String rowHeightCode, boolean withGap, String textWithMnemonic, int columnIndex, int colSpan) {
        this.addRow(rowHeightCode, withGap);
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public Component addFull(JComponent component) {
        return this.add(component, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public Component add(Component component, int columnIndex) {
        return this.add(component, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public Component addFull(Component component, int columnStartIndex) {
        return this.add(component, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public Component add(Component component, int columnIndex, int colSpan) {
        return this.add(component, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }

    public JLabel labelAddFull(String textWithMnemonic) {
        return this.addLabel(textWithMnemonic, CC.xyw((int)1, (int)this.getRowCount(), (int)this.getColumnCount()));
    }

    public JLabel labelAdd(String textWithMnemonic, int columnIndex) {
        return this.addLabel(textWithMnemonic, CC.xy((int)columnIndex, (int)this.getRowCount()));
    }

    public Component labelAddFull(String textWithMnemonic, int columnStartIndex) {
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnStartIndex, (int)this.getRowCount(), (int)(this.getColumnCount() - columnStartIndex + 1)));
    }

    public Component labelAdd(String textWithMnemonic, int columnIndex, int colSpan) {
        return this.addLabel(textWithMnemonic, CC.xyw((int)columnIndex, (int)this.getRowCount(), (int)colSpan));
    }
}

