/*
 * Decompiled with CFR 0.152.
 */
package util.ui;

import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.ChannelFilter;
import devplugin.ChannelFilterChangeListener;
import devplugin.FilterChangeListenerV2;
import devplugin.Program;
import devplugin.ProgramFilter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import tvbrowser.core.filters.FilterManagerImpl;
import util.i18n.Localizer;
import util.settings.ProgramPanelSettings;
import util.ui.ProgramList;
import util.ui.TVBrowserIcons;
import util.ui.WideComboBox;
import util.ui.WrapperFilter;
import util.ui.persona.Persona;
import util.ui.persona.PersonaListener;

public class FilterableProgramListPanel
extends JPanel
implements FilterChangeListenerV2,
PersonaListener,
ChannelFilterChangeListener {
    public static final int FILTER_START_ALL_TYPE = 0;
    public static final int FILTER_START_DEFAULT_TYPE = 1;
    public static final int FILTER_START_CURRENT_TYPE = 2;
    private static final int FILTER_START_FILTER_TYPE = -1;
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(FilterableProgramListPanel.class);
    public static final int TYPE_NAME_AND_PROGRAM_FILTER = 0;
    public static final int TYPE_PROGRAM_ONLY_FILTER = 1;
    public static final int TYPE_NAME_ONLY_FILTER = 2;
    private ProgramList mProgramList;
    private JScrollPane mProgramListScrollPane;
    private DefaultListModel<Program> mProgramListModel;
    private JLabel mProgramFilterLabel;
    private WideComboBox<WrapperFilter> mProgramFilterBox;
    private JComboBox<ProgramFilter> mTitleFilterBox;
    private JLabel mTitleFilterLabel;
    private JLabel mNumberLabel;
    private Program[] mAllPrograms;
    private static final Program[] EMPTY_PROGRAM_ARR = new Program[0];
    private int mType;
    private int mTypeStart;
    private WrapperFilter mDefaultFilter;

    public FilterableProgramListPanel(boolean showNameFilter, Program[] programs, boolean showNumberOfPrograms, boolean showDateSeparators, ProgramPanelSettings progPanelSettings, ProgramFilter startFilter) {
        this(showNameFilter ? 0 : 1, programs, showNumberOfPrograms, showDateSeparators, progPanelSettings, startFilter == null ? 0 : -1);
    }

    public FilterableProgramListPanel(int type, Program[] programs, boolean showNumberOfPrograms, boolean showDateSeparators, ProgramPanelSettings progPanelSettings, int startType) {
        this.mType = type;
        this.mProgramListModel = new DefaultListModel();
        this.mProgramList = new ProgramList(this.mProgramListModel, progPanelSettings);
        this.mProgramList.setShowDateSeparators(showDateSeparators);
        FilterManagerImpl.getInstance().registerFilterChangeListener(this);
        FilterManagerImpl.getInstance().registerChannelFilterChangeListener(this);
        this.createGUI(type, showNumberOfPrograms, startType, null);
        this.setPrograms(programs);
    }

    public void setShowDateSeparators(boolean showDateSeparators) {
        this.mProgramList.setShowDateSeparators(showDateSeparators);
    }

    public void setPrograms(Program[] programs) {
        if (programs == null) {
            programs = EMPTY_PROGRAM_ARR;
        }
        this.mAllPrograms = programs;
        this.filterPrograms(((WrapperFilter)this.mProgramFilterBox.getSelectedItem()).getFilter());
    }

    public ProgramList getProgramList() {
        return this.mProgramList;
    }

    private void createGUI(int type, boolean showNumberOfPrograms, int startType, ProgramFilter startFilter) {
        FormLayout layout = new FormLayout("default,3dlu,100dlu:grow,3dlu,default,3dlu,default", "default,3dlu,fill:default:grow");
        this.setLayout((LayoutManager)layout);
        this.setOpaque(false);
        if (type == 0) {
            layout.insertRow(1, RowSpec.decode((String)"default"));
            layout.insertRow(2, RowSpec.decode((String)"3dlu"));
        }
        int y = 1;
        this.mProgramFilterBox = new WideComboBox();
        if (type == 0 || type == 1) {
            this.mProgramFilterBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.filterPrograms(((WrapperFilter)this.mProgramFilterBox.getSelectedItem()).getFilter());
                    this.scrollToFirstNotExpiredIndex(false);
                }
            });
            this.fillProgramFilterBox(startType, startFilter);
            JButton refresh = new JButton(TVBrowserIcons.refresh(16));
            refresh.setToolTipText(LOCALIZER.msg("refresh", "Refresh list with current filter"));
            refresh.addActionListener(e -> this.filterPrograms(((WrapperFilter)this.mProgramFilterBox.getSelectedItem()).getFilter()));
            JButton reset = new JButton(TVBrowserIcons.reset(16));
            reset.setToolTipText(LOCALIZER.msg("reset", "Reset filter"));
            reset.addActionListener(e -> this.mProgramFilterBox.setSelectedItem(this.mDefaultFilter));
            this.mProgramFilterLabel = new JLabel(LOCALIZER.msg("filterPrograms", "Program filter:"));
            this.add((Component)this.mProgramFilterLabel, CC.xy((int)1, (int)y));
            this.add(this.mProgramFilterBox, CC.xy((int)3, (int)y));
            this.add((Component)refresh, CC.xy((int)5, (int)y));
            this.add((Component)reset, CC.xy((int)7, (int)y++));
            ++y;
        } else {
            this.mProgramFilterBox.addItem(new WrapperFilter(FilterManagerImpl.getInstance().getAllFilter()));
        }
        if (type == 0 || type == 2) {
            this.mTitleFilterBox = new WideComboBox<ProgramFilter>();
            this.mTitleFilterBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.filterPrograms((ProgramFilter)this.mTitleFilterBox.getSelectedItem(), true);
                    this.scrollToFirstNotExpiredIndex(false);
                }
            });
            JButton reset = new JButton(TVBrowserIcons.reset(16));
            reset.setToolTipText(LOCALIZER.msg("reset", "Reset filter"));
            reset.addActionListener(e -> this.mTitleFilterBox.setSelectedIndex(0));
            this.mTitleFilterLabel = new JLabel(LOCALIZER.msg("filterTitles", "Title filter:"));
            this.add((Component)this.mTitleFilterLabel, CC.xy((int)1, (int)y));
            this.add(this.mTitleFilterBox, CC.xyw((int)3, (int)y, (int)3));
            this.add((Component)reset, CC.xy((int)7, (int)y++));
            ++y;
        }
        if (showNumberOfPrograms) {
            layout.insertRow(y, RowSpec.decode((String)"default"));
            layout.insertRow(y + 1, RowSpec.decode((String)"3dlu"));
            this.mNumberLabel = new JLabel(LOCALIZER.msg("numberOfPrograms", "Number of shown programs: {0}", 0));
            this.add((Component)this.mNumberLabel, CC.xyw((int)1, (int)y++, (int)5));
            ++y;
        }
        this.mProgramListScrollPane = new JScrollPane(this.mProgramList);
        this.mProgramListScrollPane.setBorder(null);
        this.add((Component)this.mProgramListScrollPane, CC.xyw((int)1, (int)y, (int)7));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FilterableProgramListPanel.this.filterPrograms(((WrapperFilter)FilterableProgramListPanel.this.mProgramFilterBox.getSelectedItem()).getFilter());
                FilterableProgramListPanel.this.removeComponentListener(this);
            }
        });
    }

    private void fillProgramFilterBox(int startType, ProgramFilter startFilter) {
        ChannelFilter[] channelFilters;
        ProgramFilter[] filters;
        if (startFilter == null && startType == -1) {
            startType = 0;
        }
        this.mTypeStart = startType;
        for (ProgramFilter filter : filters = FilterManagerImpl.getInstance().getAvailableFilters()) {
            this.mProgramFilterBox.addItem(new WrapperFilter(filter));
        }
        for (ChannelFilter filter : channelFilters = FilterManagerImpl.getInstance().getAvailableChannelFilters()) {
            WrapperFilter test = new WrapperFilter(filter);
            if (this.mProgramFilterBox.contains(test)) continue;
            this.mProgramFilterBox.addItem(test);
        }
        switch (startType) {
            case 1: {
                this.mDefaultFilter = new WrapperFilter(FilterManagerImpl.getInstance().getDefaultFilter());
                this.mProgramFilterBox.setSelectedItem(this.mDefaultFilter);
                break;
            }
            case 2: {
                this.mDefaultFilter = new WrapperFilter(FilterManagerImpl.getInstance().getCurrentFilter());
                this.mProgramFilterBox.setSelectedItem(this.mDefaultFilter);
                break;
            }
            case -1: {
                this.mDefaultFilter = new WrapperFilter(startFilter);
                this.mProgramFilterBox.setSelectedItem(this.mDefaultFilter);
                break;
            }
            default: {
                this.mDefaultFilter = new WrapperFilter(FilterManagerImpl.getInstance().getAllFilter());
                this.mProgramFilterBox.setSelectedItem(this.mDefaultFilter);
            }
        }
    }

    @Override
    public void filterAdded(ProgramFilter filter) {
        WrapperFilter test;
        if (!(this.mType != 0 && this.mType != 1 || this.mProgramFilterBox.contains(test = new WrapperFilter(filter)))) {
            this.mProgramFilterBox.addItem(test);
        }
    }

    @Override
    public void filterRemoved(ProgramFilter filter) {
        if (this.mType == 0 || this.mType == 1) {
            if (this.mProgramFilterBox.getSelectedItem().equals(filter)) {
                this.mProgramFilterBox.setSelectedItem(new WrapperFilter(FilterManagerImpl.getInstance().getAllFilter()));
            }
            this.mProgramFilterBox.removeItem(filter);
        }
    }

    @Override
    public void channelFilterAdded(ChannelFilter filter) {
        this.filterAdded(filter);
    }

    @Override
    public void channelFilterRemoved(ChannelFilter filter) {
        this.filterRemoved(filter);
    }

    @Override
    public void filterTouched(ProgramFilter filter) {
        if (this.mType == 0 || this.mType == 1) {
            if (this.mProgramFilterBox.getSelectedItem().equals(filter)) {
                this.filterPrograms(filter);
            }
            this.mProgramFilterBox.updateUI();
        }
    }

    @Override
    public void filterTouched(ProgramFilter[] filters) {
        if (this.mType == 0 || this.mType == 1) {
            for (ProgramFilter filter : filters) {
                if (!this.mProgramFilterBox.getSelectedItem().equals(filter)) continue;
                this.filterPrograms(filter);
                break;
            }
            this.mProgramFilterBox.updateUI();
        }
    }

    @Override
    public void filterDefaultChanged(ProgramFilter filter) {
        if (this.mTypeStart == 1) {
            this.mDefaultFilter = new WrapperFilter(filter);
        }
    }

    private void filterPrograms(ProgramFilter filter) {
        this.filterPrograms(filter, false);
    }

    private void filterPrograms(ProgramFilter filter, boolean fromTitleFilter) {
        if (this.mAllPrograms != null) {
            this.mProgramListModel.clear();
            DefaultListModel<Program> model = new DefaultListModel<Program>();
            ArrayList<ProgramFilter> titleFilterValues = new ArrayList<ProgramFilter>();
            HashMap<String, String> titleMap = new HashMap<String, String>();
            if (FilterManagerImpl.getInstance().getAllFilter().equals(filter) && ((WrapperFilter)this.mProgramFilterBox.getSelectedItem()).equals(FilterManagerImpl.getInstance().getAllFilter())) {
                for (Program p : this.mAllPrograms) {
                    model.addElement(p);
                    if (fromTitleFilter || this.mTitleFilterBox == null || titleMap.get(p.getTitle().toLowerCase()) != null) continue;
                    titleMap.put(p.getTitle().toLowerCase(), "available");
                    titleFilterValues.add(new SimpleTitleFilter(p.getTitle()));
                }
            } else {
                ProgramFilter check = FilterManagerImpl.getInstance().getAllFilter();
                if (filter instanceof SimpleTitleFilter || filter.equals(check)) {
                    check = ((WrapperFilter)this.mProgramFilterBox.getSelectedItem()).getFilter();
                }
                for (Program p : this.mAllPrograms) {
                    if (!check.accept(p) || !filter.accept(p)) continue;
                    model.addElement(p);
                    if (fromTitleFilter || this.mTitleFilterBox == null || titleMap.get(p.getTitle().toLowerCase()) != null) continue;
                    titleMap.put(p.getTitle().toLowerCase(), "available");
                    titleFilterValues.add(new SimpleTitleFilter(p.getTitle()));
                }
            }
            if (!fromTitleFilter && this.mTitleFilterBox != null) {
                this.mTitleFilterBox.removeAllItems();
                Collections.sort(titleFilterValues, new Comparator<ProgramFilter>(){

                    @Override
                    public int compare(ProgramFilter o1, ProgramFilter o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
                titleFilterValues.add(0, FilterManagerImpl.getInstance().getAllFilter());
                for (ProgramFilter titleFilter : titleFilterValues) {
                    this.mTitleFilterBox.addItem(titleFilter);
                }
            }
            this.mProgramListModel = model;
            this.mProgramList.setModel((ListModel<Program>)model);
            if (this.mNumberLabel != null) {
                this.mNumberLabel.setText(LOCALIZER.msg("numberOfPrograms", "Number of shown programs: {0}", this.mProgramListModel.size()));
            }
        }
    }

    public void clearPrograms() {
        this.setPrograms(EMPTY_PROGRAM_ARR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollToFirstNotExpiredIndex(boolean check) {
        DefaultListModel<Program> defaultListModel = this.mProgramListModel;
        synchronized (defaultListModel) {
            if (check) {
                int firstVisibleIndex = this.mProgramList.locationToIndex(this.mProgramList.getVisibleRect().getLocation());
                int lastVisibleIndex = this.mProgramList.locationToIndex(new Point(0, this.mProgramList.getVisibleRect().y + this.mProgramList.getVisibleRect().height));
                for (int i = firstVisibleIndex; i < lastVisibleIndex; ++i) {
                    Program test = this.mProgramListModel.getElementAt(i);
                    if (!(test instanceof Program) || test.isExpired()) continue;
                    return;
                }
            }
            for (int i = 0; i < this.mProgramListModel.getSize(); ++i) {
                try {
                    Program test = this.mProgramListModel.getElementAt(i);
                    if (!(test instanceof Program) || test.isExpired()) continue;
                    this.scrollToIndex(i);
                    break;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public void scrollToIndex(int index) {
        if (index < 0) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            Point p = this.mProgramList.indexToLocation(index);
            if (p != null) {
                this.mProgramList.scrollRectToVisible(new Rectangle(p.x, p.y, 1, this.mProgramList.getVisibleRect().height));
            }
        });
    }

    @Deprecated(since="4.2.3")
    public void scrollToIndexWithoutDateSeparators(int index) {
        this.scrollToIndex(index);
    }

    @Override
    public void updatePersona() {
        if (Persona.getInstance().getHeaderImage() != null) {
            if (this.mProgramFilterLabel != null) {
                this.mProgramFilterLabel.setForeground(Persona.getInstance().getTextColor());
            }
            if (this.mTitleFilterLabel != null) {
                this.mTitleFilterLabel.setForeground(Persona.getInstance().getTextColor());
            }
            if (this.mNumberLabel != null) {
                this.mNumberLabel.setForeground(Persona.getInstance().getTextColor());
            }
        } else {
            if (this.mProgramFilterLabel != null) {
                this.mProgramFilterLabel.setForeground(UIManager.getColor("Label.foreground"));
            }
            if (this.mTitleFilterLabel != null) {
                this.mTitleFilterLabel.setForeground(UIManager.getColor("Label.foreground"));
            }
            if (this.mNumberLabel != null) {
                this.mNumberLabel.setForeground(UIManager.getColor("Label.foreground"));
            }
        }
    }

    public void selectFilter(ProgramFilter filter) {
        if ((this.mType == 0 || this.mType == 1) && filter != null) {
            this.mProgramFilterBox.setSelectedItem(new WrapperFilter(filter));
        }
    }

    public String getSelectedProgramFilterName() {
        return ((WrapperFilter)this.mProgramFilterBox.getSelectedItem()).getName();
    }

    private static final class SimpleTitleFilter
    implements ProgramFilter {
        private String mTitle;

        public SimpleTitleFilter(String title) {
            this.mTitle = title;
        }

        @Override
        public boolean accept(Program program) {
            return program.getTitle().equalsIgnoreCase(this.mTitle);
        }

        @Override
        public String getName() {
            return this.mTitle;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

